/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature.handler;

import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.feature.handler.SurfaceTextHandler;
import com.ibm.dltj.gloss.StringGloss;

abstract class AffixTextHandler
extends SurfaceTextHandler {
    private final Dictionary _dic;
    protected final int _length;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public AffixTextHandler(CRFDictionary cRFDictionary, int n) {
        super(cRFDictionary);
        this._dic = cRFDictionary.getDictionary();
        this._length = n;
    }

    @Override
    public final CharSequence getFeature(CharSequence charSequence) {
        char c;
        GlossCollection glossCollection = this._dic.get(((Object)charSequence).toString());
        if (glossCollection != null) {
            for (c = '\u0000'; c < glossCollection.size(); ++c) {
                Gloss gloss = (Gloss)glossCollection.get(c);
                if (gloss.getType() != 60) continue;
                String string = ((StringGloss)gloss).getValue();
                if (string.length() <= 2 || string.charAt(0) != '_' || string.charAt(1) != '_') break;
                return string;
            }
        }
        charSequence = this.getAffix(charSequence);
        if (this._classifier != null) {
            c = (char)this._classifier.valueOf(charSequence, 0, charSequence.length());
            return c > '\u0000' ? String.valueOf(c) : charSequence;
        }
        if (this._numeric != null && this._numeric.reset(charSequence).matches()) {
            return "__num__";
        }
        if (this._symbol != null && this._symbol.reset(charSequence).matches()) {
            return "__sym__";
        }
        return charSequence;
    }

    protected abstract CharSequence getAffix(CharSequence var1);
}

