/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature.handler;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.feature.handler.FeatureHandler;
import com.ibm.dltj.crf.feature.handler.PrefixTextHandler;
import com.ibm.dltj.crf.feature.handler.SuffixTextHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class FeatureHandlerFactory {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static FeatureHandler createHandler(String string, CRFDictionary cRFDictionary) throws DLTException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith(PrefixTextHandler.class.getName())) {
            String string2 = string.substring(PrefixTextHandler.class.getName().length());
            int n = Integer.parseInt(string2);
            return new PrefixTextHandler(cRFDictionary, n);
        }
        if (string.startsWith(SuffixTextHandler.class.getName())) {
            String string3 = string.substring(SuffixTextHandler.class.getName().length());
            int n = Integer.parseInt(string3);
            return new SuffixTextHandler(cRFDictionary, n);
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(CRFDictionary.class);
            FeatureHandler featureHandler = (FeatureHandler)constructor.newInstance(cRFDictionary);
            return featureHandler;
        }
        catch (SecurityException securityException) {
            throw new DLTException(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DLTException(illegalArgumentException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DLTException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DLTException(noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new DLTException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DLTException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DLTException(invocationTargetException);
        }
    }
}

