/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature.handler;

import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.FeatureValueClassifier;
import com.ibm.dltj.crf.feature.handler.FeatureHandler;
import java.util.regex.Matcher;

class SurfaceTextHandler
implements FeatureHandler {
    protected final FeatureValueClassifier _classifier;
    protected final Matcher _numeric;
    protected final Matcher _symbol;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public SurfaceTextHandler(CRFDictionary cRFDictionary) {
        if (cRFDictionary == null) {
            throw new IllegalArgumentException();
        }
        this._classifier = cRFDictionary.getFeatureValueClassifier();
        this._numeric = this._classifier == null && cRFDictionary.getNumericPattern() != null ? cRFDictionary.getNumericPattern().matcher("") : null;
        this._symbol = this._classifier == null && cRFDictionary.getSymbolPattern() != null ? cRFDictionary.getSymbolPattern().matcher("") : null;
    }

    @Override
    public CharSequence getFeature(CharSequence charSequence) {
        if (this._classifier != null) {
            char c = (char)this._classifier.valueOf(charSequence, 0, charSequence.length());
            return c > '\u0000' ? String.valueOf(c) : charSequence;
        }
        if (this._numeric != null && this._numeric.reset(charSequence).matches()) {
            return "__num__";
        }
        if (this._symbol != null && this._symbol.reset(charSequence).matches()) {
            return "__sym__";
        }
        return charSequence;
    }
}

