/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature.template;

import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.crf.feature.template.Entry;
import com.ibm.dltj.netgeneric.NetGeneric;
import java.util.List;

public class FeatureTemplate {
    public static final String UNIGRAM_TEMPLATE_PREFIX = "U";
    public static final String BIGRAM_TEMPLATE_PREFIX = "B";
    protected final Type _type;
    protected final Entry[] _entries;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    FeatureTemplate(Type type, List<Entry> list) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (list == null || list.isEmpty() || list.contains(null)) {
            throw new IllegalArgumentException();
        }
        this._type = type;
        this._entries = list.toArray(new Entry[list.size()]);
    }

    public Type getType() {
        return this._type;
    }

    public NetGeneric.IndexIterator iterator(final FeatureTable featureTable, final int n) {
        return new NetGeneric.IndexIterator(){
            private int idx = 0;

            @Override
            public int first() {
                this.idx = 0;
                return FeatureTemplate.this._entries[0].getFeature(featureTable, n);
            }

            @Override
            public int next() {
                if (++this.idx == FeatureTemplate.this._entries.length) {
                    return 0;
                }
                return FeatureTemplate.this._entries[this.idx].getFeature(featureTable, n);
            }
        };
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this._entries) {
            stringBuilder.append(entry.toString());
        }
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    public static enum Type {
        VOID,
        UNIGRAM,
        BIGRAM;

    }
}

