/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature.template;

import com.ibm.dltj.crf.feature.template.Entry;
import com.ibm.dltj.crf.feature.template.FeatureTemplate;
import java.util.ArrayList;
import java.util.List;

public final class FeatureTemplateGraph {
    public final Entry _entry;
    public final boolean _nextFinal;
    public final int _stackPos;
    public int _indexOnFail;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected FeatureTemplateGraph(Entry entry, boolean bl, int n) {
        this._entry = entry;
        this._nextFinal = bl;
        this._stackPos = n;
    }

    public static FeatureTemplateGraph[] buildGraph(List<FeatureTemplate> list) {
        ArrayList<FeatureTemplateGraph> arrayList = new ArrayList<FeatureTemplateGraph>(list.size() * 2);
        FeatureTemplateGraph.buildGraph(0, new ArrayList<FeatureTemplate>(list), arrayList);
        return arrayList.toArray(new FeatureTemplateGraph[arrayList.size()]);
    }

    private static void buildGraph(int n, List<FeatureTemplate> list, List<FeatureTemplateGraph> list2) {
        ArrayList<FeatureTemplate> arrayList = new ArrayList<FeatureTemplate>();
        while (!list.isEmpty()) {
            FeatureTemplate featureTemplate = list.get(0);
            Entry entry = featureTemplate._entries[n];
            boolean bl = false;
            if (featureTemplate._entries.length == n + 1) {
                bl = true;
            } else {
                arrayList.add(featureTemplate);
            }
            list.remove(0);
            Object object = list.iterator();
            while (object.hasNext()) {
                featureTemplate = object.next();
                if (!featureTemplate._entries[n].equals(entry)) continue;
                arrayList.add(featureTemplate);
                object.remove();
            }
            object = new FeatureTemplateGraph(entry, bl, n);
            list2.add((FeatureTemplateGraph)object);
            FeatureTemplateGraph.buildGraph(n + 1, arrayList, list2);
            assert (arrayList.isEmpty());
            ((FeatureTemplateGraph)object)._indexOnFail = list2.size();
        }
    }

    public String toString() {
        return this._entry.toString() + (this._nextFinal ? "#" : "") + "_st" + this._stackPos + "_in" + this._indexOnFail;
    }
}

