/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature.template;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.crf.feature.template.ConstantEntry;
import com.ibm.dltj.crf.feature.template.Entry;
import com.ibm.dltj.crf.feature.template.FeatureTemplate;
import com.ibm.dltj.crf.feature.template.RefFeatureEntry;
import com.ibm.dltj.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureTemplateParser {
    private final FeatureMapping _mapping;
    private final Pattern _templatePattern = Pattern.compile("%x\\[[-,\\d]+\\]|[^%]+");
    private final Pattern _idPattern1 = Pattern.compile("([:]?U[\\d]*[:]?)");
    private final Pattern _idPattern2 = Pattern.compile("([:]?B[\\d]*[:]?)");
    private final Pattern _digitPattern = Pattern.compile("-?\\d+");
    private static final String COMMENT = "#";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public FeatureTemplateParser(FeatureMapping featureMapping) {
        if (featureMapping == null) {
            throw new IllegalArgumentException();
        }
        this._mapping = featureMapping;
    }

    public List<FeatureTemplate> parse(File file, Charset charset) throws IOException, DLTException {
        List<String> list = FileUtils.getLines(file, charset);
        return this.parse(list);
    }

    public List<FeatureTemplate> parse(List<String> list) throws DLTException {
        ArrayList<FeatureTemplate> arrayList = new ArrayList<FeatureTemplate>();
        for (String string : list) {
            FeatureTemplate featureTemplate = this.parse(string);
            if (featureTemplate == null) continue;
            arrayList.add(featureTemplate);
        }
        if (arrayList.isEmpty()) {
            Collections.emptyList();
        }
        return arrayList;
    }

    public FeatureTemplate parse(String string) throws DLTException {
        if (string == null || string.length() == 0 || string.startsWith(COMMENT)) {
            return null;
        }
        FeatureTemplate.Type type = FeatureTemplate.Type.VOID;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Matcher matcher = this._templatePattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2.startsWith("%x")) {
                Matcher matcher2 = this._digitPattern.matcher(string2);
                matcher2.find();
                int n = Integer.parseInt(matcher2.group());
                matcher2.find();
                int n2 = Integer.parseInt(matcher2.group());
                arrayList.add(new RefFeatureEntry(n, n2));
                continue;
            }
            if (this._idPattern1.matcher(string2).matches()) {
                type = FeatureTemplate.Type.UNIGRAM;
            } else if (this._idPattern2.matcher(string2).matches()) {
                type = FeatureTemplate.Type.BIGRAM;
            }
            arrayList.add(new ConstantEntry(this._mapping, string2));
        }
        return new FeatureTemplate(type, arrayList);
    }
}

