/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature.template;

import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.crf.feature.template.Entry;

final class RefFeatureEntry
implements Entry {
    private final int _row;
    private final int _col;
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String COMMA = ",";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public RefFeatureEntry(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this._row = n;
        this._col = n2;
    }

    @Override
    public int getFeature(FeatureTable featureTable, int n) {
        return featureTable.getFeature(n + this._row, this._col);
    }

    public String toString() {
        return "%x[" + this._row + COMMA + this._col + RIGHT_BRACKET;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._row;
        n = 31 * n + this._col;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RefFeatureEntry refFeatureEntry = (RefFeatureEntry)object;
        if (this._row != refFeatureEntry._row) {
            return false;
        }
        return this._col == refFeatureEntry._col;
    }
}

