/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.data;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Messages;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class BreakIteratorManager {
    private static final Map<String, Dictionary> s_breakIterators = new TreeMap<String, Dictionary>();
    public static final int BY_LOCALE = 0;
    public static final int BY_FILE = 1;
    private static final String RESOURCE_PREFIX = "dltb_";
    private static final String EXT_BRK = ".dic";
    private static final String DEFAULT = "default";
    public static final String MANIFEST_RULES = "Rules";
    public static final String MANIFEST_TAGS = "Tags";
    public static final String EXT_RULES_JAR = ".jar";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private BreakIteratorManager() {
    }

    public static Dictionary constructBreakIteratorByFile(String string) throws DLTException {
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        try {
            Map<String, Dictionary> map = s_breakIterators;
            synchronized (map) {
                Dictionary dictionary = null;
                dictionary = BreakIteratorManager.construct(string, 1);
                if (dictionary != null) {
                    return dictionary;
                }
                throw new DLTException(Messages.format("cannot.loadresource", string + ": *file*"));
            }
        }
        catch (IOException iOException) {
            throw new DLTException(Messages.getString("exception.read") + ": *file* : " + iOException.getMessage());
        }
    }

    public static Dictionary constructBreakIterator(ULocale uLocale) throws DLTException {
        if (uLocale == null || uLocale.equals((Object)ULocale.ROOT)) {
            uLocale = new ULocale(DEFAULT);
        }
        try {
            Map<String, Dictionary> map = s_breakIterators;
            synchronized (map) {
                String string = uLocale.toString().toLowerCase();
                Dictionary dictionary = null;
                dictionary = BreakIteratorManager.construct(string, 0);
                if (dictionary != null) {
                    return dictionary;
                }
                for (ULocale uLocale2 = uLocale.getFallback(); uLocale2 != null && !uLocale2.equals((Object)ULocale.ROOT); uLocale2 = uLocale2.getFallback()) {
                    dictionary = BreakIteratorManager.construct(uLocale2.toString().toLowerCase(), 0);
                    if (dictionary == null) continue;
                    return dictionary;
                }
                dictionary = BreakIteratorManager.construct(DEFAULT, 0);
                if (dictionary != null) {
                    return dictionary;
                }
                throw new DLTException(Messages.format("cannot.loadresource", uLocale.toString() + ": *locale*"));
            }
        }
        catch (IOException iOException) {
            throw new DLTException(Messages.getString("exception.read") + ": *locale* : " + iOException.getMessage());
        }
    }

    private static Dictionary construct(String string, int n) throws IOException, DLTException {
        Dictionary dictionary = s_breakIterators.get(string);
        if (dictionary != null) {
            return dictionary;
        }
        dictionary = n == 1 ? BreakIteratorManager.getInstanceFromFile(string) : BreakIteratorManager.getInstanceFromResource(string);
        if (dictionary != null) {
            s_breakIterators.put(string, dictionary);
            return dictionary;
        }
        return null;
    }

    private static Dictionary getInstanceFromFile(String string) throws IOException, DLTException {
        if (string.endsWith(EXT_RULES_JAR)) {
            return BreakIteratorManager.getInstanceFromJar(string);
        }
        try {
            return new Dictionary(new File(string));
        }
        catch (DLTException dLTException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dictionary getInstanceFromJar(String string) throws IOException, DLTException {
        JarFile jarFile = null;
        jarFile = new JarFile(string);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            Dictionary dictionary = null;
            return dictionary;
        }
        String string2 = attributes.getValue(MANIFEST_RULES);
        if (string2 == null) {
            Dictionary dictionary = null;
            return dictionary;
        }
        ZipEntry zipEntry = jarFile.getEntry(string2);
        if (zipEntry == null) {
            throw new DLTException(Messages.format("error.nojarentry", string2, string));
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        Dictionary dictionary = new Dictionary(inputStream, 0);
        return dictionary;
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dictionary getInstanceFromResource(String string) throws IOException, DLTException {
        String string2 = RESOURCE_PREFIX + string.toLowerCase() + EXT_BRK;
        InputStream inputStream = BreakIteratorManager.class.getResourceAsStream(string2);
        if (inputStream == null) {
            return null;
        }
        try {
            Dictionary dictionary = new Dictionary(inputStream, 0);
            return dictionary;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, Dictionary> map = s_breakIterators;
        synchronized (map) {
            s_breakIterators.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEntry(String string) {
        Map<String, Dictionary> map = s_breakIterators;
        synchronized (map) {
            s_breakIterators.remove(string);
        }
    }
}

