/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.data;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.decomposition.DecompositionRuleSet;
import com.ibm.icu.util.ULocale;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class DecompositionRuleSetFactory {
    private static final String EXTENSION = ".dcr";
    private static final String DEFAULT = "default";
    private static final String BY_FILE_MODIFIER = "*file*";
    private static DecompositionRuleSetFactory singleton = new DecompositionRuleSetFactory();
    private final Map<String, Map<String, DecompositionRuleSet>> cache = new HashMap<String, Map<String, DecompositionRuleSet>>();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private DecompositionRuleSetFactory() {
    }

    public static DecompositionRuleSetFactory getInstance() {
        return singleton;
    }

    private DecompositionRuleSet getRules(ULocale uLocale, String string) throws DLTException {
        try {
            DecompositionRuleSet decompositionRuleSet;
            String string2 = uLocale == null || uLocale.equals((Object)ULocale.ROOT) ? DEFAULT : uLocale.toString().toLowerCase();
            Map<String, DecompositionRuleSet> map = this.cache.get(string);
            if (map == null) {
                map = new HashMap<String, DecompositionRuleSet>();
                this.cache.put(string, map);
            }
            if ((decompositionRuleSet = map.get(string2)) == null) {
                int n;
                int n2 = this.getLongestPrefix(uLocale, string);
                if (string != null && (n = this.getLongestPrefix(uLocale, null)) > n2) {
                    string = null;
                    n2 = n;
                }
                String string3 = n2 > 0 ? string2.substring(0, n2) : DEFAULT;
                decompositionRuleSet = this.cache.get(string).get(string3);
                map.put(string2, decompositionRuleSet);
            }
            return decompositionRuleSet;
        }
        catch (IOException iOException) {
            throw new DLTException(Messages.getString("error.decomp.load"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecompositionRuleSet getRulesByFilename(String string) throws DLTException, IOException {
        DecompositionRuleSet decompositionRuleSet;
        Map<String, DecompositionRuleSet> map = this.cache.get(BY_FILE_MODIFIER);
        if (map == null) {
            map = new HashMap<String, DecompositionRuleSet>();
            this.cache.put(BY_FILE_MODIFIER, map);
        }
        if ((decompositionRuleSet = map.get(string)) != null) {
            return decompositionRuleSet;
        }
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new FileInputStream(string));
            decompositionRuleSet = new DecompositionRuleSet((DataInput)((Object)filterInputStream));
            map.put(string, decompositionRuleSet);
            DecompositionRuleSet decompositionRuleSet2 = decompositionRuleSet;
            return decompositionRuleSet2;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    public static DecompositionRuleSet getDecompositionRules(ULocale uLocale, String string) throws DLTException {
        return DecompositionRuleSetFactory.getInstance().getRules(uLocale, string);
    }

    public static DecompositionRuleSet getDefaultDecompositionRules() {
        try {
            return DecompositionRuleSetFactory.getInstance().getRules(null, null);
        }
        catch (DLTException dLTException) {
            throw new ExceptionInInitializerError(dLTException);
        }
    }

    public static DecompositionRuleSet getDecompositionRulesByFilename(String string) throws DLTException {
        try {
            return DecompositionRuleSetFactory.getInstance().getRulesByFilename(string);
        }
        catch (IOException iOException) {
            throw new DLTException(Messages.format("exception.read.decomp", iOException.getMessage()));
        }
    }

    private String getResourceName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append('-');
            stringBuilder.append(string2);
        }
        stringBuilder.append(EXTENSION);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findResource(String string, String string2, Map<String, DecompositionRuleSet> map) throws DLTException, IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(this.getResourceName(string, string2));
        if (inputStream != null) {
            if (map.get(string) != null) {
                return true;
            }
            DataInputStream dataInputStream = null;
            try {
                dataInputStream = new DataInputStream(inputStream);
                DecompositionRuleSet decompositionRuleSet = new DecompositionRuleSet(dataInputStream);
                map.put(string, decompositionRuleSet);
                boolean bl = true;
                return bl;
            }
            finally {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
                inputStream.close();
            }
        }
        return false;
    }

    private int getLongestPrefix(ULocale uLocale, String string) throws DLTException, IOException {
        Map<String, DecompositionRuleSet> map = this.cache.get(string);
        if (map == null) {
            map = new HashMap<String, DecompositionRuleSet>();
            this.cache.put(string, map);
        }
        for (ULocale uLocale2 = uLocale; uLocale2 != null && !uLocale2.equals((Object)ULocale.ROOT); uLocale2 = uLocale2.getFallback()) {
            if (!this.findResource(uLocale2.toString().toLowerCase(), string, map)) continue;
            return uLocale2.toString().length();
        }
        return this.findResource(DEFAULT, string, map) ? 0 : -1;
    }
}

