/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.data;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ICUTransliteratorFactory {
    private final Map<String, String> transliteratorIDs = new HashMap<String, String>();
    private final Properties properties = new Properties();
    private static final String RESOURCE_NAME = "transliterator.properties";
    private static final String ID_PREFIX = "dltj_any-";
    private static final String NULL_RULE_ID = "_NONE_";
    private static final String DEFAULT = "default";

    public static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public ICUTransliteratorFactory() throws DLTException {
        try {
            this.getRulesFromPropertyFile(this.getClass().getResourceAsStream(RESOURCE_NAME));
        }
        catch (IOException iOException) {
            throw new DLTException(Messages.format("exception.io", RESOURCE_NAME));
        }
    }

    public ICUTransliteratorFactory(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        try {
            this.getRulesFromPropertyFile(string);
        }
        catch (IOException iOException) {
            throw new DLTException(Messages.format("exception.io", string));
        }
    }

    public synchronized Transliterator getTransliterator(ULocale uLocale) {
        String string;
        if (uLocale == null || uLocale.equals((Object)ULocale.ROOT)) {
            uLocale = new ULocale(DEFAULT);
        }
        if ((string = this.transliteratorIDs.get(uLocale.toString().toLowerCase())) != null) {
            if (string.equals(NULL_RULE_ID)) {
                return null;
            }
            return Transliterator.getInstance((String)string, (int)0);
        }
        return this.getRuleBasedTransliterator(uLocale);
    }

    public synchronized Transliterator getTransliterator(String string) {
        return this.getTransliterator(string == null || string.length() == 0 ? null : new ULocale(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRulesFromPropertyFile(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        try {
            this.properties.load(inputStream);
            inputStream.close();
        }
        finally {
            inputStream.close();
        }
    }

    private void getRulesFromPropertyFile(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.getRulesFromPropertyFile(fileInputStream);
        }
    }

    private Transliterator getRuleBasedTransliterator(ULocale uLocale) {
        Transliterator transliterator;
        if (this.properties.isEmpty()) {
            return null;
        }
        String string = uLocale.toString().toLowerCase();
        String string2 = this.properties.getProperty(string);
        if (string2 != null && string2.length() != 0 && (transliterator = Transliterator.createFromRules((String)(ID_PREFIX + string), (String)string2, (int)0)) != null) {
            this.transliteratorIDs.put(string, ID_PREFIX + string);
            Transliterator.registerInstance((Transliterator)transliterator);
            return transliterator;
        }
        for (ULocale uLocale2 = uLocale.getFallback(); uLocale2 != null && !uLocale2.equals((Object)ULocale.ROOT); uLocale2 = uLocale2.getFallback()) {
            String string3 = uLocale2.toString().toLowerCase();
            string2 = this.properties.getProperty(string3);
            if (string2 == null || string2.length() == 0 || (transliterator = Transliterator.createFromRules((String)(ID_PREFIX + string3), (String)string2, (int)0)) == null) continue;
            this.transliteratorIDs.put(string, ID_PREFIX + string3);
            Transliterator.registerInstance((Transliterator)transliterator);
            return transliterator;
        }
        string2 = this.properties.getProperty(DEFAULT);
        if (string2 != null && string2.length() != 0 && (transliterator = Transliterator.createFromRules((String)"dltj_any-default", (String)string2, (int)0)) != null) {
            this.transliteratorIDs.put(string, "dltj_any-default");
            Transliterator.registerInstance((Transliterator)transliterator);
            return transliterator;
        }
        this.transliteratorIDs.put(string, NULL_RULE_ID);
        return null;
    }
}

