/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionAtomBase;
import com.ibm.dltj.decomposition.DecompositionAtomBofa;
import com.ibm.dltj.decomposition.DecompositionAtomCase;
import com.ibm.dltj.decomposition.DecompositionAtomConstraintCode;
import com.ibm.dltj.decomposition.DecompositionAtomEndsIn;
import com.ibm.dltj.decomposition.DecompositionAtomGrammar;
import com.ibm.dltj.decomposition.DecompositionAtomInteger;
import com.ibm.dltj.decomposition.DecompositionAtomPos;
import com.ibm.dltj.decomposition.DecompositionAtomStartsWith;
import com.ibm.dltj.decomposition.DecompositionAtomString;
import com.ibm.dltj.util.Utils;
import java.util.HashMap;
import java.util.Map;

public class DecompositionAtomCombiner {
    static Map<Utils.HashableIntPair, Combiner> combiners = new HashMap<Utils.HashableIntPair, Combiner>();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    static StringBuilder intersectStrings(String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (!(string2.indexOf(string.charAt(i)) >= 0 ^ bl)) continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder;
    }

    static StringBuilder mergeStrings(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < string2.length(); ++i) {
            if (string.indexOf(string2.charAt(i)) >= 0) continue;
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder;
    }

    public static DecompositionAtom intersect(DecompositionAtom decompositionAtom, DecompositionAtom decompositionAtom2) {
        if (decompositionAtom.equals(decompositionAtom2)) {
            return decompositionAtom;
        }
        if (decompositionAtom.negate().equals(decompositionAtom2)) {
            return DecompositionAtom.False;
        }
        if (!(decompositionAtom2 instanceof DecompositionAtomBase) || !(decompositionAtom instanceof DecompositionAtomBase)) {
            return null;
        }
        DecompositionAtomBase decompositionAtomBase = (DecompositionAtomBase)decompositionAtom2;
        DecompositionAtomBase decompositionAtomBase2 = (DecompositionAtomBase)decompositionAtom;
        Combiner combiner = combiners.get(new Utils.HashableIntPair(decompositionAtomBase2.getType(), decompositionAtomBase.getType()));
        if (combiner != null) {
            if (decompositionAtomBase2.negated) {
                return DecompositionAtomCombiner.intersectByDemorgan(combiner, decompositionAtomBase2, decompositionAtomBase);
            }
            return combiner.intersect(decompositionAtomBase2, decompositionAtomBase);
        }
        combiner = combiners.get(new Utils.HashableIntPair(decompositionAtomBase.getType(), decompositionAtomBase2.getType()));
        if (combiner != null) {
            if (decompositionAtomBase.negated) {
                return DecompositionAtomCombiner.intersectByDemorgan(combiner, decompositionAtomBase, decompositionAtomBase2);
            }
            return combiner.intersect(decompositionAtomBase, decompositionAtomBase2);
        }
        return null;
    }

    public static DecompositionAtom merge(DecompositionAtom decompositionAtom, DecompositionAtom decompositionAtom2) {
        if (decompositionAtom.equals(decompositionAtom2)) {
            return decompositionAtom;
        }
        if (decompositionAtom.negate().equals(decompositionAtom2)) {
            return DecompositionAtom.True;
        }
        if (!(decompositionAtom2 instanceof DecompositionAtomBase) || !(decompositionAtom instanceof DecompositionAtomBase)) {
            return null;
        }
        DecompositionAtomBase decompositionAtomBase = (DecompositionAtomBase)decompositionAtom2;
        DecompositionAtomBase decompositionAtomBase2 = (DecompositionAtomBase)decompositionAtom;
        Combiner combiner = combiners.get(new Utils.HashableIntPair(decompositionAtomBase2.getType(), decompositionAtomBase.getType()));
        if (combiner != null) {
            if (decompositionAtomBase2.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(combiner, decompositionAtomBase2, decompositionAtomBase);
            }
            return combiner.merge(decompositionAtomBase2, decompositionAtomBase);
        }
        combiner = combiners.get(new Utils.HashableIntPair(decompositionAtomBase.getType(), decompositionAtomBase2.getType()));
        if (combiner != null) {
            if (decompositionAtomBase.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(combiner, decompositionAtomBase, decompositionAtomBase2);
            }
            return combiner.merge(decompositionAtomBase, decompositionAtomBase2);
        }
        return null;
    }

    static DecompositionAtom mergeByDemorgan(Combiner combiner, DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
        DecompositionAtom decompositionAtom = combiner.intersect((DecompositionAtomBase)decompositionAtomBase.negate(), (DecompositionAtomBase)decompositionAtomBase2.negate());
        if (decompositionAtom == null) {
            return null;
        }
        return decompositionAtom.negate();
    }

    static DecompositionAtom intersectByDemorgan(Combiner combiner, DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
        DecompositionAtom decompositionAtom = combiner.merge((DecompositionAtomBase)decompositionAtomBase.negate(), (DecompositionAtomBase)decompositionAtomBase2.negate());
        if (decompositionAtom == null) {
            return null;
        }
        return decompositionAtom.negate();
    }

    public static boolean contains(DecompositionAtom decompositionAtom, DecompositionAtom decompositionAtom2) {
        return decompositionAtom.equals(DecompositionAtomCombiner.merge(decompositionAtom, decompositionAtom2));
    }

    public static DecompositionAtom difference(DecompositionAtom decompositionAtom, DecompositionAtom decompositionAtom2) {
        return DecompositionAtomCombiner.intersect(decompositionAtom, decompositionAtom2.negate());
    }

    public static boolean implies(DecompositionAtom decompositionAtom, DecompositionAtom decompositionAtom2) {
        return DecompositionAtomCombiner.difference(decompositionAtom, decompositionAtom2) == DecompositionAtom.False;
    }

    static {
        Combiner combiner = new TrueCombiner();
        for (int i = 0; i < 128; ++i) {
            combiners.put(new Utils.HashableIntPair(0, i), combiner);
        }
        combiner = new MatchMatchCombiner();
        combiners.put(new Utils.HashableIntPair(1, 1), combiner);
        combiners.put(new Utils.HashableIntPair(2, 2), combiner);
        combiner = new MatchEndsInCombiner();
        combiners.put(new Utils.HashableIntPair(1, 3), combiner);
        combiners.put(new Utils.HashableIntPair(5, 3), combiner);
        combiner = new MatchStartsWithCombiner();
        combiners.put(new Utils.HashableIntPair(1, 4), combiner);
        combiners.put(new Utils.HashableIntPair(6, 4), combiner);
        combiners.put(new Utils.HashableIntPair(1, 6), new MatchBeginningCombiner());
        combiners.put(new Utils.HashableIntPair(1, 5), new MatchEndingCombiner());
        combiners.put(new Utils.HashableIntPair(4, 4), new StartsStartsCombiner());
        combiners.put(new Utils.HashableIntPair(3, 3), new EndsEndsCombiner());
        combiners.put(new Utils.HashableIntPair(5, 5), new EndingEndingCombiner());
        combiners.put(new Utils.HashableIntPair(6, 6), new BeginningBeginningCombiner());
        combiners.put(new Utils.HashableIntPair(7, 7), new CodeCodeCombiner());
        combiners.put(new Utils.HashableIntPair(67, 67), new CaseCombiner());
        combiners.put(new Utils.HashableIntPair(64, 64), new BofaCombiner());
        combiners.put(new Utils.HashableIntPair(65, 65), new GramCombiner());
        combiners.put(new Utils.HashableIntPair(68, 68), new PosCombiner());
        combiners.put(new Utils.HashableIntPair(66, 66), new IsCombiner());
    }

    static class IsCombiner
    implements Combiner {
        IsCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomInteger decompositionAtomInteger = (DecompositionAtomInteger)decompositionAtomBase;
            DecompositionAtomInteger decompositionAtomInteger2 = (DecompositionAtomInteger)decompositionAtomBase2;
            if (decompositionAtomInteger2.value > 100 || decompositionAtomInteger.value > 100) {
                return null;
            }
            return decompositionAtomInteger2.negated ^ decompositionAtomInteger2.value == decompositionAtomInteger.value ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            if (decompositionAtomBase2.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(this, decompositionAtomBase2, decompositionAtomBase);
            }
            DecompositionAtomInteger decompositionAtomInteger = (DecompositionAtomInteger)decompositionAtomBase;
            DecompositionAtomInteger decompositionAtomInteger2 = (DecompositionAtomInteger)decompositionAtomBase2;
            if (decompositionAtomInteger2.value > 100 || decompositionAtomInteger.value > 100) {
                return null;
            }
            if (decompositionAtomInteger2.value == decompositionAtomInteger.value) {
                return decompositionAtomInteger2.negated ? DecompositionAtom.True : decompositionAtomBase2;
            }
            return decompositionAtomInteger2.negated ? decompositionAtomBase2 : null;
        }
    }

    static class PosCombiner
    extends MaskCombiner {
        PosCombiner() {
        }

        @Override
        public DecompositionAtom createNew(int n) {
            return new DecompositionAtomPos(n, false);
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            int n;
            DecompositionAtomInteger decompositionAtomInteger = (DecompositionAtomInteger)decompositionAtomBase;
            DecompositionAtomInteger decompositionAtomInteger2 = (DecompositionAtomInteger)decompositionAtomBase2;
            int n2 = decompositionAtomInteger2.value;
            if (decompositionAtomInteger2.negated) {
                n2 ^= 0xFFFFFFFF;
            }
            if ((n = decompositionAtomInteger.value & n2) == 0) {
                return DecompositionAtom.False;
            }
            if (n == n2) {
                return decompositionAtomBase2;
            }
            if (n == decompositionAtomInteger.value) {
                return decompositionAtomBase;
            }
            return this.createNew(n);
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            if (decompositionAtomBase2.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(this, decompositionAtomBase2, decompositionAtomBase);
            }
            DecompositionAtomInteger decompositionAtomInteger = (DecompositionAtomInteger)decompositionAtomBase;
            DecompositionAtomInteger decompositionAtomInteger2 = (DecompositionAtomInteger)decompositionAtomBase2;
            int n = decompositionAtomInteger.value | decompositionAtomInteger2.value;
            if (n == decompositionAtomInteger.value) {
                return decompositionAtomBase;
            }
            return this.createNew(n);
        }
    }

    static class GramCombiner
    extends MaskCombiner {
        GramCombiner() {
        }

        @Override
        public DecompositionAtom createNew(int n) {
            return new DecompositionAtomGrammar(n, false);
        }
    }

    static class CaseCombiner
    extends MaskCombiner {
        CaseCombiner() {
        }

        @Override
        public DecompositionAtom createNew(int n) {
            return new DecompositionAtomCase(n, false);
        }
    }

    static class BofaCombiner
    extends MaskCombiner {
        BofaCombiner() {
        }

        @Override
        public DecompositionAtom createNew(int n) {
            return new DecompositionAtomBofa(n, false);
        }
    }

    static abstract class MaskCombiner
    implements Combiner {
        MaskCombiner() {
        }

        abstract DecompositionAtom createNew(int var1);

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomInteger decompositionAtomInteger = (DecompositionAtomInteger)decompositionAtomBase;
            DecompositionAtomInteger decompositionAtomInteger2 = (DecompositionAtomInteger)decompositionAtomBase2;
            if (decompositionAtomInteger2.negated) {
                int n = decompositionAtomInteger.value & ~decompositionAtomInteger2.value;
                if (n == 0) {
                    return DecompositionAtom.False;
                }
                if ((decompositionAtomInteger2.value & ~decompositionAtomInteger.value) != 0) {
                    return null;
                }
                return this.createNew(n);
            }
            int n = decompositionAtomInteger.value & decompositionAtomInteger2.value;
            if (n == decompositionAtomInteger2.value) {
                return decompositionAtomBase2;
            }
            if (n == decompositionAtomInteger.value) {
                return decompositionAtomBase;
            }
            return null;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            if (decompositionAtomBase2.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(this, decompositionAtomBase2, decompositionAtomBase);
            }
            DecompositionAtomInteger decompositionAtomInteger = (DecompositionAtomInteger)decompositionAtomBase;
            DecompositionAtomInteger decompositionAtomInteger2 = (DecompositionAtomInteger)decompositionAtomBase2;
            int n = decompositionAtomInteger.value | decompositionAtomInteger2.value;
            if (n == decompositionAtomInteger.value) {
                return decompositionAtomBase;
            }
            return this.createNew(n);
        }
    }

    static class CodeCodeCombiner
    implements Combiner {
        CodeCodeCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString.toMatch.length() == 0) {
                return decompositionAtomString2.negated ? null : decompositionAtomBase2;
            }
            if (decompositionAtomString2.toMatch.length() == 0) {
                return decompositionAtomString2.negated ? DecompositionAtom.False : decompositionAtomBase;
            }
            StringBuilder stringBuilder = DecompositionAtomCombiner.intersectStrings(decompositionAtomString.toMatch, decompositionAtomString2.toMatch, decompositionAtomString2.negated);
            if (stringBuilder.length() == 0) {
                return DecompositionAtom.False;
            }
            if (stringBuilder.length() == decompositionAtomString.toMatch.length()) {
                return decompositionAtomBase;
            }
            return new DecompositionAtomConstraintCode(stringBuilder.toString(), false);
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString.toMatch.length() == 0) {
                return decompositionAtomString2.negated ? DecompositionAtom.True : decompositionAtomBase;
            }
            if (decompositionAtomString2.toMatch.length() == 0) {
                return decompositionAtomString2.negated ? null : decompositionAtomBase2;
            }
            if (decompositionAtomString2.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(this, decompositionAtomBase2, decompositionAtomBase);
            }
            StringBuilder stringBuilder = DecompositionAtomCombiner.mergeStrings(decompositionAtomString.toMatch, decompositionAtomString2.toMatch);
            if (stringBuilder.length() == decompositionAtomString.toMatch.length()) {
                return decompositionAtomBase;
            }
            return new DecompositionAtomConstraintCode(stringBuilder.toString(), false);
        }
    }

    static class EndsEndsCombiner
    implements Combiner {
        EndsEndsCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            StringBuilder stringBuilder = DecompositionAtomCombiner.intersectStrings(decompositionAtomString.toMatch, decompositionAtomString2.toMatch, decompositionAtomString2.negated);
            if (stringBuilder.length() == 0) {
                return DecompositionAtom.False;
            }
            if (stringBuilder.length() == decompositionAtomString.toMatch.length()) {
                return decompositionAtomBase;
            }
            return new DecompositionAtomEndsIn(stringBuilder.toString(), false);
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString2.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(this, decompositionAtomBase2, decompositionAtomBase);
            }
            StringBuilder stringBuilder = DecompositionAtomCombiner.mergeStrings(decompositionAtomString.toMatch, decompositionAtomString2.toMatch);
            if (stringBuilder.length() == decompositionAtomString.toMatch.length()) {
                return decompositionAtomBase;
            }
            return new DecompositionAtomEndsIn(stringBuilder.toString(), false);
        }
    }

    static class StartsStartsCombiner
    implements Combiner {
        StartsStartsCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            StringBuilder stringBuilder = DecompositionAtomCombiner.intersectStrings(decompositionAtomString.toMatch, decompositionAtomString2.toMatch, decompositionAtomString2.negated);
            if (stringBuilder.length() == 0) {
                return DecompositionAtom.False;
            }
            if (stringBuilder.length() == decompositionAtomString.toMatch.length()) {
                return decompositionAtomBase;
            }
            return new DecompositionAtomStartsWith(stringBuilder.toString(), false);
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString2.negated) {
                return DecompositionAtomCombiner.mergeByDemorgan(this, decompositionAtomBase2, decompositionAtomBase);
            }
            StringBuilder stringBuilder = DecompositionAtomCombiner.mergeStrings(decompositionAtomString.toMatch, decompositionAtomString2.toMatch);
            if (stringBuilder.length() == decompositionAtomString.toMatch.length()) {
                return decompositionAtomBase;
            }
            return new DecompositionAtomStartsWith(stringBuilder.toString(), false);
        }
    }

    static class EndingEndingCombiner
    implements Combiner {
        EndingEndingCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            boolean bl;
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString.toMatch.length() < decompositionAtomString2.toMatch.length()) {
                DecompositionAtomString decompositionAtomString3 = decompositionAtomString;
                decompositionAtomString = decompositionAtomString2;
                decompositionAtomString2 = decompositionAtomString3;
            }
            return (bl = decompositionAtomString.toMatch.endsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated) ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            boolean bl;
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString.toMatch.length() < decompositionAtomString2.toMatch.length()) {
                DecompositionAtomString decompositionAtomString3 = decompositionAtomString;
                decompositionAtomString = decompositionAtomString2;
                decompositionAtomString2 = decompositionAtomString3;
            }
            return (bl = decompositionAtomString.toMatch.endsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated) ? decompositionAtomBase2 : null;
        }
    }

    static class MatchEndingCombiner
    implements Combiner {
        MatchEndingCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString.toMatch.endsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString.toMatch.endsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase2 : null;
        }
    }

    static class BeginningBeginningCombiner
    implements Combiner {
        BeginningBeginningCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            boolean bl;
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString.toMatch.length() < decompositionAtomString2.toMatch.length()) {
                DecompositionAtomString decompositionAtomString3 = decompositionAtomString;
                decompositionAtomString = decompositionAtomString2;
                decompositionAtomString2 = decompositionAtomString3;
            }
            return (bl = decompositionAtomString.toMatch.startsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated) ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            boolean bl;
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString.toMatch.length() < decompositionAtomString2.toMatch.length()) {
                DecompositionAtomString decompositionAtomString3 = decompositionAtomString;
                decompositionAtomString = decompositionAtomString2;
                decompositionAtomString2 = decompositionAtomString3;
            }
            return (bl = decompositionAtomString.toMatch.startsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated) ? decompositionAtomBase2 : null;
        }
    }

    static class MatchBeginningCombiner
    implements Combiner {
        MatchBeginningCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString.toMatch.startsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString.toMatch.startsWith(decompositionAtomString2.toMatch) ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase2 : null;
        }
    }

    static class MatchEndsInCombiner
    implements Combiner {
        MatchEndsInCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString2.toMatch.indexOf(decompositionAtomString.toMatch.charAt(decompositionAtomString.toMatch.length() - 1)) >= 0 ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString2.toMatch.indexOf(decompositionAtomString.toMatch.charAt(decompositionAtomString.toMatch.length() - 1)) >= 0 ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase2 : null;
        }
    }

    static class MatchStartsWithCombiner
    implements Combiner {
        MatchStartsWithCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString2.toMatch.indexOf(decompositionAtomString.toMatch.charAt(0)) >= 0 ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            boolean bl = decompositionAtomString2.toMatch.indexOf(decompositionAtomString.toMatch.charAt(0)) >= 0 ^ decompositionAtomString2.negated;
            return bl ? decompositionAtomBase2 : null;
        }
    }

    static class MatchMatchCombiner
    implements Combiner {
        MatchMatchCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            return decompositionAtomString2.negated ^ decompositionAtomString.toMatch.equals(decompositionAtomString2.toMatch) ? decompositionAtomBase : DecompositionAtom.False;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            DecompositionAtomString decompositionAtomString = (DecompositionAtomString)decompositionAtomBase;
            DecompositionAtomString decompositionAtomString2 = (DecompositionAtomString)decompositionAtomBase2;
            if (decompositionAtomString.toMatch.equals(decompositionAtomString2.toMatch)) {
                return decompositionAtomString2.negated ? DecompositionAtom.True : decompositionAtomBase;
            }
            return null;
        }
    }

    static class TrueCombiner
    implements Combiner {
        TrueCombiner() {
        }

        @Override
        public DecompositionAtom intersect(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            return decompositionAtomBase2;
        }

        @Override
        public DecompositionAtom merge(DecompositionAtomBase decompositionAtomBase, DecompositionAtomBase decompositionAtomBase2) {
            return DecompositionAtom.True;
        }
    }

    private static interface Combiner {
        public DecompositionAtom merge(DecompositionAtomBase var1, DecompositionAtomBase var2);

        public DecompositionAtom intersect(DecompositionAtomBase var1, DecompositionAtomBase var2);
    }
}

