/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionAtomBofa;
import com.ibm.dltj.decomposition.DecompositionAtomCase;
import com.ibm.dltj.decomposition.DecompositionAtomConstraintCode;
import com.ibm.dltj.decomposition.DecompositionAtomEndsIn;
import com.ibm.dltj.decomposition.DecompositionAtomGrammar;
import com.ibm.dltj.decomposition.DecompositionAtomIs;
import com.ibm.dltj.decomposition.DecompositionAtomLemma;
import com.ibm.dltj.decomposition.DecompositionAtomMatch;
import com.ibm.dltj.decomposition.DecompositionAtomMatchBeginning;
import com.ibm.dltj.decomposition.DecompositionAtomMatchEnding;
import com.ibm.dltj.decomposition.DecompositionAtomPos;
import com.ibm.dltj.decomposition.DecompositionAtomStartsWith;
import com.ibm.dltj.decomposition.DecompositionAtomWordCase;
import com.ibm.dltj.decomposition.DecompositionConjunction;
import com.ibm.dltj.decomposition.DecompositionDisjunction;
import java.io.DataInput;
import java.io.IOException;

public class DecompositionAtomFactory {
    static final int ATOM_TRUE = 0;
    static final int ATOM_MATCH = 1;
    static final int ATOM_LEMMA = 2;
    static final int ATOM_ENDS_IN = 3;
    static final int ATOM_STARTS_WITH = 4;
    static final int ATOM_MATCH_ENDING = 5;
    static final int ATOM_MATCH_BEGINNING = 6;
    static final int ATOM_CONSTRAINT_CODE = 7;
    public static final int ATOM_BOFA = 64;
    public static final int ATOM_GRAM = 65;
    static final int ATOM_IS = 66;
    static final int ATOM_CASE = 67;
    public static final int ATOM_POS = 68;
    static final int ATOM_WORD_CASE = 69;
    public static final int ATOM_CONJUNCTION = 128;
    static final int ATOM_DISJUNCTION = 129;
    public static final int ATOM_LAST_STRING = 63;
    static final int ATOM_LAST_INT = 127;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public static DecompositionAtom createAtom(int n, int n2, boolean bl) {
        switch (n) {
            case 64: {
                return new DecompositionAtomBofa(n2, bl);
            }
            case 68: {
                return new DecompositionAtomPos(n2, bl);
            }
            case 66: {
                return new DecompositionAtomIs(n2, bl);
            }
            case 65: {
                return new DecompositionAtomGrammar(n2, bl);
            }
            case 67: {
                return new DecompositionAtomCase(n2, bl);
            }
            case 69: {
                return new DecompositionAtomWordCase(n2, bl);
            }
        }
        return null;
    }

    public static DecompositionAtom createAtom(int n, String string, boolean bl) {
        switch (n) {
            case 1: {
                return new DecompositionAtomMatch(string, bl);
            }
            case 2: {
                return new DecompositionAtomLemma(string, bl);
            }
            case 3: {
                return new DecompositionAtomEndsIn(string, bl);
            }
            case 4: {
                return new DecompositionAtomStartsWith(string, bl);
            }
            case 6: {
                return new DecompositionAtomMatchBeginning(string, bl);
            }
            case 5: {
                return new DecompositionAtomMatchEnding(string, bl);
            }
            case 7: {
                return new DecompositionAtomConstraintCode(string, bl);
            }
        }
        return null;
    }

    static DecompositionAtom load(DataInput dataInput) throws IOException, DLTException {
        int n = dataInput.readInt();
        boolean bl = dataInput.readBoolean();
        if (n == 0) {
            return bl ? DecompositionAtom.False : DecompositionAtom.True;
        }
        if (n <= 63) {
            String string = dataInput.readUTF();
            return DecompositionAtomFactory.createAtom(n, string, bl);
        }
        if (n <= 127) {
            int n2 = dataInput.readInt();
            return DecompositionAtomFactory.createAtom(n, n2, bl);
        }
        switch (n) {
            case 128: {
                return DecompositionConjunction.load(dataInput, bl);
            }
            case 129: {
                return DecompositionDisjunction.load(dataInput, bl);
            }
        }
        throw new DLTException(Messages.getString("invalid.decomposition.atom"));
    }
}

