/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.decomposition.DecompositionAtomBase;
import java.io.DataOutput;
import java.io.IOException;

abstract class DecompositionAtomInteger
extends DecompositionAtomBase {
    final int value;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    DecompositionAtomInteger(int n, boolean bl) {
        super(bl);
        this.value = n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DecompositionAtomInteger decompositionAtomInteger = (DecompositionAtomInteger)object;
        return this.value == decompositionAtomInteger.value && this.negated == decompositionAtomInteger.negated;
    }

    @Override
    public void save(DataOutput dataOutput) throws IOException {
        super.save(dataOutput);
        dataOutput.writeInt(this.value);
    }

    public int hashCode() {
        return this.getType() << 13 ^ (this.negated ? -1 : 0) ^ this.value;
    }

    @Override
    public boolean perSurfaceForm() {
        return false;
    }

    String decomposeMask() {
        int n;
        String string = "";
        for (n = 0; n < 32; ++n) {
            if ((this.value & 1 << n) == 0) continue;
            string = string + n;
            break;
        }
        ++n;
        while (n < 32) {
            if ((this.value & 1 << n) != 0) {
                string = string + '|';
                string = string + n;
            }
            ++n;
        }
        return string;
    }
}

