/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionAtomCombiner;
import com.ibm.dltj.decomposition.DecompositionAtomFactory;
import com.ibm.dltj.decomposition.DecompositionDisjunction;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class DecompositionConjunction
implements DecompositionAtom {
    DecompositionAtom[] conjuncts;
    boolean perSurfaceForm;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    DecompositionConjunction(DecompositionAtom[] decompositionAtomArray) {
        this.conjuncts = decompositionAtomArray;
        boolean bl = true;
        for (DecompositionAtom decompositionAtom : decompositionAtomArray) {
            bl &= decompositionAtom.perSurfaceForm();
        }
        this.perSurfaceForm = bl;
    }

    public static DecompositionAtom makeConjunction(Collection<DecompositionAtom> collection) {
        if (collection.isEmpty()) {
            return DecompositionAtom.False;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        ArrayList<DecompositionAtom> arrayList = new ArrayList<DecompositionAtom>();
        boolean bl = true;
        block0: for (DecompositionAtom decompositionAtom : collection) {
            for (int i = 0; i < arrayList.size(); ++i) {
                DecompositionAtom decompositionAtom2 = DecompositionAtomCombiner.intersect(decompositionAtom, (DecompositionAtom)arrayList.get(i));
                if (decompositionAtom2 == null) continue;
                arrayList.set(i, decompositionAtom2);
                bl = false;
                continue block0;
            }
            arrayList.add(decompositionAtom);
        }
        if (bl) {
            return new DecompositionConjunction(arrayList.toArray(new DecompositionAtom[arrayList.size()]));
        }
        return DecompositionConjunction.makeConjunction(arrayList);
    }

    @Override
    public int getType() {
        return 128;
    }

    @Override
    public DecompositionAtom negate() {
        DecompositionAtom[] decompositionAtomArray = new DecompositionAtom[this.conjuncts.length];
        for (int i = 0; i < this.conjuncts.length; ++i) {
            decompositionAtomArray[i] = this.conjuncts[i].negate();
        }
        return new DecompositionDisjunction(decompositionAtomArray);
    }

    @Override
    public boolean perSurfaceForm() {
        return this.perSurfaceForm;
    }

    @Override
    public void save(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.getType());
        dataOutput.writeBoolean(false);
        dataOutput.writeInt(this.conjuncts.length);
        for (DecompositionAtom decompositionAtom : this.conjuncts) {
            decompositionAtom.save(dataOutput);
        }
    }

    @Override
    public boolean test(Gloss gloss, int n, int n2, DecompositionAtom.ExtraInfoAccess extraInfoAccess) {
        for (DecompositionAtom decompositionAtom : this.conjuncts) {
            if (decompositionAtom.test(gloss, n, n2, extraInfoAccess)) continue;
            return false;
        }
        return true;
    }

    public static DecompositionAtom load(DataInput dataInput, boolean bl) throws IOException, DLTException {
        int n = dataInput.readInt();
        DecompositionAtom[] decompositionAtomArray = new DecompositionAtom[n];
        for (int i = 0; i < n; ++i) {
            decompositionAtomArray[i] = DecompositionAtomFactory.load(dataInput);
        }
        DecompositionConjunction decompositionConjunction = new DecompositionConjunction(decompositionAtomArray);
        return bl ? decompositionConjunction.negate() : decompositionConjunction;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(91);
        boolean bl = false;
        for (DecompositionAtom decompositionAtom : this.conjuncts) {
            if (bl) {
                stringBuilder.append('&');
            } else {
                bl = true;
            }
            stringBuilder.append(decompositionAtom.toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static DecompositionAtom makeConjunction(DecompositionAtom decompositionAtom, DecompositionAtom decompositionAtom2) {
        ArrayList<DecompositionAtom> arrayList = new ArrayList<DecompositionAtom>();
        if (decompositionAtom instanceof DecompositionConjunction) {
            arrayList.addAll(Arrays.asList(((DecompositionConjunction)decompositionAtom).conjuncts));
        } else {
            arrayList.add(decompositionAtom);
        }
        if (decompositionAtom2 instanceof DecompositionConjunction) {
            arrayList.addAll(Arrays.asList(((DecompositionConjunction)decompositionAtom2).conjuncts));
        } else {
            arrayList.add(decompositionAtom2);
        }
        return DecompositionConjunction.makeConjunction(arrayList);
    }

    private boolean containsAtom(DecompositionAtom decompositionAtom) {
        for (DecompositionAtom decompositionAtom2 : this.conjuncts) {
            if (!decompositionAtom2.equals(decompositionAtom)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(DecompositionAtom decompositionAtom) {
        if (!(decompositionAtom instanceof DecompositionConjunction)) {
            return this.containsAtom(decompositionAtom);
        }
        DecompositionConjunction decompositionConjunction = (DecompositionConjunction)decompositionAtom;
        for (DecompositionAtom decompositionAtom2 : decompositionConjunction.conjuncts) {
            if (this.containsAtom(decompositionAtom2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        DecompositionConjunction decompositionConjunction = (DecompositionConjunction)object;
        return this.contains(decompositionConjunction) && decompositionConjunction.contains(this);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.conjuncts);
        return n;
    }
}

