/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionAtomCombiner;
import com.ibm.dltj.decomposition.DecompositionAtomFactory;
import com.ibm.dltj.decomposition.DecompositionConjunction;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class DecompositionDisjunction
implements DecompositionAtom {
    DecompositionAtom[] disjuncts;
    boolean perSurfaceForm;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    DecompositionDisjunction(DecompositionAtom[] decompositionAtomArray) {
        this.disjuncts = decompositionAtomArray;
        boolean bl = true;
        for (DecompositionAtom decompositionAtom : decompositionAtomArray) {
            bl &= decompositionAtom.perSurfaceForm();
        }
        this.perSurfaceForm = bl;
    }

    public static DecompositionAtom makeDisjunction(Collection<DecompositionAtom> collection) {
        if (collection.isEmpty()) {
            return DecompositionAtom.False;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        ArrayList<DecompositionAtom> arrayList = new ArrayList<DecompositionAtom>();
        boolean bl = true;
        block0: for (DecompositionAtom decompositionAtom : collection) {
            for (int i = 0; i < arrayList.size(); ++i) {
                DecompositionAtom decompositionAtom2 = DecompositionAtomCombiner.merge(decompositionAtom, (DecompositionAtom)arrayList.get(i));
                if (decompositionAtom2 == null) continue;
                arrayList.set(i, decompositionAtom2);
                bl = false;
                continue block0;
            }
            arrayList.add(decompositionAtom);
        }
        if (bl) {
            return new DecompositionDisjunction(arrayList.toArray(new DecompositionAtom[arrayList.size()]));
        }
        return DecompositionDisjunction.makeDisjunction(arrayList);
    }

    @Override
    public int getType() {
        return 129;
    }

    @Override
    public DecompositionAtom negate() {
        DecompositionAtom[] decompositionAtomArray = new DecompositionAtom[this.disjuncts.length];
        for (int i = 0; i < this.disjuncts.length; ++i) {
            decompositionAtomArray[i] = this.disjuncts[i].negate();
        }
        return new DecompositionConjunction(decompositionAtomArray);
    }

    @Override
    public boolean perSurfaceForm() {
        return this.perSurfaceForm;
    }

    @Override
    public void save(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.getType());
        dataOutput.writeBoolean(false);
        dataOutput.writeInt(this.disjuncts.length);
        for (DecompositionAtom decompositionAtom : this.disjuncts) {
            decompositionAtom.save(dataOutput);
        }
    }

    @Override
    public boolean test(Gloss gloss, int n, int n2, DecompositionAtom.ExtraInfoAccess extraInfoAccess) {
        for (DecompositionAtom decompositionAtom : this.disjuncts) {
            if (!decompositionAtom.test(gloss, n, n2, extraInfoAccess)) continue;
            return true;
        }
        return false;
    }

    public static DecompositionAtom load(DataInput dataInput, boolean bl) throws IOException, DLTException {
        int n = dataInput.readInt();
        DecompositionAtom[] decompositionAtomArray = new DecompositionAtom[n];
        for (int i = 0; i < n; ++i) {
            decompositionAtomArray[i] = DecompositionAtomFactory.load(dataInput);
        }
        DecompositionDisjunction decompositionDisjunction = new DecompositionDisjunction(decompositionAtomArray);
        return bl ? decompositionDisjunction.negate() : decompositionDisjunction;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(91);
        boolean bl = false;
        for (DecompositionAtom decompositionAtom : this.disjuncts) {
            if (bl) {
                stringBuilder.append('|');
            } else {
                bl = true;
            }
            stringBuilder.append(decompositionAtom.toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static DecompositionAtom makeDisjunction(DecompositionAtom decompositionAtom, DecompositionAtom decompositionAtom2) {
        ArrayList<DecompositionAtom> arrayList = new ArrayList<DecompositionAtom>();
        if (decompositionAtom instanceof DecompositionDisjunction) {
            arrayList.addAll(Arrays.asList(((DecompositionDisjunction)decompositionAtom).disjuncts));
        } else {
            arrayList.add(decompositionAtom);
        }
        if (decompositionAtom2 instanceof DecompositionDisjunction) {
            arrayList.addAll(Arrays.asList(((DecompositionDisjunction)decompositionAtom2).disjuncts));
        } else {
            arrayList.add(decompositionAtom2);
        }
        return DecompositionDisjunction.makeDisjunction(arrayList);
    }

    private boolean containsAtom(DecompositionAtom decompositionAtom) {
        for (DecompositionAtom decompositionAtom2 : this.disjuncts) {
            if (!decompositionAtom2.equals(decompositionAtom)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(DecompositionAtom decompositionAtom) {
        if (!(decompositionAtom instanceof DecompositionDisjunction)) {
            return this.containsAtom(decompositionAtom);
        }
        DecompositionDisjunction decompositionDisjunction = (DecompositionDisjunction)decompositionAtom;
        for (DecompositionAtom decompositionAtom2 : decompositionDisjunction.disjuncts) {
            if (this.containsAtom(decompositionAtom2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        DecompositionDisjunction decompositionDisjunction = (DecompositionDisjunction)object;
        return this.contains(decompositionDisjunction) && decompositionDisjunction.contains(this);
    }
}

