/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionAtomFactory;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import com.ibm.dltj.netgeneric.Statistics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class DecompositionRuleFsa
implements Statistics {
    final NetGeneric net;
    final NetGenericReadOnly reader;
    final DecompositionAtom[] atoms;
    public static final int INDEX_FIRST = 4;
    public static final int INDEX_NEXT = 4;
    public static final int INDEX_ENTRY = 3;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public DecompositionRuleFsa(NetGeneric netGeneric, List<? extends DecompositionAtom> list) {
        assert (netGeneric != null);
        this.net = netGeneric;
        this.net.setTransitionToStringMapper(this);
        this.reader = netGeneric.getReader();
        this.atoms = list.toArray(new DecompositionAtom[list.size()]);
    }

    public DecompositionRuleFsa(DataInput dataInput) throws DLTException, IOException {
        int n = dataInput.readInt();
        this.net = NetGenericFactory.load(dataInput, 4, n + 4, null);
        this.net.setTransitionToStringMapper(this);
        this.reader = this.net.getReader();
        int n2 = dataInput.readInt();
        assert (n2 == n);
        this.atoms = new DecompositionAtom[n];
        for (int i = 0; i < n; ++i) {
            this.atoms[i] = DecompositionAtomFactory.load(dataInput);
        }
    }

    public void savefinal(DataOutput dataOutput) throws IOException, DLTException {
        dataOutput.writeInt(this.reader.getMaxIndex() - 4);
        NetGenericFactory.save(dataOutput, this.net);
        dataOutput.writeInt(this.atoms.length);
        for (DecompositionAtom decompositionAtom : this.atoms) {
            decompositionAtom.save(dataOutput);
        }
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.net.dumpNet(printStream, n);
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        return this.net.dumpNet(printStream);
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        this.net.printStatistics(printStream);
        printStream.println("Atoms used: " + this.atoms.length);
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
        this.net.setTransitionToStringMapper(statistics);
    }

    @Override
    public String transitionToString(int n, int n2) {
        if (n >= 4) {
            return this.atoms[n - 4].toString() + "->" + n2;
        }
        if (n == 3) {
            return "entry " + n2;
        }
        if (n == 4) {
            return "next " + n2;
        }
        return "*** unknown: " + n + "->" + n2;
    }

    @Override
    public boolean verifyConsistency() {
        return this.net.verifyConsistency();
    }
}

