/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.decomposition.ComponentList;
import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionAtomFactory;
import com.ibm.dltj.decomposition.FSAComponent;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.netgeneric.Statistics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class DecompositionRuleSet
implements Statistics {
    static final int INDEX_PAYLOAD = 2;
    static final int INDEX_TEST = 3;
    static final int INDEX_NEXT_SEGMENT = 4;
    static final int INDEX_ON_FALSE = 5;
    static final int INDEX_ON_TRUE = 6;
    static final int INDEX_MAX = 7;
    final List<DecompositionAtom> tests;
    NetGeneric net;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public DecompositionRuleSet(BuildNode buildNode, List<DecompositionAtom> list) throws DLTException {
        this.net = NetGenericFactory.create(448061489, 4, null);
        this.net.setMaxIndex(7);
        this.net.setPayloadManipulator(2, PayloadManipulator.SimpleInteger);
        this.net.setPayloadManipulator(3, PayloadManipulator.SimpleInteger);
        this.net.setTransitionToStringMapper(this);
        this.net.attachFSA(NetGeneric.IndexIterator.Root, buildNode);
        this.net.endModify();
        this.tests = list;
    }

    public DecompositionRuleSet(DataInput dataInput) throws DLTException, IOException {
        this.tests = DecompositionRuleSet.loadList(dataInput);
        this.net = NetGenericFactory.load(dataInput, 4, 7, null);
        this.net.setPayloadManipulator(2, PayloadManipulator.SimpleInteger);
        this.net.setPayloadManipulator(3, PayloadManipulator.SimpleInteger);
        this.net.setTransitionToStringMapper(this);
    }

    public void save(DataOutput dataOutput) throws IOException, DLTException {
        dataOutput.writeInt(this.tests.size());
        for (DecompositionAtom decompositionAtom : this.tests) {
            decompositionAtom.save(dataOutput);
        }
        NetGenericFactory.save(dataOutput, this.net);
    }

    static List<DecompositionAtom> loadList(DataInput dataInput) throws IOException, DLTException {
        int n = dataInput.readInt();
        ArrayList<DecompositionAtom> arrayList = new ArrayList<DecompositionAtom>(n);
        for (int i = 0; i < n; ++i) {
            DecompositionAtom decompositionAtom = DecompositionAtomFactory.load(dataInput);
            arrayList.add(decompositionAtom);
        }
        return arrayList;
    }

    public ComponentList<FSAComponent> getComponentList() {
        FSAComponent fSAComponent = new FSAComponent(this.net, this.tests.toArray(new DecompositionAtom[this.tests.size()]));
        ComponentList<FSAComponent> componentList = new ComponentList<FSAComponent>(fSAComponent);
        fSAComponent.access = componentList;
        return componentList;
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.net.dumpNet(printStream, n);
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        printStream.print(this.tests.size());
        printStream.print(" tests ");
        this.net.printStatistics(printStream);
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
    }

    @Override
    public String transitionToString(int n, int n2) {
        switch (n) {
            case 2: {
                return "pay(" + n2 + ")";
            }
            case 3: {
                return this.tests.get(n2).toString();
            }
            case 4: {
                return "next->" + n2;
            }
            case 5: {
                return "false->" + n2;
            }
            case 6: {
                return "true->" + n2;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean verifyConsistency() {
        return this.net.verifyConsistency();
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        printStream.println(this.toString());
        return this.net.dumpNet(printStream);
    }

    public String toString() {
        return "Tests: " + this.tests;
    }
}

