/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.decomposition.ComponentList;
import com.ibm.dltj.decomposition.Decomposer;
import com.ibm.dltj.decomposition.DecompositionAtom;
import com.ibm.dltj.decomposition.DecompositionState;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.util.IntArray;
import java.util.Iterator;

public final class FSAComponent
extends Decomposer.Component<FSAComponent> {
    private static final int CODE_FEATURE_MASK = 15;
    private static final int CODE_EXCEPTION = 0;
    private static final int CODE_UNFILTERED = 12;
    ComponentList<FSAComponent> access;
    final NetGeneric net;
    final DecompositionAtom[] tests;
    final IntArray inStates;
    final DecompositionState outStates;
    int cur_state;
    final IntArray backPath;
    int bits;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public FSAComponent(NetGeneric netGeneric, DecompositionAtom[] decompositionAtomArray) {
        this.net = netGeneric;
        this.tests = decompositionAtomArray;
        this.inStates = new IntArray();
        this.outStates = new DecompositionState();
        this.backPath = new IntArray();
        this.inStates.add(netGeneric.first_base());
    }

    @Override
    public FSAComponent createNew() {
        FSAComponent fSAComponent = new FSAComponent(this.net, this.tests);
        fSAComponent.access = this.access;
        return fSAComponent;
    }

    @Override
    public int final_code() {
        int n = -1;
        for (int i = 0; i < this.inStates.size(); ++i) {
            int n2 = this.inStates.get(i);
            n = Math.max(n, this.net.takeTransition(n2, 2, -1));
        }
        return (n & 0xF) == 0 ? -1 : n;
    }

    @Override
    public FSAComponent next_state() {
        Object object2;
        GlossCollection glossCollection = this.glosses;
        int n = glossCollection.size();
        this.outStates.clear();
        if (n < 2) {
            int n2 = 1;
            for (Gloss gloss : glossCollection) {
                for (int i = 0; i < this.inStates.size(); ++i) {
                    this.cur_state = this.inStates.get(i);
                    this.execute(this.cur_state, gloss, n2);
                }
                n2 <<= 1;
            }
        } else if (n < 32) {
            for (int i = 0; i < this.inStates.size(); ++i) {
                this.cur_state = this.inStates.get(i);
                this.execute(this.cur_state, (1 << n) - 1);
            }
        } else {
            for (Object object2 : glossCollection) {
                for (int i = 0; i < this.inStates.size(); ++i) {
                    this.cur_state = this.inStates.get(i);
                    this.execute(this.cur_state, (Gloss)object2, 0);
                }
            }
        }
        if (this.outStates.isEmpty()) {
            return null;
        }
        FSAComponent fSAComponent = (FSAComponent)this.getNext();
        object2 = fSAComponent.inStates;
        ((IntArray)object2).clear();
        for (int i = 0; i < this.outStates.getCount(); ++i) {
            ((IntArray)object2).add(this.outStates.getOutNode(i));
        }
        ((IntArray)object2).removeDuplicates();
        return fSAComponent;
    }

    final void execute(int n, int n2) {
        while (n != -1) {
            int n3;
            this.process_output(n, n2);
            DecompositionAtom decompositionAtom = this.tests[this.net.takeTransition(n, 3, 0)];
            Iterator iterator = this.glosses.iterator();
            Gloss gloss = (Gloss)iterator.next();
            int n4 = 0;
            int n5 = 1;
            while ((n2 & n5) == 0) {
                ++n4;
                n5 <<= 1;
                assert (iterator.hasNext());
                gloss = (Gloss)iterator.next();
            }
            if (n2 == n5) {
                this.execute(n, gloss, n2);
                return;
            }
            boolean bl = decompositionAtom.test(gloss, this.start, this.end, this.access);
            boolean bl2 = true;
            if (!decompositionAtom.perSurfaceForm()) {
                while (bl2 && iterator.hasNext()) {
                    ++n4;
                    gloss = (Gloss)iterator.next();
                    if ((n2 & (n5 <<= 1)) == 0 || decompositionAtom.test(gloss, this.start, this.end, this.access) == bl) continue;
                    bl2 = false;
                }
            }
            if (bl2) {
                n3 = bl ? 6 : 5;
                n = this.net.takeTransition(n, n3, -1);
                continue;
            }
            n3 = n2;
            int n6 = n2;
            if (bl) {
                n3 &= ~n5;
                n6 &= ~(n5 - 1);
            } else {
                n6 &= ~n5;
                n3 &= ~(n5 - 1);
            }
            while (iterator.hasNext()) {
                ++n4;
                gloss = (Gloss)iterator.next();
                if ((n2 & (n5 <<= 1)) == 0) continue;
                if (decompositionAtom.test(gloss, this.start, this.end, this.access)) {
                    n6 &= ~n5;
                    continue;
                }
                n3 &= ~n5;
            }
            if (this.net.transitionPresent(n, 6)) {
                this.execute(this.net.transitionValue(n, 6), n3);
            }
            n = this.net.takeTransition(n, 5, -1);
            n2 = n6;
        }
    }

    private void process_output(int n, int n2) {
        if (this.net.transitionPresent(n, 4)) {
            int n3 = this.net.transitionValue(n, 4);
            this.outStates.add(this.cur_state, n3, n2);
        }
    }

    final void execute(int n, Gloss gloss, int n2) {
        DecompositionAtom decompositionAtom;
        int n3;
        do {
            this.process_output(n, n2);
        } while ((n = this.net.takeTransition(n, n3 = (decompositionAtom = this.tests[this.net.takeTransition(n, 3, 0)]).test(gloss, this.start, this.end, this.access) ? 6 : 5, -1)) != -1);
    }

    @Override
    public void choose_final_path(FSAComponent fSAComponent) {
        if (fSAComponent == this) {
            if (this.access.isDecompositionUnfiltered()) {
                this.backPath.clear();
                return;
            }
            int n = -1;
            for (int i = 0; i < this.inStates.size(); ++i) {
                int n2 = this.inStates.get(i);
                int n3 = this.net.takeTransition(n2, 2, -1);
                if (n3 > n) {
                    n = n3;
                    this.backPath.clear();
                    this.backPath.add(n2);
                    continue;
                }
                if (n3 != n) continue;
                this.backPath.add(n2);
            }
            if ((n & 0xF) == 12) {
                this.backPath.clear();
            }
            return;
        }
        FSAComponent fSAComponent2 = (FSAComponent)this.getNext();
        fSAComponent2.choose_final_path(fSAComponent);
        this.backPath.clear();
        IntArray intArray = fSAComponent2.backPath;
        if (intArray.isEmpty()) {
            return;
        }
        this.bits = 0;
        for (int i = 0; i < this.outStates.getCount(); ++i) {
            if (!intArray.contains(this.outStates.getOutNode(i))) continue;
            this.backPath.add(this.outStates.getInNode(i));
            this.bits |= this.outStates.getBitSet(i);
        }
        assert (this.bits != 0);
    }

    @Override
    public GlossCollection filtered_glosses() {
        Gloss gloss;
        GlossCollection glossCollection = this.glosses;
        if (this.backPath.isEmpty()) {
            return glossCollection;
        }
        if (this.bits == 0) {
            return this.filtered_by_retesting();
        }
        Iterator iterator = glossCollection.iterator();
        Gloss gloss2 = null;
        boolean bl = true;
        int n = 1;
        while (bl && iterator.hasNext()) {
            gloss2 = (Gloss)iterator.next();
            if ((this.bits & n) == 0) {
                bl = false;
            }
            n <<= 1;
        }
        if (bl) {
            return glossCollection;
        }
        GlossCollection glossCollection2 = new GlossCollection();
        Iterator iterator2 = glossCollection.iterator();
        while ((gloss = (Gloss)iterator2.next()) != gloss2) {
            glossCollection2.add(gloss);
        }
        while (iterator.hasNext()) {
            gloss2 = (Gloss)iterator.next();
            if ((this.bits & n) != 0) {
                glossCollection2.add(gloss2);
            }
            n <<= 1;
        }
        assert (!glossCollection2.isEmpty());
        return glossCollection2;
    }

    public GlossCollection filtered_by_retesting() {
        Gloss gloss;
        IntArray intArray = ((FSAComponent)this.getNext()).backPath;
        Iterator iterator = this.glosses.iterator();
        Gloss gloss2 = null;
        boolean bl = true;
        while (bl && iterator.hasNext()) {
            gloss2 = (Gloss)iterator.next();
            if (this.reaches(this.backPath, gloss2, intArray)) continue;
            bl = false;
        }
        if (bl) {
            return this.glosses;
        }
        GlossCollection glossCollection = new GlossCollection();
        Iterator iterator2 = this.glosses.iterator();
        while ((gloss = (Gloss)iterator2.next()) != gloss2) {
            glossCollection.add(gloss);
        }
        while (iterator.hasNext()) {
            gloss2 = (Gloss)iterator.next();
            if (!this.reaches(this.backPath, gloss2, intArray)) continue;
            glossCollection.add(gloss2);
        }
        assert (!glossCollection.isEmpty());
        return glossCollection;
    }

    boolean reaches(int n, Gloss gloss, IntArray intArray) {
        DecompositionAtom decompositionAtom;
        int n2;
        do {
            if (!this.net.transitionPresent(n, 4) || !intArray.contains(this.net.transitionValue(n, 4))) continue;
            return true;
        } while ((n = this.net.takeTransition(n, n2 = (decompositionAtom = this.tests[this.net.takeTransition(n, 3, 0)]).test(gloss, this.start, this.end, this.access) ? 6 : 5, -1)) != -1);
        return false;
    }

    boolean reaches(IntArray intArray, Gloss gloss, IntArray intArray2) {
        for (int i = 0; i < intArray.size(); ++i) {
            if (!this.reaches(intArray.get(i), gloss, intArray2)) continue;
            return true;
        }
        return false;
    }
}

