/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.decomposition;

import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.decomposition.ComponentList;
import com.ibm.dltj.decomposition.Decomposer;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import java.text.CharacterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class FSADecomposer<COMPONENT extends Decomposer.Component<COMPONENT>>
implements Decomposer {
    private final ComponentList<COMPONENT> clist;
    private final Decomposer.DecompositionTarget target;
    private final MatchBuffer match_buffer = new MatchBuffer();
    private CharacterIterator itr;
    private MultiNet[] nets;
    private MultiNet onenet;
    private int compound_end;
    private int count;
    private boolean aborted = false;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public FSADecomposer(Decomposer.DecompositionTarget decompositionTarget, ComponentList<COMPONENT> componentList) {
        this.clist = componentList;
        this.clist.setDecompositionTarget(decompositionTarget);
        this.target = decompositionTarget;
    }

    @Override
    public void decompose(int n, int n2, CharacterIterator characterIterator, Object object) {
        if (this.aborted) {
            return;
        }
        this.itr = characterIterator;
        this.clist.setCharacterIterator(characterIterator);
        this.compound_end = n2;
        this.nets = object instanceof MultiNet ? null : (MultiNet[])object;
        this.onenet = object instanceof MultiNet ? (MultiNet)object : null;
        this.aborted = !this.do_decompose(n);
        this.match_buffer.clear();
        this.clist.clear();
    }

    private boolean do_decompose(int n) {
        Decomposer.Component component = (Decomposer.Component)this.clist.getCurItem();
        this.clist.commitItem();
        component.start = n;
        int n2 = this.match_buffer.mpos;
        this.lookup(n);
        int n3 = this.match_buffer.mpos;
        for (int i = n3 - 1; i >= n2; --i) {
            GlossCollection glossCollection = this.match_buffer.gloss[i];
            int n4 = this.match_buffer.index[i];
            if (n4 > this.compound_end) continue;
            component.end = n4;
            component.glosses = glossCollection;
            Object t = component.next_state();
            if (t == null) continue;
            if (n4 == this.compound_end) {
                int n5 = ((Decomposer.Component)t).final_code();
                if (n5 < 0) continue;
                ((Decomposer.Component)this.clist.getFirst()).choose_final_path(t);
                if (!this.target.processDecomposition(this.clist, this.count)) {
                    return false;
                }
                ++this.count;
                continue;
            }
            if (this.do_decompose(n4)) continue;
            return false;
        }
        if (n3 > n2) {
            this.match_buffer.popMatch();
        }
        this.clist.popItem(component);
        return true;
    }

    private void lookup(int n) {
        int n2 = this.match_buffer.mpos;
        int n3 = 0;
        if (this.nets != null) {
            for (int i = 0; i < this.nets.length; ++i) {
                this.itr.setIndex(n);
                if (this.nets[i].traverse(this.itr, this.match_buffer) <= 0) continue;
                ++n3;
            }
            if (n3 > 1) {
                this.combineDuplicateIndices(n2);
            }
        } else {
            this.itr.setIndex(n);
            this.onenet.traverse(this.itr, this.match_buffer);
        }
    }

    private void combineDuplicateIndices(int n) {
        Object object;
        int n2 = this.match_buffer.mpos - n;
        if (n2 == 0) {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = n; i < this.match_buffer.mpos; ++i) {
            hashSet.add(this.match_buffer.index[i]);
        }
        if (hashSet.size() == n2) {
            return;
        }
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (int i = n; i < this.match_buffer.mpos; ++i) {
            if (!treeMap.containsKey(this.match_buffer.index[i])) {
                treeMap.put(this.match_buffer.index[i], new GlossCollection(this.match_buffer.gloss[i]));
                continue;
            }
            object = (GlossCollection)treeMap.get(this.match_buffer.index[i]);
            ((GlossCollection)object).addAll(this.match_buffer.gloss[i]);
            treeMap.put(this.match_buffer.index[i], object);
        }
        this.match_buffer.popMatch();
        Iterator iterator = treeMap.keySet().iterator();
        object = treeMap.values().iterator();
        int n3 = n;
        while (iterator.hasNext()) {
            this.match_buffer.index[n3] = (Integer)iterator.next();
            this.match_buffer.gloss[n3] = (GlossCollection)object.next();
            ++n3;
        }
        this.match_buffer.mpos = n3;
        if (this.match_buffer.matchLength() > 0) {
            this.match_buffer.pushMatch();
        }
    }

    @Override
    public int numDecomp() {
        return this.count + (this.aborted ? 1 : 0);
    }

    @Override
    public void reset() {
        this.count = 0;
        this.aborted = false;
    }

    @Override
    public boolean close() {
        this.target.closeDecomposition(this.count);
        return this.aborted || this.count > 0;
    }
}

