/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.CharacterMapping;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.util.CharacterFilterSpecification;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CharacterMapImpl
implements CharacterMap,
CharacterMapping {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    static final int CHAR_SIZE = 65536;
    static final char INDEX_UNMAPPED = '\u0001';
    static final int ALLOCATION_CHUNK = 32;
    final char INDEX_GLOSS;
    final char INDEX_FIRST;
    List<NetGeneric> nets;
    char[] character_map = null;
    private char[] characters_used = null;
    int char_count = 0;
    boolean multi_mapped;

    public CharacterMapImpl(int n, int n2) {
        this.INDEX_GLOSS = (char)n2;
        this.INDEX_FIRST = (char)n;
        assert (this.INDEX_GLOSS == n2);
        assert (this.INDEX_FIRST == n);
        this.nets = new ArrayList<NetGeneric>();
    }

    @Override
    public void attachToNet(NetGeneric netGeneric) {
        this.nets.add(netGeneric);
        if (this.getMaxIndex() > netGeneric.getMaxIndex()) {
            try {
                netGeneric.setMaxIndex(this.getMaxIndex());
            }
            catch (DLTException dLTException) {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public char translate(char c) {
        return this.character_map[c];
    }

    private void setMaxIndex(int n) {
        try {
            for (int i = 0; i < this.nets.size(); ++i) {
                this.nets.get(i).setMaxIndex(n);
            }
        }
        catch (DLTException dLTException) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public char translateAdding(char c) throws DLTException {
        int n = this.character_map[c];
        if (n == 1) {
            n = this.char_count;
            this.characters_used = Utils.assureCharArrayRoom(this.characters_used, n, 5, 4, 32);
            this.characters_used[n] = c;
            if ((n += this.INDEX_FIRST) != (char)n) {
                throw new DLTException(Messages.format("error.dict.characters", this.char_count));
            }
            ++this.char_count;
            this.character_map[c] = (char)n;
            this.setMaxIndex(n + 1);
        }
        return (char)n;
    }

    @Override
    public int getUsedCount() {
        return this.char_count;
    }

    @Override
    public char getUsedChar(int n) {
        return this.characters_used[n];
    }

    @Override
    public int getMaxIndex() {
        return this.char_count + this.INDEX_FIRST;
    }

    @Override
    public char invert(int n) {
        return this.characters_used[n - this.INDEX_FIRST];
    }

    public char[] getCharMap() {
        return this.character_map;
    }

    @Override
    public NetGeneric.IndexIterator makeIterator(CharSequence charSequence) {
        return new StringIndexIterator(charSequence, this.INDEX_GLOSS);
    }

    @Override
    public NetGeneric.IndexIterator makeIterator(CharSequence charSequence, int n) {
        return new StringIndexIterator(charSequence, n);
    }

    @Override
    public NetGeneric.IndexIterator makeIterator(CharacterIterator characterIterator, int n) {
        return new CharIndexIterator(characterIterator, n, this.INDEX_GLOSS);
    }

    @Override
    public NetGeneric.IndexIterator makeIterator(CharacterIterator characterIterator, int n, int n2) {
        return new CharIndexIterator(characterIterator, n, n2);
    }

    @Override
    public void addCharacters(CharacterIterator characterIterator, int n) throws DLTException {
        this.startModify();
        int n2 = characterIterator.getIndex();
        char c = characterIterator.current();
        for (int i = 0; c != '\uffff' && i < n; ++i) {
            this.translateAdding(c);
            c = characterIterator.next();
        }
        characterIterator.setIndex(n2);
    }

    @Override
    public void addCharacters(CharSequence charSequence) throws DLTException {
        this.startModify();
        for (int i = 0; i < charSequence.length(); ++i) {
            this.translateAdding(charSequence.charAt(i));
        }
    }

    @Override
    public NetGeneric.IndexIterator makeAddingIterator(CharacterIterator characterIterator, int n) throws DLTException {
        this.addCharacters(characterIterator, n);
        return new CharIndexIterator(characterIterator, n, this.INDEX_GLOSS);
    }

    @Override
    public NetGeneric.IndexIterator makeAddingIterator(CharacterIterator characterIterator, int n, int n2) throws DLTException {
        this.addCharacters(characterIterator, n);
        return new CharIndexIterator(characterIterator, n, n2);
    }

    @Override
    public NetGeneric.IndexIterator makeAddingIterator(CharSequence charSequence) throws DLTException {
        this.addCharacters(charSequence);
        return new StringIndexIterator(charSequence, this.INDEX_GLOSS);
    }

    @Override
    public NetGeneric.IndexIterator makeAddingIterator(CharSequence charSequence, int n) throws DLTException {
        this.addCharacters(charSequence);
        return new StringIndexIterator(charSequence, n);
    }

    @Override
    public void startModify() {
        if (this.character_map == null) {
            this.reset();
        }
    }

    @Override
    public void endModify() {
    }

    @Override
    public void reset() {
        this.character_map = new char[65536];
        Arrays.fill(this.character_map, '\u0001');
        this.characters_used = new char[32];
        this.char_count = 0;
    }

    @Override
    public void load(DataInput dataInput, NetGeneric netGeneric) throws IOException {
        if (netGeneric != this.nets.get(0)) {
            return;
        }
        this.character_map = new char[65536];
        this.character_map[0] = dataInput.readChar();
        if (this.character_map[0] != '\u0000') {
            int n;
            int n2 = this.character_map[0];
            this.multi_mapped = true;
            for (n = 1; n < 65536; ++n) {
                this.character_map[n] = dataInput.readChar();
                n2 = Math.max(n2, this.character_map[n]);
            }
            this.char_count = n2 + '\u0001' - this.INDEX_FIRST;
            this.characters_used = new char[n2];
            Arrays.fill(this.characters_used, '\uffff');
            for (n = 0; n < 65536; ++n) {
                if (this.character_map[n] < this.INDEX_FIRST) continue;
                this.characters_used[this.character_map[(char)n] - this.INDEX_FIRST] = (char)Math.min(this.characters_used[this.character_map[(char)n] - this.INDEX_FIRST], (char)n);
            }
        } else {
            this.multi_mapped = false;
            this.char_count = dataInput.readChar();
            Arrays.fill(this.character_map, '\u0001');
            this.characters_used = new char[this.char_count];
            for (int i = 0; i < this.char_count; ++i) {
                char c;
                this.characters_used[i] = c = dataInput.readChar();
                this.character_map[c] = (char)(i + this.INDEX_FIRST);
            }
        }
    }

    @Override
    public long save(DataOutput dataOutput, NetGeneric netGeneric) throws IOException {
        if (netGeneric != this.nets.get(0)) {
            return 0L;
        }
        if (this.multi_mapped) {
            for (int i = 0; i < 65536; ++i) {
                dataOutput.writeChar(this.translate((char)i));
            }
            return 131072L;
        }
        dataOutput.writeChar(0);
        dataOutput.writeChar((char)this.char_count);
        for (int i = 0; i < this.char_count; ++i) {
            dataOutput.writeChar(this.characters_used[i]);
        }
        return this.char_count * 2 + 4;
    }

    @Override
    public void createFromFrequencyMap(final int[] nArray) {
        int n;
        assert (this.character_map == null);
        class Cchar
        implements Comparable<Cchar> {
            char c;

            Cchar(int n) {
                this.c = (char)n;
            }

            @Override
            public int compareTo(Cchar cchar) {
                return -nArray[this.c] + nArray[cchar.c];
            }
        }
        Object[] objectArray = new Cchar[65536];
        for (n = 0; n < 65536; ++n) {
            objectArray[n] = new Cchar(n);
        }
        Arrays.sort(objectArray);
        this.character_map = new char[65536];
        Arrays.fill(this.character_map, '\u0001');
        int n2 = 0;
        n = 0;
        while (nArray[((Cchar)objectArray[n]).c] != 0) {
            this.character_map[((Cchar)objectArray[n]).c] = (char)(n2 + this.INDEX_FIRST);
            ++n2;
            ++n;
        }
        this.char_count = n2;
        this.characters_used = new char[n2];
        for (n = 0; n < n2; ++n) {
            this.characters_used[n] = ((Cchar)objectArray[n]).c;
        }
        this.setMaxIndex(n2 + this.INDEX_FIRST);
    }

    public void assign(int n, char[] cArray) {
        assert (cArray.length == 65536);
        this.character_map = cArray;
        this.characters_used = new char[n];
        this.char_count = n;
        boolean bl = false;
        for (int i = 0; i < this.character_map.length; ++i) {
            char c = this.character_map[i];
            int n2 = c - this.INDEX_FIRST;
            if (n2 < 0) continue;
            if (this.characters_used[n2] == '\u0000') {
                this.characters_used[n2] = (char)i;
                continue;
            }
            bl = true;
        }
        this.multi_mapped = bl;
    }

    @Override
    public char getCharMapping(char c) {
        if (this.character_map == null) {
            return c;
        }
        char c2 = this.translate(c);
        assert (c2 == '\u0001' || c2 >= this.INDEX_FIRST);
        assert (c2 < this.char_count + this.INDEX_FIRST);
        if (c2 == '\u0001') {
            return c;
        }
        return this.invert(c2);
    }

    void assign(char c, char c2) {
        this.character_map[c] = c2;
    }

    @Override
    public boolean setCharMapping(char c, char c2) throws DLTException {
        char c3;
        if (this.character_map != null && (c3 = this.translate(c)) >= this.INDEX_FIRST) {
            return this.translate(c2) == c3;
        }
        this.assign(c, this.translateAdding(c2));
        return true;
    }

    @Override
    public boolean applySpecification(CharacterFilterSpecification characterFilterSpecification) throws DLTException {
        String string;
        boolean bl = true;
        int n = 0;
        while ((string = characterFilterSpecification.getEquivalentCharacters(n++)) != null) {
            char c = string.charAt(0);
            for (int i = 1; i < string.length(); ++i) {
                bl |= this.setCharMapping(string.charAt(i), c);
            }
        }
        return bl;
    }

    @Override
    public boolean attachedToMultipleNets() {
        return this.nets.size() > 1;
    }

    @Override
    public CharacterMap.MapMergeData combineMaps(CharacterMap characterMap, boolean bl) {
        int n;
        this.startModify();
        CharacterMapImpl characterMapImpl = (CharacterMapImpl)characterMap;
        if (!(bl || this.multi_mapped || characterMapImpl.multi_mapped)) {
            return null;
        }
        CharacterMap.MapMergeData mapMergeData = new CharacterMap.MapMergeData();
        int n2 = this.char_count + this.INDEX_FIRST;
        mapMergeData.sourceToDest = new IntArray[characterMapImpl.char_count + this.INDEX_FIRST];
        char[][] cArrayArray = new char[mapMergeData.sourceToDest.length][];
        for (n = 1; n < mapMergeData.sourceToDest.length; ++n) {
            mapMergeData.sourceToDest[n] = new IntArray();
        }
        mapMergeData.destToSource = new IntArray(n2);
        mapMergeData.destToSource.addMultiple(n2, -1);
        for (n = 0; n < this.INDEX_FIRST; ++n) {
            mapMergeData.destToSource.set(n, n);
        }
        for (n = 0; n < 65536; ++n) {
            char c = characterMapImpl.translate((char)n);
            int n3 = this.character_map[n];
            int n4 = mapMergeData.destToSource.get(n3);
            int n5 = 0;
            if (cArrayArray[c] != null) {
                n5 = cArrayArray[c][n3];
            }
            if (n4 == -1) {
                mapMergeData.destToSource.set(n3, c);
            } else if (n4 != c) {
                if (n5 == 0) {
                    if (mapMergeData.destDuplications == null) {
                        mapMergeData.destDuplications = new IntArray[this.char_count + this.INDEX_FIRST];
                    }
                    if (mapMergeData.destDuplications[n3] == null) {
                        mapMergeData.destDuplications[n3] = new IntArray();
                    }
                    mapMergeData.destDuplications[n3].add(n2);
                    if (cArrayArray[c] == null) {
                        cArrayArray[c] = new char[this.char_count + this.INDEX_FIRST];
                    }
                    cArrayArray[c][n3] = (char)n2;
                    n3 = n2++;
                    this.character_map[n] = (char)n3;
                    mapMergeData.destToSource.add(c);
                } else {
                    n3 = n5;
                    this.character_map[n] = (char)n3;
                }
            }
            if (c == '\u0001') continue;
            mapMergeData.sourceToDest[c].add(n3);
        }
        if (this.getMaxIndex() < n2) {
            this.setMaxIndex(n2);
        }
        this.assign(n2 - this.INDEX_FIRST, this.character_map);
        this.char_count = n2 - this.INDEX_FIRST;
        for (n = (int)this.INDEX_FIRST; n < mapMergeData.sourceToDest.length; ++n) {
            mapMergeData.sourceToDest[n].removeDuplicates();
        }
        return mapMergeData;
    }

    private boolean hasMultipleMappings() {
        return false;
    }

    class StringIndexIterator
    implements NetGeneric.IndexIterator {
        private final CharSequence s;
        private int index;
        private final int trailing_code;

        StringIndexIterator(CharSequence charSequence, int n) {
            this.s = charSequence;
            this.index = 0;
            this.trailing_code = n;
        }

        @Override
        public int first() {
            this.index = 0;
            return this.index < this.s.length() ? (int)CharacterMapImpl.this.translate(this.s.charAt(this.index)) : this.trailing_code;
        }

        @Override
        public int next() {
            return ++this.index < this.s.length() ? (int)CharacterMapImpl.this.translate(this.s.charAt(this.index)) : this.trailing_code;
        }
    }

    private class CharIndexIterator
    implements NetGeneric.IndexIterator {
        private final CharacterIterator ci;
        private final int start_index;
        private int end_index;
        private final int trailing_code;

        CharIndexIterator(CharacterIterator characterIterator, int n, int n2) {
            this.ci = characterIterator;
            this.start_index = this.ci.getIndex();
            this.end_index = n > this.ci.getEndIndex() - this.start_index ? this.ci.getEndIndex() - 1 : this.start_index + n - 1;
            this.trailing_code = n2;
        }

        @Override
        public int first() {
            if (this.start_index > this.end_index) {
                return this.trailing_code;
            }
            this.ci.setIndex(this.start_index);
            return CharacterMapImpl.this.translate(this.ci.current());
        }

        @Override
        public int next() {
            if (this.ci.getIndex() < this.end_index) {
                return CharacterMapImpl.this.translate(this.ci.next());
            }
            return this.trailing_code;
        }
    }
}

