/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.CharacterMapImpl;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.util.CharacterMapper;
import java.io.DataInput;
import java.io.IOException;

public class CharacterMapLowercase
extends CharacterMapImpl {
    static final int CASE_SHIFT = 14;
    static final char CODE_MASK = '\u3fff';

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CharacterMapLowercase(int n, int n2) {
        super(n, n2);
    }

    private void addCases(char c) {
        char c2 = this.character_map[c];
        this.assign(c, c2);
        char c3 = Character.toUpperCase(c);
        if (CharacterMapper.toLowerCase(c3) == c) {
            this.assign(c3, c2);
        }
    }

    private void addMapCases() {
        assert (!this.multi_mapped);
        for (int i = 0; i < this.getUsedCount(); ++i) {
            this.addCases(this.getUsedChar(i));
        }
    }

    @Override
    public void load(DataInput dataInput, NetGeneric netGeneric) throws IOException {
        if (netGeneric != this.nets.get(0)) {
            return;
        }
        super.load(dataInput, netGeneric);
        this.addMapCases();
    }

    @Override
    public char translate(char c) {
        return (char)(this.character_map[c] & 0x3FFF);
    }

    @Override
    void assign(char c, char c2) {
        assert ((c2 & 0x3FFF) == c2);
        this.character_map[c] = (char)(CaseGloss.CaseExtractor.getOffset(c) << 14 | c2);
    }

    @Override
    public char translateAdding(char c) throws DLTException {
        char c2 = this.character_map[c];
        if (c2 == '\u0001') {
            char c3 = CharacterMapper.toLowerCase(c);
            if (this.character_map[c3] == '\u0001') {
                c2 = super.translateAdding(c3);
                if ((c2 & 0x3FFF) != c2) {
                    throw new DLTException(Messages.format("error.dict.characters.lowercase", this.char_count - 1));
                }
                this.addCases(c3);
            }
            if (this.character_map[c] == '\u0001') {
                c2 = super.translateAdding(c);
                if ((c2 & 0x3FFF) != c2) {
                    throw new DLTException(Messages.format("error.dict.characters.lowercase", this.char_count - 1));
                }
                this.assign(c, c2);
            }
        }
        return (char)(c2 & 0x3FFF);
    }

    @Override
    public void createFromFrequencyMap(int[] nArray) {
        super.createFromFrequencyMap(nArray);
        this.addMapCases();
    }
}

