/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.MultiNetImpl;
import com.ibm.dltj.fst.NetGenericDictionary;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.NodeBSearch;
import com.ibm.dltj.fst.NodeBaseGloss;
import com.ibm.dltj.fst.NodeGloss;
import com.ibm.dltj.fst.NodeLSearch;
import com.ibm.dltj.fst.NodePtrGloss;
import com.ibm.dltj.fst.TransitionList;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import com.ibm.dltj.util.Utils;
import java.util.HashMap;

public class GenericToObjectConverter {
    static final int GENGLOSS = 2;
    static final int GLOSS = 3;
    final NetGenericDictionary source;
    final NetGenericReadOnly net;
    final HashMap<Object, Node> nodes;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public GenericToObjectConverter(NetGenericDictionary netGenericDictionary) {
        this.source = netGenericDictionary;
        this.net = this.source.net;
        this.nodes = new HashMap();
    }

    public MultiNet convert() throws DLTException {
        MultiNetImpl multiNetImpl = new MultiNetImpl();
        multiNetImpl.setFirstNode(this.convertNode(this.net.first_base()));
        return multiNetImpl;
    }

    Node convertNode(int n) throws DLTException {
        Node node = this.nodes.get(n);
        if (node == null) {
            GlossCollection glossCollection;
            ConverterNode converterNode = new GlossFreeNode(n);
            node = this.nodes.get(converterNode);
            if (node == null && !converterNode.isNull()) {
                node = converterNode.convert();
                this.nodes.put(converterNode, node);
            }
            if (this.net.transitionPresent(n, 2) && (node = this.nodes.get(converterNode = new GlossNode(converterNode, node, glossCollection = this.source.glosses.getGlossByIdx(this.net.transitionValue(n, 2))))) == null) {
                node = converterNode.convert();
                this.nodes.put(converterNode, node);
            }
            if (this.net.transitionPresent(n, 3)) {
                glossCollection = this.source.glosses.getGlossByIdx(this.net.transitionValue(n, 3));
                converterNode = new GlossNode(converterNode, node, glossCollection);
                node = converterNode.convert();
            }
        }
        this.nodes.put(n, node);
        return node;
    }

    class GlossNode
    implements ConverterNode {
        final ConverterNode next;
        final Node mapped_next;
        final Object gloss;

        GlossNode(ConverterNode converterNode, Node node, Object object) {
            this.next = converterNode;
            this.mapped_next = node;
            this.gloss = object;
        }

        @Override
        public Node convert() {
            NodeBaseGloss nodeBaseGloss;
            if (this.mapped_next == null) {
                nodeBaseGloss = new NodeGloss();
            } else {
                nodeBaseGloss = new NodePtrGloss();
                nodeBaseGloss.set_trans(0, this.mapped_next);
            }
            nodeBaseGloss.setGloss(this.gloss);
            return nodeBaseGloss;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public int hashCode() {
            return Utils.combineHash(this.gloss.hashCode(), this.next != null ? this.next.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (object instanceof GlossNode) {
                GlossNode glossNode = (GlossNode)object;
                if (!glossNode.gloss.equals(this.gloss)) {
                    return false;
                }
                if (glossNode.next == null && this.next == null) {
                    return true;
                }
                if (glossNode.next == null || this.next == null) {
                    return false;
                }
                return glossNode.next.equals(this.next);
            }
            return false;
        }

        public String toString() {
            return "G" + this.next.toString();
        }
    }

    class GlossFreeNode
    implements ConverterNode {
        final int node;

        GlossFreeNode(int n) {
            this.node = n;
        }

        @Override
        public Node convert() throws DLTException {
            int n = 0;
            int n2 = GenericToObjectConverter.this.net.getMaxIndex();
            for (int i = GenericToObjectConverter.this.net.getFirstLinkIndex(); i < n2; ++i) {
                if (!GenericToObjectConverter.this.net.transitionPresent(this.node, i)) continue;
                ++n;
            }
            TransitionList transitionList = n > 8 ? new NodeBSearch(n) : new NodeLSearch(n);
            for (int i = GenericToObjectConverter.this.net.getFirstLinkIndex(); i < n2; ++i) {
                if (!GenericToObjectConverter.this.net.transitionPresent(this.node, i)) continue;
                transitionList.addChar(GenericToObjectConverter.this.source.char_map.invert(i), 0x20000000, GenericToObjectConverter.this.convertNode(GenericToObjectConverter.this.net.transitionValue(this.node, i)));
            }
            return transitionList;
        }

        @Override
        public boolean isNull() {
            int n = GenericToObjectConverter.this.net.getMaxIndex();
            for (int i = GenericToObjectConverter.this.net.getFirstLinkIndex(); i < n; ++i) {
                if (!GenericToObjectConverter.this.net.transitionPresent(this.node, i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 17;
            int n2 = GenericToObjectConverter.this.net.getMaxIndex();
            for (int i = GenericToObjectConverter.this.net.getFirstLinkIndex(); i < n2; ++i) {
                n = Utils.combineHash(n, i, GenericToObjectConverter.this.net.takeTransition(this.node, i, -1));
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof GlossFreeNode) {
                int n;
                GlossFreeNode glossFreeNode = (GlossFreeNode)object;
                int n2 = GenericToObjectConverter.this.net.getMaxIndex();
                for (n = GenericToObjectConverter.this.net.getFirstLinkIndex(); n < n2 && GenericToObjectConverter.this.net.takeTransition(this.node, n, -1) == GenericToObjectConverter.this.net.takeTransition(glossFreeNode.node, n, -1); ++n) {
                }
                return n == n2;
            }
            return false;
        }

        public String toString() {
            return "T" + this.node;
        }
    }

    static interface ConverterNode {
        public Node convert() throws DLTException;

        public boolean isNull();
    }
}

