/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.GlossCollectionShared;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.util.BoundedIntHeap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GlossCollectionHandler
implements PayloadManipulator {
    private final ArrayList<GlossCollection> _list = new ArrayList();
    private Map<GlossCollection, GlossCollectionShared> _collections = null;
    Dictionary ownerDictionary;
    private final BoundedIntHeap deleted = new BoundedIntHeap(32, 1);

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public GlossCollectionHandler(Dictionary dictionary) {
        this.ownerDictionary = dictionary;
        this.reset();
    }

    public void reset() {
        this._list.clear();
        this._collections = null;
    }

    public final int readGlosses(DataInput dataInput) throws DLTException, IOException {
        GlossCollection glossCollection;
        int n = dataInput.readInt();
        this._list.ensureCapacity(n);
        for (int i = n; i > 0; i -= glossCollection.readGlossCollectionDetails(dataInput, this.ownerDictionary)) {
            glossCollection = new GlossCollection();
            GlossCollectionShared glossCollectionShared = new GlossCollectionShared(glossCollection);
            glossCollectionShared.setIndex(this._list.size());
            this._list.add(glossCollectionShared.isEmpty() ? null : glossCollectionShared);
        }
        return n;
    }

    public void endReading() {
    }

    public int getGlossCollectionCount() {
        int n = 0;
        for (GlossCollection glossCollection : this._list) {
            if (glossCollection == null) continue;
            ++n;
        }
        return n;
    }

    public int getHighestIndex() {
        return this._list.size();
    }

    public void processGlosses(GlossProcessor glossProcessor) throws DLTException {
        for (GlossCollection glossCollection : this._list) {
            if (glossCollection == null) continue;
            glossProcessor.process(glossCollection);
        }
    }

    public void writeGlossCollections(DataOutput dataOutput, GlossMapper glossMapper) throws DLTException, IOException {
        int n = this.getGlossCollectionsSize();
        dataOutput.writeInt(n);
        for (GlossCollection glossCollection : this._list) {
            if (glossCollection != null) {
                n -= glossCollection.writeGlossCollectionDetails(dataOutput, glossMapper);
                continue;
            }
            if (n <= 0) continue;
            dataOutput.writeInt(-1);
        }
    }

    private int getGlossCollectionsSize() {
        int n = 0;
        for (GlossCollection glossCollection : this._list) {
            if (glossCollection == null) continue;
            n += glossCollection.size();
        }
        return n;
    }

    public void startBuild(boolean bl) {
        this._collections = bl ? new HashMap<GlossCollection, GlossCollectionShared>() : null;
    }

    public int endBuild() {
        int n = 0;
        if (this._collections != null) {
            n = this._collections.size();
            this._collections = null;
        }
        for (int i = this._list.size() - 1; i >= 0 && this._list.get(i) == null; --i) {
            this._list.remove(i);
        }
        this._list.trimToSize();
        return n;
    }

    public boolean buildStarted() {
        return this._collections != null;
    }

    public void create_collections() throws DLTException {
        int n = this.getGlossCollectionCount();
        if (this._collections == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            GlossCollectionShared glossCollectionShared;
            GlossCollection glossCollection = this.getGlossByIdx(i);
            if (glossCollection == null) continue;
            if (!(glossCollection instanceof GlossCollectionShared)) {
                glossCollectionShared = new GlossCollectionShared(glossCollection);
                glossCollectionShared.setIndex(i);
                this.updateGloss(i, glossCollectionShared);
                glossCollection = glossCollectionShared;
            } else {
                glossCollectionShared = (GlossCollectionShared)glossCollection;
                glossCollectionShared.setIndex(i);
            }
            GlossCollectionShared glossCollectionShared2 = this._collections.get(glossCollection);
            if (glossCollectionShared2 == null) {
                this._collections.put(glossCollectionShared, glossCollectionShared);
                continue;
            }
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
    }

    public void contract(int[] nArray) throws DLTException {
        assert (nArray != null);
        int n = this.getGlossCollectionCount();
        if (this._collections == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            GlossCollection glossCollection = this.getGlossByIdx(i);
            if (!(glossCollection instanceof GlossCollection)) {
                throw new DLTException(Messages.getString("error.gloss.unexpected"));
            }
            GlossCollectionShared glossCollectionShared = new GlossCollectionShared(glossCollection);
            this.removeGloss(i);
            GlossCollectionShared glossCollectionShared2 = this._collections.get(glossCollectionShared);
            if (glossCollectionShared2 == null) {
                nArray[i] = this.addGloss(glossCollectionShared);
                glossCollectionShared.setIndex(nArray[i]);
                this._collections.put(glossCollectionShared, glossCollectionShared);
                assert (glossCollectionShared.isSingleRef());
                continue;
            }
            glossCollectionShared2.incRefCount();
            nArray[i] = glossCollectionShared2.getIndex();
        }
    }

    private void buildDeleted(int n) {
        int n2 = this._list.size();
        for (int i = n; i < n2 && !this.deleted.isFull(); ++i) {
            if (this._list.get(i) != null) continue;
            this.deleted.allocateReplaceLast(i);
        }
        if (!this.deleted.isFull()) {
            this.deleted.allocateReplaceLast(n2);
        }
    }

    int addGloss(GlossCollection glossCollection) throws DLTException {
        if (this.deleted.isEmpty()) {
            this.buildDeleted(0);
        }
        int n = this.deleted.getTopKey();
        this.deleted.removeTopKeepLast();
        if (n == this._list.size()) {
            assert (this.deleted.isEmpty());
            this._list.add(glossCollection);
        } else {
            this._list.set(n, glossCollection);
        }
        if (this.deleted.isEmpty()) {
            this.buildDeleted(n + 1);
        }
        return n;
    }

    GlossCollection updateGloss(int n, GlossCollection glossCollection) {
        return this._list.set(n, glossCollection);
    }

    void removeGloss(int n) {
        this._list.set(n, null);
        this.deleted.allocateReplaceLast(n);
    }

    @Override
    public int reference(int n) {
        GlossCollection glossCollection = this.getGlossByIdx(n);
        assert (this._collections != null);
        GlossCollectionShared glossCollectionShared = (GlossCollectionShared)glossCollection;
        glossCollectionShared.incRefCount();
        return n;
    }

    @Override
    public void dereference(int n) {
        if (n < 0) {
            return;
        }
        GlossCollection glossCollection = this.getGlossByIdx(n);
        if (this._collections != null) {
            GlossCollectionShared glossCollectionShared = (GlossCollectionShared)glossCollection;
            if (glossCollectionShared.isSingleRef()) {
                this.removeGloss(n);
                this._collections.remove(glossCollectionShared);
            } else {
                glossCollectionShared.decRefCount();
            }
        } else {
            this.removeGloss(n);
        }
    }

    int processRemove(int n, Gloss gloss) throws DLTException {
        if (gloss == null) {
            this.dereference(n);
            return -1;
        }
        GlossCollection glossCollection = this.getGlossByIdx(n);
        if (this._collections != null) {
            GlossCollectionShared glossCollectionShared = (GlossCollectionShared)glossCollection;
            this.dereference(n);
            glossCollectionShared = new GlossCollectionShared(glossCollectionShared);
            glossCollectionShared.remove(gloss);
            if (!glossCollectionShared.isEmpty()) {
                return this.findOrAdd(glossCollectionShared);
            }
            return -1;
        }
        GlossCollection glossCollection2 = glossCollection;
        glossCollection2.remove(gloss);
        if (!glossCollection2.isEmpty()) {
            return n;
        }
        this.removeGloss(n);
        return -1;
    }

    int processGlossRemove(int n, Gloss gloss) throws DLTException {
        if (gloss == null) {
            return -1;
        }
        GlossCollection glossCollection = this.getGlossByIdx(n);
        assert (this._collections != null);
        assert (glossCollection instanceof GlossCollectionShared);
        GlossCollectionShared glossCollectionShared = (GlossCollectionShared)glossCollection;
        glossCollectionShared = new GlossCollectionShared(glossCollectionShared);
        glossCollectionShared.remove(gloss);
        if (!glossCollectionShared.isEmpty()) {
            return this.findOrAddNoRef(glossCollectionShared);
        }
        return -1;
    }

    int processGlossAdd(int n, Gloss gloss) throws DLTException {
        GlossCollectionShared glossCollectionShared;
        assert (this._collections != null);
        if (n == -1) {
            glossCollectionShared = new GlossCollectionShared(gloss);
        } else {
            GlossCollection glossCollection = this.getGlossByIdx(n);
            glossCollectionShared = new GlossCollectionShared((GlossCollectionShared)glossCollection);
            glossCollectionShared.add(gloss);
        }
        return this.findOrAddNoRef(glossCollectionShared);
    }

    int processGlossCollectionAdd(int n, Object object) throws DLTException {
        GlossCollectionShared glossCollectionShared;
        assert (this._collections != null);
        if (n == -1) {
            glossCollectionShared = new GlossCollectionShared((GlossCollection)object);
        } else {
            GlossCollection glossCollection = this.getGlossByIdx(n);
            glossCollectionShared = new GlossCollectionShared((GlossCollectionShared)glossCollection);
            glossCollectionShared.addAll((GlossCollection)object);
        }
        return this.findOrAddNoRef(glossCollectionShared);
    }

    int processNew(Object object) throws DLTException {
        GlossCollectionShared glossCollectionShared = new GlossCollectionShared((Gloss)object);
        if (this._collections == null) {
            return this.addGloss(glossCollectionShared);
        }
        return this.findOrAdd(glossCollectionShared);
    }

    @Override
    public int mergeInternal(int n, int n2) throws DLTException {
        return this.merge(n, this.getGlossByIdx(n2));
    }

    @Override
    public int merge(int n, Object object) throws DLTException {
        GlossCollectionShared glossCollectionShared;
        if (object instanceof GlossCollection) {
            glossCollectionShared = new GlossCollectionShared((GlossCollection)object);
        } else if (object instanceof Gloss) {
            glossCollectionShared = new GlossCollectionShared((Gloss)object);
        } else {
            if (object == null) {
                return n;
            }
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        if (n != -1) {
            GlossCollection glossCollection = this.getGlossByIdx(n);
            if (!(glossCollection instanceof GlossCollectionShared)) {
                throw new DLTException(Messages.getString("error.gloss.unexpected"));
            }
            GlossCollectionShared glossCollectionShared2 = (GlossCollectionShared)glossCollection;
            glossCollectionShared.addAll(glossCollectionShared2);
        }
        return this.findOrAddNoRef(glossCollectionShared);
    }

    private int findOrAdd(GlossCollectionShared glossCollectionShared) throws DLTException {
        int n;
        GlossCollectionShared glossCollectionShared2 = this._collections.get(glossCollectionShared);
        if (glossCollectionShared2 != null) {
            glossCollectionShared = glossCollectionShared2;
            n = glossCollectionShared.getIndex();
        } else {
            this._collections.put(glossCollectionShared, glossCollectionShared);
            n = this.addGloss(glossCollectionShared);
            glossCollectionShared.setIndex(n);
        }
        glossCollectionShared.incRefCount();
        return n;
    }

    private int findOrAddNoRef(GlossCollectionShared glossCollectionShared) throws DLTException {
        int n;
        GlossCollectionShared glossCollectionShared2 = this._collections.get(glossCollectionShared);
        if (glossCollectionShared2 != null) {
            glossCollectionShared = glossCollectionShared2;
            n = glossCollectionShared.getIndex();
        } else {
            this._collections.put(glossCollectionShared, glossCollectionShared);
            n = this.addGloss(glossCollectionShared);
            glossCollectionShared.setIndex(n);
        }
        return n;
    }

    int processExisting(int n, Gloss gloss) throws DLTException {
        GlossCollection glossCollection = this.getGlossByIdx(n);
        if (this._collections == null) {
            if (!(glossCollection instanceof GlossCollection)) {
                throw new DLTException(Messages.getString("error.gloss.unexpected"));
            }
            GlossCollection glossCollection2 = glossCollection;
            glossCollection2.add(gloss);
            return n;
        }
        if (!(glossCollection instanceof GlossCollectionShared)) {
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        GlossCollectionShared glossCollectionShared = (GlossCollectionShared)glossCollection;
        this.dereference(n);
        glossCollectionShared = new GlossCollectionShared(glossCollectionShared);
        glossCollectionShared.add(gloss);
        return this.findOrAdd(glossCollectionShared);
    }

    public GlossCollection getGlossByIdx(int n) {
        if (n < 0) {
            return null;
        }
        return this._list.get(n);
    }

    @Override
    public Object getObject(int n) {
        if (n < 0) {
            return null;
        }
        return this._list.get(n);
    }

    boolean glossesEqual(int n, int n2) {
        if (n == n2) {
            return true;
        }
        GlossCollection glossCollection = this.getGlossByIdx(n);
        GlossCollection glossCollection2 = this.getGlossByIdx(n2);
        return glossCollection.equals(glossCollection2);
    }

    int glossHash(int n) {
        return this.getGlossByIdx(n).hashCode();
    }

    int getRefCount(int n) {
        GlossCollection glossCollection = this.getGlossByIdx(n);
        if (!(glossCollection instanceof GlossCollectionShared)) {
            return glossCollection == null ? 0 : 1;
        }
        GlossCollectionShared glossCollectionShared = (GlossCollectionShared)glossCollection;
        return glossCollectionShared.getRefCount();
    }

    public void setOwnerDictionary(Dictionary dictionary) {
        this.ownerDictionary = dictionary;
    }

    public void dumpGlossCollections(PrintStream printStream) {
        int n = this.getGlossCollectionCount();
        printStream.println("Gloss collections: " + n);
        for (int i = 0; i < this._list.size(); ++i) {
            if (this._list.get(i) == null) continue;
            GlossCollection glossCollection = this._list.get(i);
            int n2 = -1;
            if (glossCollection instanceof GlossCollectionShared) {
                n2 = ((GlossCollectionShared)glossCollection).getRefCount();
            }
            printStream.format("Collection[%d] (%d refs): %s\n", i, n2, glossCollection);
        }
    }

    @Override
    public int intersect(int n, Object object) throws DLTException {
        GlossCollectionShared glossCollectionShared;
        if (n == -1) {
            return -1;
        }
        if (object instanceof GlossCollection) {
            glossCollectionShared = new GlossCollectionShared((GlossCollection)object);
        } else if (object instanceof Gloss) {
            glossCollectionShared = new GlossCollectionShared((Gloss)object);
        } else {
            if (object == null) {
                return -1;
            }
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        GlossCollection glossCollection = this.getGlossByIdx(n);
        if (!(glossCollection instanceof GlossCollectionShared)) {
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        GlossCollectionShared glossCollectionShared2 = (GlossCollectionShared)glossCollection;
        glossCollectionShared.retainAll(glossCollectionShared2);
        return this.findOrAddNoRef(glossCollectionShared);
    }

    @Override
    public int intersectInternal(int n, int n2) throws DLTException {
        if (n == n2) {
            return n;
        }
        if (n == -1 || n2 == -1) {
            return -1;
        }
        return this.intersect(n, this.getGlossByIdx(n2));
    }

    @Override
    public int subtract(int n, Object object) throws DLTException {
        GlossCollection glossCollection;
        if (n == -1) {
            return -1;
        }
        if (object instanceof GlossCollection) {
            glossCollection = (GlossCollection)object;
        } else if (object instanceof Gloss) {
            glossCollection = new GlossCollection((Gloss)object);
        } else {
            if (object == null) {
                return n;
            }
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        GlossCollectionShared glossCollectionShared = new GlossCollectionShared(this.getGlossByIdx(n));
        glossCollectionShared.removeAll(glossCollection);
        return this.findOrAddNoRef(glossCollectionShared);
    }

    @Override
    public int subtractInternal(int n, int n2) throws DLTException {
        return this.subtract(n, this.getGlossByIdx(n2));
    }
}

