/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.CharacterMapImpl;
import com.ibm.dltj.fst.GlossCollectionHandler;
import com.ibm.dltj.fst.PerfectWordHash;
import com.ibm.dltj.gloss.MWEntryLemmaGloss;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.netgeneric.Statistics;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class IntegerDictionary
implements PerfectWordHash {
    final NetGeneric net;
    final CharacterMap char_map;
    final GlossCollectionHandler glosses;
    final Set<Integer> hashes_used;
    private boolean glossesRefCountInitialized = false;
    final PerfectWordHash.Normalizer normalizer;
    final PerfectWordHash.StringHash hasher;
    static final int INDEX_UNMAPPED = 1;
    static final int INDEX_ENTRY = 2;
    static final int INDEX_LEMMA_GLOSS = 3;
    static final int INDEX_FIRST_LINK = 4;
    static final int GLOSS_NOT_PRESENT = -1;
    static final int ENTRY_NOT_PRESENT = 1;
    static final int HASH_INDEX_STAGES = 3;
    static final int HASH_BITS = 21;
    static final int HASH_MASK = 0x1FFFFF;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public static CharacterMap createCharacterMap() {
        return new CharacterMapImpl(4, 3);
    }

    public IntegerDictionary(Initializer initializer, CharacterMap characterMap, GlossCollectionHandler glossCollectionHandler, PerfectWordHash.Normalizer normalizer, PerfectWordHash.StringHash stringHash) throws DLTException {
        this.glosses = glossCollectionHandler;
        this.net = NetGenericFactory.create(448061489, 4, initializer == null ? this : initializer);
        this.net.setPayloadManipulator(2, PayloadManipulator.SimpleInteger);
        this.net.setPayloadManipulator(3, glossCollectionHandler);
        this.char_map = characterMap == null ? IntegerDictionary.createCharacterMap() : characterMap;
        this.char_map.attachToNet(this.net);
        this.net.setTransitionToStringMapper(this);
        this.normalizer = normalizer;
        this.hasher = stringHash;
        this.hashes_used = new HashSet<Integer>();
    }

    @Override
    public void reset() {
        this.net.reset();
        this.char_map.reset();
        this.hashes_used.clear();
    }

    @Override
    public void startModify() throws DLTException {
        this.net.startModify();
        this.char_map.startModify();
        this.applyForEachEntry("", this.net.first_base(), new EntryProcessor(){

            @Override
            public void apply(String string, int n) {
                IntegerDictionary.this.hashes_used.add(IntegerDictionary.this.getHash(IntegerDictionary.this.hasher.getHash(new StringCharacterIterator(string), string.length()), n));
            }
        });
        if (!this.glosses.buildStarted()) {
            this.glosses.startBuild(true);
            this.glosses.create_collections();
        }
        if (!this.glossesRefCountInitialized) {
            this.net.forAllInstances(3, new NetGeneric.ChangeEncapsulator(){

                @Override
                public int Apply(int n) throws DLTException {
                    return IntegerDictionary.this.glosses.reference(n);
                }
            });
            this.glossesRefCountInitialized = true;
        }
    }

    @Override
    public void endModify() {
        this.net.endModify();
        this.char_map.endModify();
        this.hashes_used.clear();
    }

    public boolean isEmpty() {
        return this.net.isEmpty();
    }

    @Override
    public int getMaxHash() {
        return 0x200004;
    }

    @Override
    public void load(DataInput dataInput) throws IOException, DLTException {
        this.char_map.load(dataInput, this.net);
        this.net.setMaxIndex(this.char_map.getMaxIndex());
        NetGenericFactory.load(dataInput, this.net);
        this.glossesRefCountInitialized = false;
    }

    @Override
    public long save(DataOutput dataOutput) throws IOException, DLTException {
        long l = 0L;
        l += this.char_map.save(dataOutput, this.net);
        return l += NetGenericFactory.save(dataOutput, this.net);
    }

    private void applyForEachEntry(String string, int n, EntryProcessor entryProcessor) {
        if (this.net.transitionPresent(n, 2)) {
            entryProcessor.apply(string, this.net.transitionValue(n, 2));
        }
        for (int i = 4; i < this.net.getMaxIndex(); ++i) {
            if (!this.net.transitionPresent(n, i)) continue;
            this.applyForEachEntry(string + this.char_map.invert(i), this.net.transitionValue(n, i), entryProcessor);
        }
    }

    int selectHashOffset(int n) throws DLTException {
        int n2 = 0;
        while (this.hashes_used.contains(this.getHash(n, n2))) {
            ++n2;
        }
        this.hashes_used.add(this.getHash(n, n2));
        return n2;
    }

    @Override
    public void addEntry(PerfectWordHash.Query query, Gloss gloss) throws DLTException {
        int n;
        int n2 = query.normalized_form.getIndex();
        int n3 = this.hasher.getHash(query.normalized_form, query.nf_length);
        query.normalized_form.setIndex(n2);
        int n4 = -1;
        int n5 = -1;
        if (!this.net.isEmpty() && this.net.transitionPresent(n = this.net.getEntry(this.char_map.makeIterator(query.normalized_form, query.nf_length, 0)), 2)) {
            n4 = this.net.transitionValue(n, 2);
            n5 = this.net.takeTransition(n, 3, n5);
        }
        if (n4 == -1) {
            n4 = this.selectHashOffset(n3);
            query.normalized_form.setIndex(n2);
            this.net.modifyEntry(this.char_map.makeAddingIterator(query.normalized_form, query.nf_length, 2), new NetGeneric.ChangeEncapsulator.Setter(n4));
        }
        if (gloss != null) {
            query.normalized_form.setIndex(n2);
            LemmaGlossAdder lemmaGlossAdder = new LemmaGlossAdder(gloss);
            this.net.modifyEntry(this.char_map.makeAddingIterator(query.normalized_form, query.nf_length, 3), lemmaGlossAdder);
            query.gloss = lemmaGlossAdder.gc_after_add;
        } else {
            query.gloss = this.glosses.getGlossByIdx(n5);
        }
        query.hash = this.getHash(n3, n4);
    }

    @Override
    public PerfectWordHash.Normalizer getNormalizer() {
        return this.normalizer;
    }

    int getHash(int n, int n2) {
        return (n + n2 & 0x1FFFFF) + 4;
    }

    @Override
    public void performQuery(PerfectWordHash.Query query) {
        this.normalizer.normalize(query);
        while (query != null) {
            int n = query.normalized_form.getIndex();
            int n2 = this.net.getEntry(this.char_map.makeIterator(query.normalized_form, query.nf_length, 0));
            if (this.net.transitionPresent(n2, 2)) {
                query.normalized_form.setIndex(n);
                query.hash = this.getHash(this.hasher.getHash(query.normalized_form, query.nf_length), this.net.transitionValue(n2, 2));
                if (this.net.transitionPresent(n2, 3)) {
                    query.gloss = this.glosses.getGlossByIdx(this.net.transitionValue(n2, 3));
                    this.normalizer.filterResult(query);
                } else {
                    query.gloss = null;
                }
            } else {
                query.hash = 1;
                query.gloss = null;
            }
            query = query.next;
        }
    }

    private void buildInverseMap(int n, String string, Map<Integer, String> map) {
        if (this.net.transitionPresent(n, 2)) {
            map.put(this.getHash(this.hasher.getHash(new StringCharacterIterator(string), string.length()), this.net.transitionValue(n, 2)), string);
        }
        for (int i = 4; i < this.net.getMaxIndex(); ++i) {
            if (!this.net.transitionPresent(n, i)) continue;
            this.buildInverseMap(this.net.transitionValue(n, i), string + this.char_map.invert(i), map);
        }
    }

    @Override
    public Map<Integer, String> buildInverseMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        this.buildInverseMap(this.net.first_base(), "", hashMap);
        return hashMap;
    }

    private Merger.MergerNode getMergerNode(IntegerDictionary integerDictionary, Map<Integer, Integer> map, Map<Integer, Integer> map2, GlossProcessor glossProcessor) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator("");
        assert (this.net.getSignature() == 448061489);
        class IDMergerNode
        implements Merger.MergerNode {
            private int base;
            private String string;
            private int new_offset = -1;
            final /* synthetic */ IntegerDictionary val$dest;
            final /* synthetic */ StringCharacterIterator val$it;
            final /* synthetic */ Map val$entryMap;
            final /* synthetic */ Map val$lemmaGroupMap;
            final /* synthetic */ GlossProcessor val$new_gloss_processor;

            IDMergerNode(int n, String string) {
                this.val$dest = integerDictionary2;
                this.val$it = stringCharacterIterator;
                this.val$entryMap = map;
                this.val$lemmaGroupMap = map2;
                this.val$new_gloss_processor = glossProcessor;
                this.base = n;
                this.string = string;
            }

            @Override
            public boolean startCopy() throws DLTException {
                int n;
                int n2;
                if (IntegerDictionary.this.net.transitionPresent(this.base, 2) && (n2 = this.val$dest.net.getEntry(this.val$dest.char_map.makeIterator(this.string, 2))) != (n = IntegerDictionary.this.net.transitionValue(this.base, 2))) {
                    this.val$it.setText(this.string);
                    int n3 = IntegerDictionary.this.hasher.getHash(this.val$it, this.string.length());
                    if (n2 == -1) {
                        this.new_offset = n2 = this.val$dest.selectHashOffset(n3);
                    }
                    if (n2 != n) {
                        this.val$entryMap.put(IntegerDictionary.this.getHash(n3, n), this.val$dest.getHash(n3, n2));
                    }
                }
                for (n2 = 4; n2 < IntegerDictionary.this.net.getMaxIndex(); ++n2) {
                    if (!IntegerDictionary.this.net.transitionPresent(this.base, n2)) continue;
                    this.val$dest.char_map.translateAdding(IntegerDictionary.this.char_map.invert(n2));
                }
                return true;
            }

            @Override
            public int[] gatherLinks() {
                int[] nArray = IntegerDictionary.this.net.gatherNodeLinks(this.base);
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.val$dest.char_map.translate(IntegerDictionary.this.char_map.invert(nArray[i]));
                }
                Arrays.sort(nArray);
                return nArray;
            }

            @Override
            public boolean transitionPresent(int n) {
                switch (n) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return this.new_offset != -1;
                    }
                    case 3: {
                        return IntegerDictionary.this.net.transitionPresent(this.base, n);
                    }
                }
                return IntegerDictionary.this.net.transitionPresent(this.base, IntegerDictionary.this.char_map.translate(this.val$dest.char_map.invert(n)));
            }

            @Override
            public Object transitionValue(int n) throws DLTException {
                switch (n) {
                    case 2: {
                        return this.new_offset;
                    }
                    case 3: {
                        GlossCollection glossCollection = IntegerDictionary.this.glosses.getGlossByIdx(IntegerDictionary.this.net.transitionValue(this.base, n));
                        GlossCollection glossCollection2 = new GlossCollection();
                        for (Gloss gloss : glossCollection) {
                            if (gloss instanceof MWEntryLemmaGloss) {
                                MWEntryLemmaGloss mWEntryLemmaGloss = (MWEntryLemmaGloss)gloss;
                                mWEntryLemmaGloss = mWEntryLemmaGloss.copyNewLemmaGroup(Utils.translateThroughMap(mWEntryLemmaGloss.getLemmaGroup(), this.val$lemmaGroupMap));
                                glossCollection2.add(mWEntryLemmaGloss);
                                continue;
                            }
                            glossCollection2.add(gloss);
                        }
                        return this.val$new_gloss_processor.process(glossCollection2);
                    }
                }
                return null;
            }

            @Override
            public Merger.MergerNode getTransition(int n) {
                char c = this.val$dest.char_map.invert(n);
                return new IDMergerNode(IntegerDictionary.this.net.transitionValue(this.base, IntegerDictionary.this.char_map.translate(c)), this.string + c);
            }

            @Override
            public void finalizeCopy() {
            }
        }
        return new IDMergerNode(this.net.first_base(), "");
    }

    private final void collectLemmaGroups(int n, String string, List<Collection<Utils.ModifiableObjectPair<String, MWEntryLemmaGloss>>> list) {
        if (this.net.transitionPresent(n, 3)) {
            GlossCollection glossCollection = this.glosses.getGlossByIdx(this.net.transitionValue(n, 3));
            for (Gloss gloss : glossCollection) {
                if (!(gloss instanceof MWEntryLemmaGloss)) continue;
                MWEntryLemmaGloss mWEntryLemmaGloss = (MWEntryLemmaGloss)gloss;
                int n2 = mWEntryLemmaGloss.getLemmaGroup();
                while (list.size() <= n2) {
                    list.add(new ArrayList());
                }
                list.get(n2).add(new Utils.ModifiableObjectPair<String, MWEntryLemmaGloss>(string, mWEntryLemmaGloss));
            }
        }
        int n3 = this.net.getMaxIndex();
        for (int i = 4; i < n3; ++i) {
            if (!this.net.transitionPresent(n, i)) continue;
            this.collectLemmaGroups(this.net.transitionValue(n, i), string + this.char_map.invert(i), list);
        }
    }

    public int assignLemmaGroup(Collection<Utils.ModifiableObjectPair<String, MWEntryLemmaGloss>> collection, BitSet bitSet) {
        int n;
        if (collection.isEmpty()) {
            return -1;
        }
        BitSet bitSet2 = null;
        BitSet bitSet3 = (BitSet)bitSet.clone();
        for (Utils.ModifiableObjectPair<String, MWEntryLemmaGloss> modifiableObjectPair : collection) {
            String string = (String)modifiableObjectPair.l;
            MWEntryLemmaGloss mWEntryLemmaGloss = (MWEntryLemmaGloss)modifiableObjectPair.r;
            int n2 = this.net.getEntry(this.char_map.makeIterator(string, 3));
            GlossCollection glossCollection = this.glosses.getGlossByIdx(n2);
            BitSet bitSet4 = new BitSet();
            if (glossCollection != null) {
                for (Gloss gloss : glossCollection) {
                    MWEntryLemmaGloss mWEntryLemmaGloss2 = (MWEntryLemmaGloss)gloss;
                    if (mWEntryLemmaGloss.equalsIgnoreLemmaGroup(mWEntryLemmaGloss2)) {
                        bitSet4.set(mWEntryLemmaGloss2.getLemmaGroup());
                        continue;
                    }
                    bitSet3.set(mWEntryLemmaGloss2.getLemmaGroup());
                }
            }
            if (bitSet2 == null) {
                bitSet2 = bitSet4;
                bitSet2.andNot(bitSet);
                continue;
            }
            bitSet2.and(bitSet4);
        }
        int n3 = n = bitSet2 != null ? bitSet2.nextSetBit(0) : -1;
        if (n == -1) {
            n = bitSet3.nextClearBit(0);
        }
        return n;
    }

    @Override
    public void append(PerfectWordHash perfectWordHash, Map<Integer, Integer> map, Map<Integer, Integer> map2, GlossProcessor glossProcessor) throws DLTException {
        IntegerDictionary integerDictionary = (IntegerDictionary)perfectWordHash;
        ArrayList<Collection<Utils.ModifiableObjectPair<String, MWEntryLemmaGloss>>> arrayList = new ArrayList<Collection<Utils.ModifiableObjectPair<String, MWEntryLemmaGloss>>>();
        integerDictionary.collectLemmaGroups(integerDictionary.net.first_base(), "", arrayList);
        BitSet bitSet = new BitSet();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = this.assignLemmaGroup((Collection)arrayList.get(i), bitSet);
            bitSet.set(n);
            if (n == i) continue;
            map2.put(i, n);
        }
        this.net.attachFSA(NetGeneric.IndexIterator.Root, integerDictionary.getMergerNode(this, map, map2, glossProcessor));
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.net.dumpNet(printStream, n);
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        return this.net.dumpNet(printStream);
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        this.net.printStatistics(printStream);
    }

    @Override
    public boolean verifyConsistency() {
        return this.net.verifyConsistency();
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
        this.net.setTransitionToStringMapper(statistics);
    }

    @Override
    public String transitionToString(int n, int n2) {
        String string;
        switch (n) {
            case 1: {
                string = "*** unused char should not be used ***";
                break;
            }
            case 2: {
                string = "entry";
                break;
            }
            case 3: {
                Object object;
                try {
                    object = this.net.getPayloadManipulator(n).getObject(n2);
                }
                catch (DLTException dLTException) {
                    object = "" + n2 + '(' + dLTException + ')';
                }
                return "lemma->" + object;
            }
            default: {
                string = "" + this.char_map.invert(n);
            }
        }
        string = string + "->" + n2;
        return string;
    }

    final class GlossCollectionAdder
    implements NetGeneric.ChangeEncapsulator {
        final GlossCollection gc;
        GlossCollection gc_after_add;

        GlossCollectionAdder(GlossCollection glossCollection) {
            this.gc = glossCollection;
        }

        @Override
        public int Apply(int n) throws DLTException {
            int n2 = IntegerDictionary.this.glosses.processGlossCollectionAdd(n, this.gc);
            this.gc_after_add = IntegerDictionary.this.glosses.getGlossByIdx(n2);
            return n2;
        }
    }

    final class LemmaGlossAdder
    implements NetGeneric.ChangeEncapsulator {
        final Gloss lemmaGloss;
        GlossCollection gc_after_add;

        LemmaGlossAdder(Gloss gloss) {
            this.lemmaGloss = gloss;
        }

        @Override
        public int Apply(int n) throws DLTException {
            int n2 = IntegerDictionary.this.glosses.processGlossAdd(n, this.lemmaGloss);
            this.gc_after_add = IntegerDictionary.this.glosses.getGlossByIdx(n2);
            return n2;
        }
    }

    private static interface EntryProcessor {
        public void apply(String var1, int var2);
    }
}

