/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.WritableNode;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.util.LowercasingCharacterIterator;
import com.ibm.icu.text.Normalizer;
import java.io.DataInput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.Map;

public class LowerCaseMultiNet
implements MultiNet {
    private final MultiNet net;
    static ThreadLocal<LowercasingCharacterIterator> iterator = new ThreadLocal<LowercasingCharacterIterator>(){

        @Override
        protected LowercasingCharacterIterator initialValue() {
            return new LowercasingCharacterIterator();
        }
    };

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public LowerCaseMultiNet(MultiNet multiNet) {
        this.net = multiNet;
    }

    @Override
    public GlossCollection get(CharacterIterator characterIterator, int n, int n2, int n3) {
        int n4 = characterIterator.getIndex();
        GlossCollection glossCollection = this.net.get(iterator.get().setIterator(characterIterator), n);
        if (glossCollection != null) {
            glossCollection = glossCollection.filterByStringCase(n2, n3, characterIterator, n4, n4 + n);
        }
        return glossCollection;
    }

    @Override
    public boolean traverseLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        int n3 = characterIterator.getIndex();
        MatchBuffer matchBuffer2 = new MatchBuffer();
        this.traverse(characterIterator, matchBuffer2);
        for (int i = matchBuffer2.mpos - 1; i >= 0; --i) {
            GlossCollection glossCollection = matchBuffer2.gloss[i];
            int n4 = matchBuffer2.index[i];
            int n5 = matchBuffer2.cases[i];
            if ((glossCollection = glossCollection.filterByCase(CaseGloss.applyMethod(n5, n2), n, characterIterator, n3, n4)) == null) continue;
            boolean bl = matchBuffer.addMax(n4, glossCollection, n5);
            if (bl) {
                matchBuffer.pushMatch();
            }
            return bl;
        }
        return false;
    }

    @Override
    public int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        int n3 = matchBuffer.mpos;
        int n4 = characterIterator.getIndex();
        this.traverse(characterIterator, matchBuffer);
        return matchBuffer.filterByStringCase(n3, n, n2, characterIterator, n4);
    }

    @Override
    public GlossCollection get(CharacterIterator characterIterator, int n) {
        return this.net.get(iterator.get().setIterator(characterIterator), n);
    }

    @Override
    public GlossCollection get(String string) {
        return this.get(new StringCharacterIterator(string), string.length());
    }

    @Override
    public int normalizingTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, Normalizer.Mode mode) {
        return this.net.normalizingTraverse(iterator.get().setIterator(characterIterator), matchBuffer, mode);
    }

    @Override
    public Object oovLookup(CharacterIterator characterIterator, int n) {
        return this.net.oovLookup(iterator.get().setIterator(characterIterator), n);
    }

    @Override
    public int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        int n = characterIterator.getIndex();
        int n2 = matchBuffer.mpos;
        int n3 = this.net.traverse(iterator.get().setIterator(characterIterator), matchBuffer);
        characterIterator.setIndex(n);
        matchBuffer.getCases(n2, characterIterator);
        return n3;
    }

    @Override
    public boolean traverseLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.net.traverseLongest(iterator.get().setIterator(characterIterator), matchBuffer);
    }

    @Override
    public boolean traverseLongestReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.net.traverseLongestReversed(iterator.get().setIterator(characterIterator), matchBuffer);
    }

    @Override
    public int traverseReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.net.traverseReversed(iterator.get().setIterator(characterIterator), matchBuffer);
    }

    @Override
    public int whitespaceIgnoringTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.net.whitespaceIgnoringTraverse(iterator.get().setIterator(characterIterator), matchBuffer);
    }

    @Override
    public void add(CharacterIterator characterIterator, int n, Object object) throws DLTException {
        this.net.add(iterator.get().setIterator(characterIterator), n, object);
    }

    @Override
    public int remove(CharacterIterator characterIterator, int n) throws DLTException {
        return this.net.remove(iterator.get().setIterator(characterIterator), n);
    }

    @Override
    public void removeGloss(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        this.net.removeGloss(iterator.get().setIterator(characterIterator), n, gloss);
    }

    @Override
    public void contract() throws DLTException {
        this.net.contract();
    }

    @Override
    public int endBuild() {
        return this.net.endBuild();
    }

    @Override
    public void endReading() {
        this.net.endReading();
    }

    @Override
    public Node first() {
        return this.net.first();
    }

    @Override
    public boolean getChainPolicy() {
        return this.net.getChainPolicy();
    }

    @Override
    public int getFileFSTFormat() {
        return this.net.getFileFSTFormat();
    }

    @Override
    public boolean isContracted() {
        return this.net.isContracted();
    }

    @Override
    public boolean isModifiable() {
        return this.net.isModifiable();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.net.iterator();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iteratorAC(String string) {
        return this.net.iteratorAC(string);
    }

    @Override
    public WritableNode newNode(int n, int n2) throws DLTException {
        return this.net.newNode(n, n2);
    }

    @Override
    public void processGlosses(GlossProcessor glossProcessor) throws DLTException {
        this.net.processGlosses(glossProcessor);
    }

    @Override
    public long readContents(DataInput dataInput, int n) throws DLTException, IOException {
        return this.net.readContents(dataInput, n);
    }

    @Override
    public void setChainPolicy(boolean bl) {
        this.net.setChainPolicy(bl);
    }

    @Override
    public void setFirstNode(Node node) throws DLTException {
        this.net.setFirstNode(node);
    }

    @Override
    public void setOwnerDictionary(Dictionary dictionary) {
        this.net.setOwnerDictionary(dictionary);
    }

    @Override
    public void startBuild(boolean bl) throws DLTException {
        this.net.startBuild(bl);
    }

    @Override
    public MultiNet getMultiNet() {
        return this.net;
    }
}

