/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.CharacterMapLowercase;
import com.ibm.dltj.fst.PerfectWordHash;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.util.MappingCharacterIterator;

public final class MWUCaseNormalizer
implements PerfectWordHash.Normalizer {
    CharacterMapLowercase map;
    ThreadLocal<MapLowercasingIterator> lcci = new ThreadLocal<MapLowercasingIterator>(){

        @Override
        protected MapLowercasingIterator initialValue() {
            return new MapLowercasingIterator();
        }
    };

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWUCaseNormalizer(CharacterMap characterMap) {
        this.map = (CharacterMapLowercase)characterMap;
    }

    @Override
    public void normalize(PerfectWordHash.Query query) {
        this.lcci.get().setIterator(query.surface_form);
        query.normalized_form = this.lcci.get();
        query.nf_length = query.sf_length;
    }

    @Override
    public void filterResult(PerfectWordHash.Query query) {
        int n = query.surface_form.getIndex();
        int n2 = CaseGloss.CaseExtractor.getSubStringCaseMask(query.surface_form, n, n + query.sf_length, query.analyzer.isFirstWordOfSentence());
        query.gloss = query.analyzer != null ? CaseGloss.filterByCase(query.gloss, n2, query.analyzer.getCaseHandlingMethod(), query.surface_form, n, n + query.sf_length) : CaseGloss.filterByCase(query.gloss, n2, 67372551, query.surface_form, n, n + query.sf_length);
        if (query.gloss == null) {
            query.gloss = new GlossCollection();
        }
    }

    @Override
    public Gloss getNormalizationData(PerfectWordHash.Query query) throws DLTException {
        this.map.addCharacters(query.surface_form, query.sf_length);
        int n = query.surface_form.getIndex();
        CaseGloss caseGloss = new CaseGloss(query.surface_form, n, n + query.sf_length);
        query.surface_form.setIndex(n);
        return caseGloss;
    }

    @Override
    public void clearThreadLocalData() {
        this.lcci.remove();
    }

    class MapLowercasingIterator
    extends MappingCharacterIterator {
        MapLowercasingIterator() {
        }

        @Override
        public char map(char c) {
            return MWUCaseNormalizer.this.map.getCharMapping(c);
        }
    }
}

