/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.fst.MWUDictionaryImpl;
import com.ibm.dltj.fst.MWUParser;
import com.ibm.dltj.fst.PerfectWordHash;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MWEntryLemmaGloss;
import com.ibm.dltj.gloss.MWGloss;
import com.ibm.dltj.gloss.MWValidationGloss;
import com.ibm.dltj.gloss.MidGloss;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MWUDictProcessor {
    final MWUDictionaryImpl dict;
    final PerfectWordHash.Query query_holder;
    MWState states;
    MWState res_list;
    MWUParser mwuParser;
    private List<MWUParser.IBufferedInfo> buffer = new ArrayList<MWUParser.IBufferedInfo>();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWUDictProcessor(MWUParser mWUParser, MWUDictionaryImpl mWUDictionaryImpl, List<MWUParser.IBufferedInfo> list) {
        this.buffer = list;
        this.dict = mWUDictionaryImpl;
        this.mwuParser = mWUParser;
        this.query_holder = new PerfectWordHash.Query();
    }

    public void processReset() {
        this.res_list = null;
        this.states = new MWState();
    }

    public int processEntry(int n, int n2, int n3, int n4) {
        this.mwuParser.input.setIndex(n);
        PerfectWordHash.Query query = this.query_holder;
        query.sf_length = n2 - n;
        this.dict.entries.performQuery(query);
        assert (this.states.node == this.dict.net.first_base());
        PerfectWordHash.Query query2 = query;
        MWState mWState = this.states.processTransition(query2, n, n2, n3, n4);
        MWState mWState2 = mWState.next;
        while (query2.next != null) {
            query2 = query2.next;
            this.states.processTransition(query2, n, n2, n3, n4);
        }
        while (mWState2 != null) {
            query2 = query;
            MWState mWState3 = mWState2.processTransition(query2, n, n2, n3, n4);
            MWState mWState4 = mWState3.next;
            while (query2.next != null) {
                query2 = query2.next;
                mWState3 = mWState2.processTransition(query2, n, n2, n3, n4);
            }
            if (this.mwuParser.compound_group_start < 0) {
                mWState = mWState2.processMiss(mWState, mWState3, this.mwuParser.maxMWULength, this.mwuParser.maxMWUMisses);
            }
            mWState2 = mWState4;
        }
        if (this.res_list != null) {
            return this.extractMWUsFromResults();
        }
        return -1;
    }

    public boolean processResults(int n) {
        boolean bl = false;
        MWState mWState = this.states;
        MWState mWState2 = this.states.next;
        while (mWState2 != null) {
            MWState mWState3 = mWState2.next;
            boolean bl2 = mWState2.moveToResList();
            if (bl2 || n != mWState2.end) {
                mWState.next = mWState3;
            } else {
                mWState = mWState2;
                bl = true;
            }
            mWState2 = mWState3;
        }
        this.extractMWUsFromResults();
        return bl;
    }

    private int extractMWUsFromResults() {
        int n = -1;
        MWState mWState = this.res_list;
        while (mWState != null) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = -1;
            int[] nArray3 = mWState.validation_glosses_to_ignore;
            GlossCollection glossCollection = this.dict.glosses.getGlossByIdx(this.dict.net.transitionValue(mWState.node, 3));
            boolean[] blArray = new boolean[glossCollection.size()];
            Iterator iterator = glossCollection.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                Gloss gloss = (Gloss)iterator.next();
                if (!this.ignoreGloss(nArray3, n3) && this.checkConstraints(mWState, gloss)) {
                    MWGloss mWGloss;
                    blArray[n3] = true;
                    if (nArray == null) {
                        int n4 = 0;
                        MWState mWState2 = mWState;
                        while (mWState2 != this.states) {
                            ++n4;
                            if (mWState2.parent == this.states) {
                                n2 = mWState2.start;
                            }
                            mWState2 = mWState2.parent;
                        }
                        nArray = new int[n4];
                        nArray2 = new int[n4];
                        mWState2 = mWState;
                        while (mWState2 != this.states) {
                            nArray[--n4] = mWState2.start - n2;
                            nArray2[n4] = mWState2.end - n2;
                            mWState2 = mWState2.parent;
                        }
                    }
                    if ((mWGloss = this.getMWGloss(nArray, nArray2, mWState, gloss)) != null) {
                        n = n2;
                        if (this.mwuParser.mwOutputStyle == 1 || this.mwuParser.mwOutputStyle == 3) {
                            this.buffer.add(new MWUParser.CreateMWUInfo(1, n2, nArray2[nArray2.length - 1] + n2, mWGloss));
                        } else if (this.mwuParser.endOfLastTokenizedWord == -1) {
                            this.buffer.add(new MWUParser.CreateMWUInfo(1, n2, nArray2[nArray2.length - 1] + n2, mWGloss));
                        } else {
                            this.addMWUToBuffer(n2, nArray2[nArray2.length - 1] + n2, mWGloss);
                        }
                    }
                }
                ++n3;
            }
            mWState = mWState.next;
        }
        this.res_list = null;
        return n;
    }

    private void addMWUToBuffer(int n, int n2, Gloss gloss) {
        int n3 = -1;
        int n4 = -1;
        for (MWUParser.IBufferedInfo iBufferedInfo : this.buffer) {
            if (n3 == -1) {
                n3 = iBufferedInfo.checkBoundaryBegin(n);
            }
            if (n4 == -1) {
                n4 = iBufferedInfo.checkBoundaryEnd(n2);
            }
            if (n3 <= -1 || n4 <= -1) continue;
            break;
        }
        assert (n3 != -1);
        assert (n4 != -1);
        if (n3 == -1 || n4 == -1) {
            return;
        }
        if (n3 != n) {
            gloss = ((MWGloss)gloss).getCopyWithAdjustedOffsets(n, n3);
        }
        this.buffer.add(new MWUParser.CreateMWUInfo(1, n3, n4, gloss));
    }

    private boolean ignoreGloss(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private boolean checkConstraints(MWState mWState, Gloss gloss) {
        if (gloss instanceof MWValidationGloss) {
            if (mWState.separation_num > ((MWValidationGloss)gloss).getSeparationNumber()) {
                return false;
            }
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            MWState mWState2 = mWState;
            while (mWState2 != null) {
                if (mWState2.compound_start == -1) {
                    n3 += mWState2.tmp_misses_before;
                } else if (mWState2.compound_start == n && mWState2.compound_end == n2) {
                    n4 = Math.max(n4, mWState2.tmp_misses_before);
                } else {
                    n3 += n4;
                    n4 = mWState2.tmp_misses_before;
                    n = mWState2.compound_start;
                    n2 = mWState2.compound_end;
                }
                mWState2 = mWState2.parent;
            }
            if (mWState.separation_num + (n3 += n4) > ((MWValidationGloss)gloss).getSeparationNumber()) {
                return false;
            }
        } else if (mWState.separation_num > 0) {
            return false;
        }
        return true;
    }

    public void incrementMissesCounter() {
        MWState mWState = this.states.next;
        MWState mWState2 = this.states;
        while (mWState != null) {
            MWState mWState3 = mWState.next;
            mWState2 = mWState.processMissAfterCompound(mWState2, mWState, this.mwuParser.maxMWULength, this.mwuParser.maxMWUMisses);
            mWState = mWState3;
        }
    }

    private MWGloss getMWGloss(int[] nArray, int[] nArray2, MWState mWState, Gloss gloss) {
        ArrayList<ArrayList> arrayList = null;
        Gloss gloss2 = gloss;
        boolean bl = false;
        if (gloss instanceof MWValidationGloss) {
            MWValidationGloss mWValidationGloss = (MWValidationGloss)gloss;
            if (mWValidationGloss.getUserGloss() instanceof LemmaGenerator) {
                gloss2 = mWValidationGloss.getUserGloss();
                bl = true;
            } else if (mWValidationGloss.getUserGloss() instanceof MidGloss && ((MidGloss)mWValidationGloss.getUserGloss()).getLemmaGloss() != null) {
                gloss2 = mWValidationGloss;
                bl = true;
            }
            if (!bl) {
                arrayList = new ArrayList<ArrayList>(nArray.length);
            }
            int n = mWValidationGloss.getLemmaGroupIndex();
            MWState mWState2 = mWState;
            while (mWState2 != this.states) {
                ArrayList arrayList2;
                if (n != -1 && mWState2.lemma_gloss instanceof GlossCollection) {
                    arrayList2 = (GlossCollection)mWState2.lemma_gloss;
                    ArrayList<MWEntryLemmaGloss> arrayList3 = new ArrayList<MWEntryLemmaGloss>(1);
                    assert (arrayList2 != null);
                    MWEntryLemmaGloss mWEntryLemmaGloss = null;
                    for (Gloss gloss3 : arrayList2) {
                        MWEntryLemmaGloss mWEntryLemmaGloss2 = (MWEntryLemmaGloss)gloss3;
                        if (mWEntryLemmaGloss2.getLemmaGroup() != n) continue;
                        mWEntryLemmaGloss = mWEntryLemmaGloss2;
                        if (bl) break;
                        arrayList3.add(mWEntryLemmaGloss);
                    }
                    if (mWEntryLemmaGloss == null) {
                        return null;
                    }
                    assert (mWEntryLemmaGloss != null && mWEntryLemmaGloss.getLemmaGroup() == n);
                    if (!bl) {
                        arrayList.add(arrayList3);
                    }
                } else if (!bl && mWState2.lemma_gloss instanceof LemmaGenerator) {
                    arrayList2 = new ArrayList(1);
                    arrayList2.add((LemmaGenerator)mWState2.lemma_gloss);
                    arrayList.add(arrayList2);
                } else if (!bl) {
                    arrayList2 = new ArrayList(1);
                    arrayList2.add(null);
                    arrayList.add(arrayList2);
                }
                mWState2 = mWState2.parent;
            }
        }
        return MWGloss.createMWGloss(nArray, nArray2, gloss2, arrayList);
    }

    public void reset(UniLexAnalyzer uniLexAnalyzer, CharacterIterator characterIterator) {
        this.query_holder.surface_form = characterIterator;
        this.query_holder.analyzer = uniLexAnalyzer;
    }

    public void close() {
        this.dict.clearThreadLocalStorage();
    }

    private class MWState {
        final int node;
        private int misses;
        MWState parent;
        MWState next;
        Object lemma_gloss;
        int start;
        int end;
        int separation_num;
        private final int word_count;
        private boolean increase_miss_count = true;
        int tmp_misses_before = 0;
        private int tmp_misses_after = 0;
        int compound_start = -1;
        int compound_end = -1;
        int[] validation_glosses_to_ignore = null;

        MWState() {
            this.node = MWUDictProcessor.this.dict.net.first_base();
            this.misses = 0;
            this.parent = null;
            this.separation_num = 0;
            this.word_count = 0;
            assert (!MWUDictProcessor.this.dict.net.transitionPresent(this.node, 3));
        }

        MWState(int n, int n2, MWState mWState, MWState mWState2, int n3, int n4, PerfectWordHash.Query query) {
            this.node = n;
            this.misses = n2;
            this.parent = mWState;
            this.next = mWState2;
            this.lemma_gloss = query.gloss;
            if (this.lemma_gloss == null) {
                this.lemma_gloss = query.normalization_data;
            }
            this.start = n3;
            this.end = n4;
            this.separation_num = this.parent.misses;
            this.word_count = this.parent.word_count + 1;
        }

        MWState processTransition(PerfectWordHash.Query query, int n, int n2, int n3, int n4) {
            if (MWUDictProcessor.this.mwuParser.compound_group_start >= 0) {
                return this.processTransitionCompPart(query, n, n2, n3, n4);
            }
            return this.processTransitionWord(query, n, n2);
        }

        MWState processTransitionCompPart(PerfectWordHash.Query query, int n, int n2, int n3, int n4) {
            if (MWUDictProcessor.this.dict.net.transitionPresent(this.node, query.hash)) {
                int n5 = MWUDictProcessor.this.dict.net.transitionValue(this.node, query.hash);
                this.next = new MWState(n5, this.misses, this, this.next, n, n2, query);
                this.next.tmp_misses_after = n4;
                if (this != MWUDictProcessor.this.states) {
                    this.next.tmp_misses_before = n3;
                }
                this.next.compound_start = MWUDictProcessor.this.mwuParser.compound_group_start;
                this.next.compound_end = MWUDictProcessor.this.mwuParser.compound_group_end;
                this.next.increase_miss_count = false;
                if (this.compound_start == MWUDictProcessor.this.mwuParser.compound_group_start && this.compound_end == MWUDictProcessor.this.mwuParser.compound_group_end) {
                    MWState mWState = this;
                    while (this.next.tmp_misses_before > 0) {
                        --this.next.tmp_misses_before;
                        mWState = mWState.parent;
                        if (mWState != null && mWState.compound_start == MWUDictProcessor.this.mwuParser.compound_group_start && mWState.compound_end == MWUDictProcessor.this.mwuParser.compound_group_end) continue;
                        break;
                    }
                } else {
                    this.next.tmp_misses_before += this.tmp_misses_after;
                }
                return this.next;
            }
            return this;
        }

        MWState processTransitionWord(PerfectWordHash.Query query, int n, int n2) {
            if (MWUDictProcessor.this.dict.net.transitionPresent(this.node, query.hash)) {
                int n3 = MWUDictProcessor.this.dict.net.transitionValue(this.node, query.hash);
                this.next = new MWState(n3, this.misses, this, this.next, n, n2, query);
                this.next.tmp_misses_before += this.tmp_misses_after;
                return this.next;
            }
            return this;
        }

        MWState processMiss(MWState mWState, MWState mWState2, int n, int n2) {
            ++this.misses;
            if (this.misses <= n2 && this.misses + this.word_count <= n) {
                return mWState2;
            }
            if (MWUDictProcessor.this.dict.net.transitionPresent(this.node, 3)) {
                mWState.next = this.next;
                this.next = MWUDictProcessor.this.res_list;
                MWUDictProcessor.this.res_list = this;
                if (mWState2 == this) {
                    mWState2 = mWState;
                }
                return mWState2;
            }
            mWState.next = this.next;
            if (mWState2 == this) {
                mWState2 = mWState;
            }
            return mWState2;
        }

        boolean moveToResList() {
            if (MWUDictProcessor.this.dict.net.transitionPresent(this.node, 3)) {
                this.next = MWUDictProcessor.this.res_list;
                MWUDictProcessor.this.res_list = this;
                return true;
            }
            return false;
        }

        MWState processMissAfterCompound(MWState mWState, MWState mWState2, int n, int n2) {
            if (!this.increase_miss_count) {
                this.increase_miss_count = true;
                return this;
            }
            return this.processMiss(mWState, mWState2, n, n2);
        }

        public String toString() {
            return this.next == null ? "" + this.node : "" + this.node + ", " + this.next.toString();
        }
    }
}

