/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.GlossCollectionHandler;
import com.ibm.dltj.fst.IntegerDictionary;
import com.ibm.dltj.fst.MWUCaseNormalizer;
import com.ibm.dltj.fst.MWUDictionary;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.PerfectWordHash;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MWEntryLemmaGloss;
import com.ibm.dltj.gloss.MWValidationGloss;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.Multiples;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.Permutations;
import com.ibm.dltj.netgeneric.Statistics;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class MWUDictionaryImpl
implements MWUDictionary {
    final PerfectWordHash entries;
    final GlossCollectionHandler glosses;
    final GlossProcessor new_gloss_processor;
    boolean glossesRefCountInitialized = false;
    static final int INDEX_UNMAPPED = 1;
    static final int INDEX_RESERVED = 2;
    static final int INDEX_GLOSS = 3;
    static final int INDEX_FIRST_LINK = 4;
    public static final int SIGNATURE = 813112604;
    protected int max_mwu_length = 0;
    protected int max_mwu_misses = -1;
    final NetGeneric net;
    Map<Integer, String> dumpInverseMap = null;

    @Override
    public int getSignature() {
        return 813112604;
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWUDictionaryImpl() throws DLTException {
        this(new GlossCollectionHandler(null), IntegerDictionary.createCharacterMap(), null, true);
    }

    public MWUDictionaryImpl(GlossCollectionHandler glossCollectionHandler, CharacterMap characterMap, GlossProcessor glossProcessor, boolean bl) throws DLTException {
        this(glossCollectionHandler, characterMap, glossProcessor, bl ? new MWUCaseNormalizer(characterMap) : new EmptyNormalizer(), new JavaStringHash());
    }

    public MWUDictionaryImpl(GlossCollectionHandler glossCollectionHandler, CharacterMap characterMap, GlossProcessor glossProcessor, PerfectWordHash.Normalizer normalizer, PerfectWordHash.StringHash stringHash) throws DLTException {
        this.glosses = glossCollectionHandler;
        this.entries = new IntegerDictionary(this, characterMap, this.glosses, normalizer, stringHash);
        this.new_gloss_processor = glossProcessor;
        this.net = NetGenericFactory.create(-2018189263, 4, this);
        this.net.setPayloadManipulator(3, this.glosses);
        this.net.setTransitionToStringMapper(this);
    }

    @Override
    public void reset() {
        this.net.reset();
        this.entries.reset();
        this.glosses.reset();
    }

    int getMaxMWULength() {
        return this.max_mwu_length;
    }

    int getMaxMWUMisses() {
        if (this.max_mwu_misses == -1) {
            for (int i = 0; i < this.glosses.getHighestIndex(); ++i) {
                int n;
                Gloss gloss;
                GlossCollection glossCollection = this.glosses.getGlossByIdx(i);
                if (glossCollection == null || (gloss = glossCollection.getGloss(MWValidationGloss.class)) == null || this.max_mwu_misses >= (n = ((MWValidationGloss)gloss).getSeparationNumber())) continue;
                this.max_mwu_misses = n;
            }
        }
        return this.max_mwu_misses;
    }

    @Override
    public boolean isEmpty() {
        return this.net.isEmpty();
    }

    @Override
    public void readContents(DataInput dataInput) throws IOException, DLTException {
        this.max_mwu_length = dataInput.readInt();
        this.entries.load(dataInput);
        this.net.setMaxIndex(this.entries.getMaxHash());
        NetGenericFactory.load(dataInput, this.net);
        this.glossesRefCountInitialized = false;
    }

    @Override
    public long writeNodes(DataOutput dataOutput) throws IOException, DLTException {
        long l = 0L;
        dataOutput.writeInt(this.max_mwu_length);
        l += this.entries.save(dataOutput);
        return l += NetGenericFactory.save(dataOutput, this.net);
    }

    @Override
    public void startModify() throws DLTException {
        this.net.setMaxIndex(this.entries.getMaxHash());
        this.net.startModify();
        this.entries.startModify();
        if (!this.glosses.buildStarted()) {
            this.glosses.startBuild(true);
            this.glosses.create_collections();
        }
        if (!this.glossesRefCountInitialized) {
            this.net.forAllInstances(3, new NetGeneric.ChangeEncapsulator(){

                @Override
                public int Apply(int n) {
                    return MWUDictionaryImpl.this.glosses.reference(n);
                }
            });
            this.glossesRefCountInitialized = true;
        }
    }

    @Override
    public void endModify() {
        this.net.endModify();
        this.entries.endModify();
        this.glosses.endBuild();
    }

    @Override
    public void addSimple(List<String> list, Gloss gloss) throws DLTException {
        this.addMWU(list, 0, gloss);
    }

    @Override
    public void addMWU(List<String> list, int n, Gloss gloss) throws DLTException {
        ArrayList<Dictionary.MWUElement> arrayList = new ArrayList<Dictionary.MWUElement>(list.size());
        for (String string : list) {
            arrayList.add(new Dictionary.MWUElement(Arrays.asList(string), string, false));
        }
        this.addMWU(arrayList, n, false, gloss);
    }

    @Override
    public void addMWU(List<Dictionary.MWUElement> list, int n, boolean bl, Gloss gloss) throws DLTException {
        int n2;
        int n3;
        Object object;
        this.net.ensureModifyStarted();
        PerfectWordHash.Query query = new PerfectWordHash.Query();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator("");
        query.surface_form = stringCharacterIterator;
        int[][] nArrayArray = new int[list.size()][];
        MWEntryLemmaGloss[][] mWEntryLemmaGlossArrayArray = new MWEntryLemmaGloss[list.size()][];
        BitSet bitSet = null;
        BitSet bitSet2 = new BitSet();
        boolean[] blArray = this.getOptionalWords(list);
        int[] nArray = this.getWordOrder(list);
        ArrayList<Object> arrayList = null;
        if (blArray != null && nArray != null) {
            arrayList = new ArrayList<Object>();
        }
        int n4 = 0;
        for (Dictionary.MWUElement object3 : list) {
            Object object2 = new int[object3.surfaceForms.size()];
            mWEntryLemmaGlossArrayArray[n4] = new MWEntryLemmaGloss[object3.surfaceForms.size()];
            int n5 = 0;
            object = object3.lemma;
            if (object == null) {
                object = object3.surfaceForms.get(0);
            }
            n3 = 0;
            for (String string2 : object3.surfaceForms) {
                MWEntryLemmaGloss mWEntryLemmaGloss;
                stringCharacterIterator.setText(string2);
                query.sf_length = string2.length();
                this.entries.getNormalizer().normalize(query);
                Gloss gloss2 = this.entries.getNormalizer().getNormalizationData(query);
                this.entries.addEntry(query, null);
                if (gloss2 != null) {
                    gloss2 = (Gloss)this.new_gloss_processor.process(gloss2);
                }
                Gloss gloss3 = new CutPasteGloss(string2, (String)object);
                gloss3 = (Gloss)this.new_gloss_processor.process(gloss3);
                mWEntryLemmaGlossArrayArray[n4][n3] = mWEntryLemmaGloss = new MWEntryLemmaGloss(gloss3, gloss2, -1);
                object2[n5++] = query.hash;
                if (object != null) {
                    BitSet bitSet3 = new BitSet();
                    if (query.gloss != null) {
                        for (Gloss gloss4 : query.gloss) {
                            MWEntryLemmaGloss mWEntryLemmaGloss2 = (MWEntryLemmaGloss)gloss4;
                            if (mWEntryLemmaGloss.equalsIgnoreLemmaGroup(mWEntryLemmaGloss2)) {
                                bitSet3.set(mWEntryLemmaGloss2.getLemmaGroup());
                                continue;
                            }
                            bitSet2.set(mWEntryLemmaGloss2.getLemmaGroup());
                        }
                    }
                    if (bitSet == null) {
                        bitSet = bitSet3;
                    } else {
                        bitSet.and(bitSet3);
                    }
                }
                ++n3;
            }
            if (object3.optional && arrayList != null) {
                Object object4 = new LemmaGloss((String)object);
                object4 = (Gloss)this.new_gloss_processor.process(object4);
                arrayList.add(object4);
            }
            nArrayArray[n4] = Utils.removeDuplicates(object2);
            ++n4;
        }
        int n6 = n2 = bitSet != null ? bitSet.nextSetBit(0) : -1;
        if (n2 == -1) {
            n2 = bitSet2.nextClearBit(0);
            n4 = 0;
            for (Object object2 : list) {
                String string = object2.lemma;
                if (string == null) {
                    string = object2.surfaceForms.get(0);
                }
                if (string != null) {
                    object = null;
                    n3 = 0;
                    for (String string2 : object2.surfaceForms) {
                        stringCharacterIterator.setText(string2);
                        query.sf_length = string2.length();
                        this.entries.getNormalizer().normalize(query);
                        object = mWEntryLemmaGlossArrayArray[n4][n3].copyNewLemmaGroup(n2);
                        object = (Gloss)this.new_gloss_processor.process(object);
                        this.entries.addEntry(query, (Gloss)object);
                        ++n3;
                    }
                }
                ++n4;
            }
        }
        if (n2 != -1 || n != 0 || nArray != null) {
            gloss = arrayList != null ? (Gloss)this.new_gloss_processor.process(new MWValidationGloss(gloss, n, nArray, arrayList.toArray(new Gloss[arrayList.size()]), n2)) : (Gloss)this.new_gloss_processor.process(new MWValidationGloss(gloss, n, nArray, null, n2));
        }
        assert (blArray == null || blArray.length == nArrayArray.length);
        if (!bl) {
            Multiples.addMultiple(this.net, NetGeneric.IndexIterator.Root, nArrayArray, blArray, 3, gloss);
        } else {
            Permutations.addPermutations(this.net, NetGeneric.IndexIterator.Root, nArrayArray, blArray, 3, gloss);
        }
        this.updateMaxLength(nArrayArray.length, n);
    }

    @Override
    public void append(MWUDictionary mWUDictionary, GlossProcessor glossProcessor) throws DLTException {
        if (mWUDictionary.getClass() != this.getClass()) {
            throw new DLTException(Messages.getString("error.mwu.incompatible"));
        }
        this.doAppend(mWUDictionary, glossProcessor);
    }

    void doAppend(MWUDictionary mWUDictionary, GlossProcessor glossProcessor) throws DLTException {
        MWUDictionaryImpl mWUDictionaryImpl = (MWUDictionaryImpl)mWUDictionary;
        this.net.ensureModifyStarted();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        this.entries.append(mWUDictionaryImpl.entries, hashMap, hashMap2, glossProcessor);
        Map<Integer, Integer> map = Utils.invertMap(hashMap, null);
        class MWUMergerNode
        implements Merger.MergerNode {
            final int base;
            final /* synthetic */ MWUDictionaryImpl val$src;
            final /* synthetic */ Map val$entryMap;
            final /* synthetic */ Map val$inverseEntryMap;
            final /* synthetic */ Map val$lemmaGroupMap;
            final /* synthetic */ GlossProcessor val$processor;

            MWUMergerNode(int n) {
                this.val$src = mWUDictionaryImpl2;
                this.val$entryMap = map;
                this.val$inverseEntryMap = map2;
                this.val$lemmaGroupMap = map3;
                this.val$processor = glossProcessor;
                this.base = n;
            }

            @Override
            public boolean startCopy() throws DLTException {
                return true;
            }

            @Override
            public int[] gatherLinks() {
                int[] nArray = this.val$src.net.gatherNodeLinks(this.base);
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = Utils.translateThroughMap(nArray[i], this.val$entryMap);
                }
                Arrays.sort(nArray);
                return nArray;
            }

            @Override
            public boolean transitionPresent(int n) {
                return this.val$src.net.transitionPresent(this.base, Utils.translateThroughMap(n, this.val$inverseEntryMap));
            }

            @Override
            public Object transitionValue(int n) throws DLTException {
                if (n != 3) {
                    return null;
                }
                GlossCollection glossCollection = this.val$src.glosses.getGlossByIdx(this.val$src.net.transitionValue(this.base, n));
                GlossCollection glossCollection2 = new GlossCollection();
                for (Gloss gloss : glossCollection) {
                    if (gloss instanceof MWValidationGloss) {
                        MWValidationGloss mWValidationGloss = (MWValidationGloss)gloss;
                        MWValidationGloss mWValidationGloss2 = (MWValidationGloss)mWValidationGloss.copyNewLemmaGroup(Utils.translateThroughMap(mWValidationGloss.getLemmaGroupIndex(), this.val$lemmaGroupMap));
                        glossCollection2.add(mWValidationGloss2);
                        continue;
                    }
                    glossCollection2.add(gloss);
                }
                return this.val$processor.process(glossCollection2);
            }

            @Override
            public Merger.MergerNode getTransition(int n) {
                int n2 = Utils.translateThroughMap(n, this.val$inverseEntryMap);
                int n3 = this.val$src.net.transitionValue(this.base, n2);
                return new MWUMergerNode(n3);
            }

            @Override
            public void finalizeCopy() {
            }
        }
        this.net.attachFSA(NetGeneric.IndexIterator.Root, new MWUMergerNode(mWUDictionaryImpl.net.first_base()));
        this.max_mwu_length = Math.max(this.max_mwu_length, mWUDictionaryImpl.max_mwu_length);
    }

    void updateMaxLength(int n, int n2) {
        int n3 = n + n2;
        if (this.max_mwu_length < n3) {
            this.max_mwu_length = n3;
        }
        if (this.max_mwu_misses < n2) {
            this.max_mwu_misses = n2;
        }
    }

    void addMultiple(int[][] nArray, Object object) throws DLTException {
        class MultipleMergerNode
        implements Merger.MergerNode {
            int[] trans;
            Merger.MergerNode child;
            final /* synthetic */ int[][] val$translated;
            final /* synthetic */ Object val$gloss;

            MultipleMergerNode(int n) {
                this.val$translated = nArray;
                this.val$gloss = object;
                if (n == this.val$translated.length) {
                    this.child = null;
                    this.trans = new int[0];
                } else {
                    this.child = new MultipleMergerNode(n + 1);
                    this.trans = this.val$translated[n];
                }
            }

            @Override
            public boolean startCopy() throws DLTException {
                return true;
            }

            @Override
            public int[] gatherLinks() {
                return this.trans;
            }

            @Override
            public boolean transitionPresent(int n) {
                if (n == 3) {
                    return this.child == null;
                }
                if (n < 4) {
                    return false;
                }
                return Arrays.binarySearch(this.trans, n) >= 0;
            }

            @Override
            public Object transitionValue(int n) throws DLTException {
                if (n == 3) {
                    return this.val$gloss;
                }
                assert (false);
                return null;
            }

            @Override
            public Merger.MergerNode getTransition(int n) {
                return this.child;
            }

            @Override
            public void finalizeCopy() {
            }
        }
        this.net.attachFSA(NetGeneric.IndexIterator.Root, new MultipleMergerNode(0));
    }

    protected int[] getWordOrder(List<Dictionary.MWUElement> list) {
        int n = list.size();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Dictionary.MWUElement mWUElement : list) {
            if (mWUElement.lemma != null) {
                treeSet.add(mWUElement.lemma);
                continue;
            }
            return null;
        }
        Object object = new int[n];
        int n2 = 0;
        for (String string : treeSet) {
            for (int i = 0; i < n; ++i) {
                if (!string.equals(list.get((int)i).lemma)) continue;
                object[i] = n2;
            }
            ++n2;
        }
        return object;
    }

    protected boolean[] getOptionalWords(List<Dictionary.MWUElement> list) throws DLTException {
        boolean bl = false;
        boolean bl2 = true;
        int n = list.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            boolean bl3;
            blArray[i] = bl3 = list.get((int)i).optional;
            if (bl3) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            throw new DLTException(Messages.getString("invalid.mwu.all.optional"));
        }
        if (!bl) {
            return null;
        }
        return blArray;
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        printStream.print("Index ");
        this.entries.printStatistics(printStream);
        printStream.print("MWU ");
        this.net.printStatistics(printStream);
        printStream.println("Glosses " + this.glosses.getGlossCollectionCount() + " max index " + this.glosses.getHighestIndex());
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        printStream.print("Entries ");
        this.entries.dumpNet(printStream);
        this.dumpInverseMap = this.entries.buildInverseMap();
        printStream.print("MWUs ");
        return this.net.dumpNet(printStream);
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.dumpInverseMap = this.entries.buildInverseMap();
        this.net.dumpNet(printStream, n);
    }

    @Override
    public boolean verifyConsistency() {
        boolean bl = this.entries.verifyConsistency() && this.net.verifyConsistency();
        return bl;
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
        this.net.setTransitionToStringMapper(statistics);
    }

    @Override
    public String transitionToString(int n, int n2) {
        if (n < 4 || this.dumpInverseMap == null) {
            return this.net.transitionToString(n, n2);
        }
        String string = this.dumpInverseMap.get(n);
        if (string == null) {
            return this.net.transitionToString(n, n2);
        }
        return string + "->" + n2;
    }

    @Override
    public Node getNodeInterface() {
        return new MWUNode(this.net.first_base(), this.entries.buildInverseMap());
    }

    @Override
    public void clearThreadLocalStorage() {
        this.entries.getNormalizer().clearThreadLocalData();
    }

    private class MWUNode
    implements Node {
        private final int node;
        private final int[] trans;
        private final Map<Integer, String> inverseMap;

        MWUNode(int n, Map<Integer, String> map) {
            this.node = n;
            this.inverseMap = map;
            this.trans = MWUDictionaryImpl.this.net.gatherNodeLinks(this.node);
        }

        @Override
        public void dispose() {
        }

        @Override
        public GlossCollection getGloss() {
            if (MWUDictionaryImpl.this.net.transitionPresent(this.node, 3)) {
                return MWUDictionaryImpl.this.glosses.getGlossByIdx(MWUDictionaryImpl.this.net.transitionValue(this.node, 3));
            }
            return null;
        }

        @Override
        public char get_char(int n) {
            return '\u0000';
        }

        @Override
        public String get_chars(int n) {
            return this.inverseMap.get(this.trans[n]) + ' ';
        }

        @Override
        public Node get_trans(int n) {
            return new MWUNode(MWUDictionaryImpl.this.net.transitionValue(this.node, this.trans[n]), this.inverseMap);
        }

        @Override
        public boolean isFinal() {
            return MWUDictionaryImpl.this.net.transitionPresent(this.node, 3);
        }

        @Override
        public Node next(char c) {
            return null;
        }

        @Override
        public Node next(CharacterIterator characterIterator) {
            int n = characterIterator.getIndex();
            char c = characterIterator.current();
            while (c != ' ' && c != '\uffff') {
                c = characterIterator.next();
            }
            int n2 = characterIterator.getIndex() - n;
            characterIterator.setIndex(n);
            Node node = this.nextRestricted(characterIterator, n2);
            if (node != null) {
                characterIterator.setIndex(n + n2);
                characterIterator.next();
            }
            return node;
        }

        @Override
        public Node previous(CharacterIterator characterIterator) {
            int n = characterIterator.getIndex();
            char c = characterIterator.previous();
            while (c != ' ' && c != '\uffff') {
                c = characterIterator.previous();
            }
            int n2 = characterIterator.getIndex();
            int n3 = n - (n2 + 1);
            characterIterator.next();
            Node node = this.nextRestricted(characterIterator, n3);
            if (node != null) {
                characterIterator.setIndex(n2);
            }
            return node;
        }

        @Override
        public Node nextRestricted(CharacterIterator characterIterator, int n) {
            PerfectWordHash.Query query = new PerfectWordHash.Query();
            query.surface_form = characterIterator;
            query.sf_length = n;
            MWUDictionaryImpl.this.entries.performQuery(query);
            if (MWUDictionaryImpl.this.net.transitionPresent(this.node, query.hash)) {
                return new MWUNode(MWUDictionaryImpl.this.net.transitionValue(this.node, query.hash), this.inverseMap);
            }
            return null;
        }

        @Override
        public int num_chars() {
            return 2;
        }

        @Override
        public int num_trans() {
            return this.trans.length;
        }
    }

    static class EmptyNormalizer
    implements PerfectWordHash.Normalizer {
        EmptyNormalizer() {
        }

        @Override
        public void normalize(PerfectWordHash.Query query) {
            query.nf_length = query.sf_length;
            query.normalized_form = query.surface_form;
        }

        @Override
        public void filterResult(PerfectWordHash.Query query) {
        }

        @Override
        public Gloss getNormalizationData(PerfectWordHash.Query query) {
            return null;
        }

        @Override
        public void clearThreadLocalData() {
        }
    }

    static class JavaStringHash
    implements PerfectWordHash.StringHash {
        JavaStringHash() {
        }

        @Override
        public int getHash(CharacterIterator characterIterator, int n) {
            int n2 = 0;
            int n3 = 1;
            int n4 = characterIterator.getIndex();
            for (int i = n4 + n - 1; i >= n4; --i) {
                n2 += characterIterator.setIndex(i) * n3;
                int n5 = n3 << 5;
                n3 = n5 - n3;
            }
            return n2;
        }
    }
}

