/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.GlossCollectionHandler;
import com.ibm.dltj.fst.MWUCaseNormalizer;
import com.ibm.dltj.fst.MWUDictionary;
import com.ibm.dltj.fst.MWUDictionaryImpl;
import com.ibm.dltj.fst.NetGenericDictionary;
import com.ibm.dltj.fst.PerfectWordHash;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MWValidationGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.netgeneric.Multiples;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.Permutations;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

class MWUDictionaryLemmatized
extends MWUDictionaryImpl {
    public static final int SIGNATURE = 813112591;
    static final char LEMMA_CHARACTER = '&';
    final NetGenericDictionary lemmas;
    final PerfectWordHash.Normalizer case_normalizer;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public int getSignature() {
        return 813112591;
    }

    public MWUDictionaryLemmatized(GlossCollectionHandler glossCollectionHandler, CharacterMap characterMap, GlossProcessor glossProcessor, boolean bl) throws DLTException {
        this(glossCollectionHandler, characterMap, glossProcessor, new NetGenericDictionary(glossCollectionHandler, characterMap), bl ? new MWUCaseNormalizer(characterMap) : new MWUDictionaryImpl.EmptyNormalizer());
    }

    public MWUDictionaryLemmatized(GlossCollectionHandler glossCollectionHandler, CharacterMap characterMap, GlossProcessor glossProcessor, NetGenericDictionary netGenericDictionary, PerfectWordHash.Normalizer normalizer) throws DLTException {
        super(glossCollectionHandler, characterMap, glossProcessor, new Lemmatizer(netGenericDictionary, normalizer), new MWUDictionaryImpl.JavaStringHash());
        this.lemmas = netGenericDictionary;
        this.case_normalizer = normalizer;
    }

    @Override
    public void addMWU(List<Dictionary.MWUElement> list, int n, boolean bl, Gloss gloss) throws DLTException {
        this.net.ensureModifyStarted();
        int[][] nArrayArray = new int[list.size()][];
        boolean[] blArray = this.getOptionalWords(list);
        int[] nArray = this.getWordOrder(list);
        PerfectWordHash.Query query = new PerfectWordHash.Query();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator("");
        query.surface_form = stringCharacterIterator;
        ArrayList<Object> arrayList = null;
        if (blArray != null && nArray != null) {
            arrayList = new ArrayList<Object>();
        }
        int n2 = 0;
        for (Dictionary.MWUElement mWUElement : list) {
            int n3 = 0;
            String string = mWUElement.lemma;
            int[] nArray2 = new int[string == null ? mWUElement.surfaceForms.size() : 1];
            if (string != null) {
                Object object = null;
                boolean bl2 = true;
                for (String string2 : mWUElement.surfaceForms) {
                    Gloss gloss2;
                    stringCharacterIterator.setText(string2);
                    query.sf_length = string2.length();
                    this.case_normalizer.normalize(query);
                    if (mWUElement.optional && arrayList != null) {
                        if (bl2) {
                            object = new LemmaGloss(string);
                            object = (Gloss)this.new_gloss_processor.process(object);
                            arrayList.add(object);
                            bl2 = false;
                        }
                    } else {
                        object = new CutPasteGloss(string2, string);
                        object = (Gloss)this.new_gloss_processor.process(object);
                    }
                    if ((gloss2 = this.case_normalizer.getNormalizationData(query)) != null) {
                        gloss2 = (Gloss)this.new_gloss_processor.process(gloss2);
                        object = new MidGloss(new Gloss[]{object, gloss2});
                        object = (Gloss)this.new_gloss_processor.process(object);
                    }
                    this.lemmas.add(new StringCharacterIterator(string2), string2.length(), object);
                }
                string = string + '&';
                this.entries.addEntry(query, null);
                nArray2[n3++] = query.hash;
            } else {
                for (String string3 : mWUElement.surfaceForms) {
                    stringCharacterIterator.setText(string3);
                    query.sf_length = string3.length();
                    this.case_normalizer.normalize(query);
                    this.entries.addEntry(query, null);
                    nArray2[n3++] = query.hash;
                }
            }
            nArrayArray[n2++] = Utils.removeDuplicates(nArray2);
        }
        if (n != 0 || nArray != null) {
            gloss = arrayList != null ? (Gloss)this.new_gloss_processor.process(new MWValidationGloss(gloss, n, nArray, arrayList.toArray(new Gloss[arrayList.size()]), -1)) : (Gloss)this.new_gloss_processor.process(new MWValidationGloss(gloss, n, nArray, null, -1));
        }
        assert (blArray == null || blArray.length == nArrayArray.length);
        if (!bl) {
            Multiples.addMultiple(this.net, NetGeneric.IndexIterator.Root, nArrayArray, blArray, 3, gloss);
        } else {
            Permutations.addPermutations(this.net, NetGeneric.IndexIterator.Root, nArrayArray, blArray, 3, gloss);
        }
        this.updateMaxLength(nArrayArray.length, n);
    }

    @Override
    public void append(MWUDictionary mWUDictionary, GlossProcessor glossProcessor) throws DLTException {
        if (mWUDictionary.getClass() != this.getClass()) {
            throw new DLTException(Messages.getString("error.mwu.incompatible"));
        }
        MWUDictionaryLemmatized mWUDictionaryLemmatized = (MWUDictionaryLemmatized)mWUDictionary;
        this.lemmas.append(mWUDictionaryLemmatized.lemmas, glossProcessor);
        super.doAppend(mWUDictionaryLemmatized, glossProcessor);
    }

    @Override
    public void readContents(DataInput dataInput) throws IOException, DLTException {
        this.max_mwu_length = dataInput.readInt();
        this.entries.load(dataInput);
        this.lemmas.load(dataInput);
        this.net.setMaxIndex(this.entries.getMaxHash());
        NetGenericFactory.load(dataInput, this.net);
        this.glossesRefCountInitialized = false;
    }

    @Override
    public long writeNodes(DataOutput dataOutput) throws IOException, DLTException {
        long l = 0L;
        dataOutput.writeInt(this.max_mwu_length);
        l += this.entries.save(dataOutput);
        l += this.lemmas.save(dataOutput);
        return l += NetGenericFactory.save(dataOutput, this.net);
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        printStream.print("Entries ");
        this.entries.dumpNet(printStream);
        printStream.print("Lemmas ");
        this.lemmas.dumpNet(printStream);
        printStream.print("MWUs ");
        return this.net.dumpNet(printStream);
    }

    static class Lemmatizer
    implements PerfectWordHash.Normalizer {
        final ArrayList<PerfectWordHash.Query> queries = new ArrayList();
        final NetGenericDictionary lemmas;
        final PerfectWordHash.Normalizer chained_normalizer;

        Lemmatizer(NetGenericDictionary netGenericDictionary, PerfectWordHash.Normalizer normalizer) {
            this.lemmas = netGenericDictionary;
            this.chained_normalizer = normalizer;
        }

        @Override
        public void normalize(PerfectWordHash.Query query) {
            this.chained_normalizer.normalize(query);
            query.gloss = this.lemmas.get(query.surface_form, query.sf_length);
            this.chained_normalizer.filterResult(query);
            assert (query.next == null);
            GlossCollection glossCollection = query.gloss;
            PerfectWordHash.Query query2 = query;
            if (glossCollection != null) {
                int n = glossCollection.size();
                if (this.queries.size() < n) {
                    this.queries.ensureCapacity(n);
                    while (this.queries.size() < n) {
                        this.queries.add(new PerfectWordHash.Query());
                    }
                }
                CharacterIterator characterIterator = query.normalized_form;
                int n2 = characterIterator.getIndex();
                int n3 = query.nf_length + n2;
                int n4 = 0;
                for (Gloss gloss : glossCollection) {
                    LemmaGenerator lemmaGenerator = null;
                    if (gloss instanceof LemmaGenerator) {
                        lemmaGenerator = (LemmaGenerator)((Object)gloss);
                    } else if (gloss instanceof MidGloss) {
                        lemmaGenerator = ((MidGloss)gloss).getLemmaGloss();
                    }
                    if (lemmaGenerator != null) {
                        try {
                            String string = lemmaGenerator.getLemma(characterIterator, n2, n3) + '&';
                            query2 = query2.next = this.queries.get(n4);
                            query2.surface_form = null;
                            query2.sf_length = 0;
                            query2.normalized_form = new StringCharacterIterator(string);
                            query2.nf_length = string.length();
                            query2.normalization_data = lemmaGenerator;
                        }
                        catch (DLTException dLTException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
            query2.next = null;
        }

        @Override
        public void filterResult(PerfectWordHash.Query query) {
        }

        @Override
        public Gloss getNormalizationData(PerfectWordHash.Query query) {
            return (Gloss)query.normalization_data;
        }

        @Override
        public void clearThreadLocalData() {
        }
    }
}

