/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.RepeatedWordsChecker;
import com.ibm.dltj.SimpleWordTokenizer;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.fst.MWUDictProcessor;
import com.ibm.dltj.fst.MWUDictionary;
import com.ibm.dltj.fst.MWUDictionaryImpl;
import com.ibm.dltj.gloss.MWGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.impl.TokenCountObserverParsingStream;
import com.ibm.dltj.util.BoundedCharacterIterator;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.Utils;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MWUParser
extends TokenCountObserverParsingStream
implements MWUParsingStream {
    CharacterIterator input;
    private final MWUParsingStream parsingStream;
    private BoundedCharacterIterator inputBounded;
    int compound_group_start = -1;
    int compound_group_end = -1;
    private GroupInfo compoundGroupInfo;
    private final IntArray compoundBoundaries = new IntArray();
    private MWUDictProcessor[] mwuDictProcessors;
    private final SimpleWordTokenizer tokenizer;
    private int compoundGroupOpened = 0;
    private boolean lookupEntireCompoundOnly = false;
    private final boolean attemptBreakOnRBBI = true;
    private boolean ignoreForkedDecomp = false;
    int endOfLastTokenizedWord = -1;
    private int mwSpanFlag = 1;
    int mwOutputStyle = 4;
    private List<IBufferedInfo> buffer = new LinkedList<IBufferedInfo>();
    int maxMWULength = -1;
    int maxMWUMisses = -1;
    private static final ByIndexComparator byIndexComparator = new ByIndexComparator();
    private static final LongestOnlyComparator longestOnlyComparator = new LongestOnlyComparator();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWUParser(ArrayList<MWUDictionary> arrayList, MWUParsingStream mWUParsingStream, ULocale uLocale) throws DLTException {
        this.mwuDictProcessors = new MWUDictProcessor[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            MWUDictionaryImpl mWUDictionaryImpl = (MWUDictionaryImpl)arrayList.get(i);
            this.mwuDictProcessors[i] = new MWUDictProcessor(this, mWUDictionaryImpl, this.buffer);
            int n2 = mWUDictionaryImpl.getMaxMWULength();
            if (n2 > this.maxMWULength) {
                this.maxMWULength = n2;
            }
            if ((n = mWUDictionaryImpl.getMaxMWUMisses()) <= this.maxMWUMisses) continue;
            this.maxMWUMisses = n;
        }
        this.parsingStream = mWUParsingStream;
        this.checkLocale(uLocale);
        this.tokenizer = new SimpleWordTokenizer();
    }

    @Deprecated
    public MWUParser(ArrayList<MWUDictionary> arrayList, MWUParsingStream mWUParsingStream, String string) throws DLTException {
        this(arrayList, mWUParsingStream, new ULocale(string));
    }

    private void checkLocale(ULocale uLocale) {
        if (UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.GERMAN) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.DUTCH) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.BOKMAL) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.NYNORSK) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.SWEDISH) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.DANISH) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.FINNISH) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.KOREAN) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.AFRIKAANS) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.HEBREW) || UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.HEBREW_FORMER)) {
            this.lookupEntireCompoundOnly = true;
        }
    }

    public void setSpanFlag(int n) {
        this.mwSpanFlag = n;
    }

    public void setMWOutputStyle(int n) {
        this.mwOutputStyle = n;
    }

    @Override
    public void addToFork() {
        if (this.compoundGroupOpened > 0) {
            this.ignoreForkedDecomp = true;
        }
        if (this.mwOutputStyle == 1 || this.parsingStream instanceof MWUParser) {
            this.parsingStream.addToFork();
        } else if (this.compoundGroupOpened <= 0) {
            this.buffer.add(new AddToForkInfo());
        } else {
            this.compoundGroupInfo.addElement(new AddToForkInfo());
        }
    }

    @Override
    public void close() {
        this.processResults(-1);
        this.processReset();
        this.parsingStream.close();
        for (MWUDictProcessor mWUDictProcessor : this.mwuDictProcessors) {
            mWUDictProcessor.close();
        }
        this.mwuDictProcessors = null;
        this.buffer = null;
        this.compoundGroupInfo = null;
    }

    @Override
    public void closeGroup(int n) {
        this.ignoreForkedDecomp = false;
        boolean bl = false;
        if (this.compoundGroupOpened > 0) {
            --this.compoundGroupOpened;
            bl = true;
            if (this.compoundGroupOpened == 0) {
                this.processEndOfCompound(false);
            }
        }
        if (this.mwOutputStyle == 1) {
            this.parsingStream.closeGroup(n);
        } else if (!bl) {
            this.buffer.add(new CloseGroupInfo(n));
        } else {
            this.compoundGroupInfo.addElement(new CloseGroupInfo(n));
        }
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        if (this.mwSpanFlag == 1 && n3 == 2) {
            this.processResults(n2);
        } else if (this.mwSpanFlag == 1 && n3 == 1) {
            this.processReset();
        } else if (this.mwSpanFlag == 2 && n3 == 1) {
            this.processResults(-1);
            this.processReset();
        }
        if (this.mwOutputStyle == 1) {
            this.parsingStream.createBreakpoint(n, n2, n3);
        } else {
            this.buffer.add(new CreateBreakInfo(n, n2, n3));
        }
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        super.createPunctuation(n, n2, n3, n4);
        if (this.compoundGroupOpened <= 0) {
            this.processEntry(n2, n3);
        }
        if (this.mwOutputStyle == 1) {
            this.parsingStream.createPunctuation(n, n2, n3, n4);
        } else if (this.compoundGroupOpened <= 0) {
            this.buffer.add(new CreatePunctInfo(n, n2, n3, n4));
        } else {
            this.compoundGroupInfo.addElement(new CreatePunctInfo(n, n2, n3, n4));
        }
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        super.createStd(n, n2, n3, glossCollection);
        this.createStdOrUnknown(n2, n3);
        if (this.mwOutputStyle == 1) {
            this.parsingStream.createStd(n, n2, n3, glossCollection);
        } else if (this.compoundGroupOpened <= 0) {
            this.buffer.add(new CreateStdInfo(n, n2, n3, glossCollection));
        } else {
            this.compoundGroupInfo.addElement(new CreateStdInfo(n, n2, n3, glossCollection));
        }
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        super.createUnknown(n, n2, n3, n4);
        this.createStdOrUnknown(n2, n3);
        if (this.mwOutputStyle == 1) {
            this.parsingStream.createUnknown(n, n2, n3, n4);
        } else if (this.compoundGroupOpened <= 0) {
            this.buffer.add(new CreateUnknownInfo(n, n2, n3, n4));
        } else {
            this.compoundGroupInfo.addElement(new CreateUnknownInfo(n, n2, n3, n4));
        }
    }

    private void createStdOrUnknown(int n, int n2) {
        if (this.ignoreForkedDecomp) {
            this.processStdOrUnknown(n, n2);
        } else {
            ArrayList<SimpleWordTokenizer.Token> arrayList = this.tokenize(n, n2);
            if (arrayList != null && arrayList.size() > 1) {
                this.processStdOrUnknown(n, n2, arrayList);
            } else {
                this.processStdOrUnknown(n, n2);
            }
        }
    }

    private void processStdOrUnknown(int n, int n2) {
        if (this.compoundGroupOpened > 0) {
            if (!this.lookupEntireCompoundOnly && !this.ignoreForkedDecomp) {
                this.compoundBoundaries.add(n);
                this.compoundBoundaries.add(n2);
            }
        } else {
            this.processEntry(n, n2);
        }
    }

    private void processStdOrUnknown(int n, int n2, ArrayList<SimpleWordTokenizer.Token> arrayList) {
        if (this.compoundGroupOpened > 0) {
            if (!this.lookupEntireCompoundOnly) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    SimpleWordTokenizer.Token token = arrayList.get(i);
                    this.compoundBoundaries.add(token.getBegin());
                    this.compoundBoundaries.add(token.getEnd());
                }
                this.endOfLastTokenizedWord = n2;
            }
        } else {
            this.compound_group_start = n;
            this.compound_group_end = n2;
            for (int i = 0; i < arrayList.size(); ++i) {
                SimpleWordTokenizer.Token token = arrayList.get(i);
                this.compoundBoundaries.add(token.getBegin());
                this.compoundBoundaries.add(token.getEnd());
            }
            this.endOfLastTokenizedWord = n2;
            this.processEndOfCompound(true);
        }
    }

    @Override
    public void fork() {
        if (this.mwOutputStyle == 1) {
            this.parsingStream.fork();
        } else if (this.compoundGroupOpened <= 0) {
            this.buffer.add(new ForkInfo());
        } else {
            this.compoundGroupInfo.addElement(new ForkInfo());
        }
    }

    @Override
    public void mergeRoutes(int n) {
        if (this.mwOutputStyle == 1) {
            this.parsingStream.mergeRoutes(n);
        } else if (this.compoundGroupOpened <= 0) {
            this.buffer.add(new MergeRoutesInfo(n));
        } else {
            this.compoundGroupInfo.addElement(new MergeRoutesInfo(n));
        }
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.input = uniLexAnalyzer.getSourceText();
        this.compoundGroupOpened = 0;
        this.compound_group_start = -1;
        this.compound_group_end = -1;
        this.ignoreForkedDecomp = false;
        this.compoundGroupInfo = null;
        this.compoundBoundaries.clear();
        for (MWUDictProcessor mWUDictProcessor : this.mwuDictProcessors) {
            mWUDictProcessor.reset(uniLexAnalyzer, this.input);
        }
        this.inputBounded = new BoundedCharacterIterator(this.input, this.input.getBeginIndex(), this.input.getEndIndex());
        this.processReset();
        this.parsingStream.reset(uniLexAnalyzer);
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        if (this.compoundGroupOpened == 0) {
            this.compound_group_start = n;
            this.compound_group_end = n2;
        }
        ++this.compoundGroupOpened;
        if (this.mwOutputStyle == 1) {
            return this.parsingStream.startGroup(n, n2, n3);
        }
        if (this.compoundGroupOpened == 1) {
            this.compoundGroupInfo = new GroupInfo(new StartGroupInfo(n, n2, n3));
            this.buffer.add(this.compoundGroupInfo);
        } else {
            this.compoundGroupInfo.addElement(new StartGroupInfo(n, n2, n3));
        }
        return 0;
    }

    private void processEndOfCompound(boolean bl) {
        int n = this.compoundBoundaries.size();
        if (this.lookupEntireCompoundOnly && !bl) {
            this.processEntry(this.compound_group_start, this.compound_group_end);
        } else {
            int n2 = 0;
            for (int i = 0; i < n; i += 2) {
                int n3 = this.compoundBoundaries.get(i);
                int n4 = 0;
                for (int j = n - 1; j >= i; j -= 2) {
                    this.processEntry(n3, this.compoundBoundaries.get(j), n2, n4);
                    ++n4;
                }
                ++n2;
            }
            for (MWUDictProcessor mWUDictProcessor : this.mwuDictProcessors) {
                mWUDictProcessor.incrementMissesCounter();
            }
        }
        this.compoundBoundaries.clear();
        this.compound_group_start = -1;
        this.compound_group_end = -1;
    }

    @Override
    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        this.parsingStream.createMWU(n, n2, n3, gloss);
    }

    private void processEntry(int n, int n2, int n3, int n4) {
        int n5 = -1;
        for (MWUDictProcessor mWUDictProcessor : this.mwuDictProcessors) {
            int n6 = mWUDictProcessor.processEntry(n, n2, n3, n4);
            if (n5 >= n6) continue;
            n5 = n6;
        }
        if (n5 != -1 && this.endOfLastTokenizedWord <= n5) {
            this.endOfLastTokenizedWord = -1;
        }
    }

    private void processEntry(int n, int n2) {
        this.processEntry(n, n2, 0, 0);
    }

    private void processReset() {
        for (MWUDictProcessor mWUDictProcessor : this.mwuDictProcessors) {
            mWUDictProcessor.processReset();
        }
    }

    private void processResults(int n) {
        boolean bl = false;
        for (MWUDictProcessor mWUDictProcessor : this.mwuDictProcessors) {
            bl |= mWUDictProcessor.processResults(n);
        }
        if (!bl) {
            this.callBufferedFunctions(-1);
            this.endOfLastTokenizedWord = -1;
        }
    }

    private void callBufferedFunctions(int n) {
        boolean bl = false;
        if (this.mwOutputStyle == 4) {
            Collections.sort(this.buffer, byIndexComparator);
            this.findIntersectingMWUs(this.buffer, false);
            Collections.sort(this.buffer, byIndexComparator);
        } else if (this.mwOutputStyle == 2) {
            Collections.sort(this.buffer, longestOnlyComparator);
            this.findIntersectingMWUs(this.buffer, true);
            Collections.sort(this.buffer, byIndexComparator);
            if (this.parsingStream instanceof RepeatedWordsChecker) {
                bl = true;
            }
        } else if (this.mwOutputStyle == 3) {
            Collections.sort(this.buffer, byIndexComparator);
        }
        Iterator<IBufferedInfo> iterator = this.buffer.iterator();
        while (iterator.hasNext()) {
            IBufferedInfo iBufferedInfo = iterator.next();
            if (iBufferedInfo.isMarkedForDeletion()) {
                if (bl) {
                    iBufferedInfo.callDeleted((RepeatedWordsChecker)this.parsingStream);
                }
                iterator.remove();
                continue;
            }
            boolean bl2 = iBufferedInfo.callFunction(this.parsingStream, n);
            if (!bl2) {
                return;
            }
            iterator.remove();
        }
    }

    private void findIntersectingMWUs(List<IBufferedInfo> list, boolean bl) {
        int n = -1;
        int n2 = -1;
        ArrayList<CreateMWUInfo> arrayList = new ArrayList<CreateMWUInfo>();
        block0: for (IBufferedInfo iBufferedInfo : list) {
            int n3;
            if (iBufferedInfo instanceof CreateMWUInfo) {
                CreateMWUInfo createMWUInfo = (CreateMWUInfo)iBufferedInfo;
                if (n == -1) {
                    n = createMWUInfo.begin;
                    n2 = createMWUInfo.end;
                    arrayList.add(createMWUInfo);
                    continue;
                }
                if (createMWUInfo.begin < n2) {
                    n2 = Math.max(createMWUInfo.end, n2);
                    arrayList.add(createMWUInfo);
                    continue;
                }
                this.processIntersectingMWUs(arrayList, n, n2);
                arrayList.clear();
                n = createMWUInfo.begin;
                n2 = createMWUInfo.end;
                arrayList.add(createMWUInfo);
                continue;
            }
            if (!bl || n == -1 || iBufferedInfo instanceof CreateBreakInfo || (n3 = iBufferedInfo.getBegin()) == -1 || n3 >= n2) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                CreateMWUInfo createMWUInfo = arrayList.get(i);
                if (!iBufferedInfo.isCoveredByMWUToken(createMWUInfo)) continue;
                iBufferedInfo.markForDeletion(true);
                continue block0;
            }
        }
        this.processIntersectingMWUs(arrayList, n, n2);
        arrayList.clear();
    }

    private void processIntersectingMWUs(ArrayList<CreateMWUInfo> arrayList, int n, int n2) {
        if (arrayList.size() < 2) {
            return;
        }
        this.removeCoveredMWUs(arrayList);
        for (CreateMWUInfo createMWUInfo : arrayList) {
            createMWUInfo.gloss = ((MWGloss)createMWUInfo.gloss).getCopyWithAdjustedOffsets(createMWUInfo.begin, n);
            createMWUInfo.begin = n;
            createMWUInfo.end = n2;
        }
    }

    private void removeCoveredMWUs(ArrayList<CreateMWUInfo> arrayList) {
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            CreateMWUInfo createMWUInfo = arrayList.get(i);
            if (createMWUInfo.isMarkedForDeletion()) continue;
            for (int j = i + 1; j < arrayList.size(); ++j) {
                CreateMWUInfo createMWUInfo2 = arrayList.get(j);
                if (createMWUInfo2.isMarkedForDeletion()) continue;
                CreateMWUInfo.Intersection intersection = createMWUInfo.covers(createMWUInfo2);
                if (intersection == CreateMWUInfo.Intersection.COVERS) {
                    createMWUInfo2.markForDeletion(true);
                    continue;
                }
                if (intersection != CreateMWUInfo.Intersection.IS_COVERED) continue;
                createMWUInfo.markForDeletion(true);
                continue block0;
            }
        }
    }

    private ArrayList<SimpleWordTokenizer.Token> tokenize(int n, int n2) {
        try {
            int n3 = this.input.getIndex();
            this.inputBounded.setBoundaries(n, n2);
            ArrayList<SimpleWordTokenizer.Token> arrayList = this.tokenizer.tokenize(this.inputBounded);
            this.input.setIndex(n3);
            return arrayList;
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
            return null;
        }
    }

    static class LongestOnlyComparator
    implements Comparator<IBufferedInfo> {
        LongestOnlyComparator() {
        }

        @Override
        public int compare(IBufferedInfo iBufferedInfo, IBufferedInfo iBufferedInfo2) {
            int n = iBufferedInfo.getBegin() - iBufferedInfo2.getBegin();
            if (iBufferedInfo instanceof GroupInfo && iBufferedInfo2 instanceof CreateMWUInfo) {
                n = ((GroupInfo)iBufferedInfo).longestOnlyBeginCompare((CreateMWUInfo)iBufferedInfo2);
            } else if (iBufferedInfo2 instanceof GroupInfo && iBufferedInfo instanceof CreateMWUInfo) {
                n = -((GroupInfo)iBufferedInfo2).longestOnlyBeginCompare((CreateMWUInfo)iBufferedInfo);
            }
            if (n == 0) {
                n = iBufferedInfo.getPriority() - iBufferedInfo2.getPriority();
            }
            return n;
        }
    }

    static class ByIndexComparator
    implements Comparator<IBufferedInfo> {
        ByIndexComparator() {
        }

        @Override
        public int compare(IBufferedInfo iBufferedInfo, IBufferedInfo iBufferedInfo2) {
            int n = iBufferedInfo.getBegin() - iBufferedInfo2.getBegin();
            if (n == 0) {
                n = iBufferedInfo.getPriority() - iBufferedInfo2.getPriority();
            }
            return n;
        }
    }

    static final class CreateMWUInfo
    extends BoundedInfo {
        int p;
        Gloss gloss;

        public CreateMWUInfo(int n, int n2, int n3, Gloss gloss) {
            this.p = n;
            this.begin = n2;
            this.end = n3;
            this.gloss = gloss;
        }

        public Intersection covers(CreateMWUInfo createMWUInfo) {
            int[] nArray = ((MWGloss)this.gloss).getStartOffsets();
            int[] nArray2 = ((MWGloss)this.gloss).getEndOffsets();
            MWGloss mWGloss = (MWGloss)createMWUInfo.gloss;
            int[] nArray3 = mWGloss.getStartOffsets();
            int[] nArray4 = mWGloss.getEndOffsets();
            int n = this.begin + nArray[0];
            int n2 = createMWUInfo.begin + nArray3[0];
            int n3 = this.begin + nArray2[nArray2.length - 1];
            int n4 = createMWUInfo.begin + nArray4[nArray4.length - 1];
            if (n2 >= n && n4 <= n3 || n >= n2 && n3 <= n4) {
                Set<Utils.HashableIntPair> set;
                Set<Utils.HashableIntPair> set2 = CreateMWUInfo.buildSet(this.begin, (MWGloss)this.gloss);
                if (((Object)set2).equals(set = CreateMWUInfo.buildSet(createMWUInfo.begin, mWGloss))) {
                    return Intersection.EQUAL;
                }
                if (set2.containsAll(set)) {
                    return Intersection.COVERS;
                }
                if (set.containsAll(set2)) {
                    return Intersection.IS_COVERED;
                }
            }
            return Intersection.NOT_COVERED;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            if (parsingStream instanceof MWUParsingStream) {
                if (n != -1 && this.end > n) {
                    return false;
                }
                ((MWUParsingStream)parsingStream).createMWU(this.p, this.begin, this.end, this.gloss);
                return true;
            }
            return true;
        }

        public Gloss getGloss() {
            return this.gloss;
        }

        private static Set<Utils.HashableIntPair> buildSet(int n, MWGloss mWGloss) {
            HashSet<Utils.HashableIntPair> hashSet = new HashSet<Utils.HashableIntPair>();
            int[] nArray = mWGloss.getStartOffsets();
            int[] nArray2 = mWGloss.getEndOffsets();
            for (int i = 0; i < nArray.length; ++i) {
                Utils.HashableIntPair hashableIntPair = new Utils.HashableIntPair(n + nArray[i], n + nArray2[i]);
                hashSet.add(hashableIntPair);
            }
            return hashSet;
        }

        @Override
        public int getPriority() {
            return 1;
        }

        public static enum Intersection {
            NOT_COVERED,
            IS_COVERED,
            COVERS,
            EQUAL;

        }
    }

    public static final class MergeRoutesInfo
    extends BufferedInfo {
        int num_routes;

        public MergeRoutesInfo(int n) {
            this.num_routes = n;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            parsingStream.mergeRoutes(this.num_routes);
            return true;
        }

        @Override
        public int getBegin() {
            return -1;
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }

    public static final class AddToForkInfo
    extends BufferedInfo {
        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            parsingStream.addToFork();
            return true;
        }

        @Override
        public int getBegin() {
            return -1;
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }

    public static final class ForkInfo
    extends BufferedInfo {
        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            parsingStream.fork();
            return true;
        }

        @Override
        public int getBegin() {
            return -1;
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }

    public static final class CloseGroupInfo
    extends BufferedInfo {
        int decompGroupN;

        public CloseGroupInfo(int n) {
            this.decompGroupN = n;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            parsingStream.closeGroup(this.decompGroupN);
            return true;
        }

        @Override
        public int getBegin() {
            return -1;
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }

    public static final class StartGroupInfo
    extends BoundedInfo {
        int type;

        public StartGroupInfo(int n, int n2, int n3) {
            this.begin = n;
            this.end = n2;
            this.type = n3;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            if (n != -1 && this.end > n) {
                return false;
            }
            parsingStream.startGroup(this.begin, this.end, this.type);
            return true;
        }
    }

    static final class CreateBreakInfo
    extends BufferedInfo {
        int p;
        int pos;
        int bType;

        public CreateBreakInfo(int n, int n2, int n3) {
            this.p = n;
            this.pos = n2;
            this.bType = n3;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            parsingStream.createBreakpoint(this.p, this.pos, this.bType);
            return true;
        }

        @Override
        public int getBegin() {
            return this.pos;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    static final class CreatePunctInfo
    extends TokenInfo {
        int p;
        int flags;

        public CreatePunctInfo(int n, int n2, int n3, int n4) {
            this.p = n;
            this.begin = n2;
            this.end = n3;
            this.flags = n4;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            if (n != -1 && this.end > n) {
                return false;
            }
            parsingStream.createPunctuation(this.p, this.begin, this.end, this.flags);
            return true;
        }
    }

    public static final class CreateUnknownInfo
    extends TokenInfo {
        int p;
        int wclass;

        public CreateUnknownInfo(int n, int n2, int n3, int n4) {
            this.p = n;
            this.begin = n2;
            this.end = n3;
            this.wclass = n4;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            if (n != -1 && this.end > n) {
                return false;
            }
            parsingStream.createUnknown(this.p, this.begin, this.end, this.wclass);
            return true;
        }

        @Override
        public void callDeleted(RepeatedWordsChecker repeatedWordsChecker) {
            repeatedWordsChecker.createDeletedToken(this.begin, this.end);
        }
    }

    public static final class CreateStdInfo
    extends TokenInfo {
        int p;
        GlossCollection gc;

        public CreateStdInfo(int n, int n2, int n3, GlossCollection glossCollection) {
            this.p = n;
            this.begin = n2;
            this.end = n3;
            this.gc = glossCollection;
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            if (n != -1 && this.end > n) {
                return false;
            }
            parsingStream.createStd(this.p, this.begin, this.end, this.gc);
            return true;
        }

        @Override
        public void callDeleted(RepeatedWordsChecker repeatedWordsChecker) {
            repeatedWordsChecker.createDeletedToken(this.begin, this.end);
        }
    }

    static abstract class TokenInfo
    extends BoundedInfo {
        TokenInfo() {
        }

        @Override
        public boolean isCoveredByMWUToken(CreateMWUInfo createMWUInfo) {
            int n = -1;
            int n2 = -1;
            MWGloss mWGloss = (MWGloss)createMWUInfo.gloss;
            int[] nArray = mWGloss.getStartOffsets();
            int[] nArray2 = mWGloss.getEndOffsets();
            if (this.begin < createMWUInfo.begin + nArray[0] || this.end > createMWUInfo.begin + nArray2[nArray2.length - 1]) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i] + createMWUInfo.begin;
                if (n3 != n2) {
                    n = n3;
                }
                n2 = nArray2[i] + createMWUInfo.begin;
                if (this.begin < n || this.end > n2) continue;
                return true;
            }
            return false;
        }

        @Override
        public int checkBoundaryBegin(int n) {
            if (n >= this.begin && n < this.end) {
                return this.begin;
            }
            return -1;
        }

        @Override
        public int checkBoundaryEnd(int n) {
            if (n <= this.end && n > this.begin) {
                return this.end;
            }
            return -1;
        }
    }

    public static final class GroupInfo
    extends BoundedInfo {
        private final List<IBufferedInfo> elements = new LinkedList<IBufferedInfo>();

        public GroupInfo(StartGroupInfo startGroupInfo) {
            this.begin = startGroupInfo.begin;
            this.end = startGroupInfo.end;
            this.elements.add(startGroupInfo);
        }

        public void addElement(IBufferedInfo iBufferedInfo) {
            this.elements.add(iBufferedInfo);
        }

        @Override
        public boolean callFunction(ParsingStream parsingStream, int n) {
            Iterator<IBufferedInfo> iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                IBufferedInfo iBufferedInfo = iterator.next();
                if (iBufferedInfo.isMarkedForDeletion()) continue;
                boolean bl = iBufferedInfo.callFunction(parsingStream, n);
                if (!bl) {
                    return false;
                }
                iterator.remove();
            }
            return true;
        }

        @Override
        public void callDeleted(RepeatedWordsChecker repeatedWordsChecker) {
            repeatedWordsChecker.createDeletedToken(this.begin, this.end);
        }

        @Override
        public boolean isCoveredByMWUToken(CreateMWUInfo createMWUInfo) {
            int n = 0;
            int n2 = -1;
            boolean bl = false;
            boolean bl2 = false;
            for (IBufferedInfo iBufferedInfo : this.elements) {
                if (iBufferedInfo instanceof TokenInfo) {
                    if (iBufferedInfo.isCoveredByMWUToken(createMWUInfo)) {
                        bl = true;
                        iBufferedInfo.markForDeletion(true);
                    } else {
                        bl2 = true;
                    }
                } else if (n2 < 0 && iBufferedInfo instanceof AddToForkInfo) {
                    n2 = n;
                    break;
                }
                ++n;
            }
            if (bl) {
                n = 0;
                for (IBufferedInfo iBufferedInfo : this.elements) {
                    if (iBufferedInfo instanceof TokenInfo) {
                        if (n2 != -1 && n > n2) {
                            iBufferedInfo.markForDeletion(true);
                        }
                    } else {
                        iBufferedInfo.markForDeletion(true);
                    }
                    ++n;
                }
            }
            return !bl2;
        }

        public int longestOnlyBeginCompare(CreateMWUInfo createMWUInfo) {
            if (createMWUInfo.begin <= this.begin) {
                return 1;
            }
            if (createMWUInfo.begin > this.begin && createMWUInfo.begin < this.end) {
                return 1;
            }
            return -1;
        }

        @Override
        public int checkBoundaryBegin(int n) {
            for (IBufferedInfo iBufferedInfo : this.elements) {
                int n2 = iBufferedInfo.checkBoundaryBegin(n);
                if (n2 == -1) continue;
                return n2;
            }
            return -1;
        }

        @Override
        public int checkBoundaryEnd(int n) {
            for (IBufferedInfo iBufferedInfo : this.elements) {
                int n2 = iBufferedInfo.checkBoundaryEnd(n);
                if (n2 == -1) continue;
                return n2;
            }
            return -1;
        }
    }

    static abstract class BoundedInfo
    extends BufferedInfo {
        protected int begin;
        protected int end;

        BoundedInfo() {
        }

        @Override
        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }

    static abstract class BufferedInfo
    implements IBufferedInfo {
        protected static final int PRIORITY_BREAK = 0;
        protected static final int PRIORITY_MWU = 1;
        protected static final int PRIORITY_OTHER = 2;
        private boolean markedForDeletion = false;

        BufferedInfo() {
        }

        @Override
        public void markForDeletion(boolean bl) {
            this.markedForDeletion = bl;
        }

        @Override
        public boolean isMarkedForDeletion() {
            return this.markedForDeletion;
        }

        @Override
        public boolean isCoveredByMWUToken(CreateMWUInfo createMWUInfo) {
            return false;
        }

        @Override
        public int checkBoundaryBegin(int n) {
            return -1;
        }

        @Override
        public int checkBoundaryEnd(int n) {
            return -1;
        }

        @Override
        public void callDeleted(RepeatedWordsChecker repeatedWordsChecker) {
            repeatedWordsChecker.createDeletedBreak();
        }
    }

    public static interface IBufferedInfo {
        public int getBegin();

        public boolean callFunction(ParsingStream var1, int var2);

        public void callDeleted(RepeatedWordsChecker var1);

        public int getPriority();

        public void markForDeletion(boolean var1);

        public boolean isMarkedForDeletion();

        public boolean isCoveredByMWUToken(CreateMWUInfo var1);

        public int checkBoundaryBegin(int var1);

        public int checkBoundaryEnd(int var1);
    }
}

