/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.gloss.CaseGloss;
import java.text.CharacterIterator;

public class MatchBuffer {
    public int[] index;
    public GlossCollection[] gloss;
    public int[] cases;
    int[] savedPositions;
    int savedIndex;
    public int mpos;
    int maxIndex;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public int getNumMatches() {
        return this.savedIndex;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void setMaxIndex(int n) {
        this.maxIndex = n;
    }

    public MatchBuffer() {
        this.init(16);
    }

    public MatchBuffer(int n) {
        this.init(n);
    }

    protected void init(int n) {
        this.savedPositions = new int[16];
        this.index = new int[n];
        this.gloss = new GlossCollection[n];
        this.cases = new int[n];
        this.mpos = 0;
        this.maxIndex = 0;
        this.savedIndex = 0;
    }

    public final int grow() {
        int[] nArray = new int[this.index.length * 2];
        int[] nArray2 = new int[this.index.length * 2];
        GlossCollection[] glossCollectionArray = new GlossCollection[this.index.length * 2];
        int n = this.index.length;
        System.arraycopy(this.index, 0, nArray, 0, n);
        System.arraycopy(this.gloss, 0, glossCollectionArray, 0, n);
        System.arraycopy(this.cases, 0, nArray2, 0, n);
        this.index = nArray;
        this.gloss = glossCollectionArray;
        this.cases = nArray2;
        return this.index.length;
    }

    public final void clear() {
        this.maxIndex = 0;
        this.savedIndex = 0;
        this.mpos = 0;
        this.gloss[0] = null;
    }

    public void add(int n, GlossCollection glossCollection) {
        this.add(n, glossCollection, -1);
    }

    public void add(int n, GlossCollection glossCollection, int n2) {
        if (this.mpos >= this.index.length) {
            this.grow();
        }
        this.index[this.mpos] = n;
        this.gloss[this.mpos] = glossCollection;
        this.cases[this.mpos] = n2;
        this.maxIndex = Math.max(this.maxIndex, n);
        ++this.mpos;
    }

    public void addReversed(int n, GlossCollection glossCollection) {
        this.addReversed(n, glossCollection, -1);
    }

    public void addReversed(int n, GlossCollection glossCollection, int n2) {
        if (this.mpos >= this.index.length) {
            this.grow();
        }
        this.index[this.mpos] = n;
        this.gloss[this.mpos] = glossCollection;
        this.cases[this.mpos] = n2;
        this.maxIndex = Math.min(this.maxIndex, n);
        ++this.mpos;
    }

    public boolean addMax(int n, GlossCollection glossCollection) {
        return this.addMax(n, glossCollection, -1);
    }

    public boolean addMax(int n, GlossCollection glossCollection, int n2) {
        if (n >= this.maxIndex) {
            if (n > this.maxIndex) {
                this.savedIndex = 0;
                this.mpos = 0;
                this.maxIndex = n;
            }
            if (this.mpos >= this.index.length) {
                this.grow();
            }
            this.index[this.mpos] = n;
            this.gloss[this.mpos] = glossCollection;
            this.cases[this.mpos] = n2;
            ++this.mpos;
            return true;
        }
        return false;
    }

    public boolean addMin(int n, GlossCollection glossCollection) {
        return this.addMin(n, glossCollection, -1);
    }

    public boolean addMin(int n, GlossCollection glossCollection, int n2) {
        if (n <= this.maxIndex) {
            if (n < this.maxIndex) {
                this.savedIndex = 0;
                this.mpos = 0;
                this.maxIndex = n;
            }
            if (this.mpos >= this.index.length) {
                this.grow();
            }
            this.index[this.mpos] = n;
            this.gloss[this.mpos] = glossCollection;
            this.cases[this.mpos] = n2;
            ++this.mpos;
            return true;
        }
        return false;
    }

    public void removeRange(int n, int n2) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(this.index, n2, this.index, n, this.mpos - n2);
        System.arraycopy(this.gloss, n2, this.gloss, n, this.mpos - n2);
        System.arraycopy(this.cases, n2, this.cases, n, this.mpos - n2);
        this.mpos -= n2 - n;
        assert (this.verify());
    }

    public void pushMatch() {
        ++this.savedIndex;
        if (this.savedIndex >= this.savedPositions.length) {
            int[] nArray = new int[this.savedPositions.length * 2];
            System.arraycopy(this.savedPositions, 0, nArray, 0, this.savedPositions.length);
            this.savedPositions = nArray;
        }
        this.savedPositions[this.savedIndex] = this.mpos;
        assert (this.verify());
    }

    public void prepend(int n, int n2) {
        int n3 = n2 - n;
        assert (n2 <= this.mpos);
        assert (n3 >= 0);
        if (n3 > 0) {
            if (this.mpos + n3 >= this.index.length) {
                this.grow();
            }
            System.arraycopy(this.index, n, this.index, this.mpos, n3);
            System.arraycopy(this.gloss, n, this.gloss, this.mpos, n3);
            System.arraycopy(this.cases, n, this.cases, this.mpos, n3);
            this.mpos += n3;
        }
        assert (this.verify());
    }

    public void popMatch() {
        assert (this.savedPositions[0] == 0);
        if (this.savedIndex > 0) {
            --this.savedIndex;
        } else {
            this.mpos = 0;
        }
        assert (this.verify());
    }

    public int matchLength() {
        return this.savedIndex == 0 ? this.mpos : this.mpos - this.savedPositions[this.savedIndex];
    }

    public int getMatchStart(int n) {
        assert (n >= 0 && n <= this.savedIndex);
        return this.savedPositions[n];
    }

    public int getMatchEnd(int n) {
        assert (n >= 0);
        return n < this.savedIndex ? this.savedPositions[n + 1] : this.mpos;
    }

    public void removeMatch(int n) {
        assert (n >= 0 && n < this.savedIndex);
        int n2 = this.getMatchStart(n);
        int n3 = this.getMatchEnd(n);
        int n4 = n3 - n2;
        System.arraycopy(this.index, n3, this.index, n2, this.mpos - n3);
        System.arraycopy(this.gloss, n3, this.gloss, n2, this.mpos - n3);
        System.arraycopy(this.cases, n3, this.cases, n2, this.mpos - n3);
        for (int i = n + 1; i < this.savedIndex; ++i) {
            this.savedPositions[i] = this.savedPositions[i + 1] - n4;
        }
        if (this.savedIndex > 0) {
            --this.savedIndex;
        }
        this.mpos -= n3 - n2;
        assert (this.verify());
    }

    int filterByStringCase(int n, int n2, int n3, CharacterIterator characterIterator, int n4) {
        int n5;
        int n6 = n;
        int n7 = n;
        for (n5 = 0; n5 < this.savedIndex && this.savedPositions[n5] < n7; ++n5) {
        }
        while (n7 < this.mpos) {
            if (n5 < this.savedIndex && this.savedPositions[n5] == n7) {
                this.savedPositions[n5++] = n6;
            }
            int n8 = this.index[n7];
            int n9 = this.cases[n7] == -1 ? CaseGloss.CaseExtractor.getSubStringCase(characterIterator, n4, n8) : this.cases[n7];
            GlossCollection glossCollection = this.gloss[n7].filterByCase(n9 = CaseGloss.applyMethod(n9, n3), n2, characterIterator, n4, n8);
            if (glossCollection != null) {
                this.gloss[n6] = glossCollection;
                this.index[n6] = n8;
                this.cases[n6] = n9;
                ++n6;
            }
            ++n7;
        }
        this.mpos = n6;
        assert (this.verify());
        return this.mpos - n;
    }

    private boolean verify() {
        return true;
    }

    void getCases(int n, CharacterIterator characterIterator) {
        int n2 = 1;
        char c = characterIterator.current();
        for (int i = n; i < this.mpos; ++i) {
            while (characterIterator.getIndex() < this.index[i]) {
                n2 = CaseGloss.CaseExtractor.takeStep(n2, c);
                c = characterIterator.next();
            }
            this.cases[i] = CaseGloss.CaseExtractor.getCaseMask(n2);
        }
    }

    public GlossCollection collectMaxGlosses(boolean bl) {
        if (this.mpos == 0) {
            return null;
        }
        if (this.mpos == 1 || bl || this.index[this.mpos - 2] != this.maxIndex) {
            return this.gloss[this.mpos - 1];
        }
        GlossCollection glossCollection = new GlossCollection(this.gloss[this.mpos - 1]);
        for (int i = this.mpos - 2; i >= 0 && this.index[i] == this.maxIndex; --i) {
            glossCollection.addAll(this.gloss[i]);
        }
        return glossCollection;
    }
}

