/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.GlossReader;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.Net;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.WritableNode;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInput;
import java.io.IOException;
import java.text.CharacterIterator;

public class MultiNetImpl
extends Net
implements MultiNet {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public int getFileFSTFormat() {
        return 1;
    }

    @Override
    void processNew(Node node, Object object) throws DLTException {
        GlossCollection glossCollection = new GlossCollection();
        glossCollection.add((Gloss)object);
        ((WritableNode)node).setGloss(glossCollection);
    }

    @Override
    void processExisting(Node node, Object object) throws DLTException {
        GlossCollection glossCollection = node.getGloss();
        if (!(glossCollection instanceof GlossCollection) || !(object instanceof Gloss)) {
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        glossCollection.add((Gloss)object);
    }

    @Override
    public long readContents(DataInput dataInput, int n) throws DLTException, IOException {
        int n2;
        if (dataInput.readInt() != -1161904401) {
            throw new DLTException(Messages.getString("error.dict.signature"));
        }
        dataInput.readInt();
        int n3 = dataInput.readInt();
        SimpleGlossReader simpleGlossReader = new SimpleGlossReader(n3);
        super.read_contents(dataInput, simpleGlossReader);
        int n4 = dataInput.readInt();
        int n5 = 0;
        for (int i = n4; i != 0; i -= n2) {
            int n6;
            n2 = 0;
            GlossCollection glossCollection = new GlossCollection();
            while ((n6 = dataInput.readInt()) != -1) {
                MapperGloss mapperGloss = new MapperGloss(n6);
                glossCollection.add(mapperGloss, this.ownerDictionary);
                ++n2;
            }
            simpleGlossReader.map[n5++] = glossCollection;
        }
        n2 = dataInput.readInt();
        if (n2 != -84230466) {
            throw new DLTException(Messages.getString("error.marker"));
        }
        this.processGlosses(simpleGlossReader);
        simpleGlossReader.map = null;
        return n4;
    }

    @Override
    public void removeGloss(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        int n2 = characterIterator.getIndex();
        GlossCollection glossCollection = this.get(characterIterator, n);
        if (gloss != null) {
            glossCollection.remove(gloss);
        }
        if (gloss == null || glossCollection.isEmpty()) {
            characterIterator.setIndex(n2);
            this.remove(characterIterator, n);
        }
    }

    @Override
    public void contract() throws DLTException {
        throw new DLTException(Messages.getString("notimplement.method"));
    }

    @Override
    public WritableNode newNode(int n, int n2) throws DLTException {
        throw new DLTException(Messages.getString("notimplement.method"));
    }

    @Override
    public void setFirstNode(Node node) {
        this.first = node;
    }

    @Override
    public void startBuild(boolean bl) {
    }

    @Override
    public int endBuild() {
        return 0;
    }

    @Override
    public MultiNet getMultiNet() {
        return this;
    }

    private static class SimpleGlossReader
    extends GlossReader
    implements GlossProcessor {
        Object[] map;

        SimpleGlossReader(int n) {
            this.map = new Object[n > 0 ? n : 0];
        }

        @Override
        public final Object process(Object object) {
            if (object != null && object instanceof MapperGloss) {
                return this.map[((MapperGloss)object).map];
            }
            return object;
        }

        @Override
        public Object recalc(long l) throws DLTException {
            if (l == -1L) {
                return null;
            }
            int n = SimpleGlossReader.decode_ordinal((int)l);
            return this.map[n] == null ? new MapperGloss(n) : this.map[n];
        }

        @Override
        public final void reset() {
        }
    }
}

