/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.GlossCollectionHandler;
import com.ibm.dltj.fst._NetIntegerImpl;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.util.GlossUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MultiNetIntegerImpl
extends _NetIntegerImpl {
    GlossCollectionHandler gloss_handler = new GlossCollectionHandler(null);

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public void endReading() {
        super.endReading();
        this.gloss_handler.endReading();
    }

    public int getGlossCollectionCount() {
        return this.gloss_handler.getGlossCollectionCount();
    }

    @Override
    public void processGlosses(GlossProcessor glossProcessor) throws DLTException {
        this.gloss_handler.processGlosses(glossProcessor);
    }

    @Override
    protected int readGlosses(DataInput dataInput) throws IOException, DLTException {
        return this.gloss_handler.readGlosses(dataInput);
    }

    public void writeGlossCollections(DataOutput dataOutput, GlossMapper glossMapper) throws DLTException, IOException {
        this.gloss_handler.writeGlossCollections(dataOutput, glossMapper);
        dataOutput.writeInt(-84230466);
    }

    @Override
    public void startBuild(boolean bl) {
        this.gloss_handler.startBuild(bl);
    }

    @Override
    public int endBuild() {
        return this.gloss_handler.endBuild();
    }

    @Override
    int addGloss(Object object) throws DLTException {
        return this.gloss_handler.addGloss(GlossUtils.toGlossCollection(object));
    }

    @Override
    void removeGloss(int n) {
        this.gloss_handler.dereference(n);
    }

    @Override
    boolean processRemove(int n, Object object) throws DLTException {
        if (!(object instanceof Gloss)) {
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        int n2 = this.getGlossIdx(n);
        int n3 = this.gloss_handler.processRemove(n2, (Gloss)object);
        if (n3 != n2) {
            this.setGlossIdx(n, n3);
        }
        return n3 != n2;
    }

    @Override
    void processNew(int n, Object object) throws DLTException {
        this.setGlossIdx(n, this.gloss_handler.processNew(object));
    }

    @Override
    void processExisting(int n, Object object) throws DLTException {
        if (!(object instanceof Gloss)) {
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        int n2 = this.getGlossIdx(n);
        int n3 = this.gloss_handler.processExisting(n2, (Gloss)object);
        this.setGlossIdx(n, n3);
    }

    @Override
    GlossCollection getGlossByIdx(int n) {
        return this.gloss_handler.getGlossByIdx(n);
    }

    @Override
    GlossCollection getGlossForNode(int n) {
        return this.gloss_handler.getGlossByIdx(this.getGlossIdx(n));
    }

    @Override
    boolean glossesEqual(int n, int n2) {
        if (n == n2) {
            return true;
        }
        GlossCollection glossCollection = this.getGlossByIdx(n);
        GlossCollection glossCollection2 = this.getGlossByIdx(n2);
        return glossCollection.equals(glossCollection2);
    }

    @Override
    int glossHash(int n) {
        return this.getGlossByIdx(n).hashCode();
    }

    @Override
    public void setOwnerDictionary(Dictionary dictionary) {
        this.gloss_handler.setOwnerDictionary(dictionary);
        super.setOwnerDictionary(dictionary);
    }
}

