/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.fst.MWUParser;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.MWGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.util.BoundedCharacterIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NTAParser
implements MWUParsingStream {
    private final Dictionary[] nta_dicts;
    private final ParsingStream parsingStream;
    private CharacterIterator input;
    private BoundedCharacterIterator inputBounded;
    private int mwSpanFlag = 1;
    private ArrayList<MWUParser.IBufferedInfo> buffer = new ArrayList();
    private List<MWUParser.IBufferedInfo> tokens_buffer = new ArrayList<MWUParser.IBufferedInfo>();
    private int outputStyle = 256;
    private boolean longestOnlyMWU = false;
    private boolean isFirstComponent = false;
    UniLexAnalyzer lexAnalyzer = null;
    private final boolean checkMWUs;
    private final ArrayList<ComparableIntPair> indices = new ArrayList();
    private final MatchBuffer break_matches = new MatchBuffer();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public NTAParser(Dictionary[] dictionaryArray, ParsingStream parsingStream, int n, boolean bl) {
        if ((n & 0x80) != 0) {
            this.outputStyle = 128;
        } else if ((n & 0x100) != 0) {
            this.outputStyle = 256;
        }
        this.longestOnlyMWU = bl;
        this.nta_dicts = dictionaryArray;
        this.checkMWUs = parsingStream instanceof MWUParsingStream;
        this.parsingStream = parsingStream;
    }

    @Override
    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        if (this.longestOnlyMWU && gloss instanceof MWGloss) {
            int[] nArray = ((MWGloss)gloss).getStartOffsets();
            int[] nArray2 = ((MWGloss)gloss).getEndOffsets();
            int n4 = nArray.length;
            for (int i = 0; i < n4; ++i) {
                this.processToken(n2 + nArray[i], n2 + nArray2[i]);
            }
        }
        this.tokens_buffer.add(new MWUParser.CreateMWUInfo(1, n2, n3, gloss));
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        if (!this.isFirstComponent || !UniLexAnalyzer.isSameLanguage(this.lexAnalyzer.getLocale(), UniLexAnalyzerConstants.JAPANESE) && !UniLexAnalyzer.isSameLanguage(this.lexAnalyzer.getLocale(), UniLexAnalyzerConstants.CHINESE)) {
            this.processToken(n2, n3);
        }
        if (!this.checkMWUs) {
            this.parsingStream.createUnknown(n, n2, n3, n4);
        } else {
            this.tokens_buffer.add(new MWUParser.CreateUnknownInfo(n, n2, n3, n4));
        }
    }

    @Override
    public void addToFork() {
        if (!this.checkMWUs) {
            this.parsingStream.addToFork();
        } else {
            this.tokens_buffer.add(new MWUParser.AddToForkInfo());
        }
        this.isFirstComponent = false;
    }

    @Override
    public void close() {
        this.processEndOfSpan();
        this.parsingStream.close();
        this.buffer = null;
        this.tokens_buffer = null;
        this.lexAnalyzer = null;
    }

    @Override
    public void closeGroup(int n) {
        if (!this.checkMWUs) {
            this.parsingStream.closeGroup(n);
        } else {
            this.tokens_buffer.add(new MWUParser.CloseGroupInfo(n));
        }
        this.isFirstComponent = false;
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        if (this.mwSpanFlag == 1 && n3 == 2) {
            this.processEndOfSpan();
        } else if (this.mwSpanFlag == 2 && n3 == 1) {
            this.processEndOfSpan();
        }
        if (!this.checkMWUs) {
            this.parsingStream.createBreakpoint(n, n2, n3);
        } else {
            this.tokens_buffer.add(new MWUParser.CreateBreakInfo(n, n2, n3));
        }
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.processToken(n2, n3);
        if (!this.checkMWUs) {
            this.parsingStream.createPunctuation(n, n2, n3, n4);
        } else {
            this.tokens_buffer.add(new MWUParser.CreatePunctInfo(n, n2, n3, n4));
        }
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        this.processToken(n2, n3);
        if (!this.checkMWUs) {
            this.parsingStream.createStd(n, n2, n3, glossCollection);
        } else {
            this.tokens_buffer.add(new MWUParser.CreateStdInfo(n, n2, n3, glossCollection));
        }
    }

    @Override
    public void fork() {
        if (!this.checkMWUs) {
            this.parsingStream.fork();
        } else {
            this.tokens_buffer.add(new MWUParser.ForkInfo());
        }
        this.isFirstComponent = true;
    }

    @Override
    public void mergeRoutes(int n) {
        if (!this.checkMWUs) {
            this.parsingStream.mergeRoutes(n);
        } else {
            this.tokens_buffer.add(new MWUParser.MergeRoutesInfo(n));
        }
        this.isFirstComponent = false;
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.input = uniLexAnalyzer.getSourceText();
        this.lexAnalyzer = uniLexAnalyzer;
        this.inputBounded = new BoundedCharacterIterator(this.input, this.input.getBeginIndex(), this.input.getEndIndex());
        this.parsingStream.reset(uniLexAnalyzer);
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        if (!this.checkMWUs) {
            return this.parsingStream.startGroup(n, n2, n3);
        }
        this.tokens_buffer.add(new MWUParser.StartGroupInfo(n, n2, n3));
        return 0;
    }

    public void setSpanFlag(int n) {
        this.mwSpanFlag = n;
    }

    private void processToken(int n, int n2) {
        if (!this.checkMWUs) {
            this.lookUpToken(n, n2, this.lexAnalyzer.getCaseHandlingMethod(), this.lexAnalyzer.getCasePromotion());
        } else {
            this.indices.add(new ComparableIntPair(n, n2));
        }
    }

    private void processEndOfSpan() {
        if (this.checkMWUs) {
            if (this.longestOnlyMWU) {
                Collections.sort(this.indices);
            }
            this.lookUp(this.lexAnalyzer.getCaseHandlingMethod(), this.lexAnalyzer.getCasePromotion());
            this.indices.clear();
            this.callBufferedFunctions();
        }
    }

    private void lookUpToken(int n, int n2, int n3, int n4) {
        for (Dictionary dictionary : this.nta_dicts) {
            this.inputBounded.setBoundaries(n, n2);
            this.break_matches.clear();
            int n5 = this.inputBounded.getIndex();
            dictionary.lookupLongest(this.inputBounded, this.break_matches, n3, n4);
            if (this.break_matches.mpos == 0) {
                return;
            }
            int n6 = this.break_matches.index[0];
            if (n6 != n2) {
                return;
            }
            this.parsingStream.createStd(65535, n5, n6, this.break_matches.gloss[0]);
        }
    }

    private void lookUp(int n, int n2) {
        if (this.indices == null || this.indices.size() == 0) {
            return;
        }
        block0: for (int i = 0; i < this.nta_dicts.length; ++i) {
            int n3 = 0;
            int n4 = this.indices.get(0).getStart();
            int n5 = this.indices.get(this.indices.size() - 1).getEnd();
            int n6 = n4;
            while (n6 < n5) {
                this.inputBounded.setBoundaries(n6, n5);
                this.break_matches.clear();
                this.nta_dicts[i].traverse(this.inputBounded, this.break_matches, n, n2);
                if (this.break_matches.mpos == 0) {
                    if (n3 == this.indices.size() - 1) continue block0;
                    n6 = this.indices.get(++n3).getStart();
                    continue;
                }
                boolean bl = false;
                block2: for (int j = this.break_matches.mpos - 1; j >= 0; --j) {
                    for (int k = n3; k < this.indices.size(); ++k) {
                        if (this.break_matches.index[j] == this.indices.get(k).getEnd()) {
                            if (this.outputStyle == 256) {
                                this.addEntryToBuffer_not_removing(n6, this.break_matches.index[j], this.break_matches.gloss[j], k - n3 > 0);
                            } else {
                                this.addEntryToBuffer(n6, this.break_matches.index[j], this.break_matches.gloss[j], k - n3 > 0);
                            }
                            if (k >= this.indices.size() - 1) continue block0;
                            n3 = k + 1;
                            n6 = this.indices.get(n3).getStart();
                            bl = true;
                            break block2;
                        }
                        if (this.break_matches.index[j] < this.indices.get(k).getEnd()) continue block2;
                    }
                }
                if (bl) continue;
                if (n3 >= this.indices.size() - 1) continue block0;
                n6 = this.indices.get(++n3).getStart();
            }
        }
    }

    private void addEntryToBuffer_not_removing(int n, int n2, GlossCollection glossCollection, boolean bl) {
        if (bl) {
            for (Gloss gloss : glossCollection) {
                this.addIBufferedInfo_not_removing(new MWUParser.CreateMWUInfo(1, n, n2, gloss), n, n2);
            }
        } else {
            this.addIBufferedInfo_not_removing(new MWUParser.CreateStdInfo(65535, n, n2, glossCollection), n, n2);
        }
    }

    private void addEntryToBuffer(int n, int n2, GlossCollection glossCollection, boolean bl) {
        if (bl) {
            for (Gloss gloss : glossCollection) {
                this.addIBufferedInfo(new MWUParser.CreateMWUInfo(1, n, n2, gloss), n, n2);
            }
        } else {
            this.addIBufferedInfo(new MWUParser.CreateStdInfo(65535, n, n2, glossCollection), n, n2);
        }
    }

    private void addIBufferedInfo(MWUParser.IBufferedInfo iBufferedInfo, int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.buffer.size(); ++i) {
            MWUParser.IBufferedInfo iBufferedInfo2 = this.buffer.get(i);
            int n3 = ((MWUParser.BoundedInfo)iBufferedInfo2).getBegin();
            int n4 = ((MWUParser.BoundedInfo)iBufferedInfo2).getEnd();
            if (n == n3 && n2 == n4) {
                if (bl) continue;
                this.buffer.add(++i, iBufferedInfo);
                bl = true;
                continue;
            }
            if (n <= n3 && n2 >= n4) {
                this.buffer.remove(i);
                if (!bl) {
                    this.buffer.add(i, iBufferedInfo);
                    bl = true;
                }
                --i;
                continue;
            }
            if (n3 <= n && n4 >= n2) {
                bl = true;
                continue;
            }
            if ((n3 > n || n4 <= n) && (n > n3 || n2 <= n3) || bl) continue;
            this.buffer.add(++i, iBufferedInfo);
            bl = true;
        }
        if (!bl) {
            this.buffer.add(iBufferedInfo);
        }
    }

    private void addIBufferedInfo_not_removing(MWUParser.IBufferedInfo iBufferedInfo, int n, int n2) {
        for (int i = 0; i < this.buffer.size(); ++i) {
            MWUParser.IBufferedInfo iBufferedInfo2 = this.buffer.get(i);
            int n3 = ((MWUParser.BoundedInfo)iBufferedInfo2).getBegin();
            int n4 = ((MWUParser.BoundedInfo)iBufferedInfo2).getEnd();
            if (n == n3 && n2 == n4) {
                this.buffer.add(++i, iBufferedInfo);
                return;
            }
            if (n3 <= n && n4 >= n2) {
                this.buffer.add(i, iBufferedInfo);
                return;
            }
            if (n3 <= n && n4 > n || n <= n3 && n2 > n3) {
                this.buffer.add(++i, iBufferedInfo);
                return;
            }
            if (n >= n3 || n2 > n3) continue;
            this.buffer.add(i, iBufferedInfo);
            return;
        }
        this.buffer.add(iBufferedInfo);
    }

    private void callBufferedFunctions() {
        int n = 0;
        int n2 = this.buffer.size();
        int n3 = this.tokens_buffer.size();
        for (int i = 0; i < n2; ++i) {
            MWUParser.IBufferedInfo iBufferedInfo;
            int n4;
            MWUParser.IBufferedInfo iBufferedInfo2 = this.buffer.get(i);
            int n5 = ((MWUParser.BoundedInfo)iBufferedInfo2).getBegin();
            while (n < n3 && ((n4 = (iBufferedInfo = this.tokens_buffer.get(n)).getBegin()) < n5 || iBufferedInfo instanceof MWUParser.CreateBreakInfo)) {
                iBufferedInfo.callFunction(this.parsingStream, -1);
                ++n;
            }
            iBufferedInfo2.callFunction(this.parsingStream, -1);
        }
        while (n < n3) {
            MWUParser.IBufferedInfo iBufferedInfo = this.tokens_buffer.get(n);
            iBufferedInfo.callFunction(this.parsingStream, -1);
            ++n;
        }
        this.buffer.clear();
        this.tokens_buffer.clear();
    }

    static class ComparableIntPair
    implements Comparable<ComparableIntPair> {
        final int start;
        final int end;

        public ComparableIntPair(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int compareTo(ComparableIntPair comparableIntPair) {
            int n = this.start - comparableIntPair.start;
            if (n == 0) {
                n = this.end - comparableIntPair.end;
            }
            return n;
        }
    }
}

