/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.GlossReader;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.NodeBSearch;
import com.ibm.dltj.fst.NodeBaseGloss;
import com.ibm.dltj.fst.NodeChain;
import com.ibm.dltj.fst.NodeEmpty;
import com.ibm.dltj.fst.NodeFork;
import com.ibm.dltj.fst.NodeGloss;
import com.ibm.dltj.fst.NodeLSearch;
import com.ibm.dltj.fst.NodePtrGloss;
import com.ibm.dltj.fst.NodeTable;
import com.ibm.dltj.fst.WritableNode;
import com.ibm.icu.text.Normalizer;
import java.io.DataInput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class Net {
    protected boolean enchain = false;
    protected boolean contracted = false;
    protected Node[] node_pool = null;
    protected Node first = new NodeLSearch(8);
    protected Dictionary ownerDictionary;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public Node first() {
        return this.first;
    }

    final WritableNode instantiate_node(Class<? extends WritableNode> clazz, int n) throws DLTException {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new DLTException(Messages.format("cannot.instantiate", clazz.getName(), exception.getClass().getName(), exception.getMessage()));
        }
    }

    final void deallocate(Node node) {
    }

    Class<? extends WritableNode> next_recommended_type(Node node, int n) {
        return NodeBSearch.class;
    }

    void processNew(Node node, Object object) throws DLTException {
        ((WritableNode)node).setGloss(object);
    }

    void processExisting(Node node, Object object) throws DLTException {
        ((WritableNode)node).setGloss(object);
    }

    private final void addTail(CharacterIterator characterIterator, int n, WritableNode writableNode, WritableNode writableNode2, Object object) throws DLTException {
        WritableNode writableNode3;
        WritableNode writableNode4;
        Class<NodeGloss> clazz = NodeGloss.class;
        int n2 = 1;
        Class<? extends WritableNode> clazz2 = this.next_recommended_type(writableNode2, 1);
        int n3 = writableNode2.num_trans() + 1;
        if (writableNode2.getClass() != clazz2) {
            writableNode4 = this.instantiate_node(clazz2, n3);
            writableNode4.copy(writableNode2);
            if (writableNode2 == this.first) {
                this.first = writableNode4;
            } else {
                if (writableNode == null) {
                    throw new DLTException(Messages.getString("error.logicFSA"));
                }
                writableNode.add(characterIterator, Integer.MAX_VALUE, 0x40000000, writableNode4);
            }
            this.deallocate(writableNode2);
        } else {
            if (writableNode != null) {
                writableNode.next(characterIterator);
            }
            writableNode4 = writableNode2;
        }
        int n4 = n - 1;
        if (n4 > 0) {
            WritableNode writableNode5;
            if (n4 == 1 || !this.enchain) {
                Class<NodeLSearch> clazz3 = NodeLSearch.class;
                writableNode5 = this.instantiate_node(clazz3, 1);
                writableNode4.add(characterIterator, Integer.MAX_VALUE, 0, writableNode5);
                while (true) {
                    int n5 = --n4;
                    --n4;
                    if (n5 > 0) {
                        WritableNode writableNode6 = this.instantiate_node(clazz3, 1);
                        writableNode5.add(characterIterator, 1, 0, writableNode6);
                        writableNode5 = writableNode6;
                        continue;
                    }
                    break;
                }
            } else {
                Class<NodeChain> clazz4 = NodeChain.class;
                writableNode5 = this.instantiate_node(clazz4, n4);
                writableNode4.add(characterIterator, Integer.MAX_VALUE, 0, writableNode5);
            }
            writableNode3 = this.instantiate_node(clazz, n2);
            writableNode5.add(characterIterator, n - 1, Integer.MIN_VALUE, writableNode3);
        } else {
            writableNode3 = this.instantiate_node(clazz, n2);
            writableNode4.add(characterIterator, Integer.MAX_VALUE, 0, writableNode3);
        }
        this.processNew(writableNode3, object);
    }

    private final void split_chain5(CharacterIterator characterIterator, int n, WritableNode writableNode, NodeChain nodeChain, Object object) throws DLTException {
        int n2;
        Class clazz;
        Class clazz2 = NodeGloss.class;
        int n3 = 1;
        Class clazz3 = clazz = NodeChain.class;
        Class clazz4 = clazz;
        Class clazz5 = clazz;
        int n4 = characterIterator.getIndex();
        writableNode.next(characterIterator);
        int n5 = nodeChain.match(characterIterator);
        int n6 = n > n5 && nodeChain.num_chars() > n5 ? 2 : 0;
        int n7 = n - n5 - (n6 >> 1);
        n3 = 1;
        int n8 = nodeChain.num_chars() - n5 - n6 / 2;
        if (n5 == 1) {
            clazz = NodeLSearch.class;
        }
        clazz3 = NodeLSearch.class;
        if (n7 == 1) {
            clazz4 = NodeLSearch.class;
        }
        if (n6 == 0) {
            clazz2 = NodePtrGloss.class;
        }
        if (n8 == 1) {
            clazz5 = NodeLSearch.class;
        }
        if (n6 == 0 && n8 == 0) {
            throw new DLTException(Messages.getString("error.logic"));
        }
        WritableNode writableNode2 = null;
        WritableNode writableNode3 = null;
        WritableNode writableNode4 = null;
        WritableNode writableNode5 = null;
        if (n5 > 0) {
            writableNode2 = this.instantiate_node(clazz, n5);
        }
        if (n6 > 0) {
            writableNode3 = this.instantiate_node(clazz3, n6);
        }
        if (n7 > 0) {
            writableNode4 = this.instantiate_node(clazz4, n7);
        }
        WritableNode writableNode6 = this.instantiate_node(clazz2, n3);
        if (n8 > 0) {
            writableNode5 = this.instantiate_node(clazz5, n8);
        }
        WritableNode writableNode7 = (WritableNode)nodeChain.get_trans(0);
        characterIterator.setIndex(n4);
        writableNode.add(characterIterator, Integer.MAX_VALUE, 0x40000000, writableNode2);
        if (n5 > 0) {
            n2 = n5;
            writableNode2.add(characterIterator, n2, Integer.MIN_VALUE, writableNode3);
        }
        if (n6 > 0) {
            writableNode3.addChar(nodeChain.get_char(n5), 0x20000000, writableNode5);
            n2 = 1;
            writableNode3.add(characterIterator, n2, 0x20000000, writableNode4);
        }
        if (n7 > 0) {
            n2 = n7;
            writableNode4.add(characterIterator, n2, 0, writableNode6);
        }
        if (n6 == 0) {
            writableNode6.addChar(' ', 0x40000000, writableNode5);
        }
        this.processNew(writableNode6, object);
        if (n8 > 0) {
            int n9 = nodeChain.num_chars();
            for (n2 = n5 + n6 / 2; n2 < n9; ++n2) {
                writableNode5.addChar(nodeChain.get_char(n2), 0x20000000, writableNode7);
            }
        }
    }

    private final void add_gloss_tail(CharacterIterator characterIterator, int n, WritableNode writableNode, NodeGloss nodeGloss, Object object) throws DLTException {
        Class clazz = NodeGloss.class;
        Class<Object> clazz2 = writableNode.getClass();
        int n2 = 1;
        int n3 = n;
        if (n <= 0) {
            throw new IllegalArgumentException(Messages.getString("length.positive"));
        }
        clazz = NodePtrGloss.class;
        WritableNode writableNode2 = this.instantiate_node(clazz, n2);
        writableNode.add(characterIterator, Integer.MAX_VALUE, 0x40000000, writableNode2);
        writableNode2.setGloss(nodeGloss.getGloss());
        this.processNew(nodeGloss, object);
        if (n3 == 1 || !this.enchain) {
            clazz2 = NodeLSearch.class;
            WritableNode writableNode3 = this.instantiate_node(clazz2, 1);
            writableNode2.addChar(' ', 0x40000000, writableNode3);
            while (true) {
                int n4 = --n3;
                --n3;
                if (n4 <= 0) break;
                WritableNode writableNode4 = this.instantiate_node(clazz2, 1);
                writableNode3.add(characterIterator, n, 0, writableNode4);
                writableNode3 = writableNode4;
            }
            writableNode3.add(characterIterator, n, 0, nodeGloss);
        } else {
            clazz2 = NodeChain.class;
            WritableNode writableNode5 = this.instantiate_node(clazz2, n3);
            writableNode2.addChar(' ', 0x40000000, writableNode5);
            writableNode5.add(characterIterator, n3, Integer.MIN_VALUE, nodeGloss);
        }
    }

    private final void slipGloss(CharacterIterator characterIterator, int n, WritableNode writableNode, WritableNode writableNode2, Object object) throws DLTException {
        WritableNode writableNode3 = this.instantiate_node(NodePtrGloss.class, 1);
        if (writableNode != null) {
            writableNode.add(characterIterator, Integer.MAX_VALUE, 0x40000000, writableNode3);
        }
        writableNode3.add(characterIterator, 0, 0x40000000, writableNode2);
        this.processNew(writableNode3, object);
    }

    public final void add(CharacterIterator characterIterator, int n, Object object) throws DLTException {
        Node node;
        int n2;
        if (this.contracted) {
            throw new DLTException(Messages.getString("cannot.modifyFSA"));
        }
        int n3 = n2 = characterIterator.getIndex();
        int n4 = characterIterator.getEndIndex();
        int n5 = n4 = n4 - n2 < n ? n4 : n2 + n;
        if (n4 <= n2) {
            throw new IllegalArgumentException(Messages.getString("length.length"));
        }
        Node node2 = this.first();
        Node node3 = null;
        while (n2 < n4 && (node = node2.next(characterIterator)) != null) {
            node3 = node2;
            node2 = node;
            n3 = n2;
            n2 = characterIterator.getIndex();
        }
        if (n2 == n4) {
            characterIterator.setIndex(n3);
            if (node2.isFinal()) {
                this.processExisting(node2, object);
            } else {
                this.slipGloss(characterIterator, n4 - n2, (WritableNode)node3, (WritableNode)node2, object);
            }
        } else {
            characterIterator.setIndex(n3);
            if (node2 instanceof NodeGloss) {
                this.add_gloss_tail(characterIterator, n4 - n2, (WritableNode)node3, (NodeGloss)node2, object);
            } else if (node2 instanceof NodeChain) {
                this.split_chain5(characterIterator, n4 - n2, (WritableNode)node3, (NodeChain)node2, object);
            } else {
                this.addTail(characterIterator, n4 - n2, (WritableNode)node3, (WritableNode)node2, object);
            }
        }
    }

    public synchronized long read_contents(DataInput dataInput, GlossReader glossReader) throws DLTException, IOException {
        int n = dataInput.readInt();
        if (n != -1161904401) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        int n4 = dataInput.readInt();
        if (n2 < 0 || n3 < 0) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        this.enchain = (n4 & 1) != 0;
        this.contracted = (n4 & 2) != 0;
        this.node_pool = new Node[n2];
        this.read_nodes(dataInput, n2, glossReader);
        this.first = this.node_pool[0];
        return n3;
    }

    private final int read_nodes(DataInput dataInput, int n, GlossReader glossReader) throws IOException, DLTException {
        int n2;
        int n3;
        int n4;
        if (n <= 0) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        ReaderNode[] readerNodeArray = new ReaderNode[n];
        for (int i = 0; i < n; ++i) {
            readerNodeArray[i] = new ReaderNode();
            readerNodeArray[i].n = i;
        }
        for (n4 = 0; n4 < n; ++n4) {
            Node node;
            byte by = dataInput.readByte();
            n3 = dataInput.readByte();
            dataInput.readByte();
            dataInput.readByte();
            if (by == 2) {
                n2 = dataInput.readShort();
            } else if (by == 1) {
                n2 = dataInput.readByte();
            } else {
                throw new DLTException(Messages.format("node.charsize", by));
            }
            if (n2 < 0 || n3 < 0 || n3 >= 9) {
                throw new DLTException(Messages.getString("error.dict.format"));
            }
            this.node_pool[n4] = node = this.readNode(dataInput, readerNodeArray, glossReader, by, n3, n2);
        }
        for (n4 = 0; n4 < n; ++n4) {
            Node node = this.node_pool[n4];
            n2 = node.num_trans();
            for (n3 = 0; n3 < n2; ++n3) {
                ReaderNode readerNode = (ReaderNode)node.get_trans(n3);
                ((WritableNode)node).set_trans(n3, this.node_pool[readerNode.n]);
            }
        }
        return n;
    }

    public GlossCollection get(CharacterIterator characterIterator, int n) {
        int n2 = characterIterator.getIndex();
        int n3 = n2 + n;
        Node node = this.first();
        while (n2 <= n3) {
            Node node2 = node.next(characterIterator);
            n2 = characterIterator.getIndex();
            if (node2 == null) {
                return null;
            }
            if (node2.isFinal() && n2 == n3) {
                return ((NodeBaseGloss)node2).getGloss();
            }
            node = node2;
        }
        return null;
    }

    public GlossCollection get(String string) {
        return this.get(new StringCharacterIterator(string), string.length());
    }

    public int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        Node node;
        Node node2 = this.first();
        while ((node = node2.next(characterIterator)) != null) {
            if (node.isFinal()) {
                matchBuffer.add(characterIterator.getIndex(), node.getGloss());
            }
            node2 = node;
        }
        int n = matchBuffer.matchLength();
        if (n > 0) {
            matchBuffer.pushMatch();
        }
        return n;
    }

    public int traverseReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        Node node;
        Node node2 = this.first();
        while ((node = node2.previous(characterIterator)) != null) {
            if (node.isFinal()) {
                matchBuffer.addReversed(characterIterator.getIndex(), node.getGloss());
            }
            node2 = node;
        }
        int n = matchBuffer.matchLength();
        if (n > 0) {
            matchBuffer.pushMatch();
        }
        return n;
    }

    public final int normalizingTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, Normalizer.Mode mode) {
        Node node = this.first();
        while (true) {
            Node node2;
            if ((node2 = node.next(characterIterator)) == null) {
                String string = Normalizer.normalize((int)characterIterator.current(), (Normalizer.Mode)mode);
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                do {
                    node = node2 = node.next(stringCharacterIterator);
                } while (node2 != null && stringCharacterIterator.current() != '\uffff');
                if (node2 == null) break;
                characterIterator.setIndex(characterIterator.getIndex() + 1);
            }
            if (node2.isFinal()) {
                matchBuffer.add(characterIterator.getIndex(), node2.getGloss());
            }
            node = node2;
        }
        int n = matchBuffer.matchLength();
        if (n > 0) {
            matchBuffer.pushMatch();
        }
        return n;
    }

    public final int whitespaceIgnoringTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        Node node = this.first();
        while (true) {
            Node node2;
            if ((node2 = node.next(characterIterator)) == null) {
                if (node == this.first || !Character.isSpaceChar(characterIterator.current())) break;
                characterIterator.next();
                continue;
            }
            if (node2.isFinal()) {
                matchBuffer.add(characterIterator.getIndex(), node2.getGloss());
            }
            node = node2;
        }
        int n = matchBuffer.matchLength();
        if (n > 0) {
            matchBuffer.pushMatch();
        }
        return n;
    }

    public boolean traverseLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        Node node;
        Node node2 = this.first();
        boolean bl = false;
        while ((node = node2.next(characterIterator)) != null) {
            if (node.isFinal() && matchBuffer.addMax(characterIterator.getIndex(), node.getGloss())) {
                bl = true;
            }
            node2 = node;
        }
        if (bl) {
            matchBuffer.pushMatch();
        }
        return bl;
    }

    public boolean traverseLongestReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        Node node;
        Node node2 = this.first();
        boolean bl = false;
        while ((node = node2.previous(characterIterator)) != null) {
            if (node.isFinal() && matchBuffer.addMin(characterIterator.getIndex(), node.getGloss())) {
                bl = true;
            }
            node2 = node;
        }
        if (bl) {
            matchBuffer.pushMatch();
        }
        return bl;
    }

    public Object oovLookup(CharacterIterator characterIterator, int n) {
        MatchBuffer matchBuffer = new MatchBuffer();
        matchBuffer.setMaxIndex(Integer.MAX_VALUE);
        int n2 = characterIterator.getIndex() - n;
        this.traverseReversed(characterIterator, matchBuffer);
        GlossCollection[] glossCollectionArray = matchBuffer.gloss;
        int[] nArray = matchBuffer.index;
        for (int i = matchBuffer.mpos - 1; i >= 0; --i) {
            boolean bl = false;
            if (glossCollectionArray[i] instanceof GlossCollection) {
                GlossCollection glossCollection = glossCollectionArray[i];
                bl = glossCollection.isGeneric();
            }
            if (!bl && nArray[i] == n2) {
                return glossCollectionArray[i];
            }
            if (!bl || nArray[i] <= n2) continue;
            return glossCollectionArray[i];
        }
        return null;
    }

    Node readNode(DataInput dataInput, ReaderNode[] readerNodeArray, GlossReader glossReader, int n, int n2, int n3) throws IOException, DLTException {
        WritableNode writableNode = null;
        switch (n2) {
            case 1: {
                int n4;
                int n5;
                if (n != 2) {
                    throw new DLTException(Messages.format("dlt.charsize", n));
                }
                NodeLSearch nodeLSearch = new NodeLSearch(n3);
                for (n5 = 0; n5 < n3; ++n5) {
                    nodeLSearch.inChar[n5] = n4 = n == 2 ? (int)dataInput.readShort() : (int)dataInput.readByte();
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    n4 = dataInput.readInt();
                    nodeLSearch.outNode[n5] = readerNodeArray[n4];
                }
                nodeLSearch.size = n3;
                writableNode = nodeLSearch;
                break;
            }
            case 2: {
                int n6;
                int n7;
                if (n < 1 || n > 2) {
                    throw new DLTException(Messages.format("dlt.bsearch", n));
                }
                NodeBSearch nodeBSearch = new NodeBSearch(n3);
                for (n7 = 0; n7 < n3; ++n7) {
                    nodeBSearch.inChar[n7] = n6 = n == 2 ? (int)dataInput.readShort() : (int)dataInput.readByte();
                }
                for (n7 = 0; n7 < n3; ++n7) {
                    n6 = dataInput.readInt();
                    nodeBSearch.outNode[n7] = readerNodeArray[n6];
                }
                nodeBSearch.size = n3;
                writableNode = nodeBSearch;
                break;
            }
            case 3: {
                if (n < 1 || n > 2) {
                    throw new DLTException(Messages.format("dlt.bsearch", n));
                }
                NodeTable nodeTable = new NodeTable(n3);
                for (int i = 0; i < n3; ++i) {
                    int n8 = dataInput.readInt();
                    nodeTable.outNode[i] = readerNodeArray[n8];
                    if (nodeTable.outNode[i] == null) continue;
                    ++nodeTable.size;
                }
                writableNode = nodeTable;
                break;
            }
            case 4: {
                int n9;
                if (n < 1 || n > 2) {
                    throw new DLTException(Messages.format("dlt.lsearch", n));
                }
                NodeChain nodeChain = new NodeChain(n3);
                for (n9 = 0; n9 < n3; ++n9) {
                    char c;
                    nodeChain.inChar[n9] = c = n == 2 ? (char)dataInput.readShort() : (char)dataInput.readByte();
                }
                n9 = dataInput.readInt();
                nodeChain.outNode = readerNodeArray[n9];
                writableNode = nodeChain;
                break;
            }
            case 5: {
                writableNode = new NodeGloss(n3);
                int n10 = dataInput.readInt();
                writableNode.setGloss(glossReader.recalc(n10));
                break;
            }
            case 6: {
                writableNode = new NodePtrGloss(n3);
                int n11 = dataInput.readInt();
                int n12 = dataInput.readInt();
                ((NodePtrGloss)writableNode).next = readerNodeArray[n11];
                ((NodePtrGloss)writableNode).setGloss(glossReader.recalc(n12));
                break;
            }
            case 8: {
                NodeFork nodeFork = new NodeFork(n3);
                for (int i = 0; i < n3; ++i) {
                    int n13 = dataInput.readInt();
                    nodeFork.outNode[i] = readerNodeArray[n13];
                }
                writableNode = nodeFork;
                break;
            }
            default: {
                throw new DLTException(Messages.format("node.type", n2));
            }
        }
        return writableNode;
    }

    public final void setChainPolicy(boolean bl) {
        this.enchain = bl;
    }

    public void setOwnerDictionary(Dictionary dictionary) {
        this.ownerDictionary = dictionary;
    }

    public final boolean getChainPolicy() {
        return this.enchain;
    }

    public final boolean isContracted() {
        return this.contracted;
    }

    public boolean isModifiable() {
        return !this.isContracted();
    }

    public void processGlosses(GlossProcessor glossProcessor) throws DLTException {
        if (this.node_pool != null) {
            for (int i = 0; i < this.node_pool.length; ++i) {
                ((WritableNode)this.node_pool[i]).process_glosses(glossProcessor);
            }
        } else {
            Net.processGlosses(this.first(), glossProcessor);
        }
    }

    static void processGlosses(Node node, GlossProcessor glossProcessor) throws DLTException {
        if (node == null) {
            return;
        }
        ((WritableNode)node).process_glosses(glossProcessor);
        for (int i = 0; i < node.num_trans(); ++i) {
            Net.processGlosses(node.get_trans(i), glossProcessor);
        }
    }

    public void endReading() {
        this.node_pool = null;
    }

    private void processToMap(Map<String, GlossCollection> map, Node node, StringBuffer stringBuffer) {
        if (node.isFinal()) {
            map.put(stringBuffer.toString(), node.getGloss());
            if (node instanceof NodePtrGloss) {
                this.processToMap(map, node.get_trans(0), stringBuffer);
            }
            return;
        }
        int n = stringBuffer.length();
        if (node instanceof NodeChain) {
            int n2 = node.num_chars();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(node.get_char(i));
            }
            this.processToMap(map, node.get_trans(0), stringBuffer);
            stringBuffer.setLength(n);
            return;
        }
        int n3 = node.num_trans();
        for (int i = 0; i < n3; ++i) {
            Node node2 = node.get_trans(i);
            if (node2 == null) continue;
            char c = node.get_char(i);
            stringBuffer.append(c);
            this.processToMap(map, node2, stringBuffer);
            stringBuffer.setLength(n);
        }
    }

    public void asMap(Map<String, GlossCollection> map) {
        if (map != null) {
            map.clear();
            if (this.first() != null) {
                StringBuffer stringBuffer = new StringBuffer();
                this.processToMap(map, this.first(), stringBuffer);
            }
        }
    }

    public int remove(CharacterIterator characterIterator, int n) throws DLTException {
        Node node;
        Node node2;
        int n2 = characterIterator.getIndex();
        if (characterIterator.current() == '\uffff') {
            return 0;
        }
        int n3 = 0;
        Node node3 = this.first();
        Node node4 = this.first();
        int n4 = characterIterator.getIndex();
        while (characterIterator.getIndex() < n2 + n) {
            n3 = characterIterator.getIndex();
            node2 = node3.nextRestricted(characterIterator, n + n2 - n3);
            if (node2 == null) {
                return 0;
            }
            if (node3.num_trans() > 1 || node2 instanceof NodePtrGloss) {
                node4 = node3;
                n4 = n3;
            }
            node3 = node2;
        }
        if (characterIterator.getIndex() != n + n2 && characterIterator.current() != '\uffff') {
            return 0;
        }
        if (!(node3 instanceof NodePtrGloss) && !(node3 instanceof NodeGloss)) {
            return 0;
        }
        if (node3 instanceof NodePtrGloss) {
            characterIterator.setIndex(n4);
            node2 = node4.nextRestricted(characterIterator, n + n2);
            Node node5 = node2.get_trans(0);
            this.deallocate(node2);
            characterIterator.setIndex(n4);
            ((WritableNode)node4).add(characterIterator, n + n2, 0x40000000, node5);
            return 1;
        }
        characterIterator.setIndex(n4);
        node2 = node4.nextRestricted(characterIterator, n + n2 - n3);
        if (node2 instanceof NodePtrGloss) {
            node = node2.get_trans(0);
            GlossCollection glossCollection = node2.getGloss();
            this.deallocate(node2);
            NodeGloss nodeGloss = new NodeGloss();
            nodeGloss.setGloss(glossCollection);
            characterIterator.setIndex(n4);
            ((WritableNode)node4).add(characterIterator, n + n2, 0x40000000, nodeGloss);
            node2 = node;
        } else {
            characterIterator.setIndex(n4);
            ((WritableNode)node4).removeChar(characterIterator.current(), 0);
        }
        while (node2 != null) {
            if (node2.num_trans() > 1) {
                throw new DLTException(Messages.getString("error.network"));
            }
            node = node2.get_trans(0);
            this.deallocate(node2);
            node2 = node;
        }
        return 1;
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return new WordIterator(this.first());
    }

    public Iterator<Map.Entry<String, Object>> iteratorAC(String string) {
        return new WordIterator(this.first(), string, true);
    }

    public GlossCollection get(CharacterIterator characterIterator, int n, int n2, int n3) {
        return this.get(characterIterator, n);
    }

    public GlossCollection get(String string, int n, int n2) {
        return this.get(string);
    }

    public int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.traverse(characterIterator, matchBuffer);
    }

    public boolean traverseLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.traverseLongest(characterIterator, matchBuffer);
    }

    public int traverseReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.traverseReversed(characterIterator, matchBuffer);
    }

    public boolean traverseLongestReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.traverseLongestReversed(characterIterator, matchBuffer);
    }

    public Object oovLookup(CharacterIterator characterIterator, int n, int n2, int n3) {
        return this.oovLookup(characterIterator, n);
    }

    static class WordIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final StringBuffer buff = new StringBuffer();
        private ArrayListStack stack = new ArrayListStack();
        private boolean hasNext = false;

        WordIterator(Node node) {
            this.hasNext = this.propagate(node);
        }

        WordIterator(Node node, String string) {
            this.hasNext = this.propagate(node, new StringCharacterIterator(string), false);
        }

        WordIterator(Node node, String string, boolean bl) {
            this.hasNext = this.propagate(node, new StringCharacterIterator(string), bl);
        }

        private boolean propagate(Node node) {
            if (node == null) {
                return false;
            }
            block0: while (node != null) {
                Node node2 = node;
                if (node2.isFinal()) {
                    this.stack.add(new StackElement(node, -1, ""));
                    return true;
                }
                int n = node2.num_trans();
                node = null;
                for (int i = 0; i < n; ++i) {
                    node = node2.get_trans(i);
                    if (node == null) continue;
                    this.stack.add(new StackElement(node2, i, node2.get_chars(i)));
                    continue block0;
                }
            }
            return false;
        }

        private boolean propagate(Node node, CharacterIterator characterIterator, boolean bl) {
            Node node2;
            if (node == null) {
                return false;
            }
            while (true) {
                node2 = node;
                int n = characterIterator.getIndex();
                if ((node = node.next(characterIterator)) == null) break;
                int n2 = node2.num_trans();
                if (bl) {
                    UniLexAnalyzer.memcpy(this.buff, characterIterator, n, characterIterator.getIndex());
                    this.stack.add(new StackElement(node2, -1, this.buff.toString()));
                } else {
                    for (int i = 0; i < n2; ++i) {
                        if (node != node2.get_trans(i)) continue;
                        this.stack.add(new StackElement(node2, i, node2.get_chars(i)));
                        break;
                    }
                }
                if (!bl) continue;
                ++this.stack.baseLength;
            }
            if (bl && this.stack.baseLength <= 0 || characterIterator.getIndex() != characterIterator.getEndIndex()) {
                this.stack.baseLength = 0;
                return false;
            }
            return this.propagate(node2);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        private Entry collectWord() {
            if (this.stack.size() <= this.stack.baseLength) {
                return null;
            }
            int n = this.stack.size();
            this.buff.setLength(0);
            for (int i = 0; i < n; ++i) {
                StackElement stackElement = (StackElement)this.stack.get(i);
                this.buff.append(stackElement.chars);
            }
            this.buff.trimToSize();
            String string = this.buff.toString();
            return new Entry(string, this.stack.top().n.getGloss());
        }

        @Override
        public Entry next() {
            Entry entry = this.collectWord();
            int n = this.stack.size() - 1;
            while (n >= this.stack.baseLength) {
                StackElement stackElement = (StackElement)this.stack.get(n);
                int n2 = stackElement.n.num_trans();
                while (n2 > stackElement.pos + 1) {
                    ++stackElement.pos;
                    Node node = stackElement.n.get_trans(stackElement.pos);
                    if (node == null || !this.propagate(node)) continue;
                    stackElement.chars = stackElement.n.get_chars(stackElement.pos);
                    return entry;
                }
                this.stack.remove(n--);
            }
            if (this.stack.size() <= this.stack.baseLength) {
                this.hasNext = false;
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new IllegalStateException(Messages.getString("cannot.removeword"));
        }

        public final class Entry
        implements Map.Entry<String, Object> {
            private String key;
            private Object value;

            public Entry(String string, Object object) {
                this.key = string;
                this.value = object;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public Object setValue(Object object) {
                throw new UnsupportedOperationException();
            }
        }

        protected class StackElement {
            public Node n;
            public int pos;
            String chars = "";

            public StackElement(Node node, int n, String string) {
                this.n = node;
                this.chars = string;
                this.pos = n;
            }
        }

        protected class ArrayListStack
        extends ArrayList<StackElement> {
            private static final long serialVersionUID = 1L;
            int baseLength = 0;

            protected ArrayListStack() {
            }

            public void push(StackElement stackElement) {
                this.add(stackElement);
            }

            public StackElement pop() {
                if (this.size() > this.baseLength) {
                    return (StackElement)this.remove(this.size() - 1);
                }
                return null;
            }

            public StackElement top() {
                if (this.size() > 0) {
                    return (StackElement)this.get(this.size() - 1);
                }
                return null;
            }
        }
    }

    protected static class ReaderNode
    extends NodeEmpty {
        public int n;

        protected ReaderNode() {
        }
    }
}

