/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.CharacterMapImpl;
import com.ibm.dltj.fst.GlossCollectionHandler;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.Net;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.WritableNode;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.MorphRuleGloss;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import com.ibm.dltj.netgeneric.Permutations;
import com.ibm.dltj.netgeneric.Statistics;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.Utils;
import com.ibm.icu.text.Normalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NetGenericDictionary
implements MultiNet,
Statistics,
Initializer {
    protected static final char SPECIAL_VALUE_UNASSIGNED_CELL = '\u0000';
    protected static final char SPECIAL_VALUE_UNUSED_CHARACTER = '\u0001';
    public static final char SPECIAL_VALUE_GENERIC_GLOSS = '\u0002';
    public static final char SPECIAL_VALUE_GLOSS = '\u0003';
    public static final char SPECIAL_VALUES_END = '\u0004';
    final NetGeneric net;
    final GlossCollectionHandler glosses;
    final CharacterMap char_map;
    private boolean glossesRefCountInitialized = false;
    private static BitSet GlossIndexSet = null;
    private int fileFstFormat = -1;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public static CharacterMap createCharacterMap() {
        return new CharacterMapImpl(4, 3);
    }

    synchronized BitSet getGlossIndexSet() {
        if (GlossIndexSet == null) {
            GlossIndexSet = new BitSet();
            GlossIndexSet.set(2, 4);
        }
        return GlossIndexSet;
    }

    public NetGenericDictionary(GlossCollectionHandler glossCollectionHandler, CharacterMap characterMap) throws DLTException {
        this.glosses = glossCollectionHandler;
        this.net = NetGenericFactory.create(448061489, 4, this);
        this.net.setPayloadManipulator(2, glossCollectionHandler);
        this.net.setPayloadManipulator(3, glossCollectionHandler);
        this.char_map = characterMap;
        this.char_map.attachToNet(this.net);
        this.net.setTransitionToStringMapper(this);
    }

    public NetGenericDictionary() throws DLTException {
        this(new GlossCollectionHandler(null), NetGenericDictionary.createCharacterMap());
    }

    public NetGenericDictionary(int n, GlossCollectionHandler glossCollectionHandler, CharacterMap characterMap) throws DLTException {
        if (glossCollectionHandler == null) {
            glossCollectionHandler = new GlossCollectionHandler(null);
        }
        if (characterMap == null) {
            characterMap = NetGenericDictionary.createCharacterMap();
        }
        this.glosses = glossCollectionHandler;
        this.net = NetGenericFactory.create(n, 4, this);
        this.net.setPayloadManipulator(2, glossCollectionHandler);
        this.net.setPayloadManipulator(3, glossCollectionHandler);
        this.char_map = characterMap;
        this.char_map.attachToNet(this.net);
        this.net.setTransitionToStringMapper(this);
    }

    @Override
    public void reset() {
        this.char_map.reset();
        this.fileFstFormat = -1;
        this.glosses.reset();
        this.net.reset();
    }

    @Override
    public Node first() {
        return this.net.isEmpty() ? null : (this.isStaged() ? new NetStagedNode(new DictionaryAccess(this), this.net.first_base()) : new NetGenericNode(new DictionaryAccess(this), this.net.first_base()));
    }

    @Override
    public GlossCollection get(CharacterIterator characterIterator, int n) {
        if (this.net.isEmpty()) {
            return null;
        }
        NetGenericReadOnly netGenericReadOnly = this.net.getReader();
        int n2 = this.char_map.translate(characterIterator.current());
        int n3 = this.net.first_base();
        while (--n >= 0) {
            if (!netGenericReadOnly.transitionPresent(n3, n2)) {
                return null;
            }
            n3 = netGenericReadOnly.transitionValue(n3, n2);
            n2 = this.char_map.translate(characterIterator.next());
        }
        n2 = 3;
        if (!netGenericReadOnly.transitionPresent(n3, n2)) {
            return null;
        }
        return this.glosses.getGlossByIdx(netGenericReadOnly.transitionValue(n3, n2));
    }

    @Override
    public GlossCollection get(String string) {
        if (this.net.isEmpty()) {
            return null;
        }
        return this.glosses.getGlossByIdx(this.net.getEntry(this.char_map.makeIterator(string)));
    }

    protected GlossCollection getGlossByNode(int n) {
        return this.glosses.getGlossByIdx(this.net.transitionValue(n, 3));
    }

    @Override
    public int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        if (this.net.isEmpty()) {
            return -1;
        }
        NetGenericReadOnly netGenericReadOnly = this.net.getReader();
        char c = this.char_map.translate(characterIterator.current());
        int n = netGenericReadOnly.first_base();
        while (netGenericReadOnly.transitionPresent(n, c)) {
            n = netGenericReadOnly.transitionValue(n, c);
            c = this.char_map.translate(characterIterator.next());
            if (!netGenericReadOnly.transitionPresent(n, 3)) continue;
            matchBuffer.add(characterIterator.getIndex(), this.getGlossByNode(n));
        }
        int n2 = matchBuffer.matchLength();
        if (n2 > 0) {
            matchBuffer.pushMatch();
        }
        return n2;
    }

    @Override
    public int traverseReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        if (this.net.isEmpty()) {
            return -1;
        }
        char c = this.char_map.translate(characterIterator.previous());
        int n = this.net.first_base();
        while (this.net.transitionPresent(n, c)) {
            if (this.net.transitionPresent(n = this.net.transitionValue(n, c), 3)) {
                matchBuffer.addReversed(characterIterator.getIndex(), this.getGlossByNode(n));
            }
            c = this.char_map.translate(characterIterator.previous());
        }
        int n2 = matchBuffer.matchLength();
        if (n2 > 0) {
            matchBuffer.pushMatch();
        }
        return n2;
    }

    @Override
    public final int normalizingTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, Normalizer.Mode mode) {
        int n;
        Node node = this.first();
        if (node != null) {
            while (true) {
                Node node2;
                if ((node2 = node.next(characterIterator)) == null) {
                    String string = Normalizer.normalize((int)characterIterator.current(), (Normalizer.Mode)mode);
                    StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                    do {
                        node = node2 = node.next(stringCharacterIterator);
                    } while (node2 != null && stringCharacterIterator.current() != '\uffff');
                    if (node2 == null) break;
                    characterIterator.setIndex(characterIterator.getIndex() + 1);
                }
                if (node2.isFinal()) {
                    matchBuffer.add(characterIterator.getIndex(), node2.getGloss());
                }
                node = node2;
            }
        }
        if ((n = matchBuffer.matchLength()) > 0) {
            matchBuffer.pushMatch();
        }
        return n;
    }

    @Override
    public final int whitespaceIgnoringTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        int n;
        Node node = this.first();
        Node node2 = node;
        if (node2 != null) {
            while (true) {
                Node node3;
                if ((node3 = node2.next(characterIterator)) == null) {
                    if (node2 == node || !Character.isSpaceChar(characterIterator.current())) break;
                    characterIterator.next();
                    continue;
                }
                if (node3.isFinal()) {
                    matchBuffer.add(characterIterator.getIndex(), node3.getGloss());
                }
                node2 = node3;
            }
        }
        if ((n = matchBuffer.matchLength()) > 0) {
            matchBuffer.pushMatch();
        }
        return n;
    }

    @Override
    public boolean traverseLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        if (this.net.isEmpty()) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.net.first_base();
        NetGenericReadOnly netGenericReadOnly = this.net.getReader();
        char c = this.char_map.translate(characterIterator.current());
        while (netGenericReadOnly.transitionPresent(n3, c)) {
            n3 = netGenericReadOnly.transitionValue(n3, c);
            c = this.char_map.translate(characterIterator.next());
            if (!netGenericReadOnly.transitionPresent(n3, 3)) continue;
            n = netGenericReadOnly.transitionValue(n3, 3);
            n2 = characterIterator.getIndex();
        }
        if (n2 != 0) {
            matchBuffer.addMax(n2, this.glosses.getGlossByIdx(n));
            matchBuffer.pushMatch();
        }
        return n2 != 0;
    }

    @Override
    public boolean traverseLongestReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        if (this.net.isEmpty()) {
            return false;
        }
        char c = this.char_map.translate(characterIterator.previous());
        int n = this.net.first_base();
        boolean bl = false;
        while (this.net.transitionPresent(n, c)) {
            if (this.net.transitionPresent(n = this.net.transitionValue(n, c), 3) && matchBuffer.addMin(characterIterator.getIndex(), this.getGlossByNode(n))) {
                bl = true;
            }
            c = this.char_map.translate(characterIterator.previous());
        }
        if (bl) {
            matchBuffer.pushMatch();
        }
        return bl;
    }

    @Override
    public Object oovLookup(CharacterIterator characterIterator, int n) {
        if (this.net.isEmpty()) {
            return null;
        }
        int n2 = -1;
        NetGenericReadOnly netGenericReadOnly = this.net.getReader();
        int n3 = this.char_map.translate(characterIterator.previous());
        int n4 = this.net.first_base();
        while (--n >= 0) {
            if (!netGenericReadOnly.transitionPresent(n4, n3)) {
                return this.glosses.getGlossByIdx(n2);
            }
            n4 = netGenericReadOnly.transitionValue(n4, n3);
            n2 = netGenericReadOnly.takeTransition(n4, 2, n2);
            n3 = this.char_map.translate(characterIterator.previous());
        }
        n3 = 3;
        n2 = netGenericReadOnly.takeTransition(n4, n3, n2);
        return this.glosses.getGlossByIdx(n2);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Net.WordIterator(this.first());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iteratorAC(String string) {
        return new Net.WordIterator(this.first(), string, true);
    }

    @Override
    public void add(CharacterIterator characterIterator, int n, final Object object) throws DLTException {
        this.char_map.addCharacters(characterIterator, n);
        class GlossAdder
        implements NetGeneric.ChangeEncapsulator {
            GlossAdder() {
            }

            @Override
            public int Apply(int n) throws DLTException {
                return NetGenericDictionary.this.glosses.processGlossAdd(n, (Gloss)object);
            }
        }
        this.net.modifyEntry(this.char_map.makeIterator(characterIterator, n), new GlossAdder());
    }

    @Override
    public int remove(CharacterIterator characterIterator, int n) throws DLTException {
        this.net.modifyEntry(this.char_map.makeIterator(characterIterator, n), new NetGeneric.ChangeEncapsulator.Setter(-1));
        return 0;
    }

    @Override
    public void removeGloss(CharacterIterator characterIterator, int n, final Gloss gloss) throws DLTException {
        class GlossRemover
        implements NetGeneric.ChangeEncapsulator {
            GlossRemover() {
            }

            @Override
            public int Apply(int n) throws DLTException {
                return NetGenericDictionary.this.glosses.processGlossRemove(n, gloss);
            }
        }
        this.net.modifyEntry(this.char_map.makeIterator(characterIterator, n), new GlossRemover());
    }

    @Override
    public WritableNode newNode(int n, int n2) throws DLTException {
        throw new DLTException(Messages.getString("wrong.call"));
    }

    @Override
    public void setFirstNode(Node node) throws DLTException {
        throw new DLTException(Messages.getString("wrong.call"));
    }

    @Override
    public void processGlosses(GlossProcessor glossProcessor) throws DLTException {
        this.glosses.processGlosses(glossProcessor);
    }

    public void addPermutations(String string, Gloss gloss) throws DLTException {
        int[][] nArrayArray = new int[string.length()][];
        for (int i = 0; i < string.length(); ++i) {
            nArrayArray[i] = new int[]{this.char_map.translateAdding(string.charAt(i))};
        }
        Permutations.addPermutations(this.net, NetGeneric.IndexIterator.Root, nArrayArray, null, 3, gloss);
    }

    private BuildNode getSimpleMergingNode(NetGenericDictionary netGenericDictionary, GlossProcessor glossProcessor, int n) {
        class NGDicMergingNode
        extends BuildNodeBase {
            final int node;
            final int dest_node;
            final /* synthetic */ NetGenericDictionary val$dest;
            final /* synthetic */ GlossProcessor val$processor;

            NGDicMergingNode(int n, int n2) {
                this.val$dest = netGenericDictionary2;
                this.val$processor = glossProcessor;
                this.node = n;
                this.dest_node = n2;
            }

            @Override
            public BuildNode getChild() throws DLTException {
                if (this.depth < 4) {
                    int n = this.val$dest.net.takeTransition(this.dest_node, this.depth, -1);
                    Object object = NetGenericDictionary.this.net.getPayload(this.node, this.depth, null);
                    if (object != null) {
                        n = this.val$dest.glosses.merge(n, this.val$processor.process(object));
                    }
                    return NGDicMergingNode.makeAssignedNode(n);
                }
                char c = NetGenericDictionary.this.char_map.translate(this.val$dest.char_map.invert(this.depth));
                return new NGDicMergingNode(NetGenericDictionary.this.net.takeTransition(this.node, c, -1), this.val$dest.net.takeTransition(this.dest_node, this.depth, -1));
            }

            @Override
            public int getIndex() {
                return this.depth;
            }

            @Override
            public boolean nextTransition() {
                int n = this.depth;
                int n2 = this.val$dest.net.getMaxIndex();
                do {
                    if (++n != n2) continue;
                    return false;
                } while (!this.val$dest.net.transitionPresent(this.dest_node, n) && !NetGenericDictionary.this.net.transitionPresent(this.node, n < 4 ? n : (int)NetGenericDictionary.this.char_map.translate(this.val$dest.char_map.invert(n))));
                this.depth = n;
                return true;
            }

            @Override
            public void startEnumeration() throws DLTException {
                for (int i = 4; i < NetGenericDictionary.this.net.getMaxIndex(); ++i) {
                    if (!NetGenericDictionary.this.net.transitionPresent(this.node, i)) continue;
                    this.val$dest.char_map.translateAdding(NetGenericDictionary.this.char_map.invert(i));
                }
                this.depth = 0;
            }

            public int hashCode() {
                return Utils.combineHash(this.node, this.dest_node);
            }

            public boolean equals(Object object) {
                NGDicMergingNode nGDicMergingNode = (NGDicMergingNode)object;
                return this.node == nGDicMergingNode.node && this.dest_node == nGDicMergingNode.dest_node;
            }

            @Override
            public String toString() {
                return "<" + Integer.toString(this.dest_node) + ',' + Integer.toString(this.node) + '>';
            }
        }
        return new NGDicMergingNode(this.net.first_base(), n);
    }

    BuildNode getMultiMappedMergerNode(NetGenericDictionary netGenericDictionary, CharacterMap.MapMergeData mapMergeData, GlossProcessor glossProcessor) {
        class MultiMappedMergerNode
        extends BuildNodeBase {
            final int node;
            int[] trans = null;
            final /* synthetic */ CharacterMap.MapMergeData val$merge_data;
            final /* synthetic */ NetGenericDictionary val$dest;
            final /* synthetic */ GlossProcessor val$processor;

            MultiMappedMergerNode(int n) {
                this.val$merge_data = mapMergeData;
                this.val$dest = netGenericDictionary2;
                this.val$processor = glossProcessor;
                this.node = n;
            }

            @Override
            public void startEnumeration() throws DLTException {
                int[] nArray = NetGenericDictionary.this.net.gatherNodeLinks(this.node);
                IntArray intArray = new IntArray(nArray.length + 2);
                for (int i = 1; i < 4; ++i) {
                    if (!NetGenericDictionary.this.net.transitionPresent(this.node, i)) continue;
                    intArray.add(i);
                }
                for (int n : nArray) {
                    intArray.addAll(this.val$merge_data.sourceToDest[n]);
                }
                this.trans = intArray.toArray();
                Arrays.sort(this.trans);
                super.startEnumeration();
            }

            @Override
            public BuildNode getChild() throws DLTException {
                int n = this.trans[this.depth];
                if (n < 4) {
                    return MultiMappedMergerNode.makeAssignedNode(this.val$dest.glosses.merge(-1, this.val$processor.process(NetGenericDictionary.this.net.getPayload(this.node, n, null))));
                }
                return new MultiMappedMergerNode(NetGenericDictionary.this.net.transitionValue(this.node, this.val$merge_data.destToSource.get(n)));
            }

            @Override
            public int getIndex() {
                return this.trans[this.depth];
            }

            @Override
            public boolean nextTransition() {
                return ++this.depth < this.trans.length;
            }

            public int hashCode() {
                return this.node;
            }

            public boolean equals(Object object) {
                return this.node == ((MultiMappedMergerNode)object).node;
            }

            @Override
            public String toString() {
                return Integer.toString(this.node);
            }
        }
        return new MultiMappedMergerNode(this.net.first_base());
    }

    void duplicateNodes(IntArray[] intArrayArray) throws DLTException {
        class DuplicationNode
        implements Merger.MergerNode {
            int node;
            int[] trans;
            int[] invmap;
            final /* synthetic */ IntArray[] val$duplications;

            public DuplicationNode(int n) {
                this.val$duplications = intArrayArray;
                this.node = n;
            }

            @Override
            public boolean startCopy() throws DLTException {
                int[] nArray = NetGenericDictionary.this.net.gatherNodeLinks(this.node);
                this.invmap = new int[NetGenericDictionary.this.net.getMaxIndex()];
                IntArray intArray = new IntArray(nArray.length);
                intArray.addAll(nArray);
                int[] nArray2 = nArray;
                int n = nArray2.length;
                for (int i = 0; i < n; ++i) {
                    int n2;
                    this.invmap[n2] = n2 = nArray2[i];
                    IntArray intArray2 = this.val$duplications[n2];
                    if (intArray2 == null) continue;
                    intArray.addAll(intArray2);
                    for (int j = 0; j < intArray2.size(); ++j) {
                        this.invmap[intArray2.get((int)j)] = n2;
                    }
                }
                this.trans = intArray.toArray();
                Arrays.sort(this.trans);
                return true;
            }

            @Override
            public int[] gatherLinks() {
                return this.trans;
            }

            @Override
            public boolean transitionPresent(int n) {
                if (n < NetGenericDictionary.this.net.getFirstLinkIndex()) {
                    return NetGenericDictionary.this.net.transitionPresent(this.node, n);
                }
                return this.invmap[n] != 0;
            }

            @Override
            public Object transitionValue(int n) throws DLTException {
                return NetGenericDictionary.this.net.getPayload(this.node, n, null);
            }

            @Override
            public Merger.MergerNode getTransition(int n) throws DLTException {
                return new DuplicationNode(NetGenericDictionary.this.net.transitionValue(this.node, n));
            }

            @Override
            public void finalizeCopy() {
            }

            @Override
            public int hashCode() {
                return this.node;
            }

            @Override
            public boolean equals(Object object) {
                DuplicationNode duplicationNode = (DuplicationNode)object;
                return this.node == duplicationNode.node;
            }
        }
        this.net.attachFSA(NetGeneric.IndexIterator.Root, new DuplicationNode(this.net.first_base()));
    }

    public boolean isStaged() {
        return NetGenericFactory.isStaged(this.net.getSignature());
    }

    public void append(NetGenericDictionary netGenericDictionary, GlossProcessor glossProcessor) throws DLTException {
        boolean bl = this.isStaged() || netGenericDictionary.isStaged();
        CharacterMap.MapMergeData mapMergeData = this.char_map.combineMaps(netGenericDictionary.char_map, bl);
        if (mapMergeData == null) {
            this.net.transformBranch(NetGeneric.IndexIterator.Root, netGenericDictionary.getSimpleMergingNode(this, glossProcessor, this.net.first_base()));
        } else {
            if (mapMergeData.destDuplications != null) {
                this.duplicateNodes(mapMergeData.destDuplications);
            }
            this.net.attachFSA(NetGeneric.IndexIterator.Root, netGenericDictionary.getMultiMappedMergerNode(this, mapMergeData, glossProcessor));
        }
    }

    private void addNetCharacters(Node node, Set<Node> set) throws DLTException {
        if (set.contains(node)) {
            return;
        }
        set.add(node);
        switch (node.num_chars()) {
            case 0: {
                for (int i = 0; i < node.num_trans(); ++i) {
                    this.addNetCharacters(node.get_trans(i), set);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < node.num_trans(); ++i) {
                    this.char_map.translateAdding(node.get_char(i));
                    this.addNetCharacters(node.get_trans(i), set);
                }
                break;
            }
            default: {
                throw new DLTException(Messages.getString("node.format"));
            }
        }
    }

    public void append(Node node, GlossProcessor glossProcessor) throws DLTException {
        if (node == null) {
            return;
        }
        if (this.isStaged()) {
            this.addNetCharacters(node, new HashSet<Node>());
        }
        this.net.attachFSA(NetGeneric.IndexIterator.Root, new LWareMergerNode(node, this.char_map, glossProcessor));
    }

    public CharacterMap getCharacterMap() {
        return this.char_map;
    }

    public GlossCollectionHandler getGlossCollectionHandler() {
        return this.glosses;
    }

    public NetGeneric getNet() {
        return this.net;
    }

    @Override
    public long readContents(DataInput dataInput, int n) throws IOException, DLTException {
        boolean bl;
        if (dataInput.readInt() != -1161904401) {
            throw new DLTException(Messages.getString("error.dict.signature"));
        }
        dataInput.readInt();
        dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        dataInput.readInt();
        int n4 = dataInput.readInt();
        if (n3 < 0) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        boolean bl2 = bl = (n4 & 2) != 0;
        if (!bl) {
            throw new DLTException(Messages.getString("error.dict.not.contracted"));
        }
        this.fileFstFormat = 3;
        int n5 = dataInput.readInt();
        int n6 = -1;
        if (n5 > 0) {
            n6 = dataInput.readInt();
        }
        while (true) {
            int n7 = --n5;
            --n5;
            if (n7 <= 0) break;
            dataInput.readInt();
        }
        this.char_map.load(dataInput, this.net);
        this.net.setMaxIndex(this.char_map.getMaxIndex());
        this.net.readNet(dataInput, n2, n3, n6);
        this.glossesRefCountInitialized = false;
        return n3;
    }

    public long writeNodes(DataOutput dataOutput) throws IOException, DLTException {
        dataOutput.writeInt(1);
        dataOutput.writeInt(this.net.getBiggestValue());
        int n = 8;
        n = (int)((long)n + this.char_map.save(dataOutput, this.net));
        n = (int)((long)n + this.net.writeNet(dataOutput));
        return n;
    }

    public void load(DataInput dataInput) throws IOException, DLTException {
        this.char_map.load(dataInput, this.net);
        this.net.setMaxIndex(this.char_map.getMaxIndex());
        NetGenericFactory.load(dataInput, this.net);
        this.glossesRefCountInitialized = false;
    }

    public long save(DataOutput dataOutput) throws IOException, DLTException {
        long l = 0L;
        l += this.char_map.save(dataOutput, this.net);
        return l += NetGenericFactory.save(dataOutput, this.net);
    }

    @Override
    public boolean getChainPolicy() {
        return false;
    }

    @Override
    public void setChainPolicy(boolean bl) {
    }

    @Override
    public int getFileFSTFormat() {
        return this.fileFstFormat;
    }

    @Override
    public boolean isContracted() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public void contract() throws DLTException {
    }

    @Override
    public void startBuild(boolean bl) throws DLTException {
        this.startModify();
    }

    @Override
    public int endBuild() {
        this.net.endModify();
        return 0;
    }

    @Override
    public void endReading() {
    }

    @Override
    public void startModify() throws DLTException {
        this.net.startModify();
        this.char_map.startModify();
        if (!this.glosses.buildStarted()) {
            this.glosses.startBuild(true);
            this.glosses.create_collections();
        }
        if (!this.glossesRefCountInitialized) {
            this.net.forAllInstances(3, new NetGeneric.ChangeEncapsulator(){

                @Override
                public int Apply(int n) throws DLTException {
                    return NetGenericDictionary.this.glosses.reference(n);
                }
            });
            this.net.forAllInstances(2, new NetGeneric.ChangeEncapsulator(){

                @Override
                public int Apply(int n) throws DLTException {
                    return NetGenericDictionary.this.glosses.reference(n);
                }
            });
            this.glossesRefCountInitialized = true;
        }
    }

    @Override
    public void endModify() {
        this.net.endModify();
        this.glosses.endBuild();
        this.char_map.endModify();
    }

    public int getSize() {
        return this.net.getSize();
    }

    public int getSignature() {
        return this.net.getSignature();
    }

    @Override
    public String transitionToString(int n, int n2) {
        String string = "";
        switch (n) {
            case 1: {
                string = "*** unused char should not be used ***";
                break;
            }
            case 2: {
                return "gengloss->" + this.glosses.getGlossByIdx(n2);
            }
            case 3: {
                return "gloss->" + this.glosses.getGlossByIdx(n2);
            }
            default: {
                char c = this.char_map.invert(n);
                if (Character.isJavaIdentifierPart(c)) {
                    string = "" + c;
                    break;
                }
                string = "\\u" + Integer.toHexString(c);
                break;
            }
        }
        string = string + "->" + n2;
        if (n2 < 0 || n == 3 && this.glosses.getGlossByIdx(n2) == null) {
            string = string + "*** incorrect link ***";
        }
        return string;
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        if (!this.net.dumpNet(printStream) && !this.net.isEmpty()) {
            printStream.print("  words in dict: ");
            Iterator<Map.Entry<String, Object>> iterator = this.iterator();
            while (iterator.hasNext()) {
                printStream.print((Object)iterator.next().getKey());
                printStream.print(' ');
            }
            printStream.println("\n");
            return true;
        }
        if (this.net.isEmpty()) {
            printStream.println("Empty dictionary.\n");
        } else {
            printStream.println("Dictionary has loops.\n");
        }
        return false;
    }

    boolean checkGlossReferences(final PrintStream printStream) {
        final int[] nArray = new int[this.glosses.getHighestIndex() + 1];
        boolean bl = true;
        try {
            this.net.forAllInstances(3, new NetGeneric.ChangeEncapsulator(){

                @Override
                public int Apply(int n) {
                    if (n >= nArray.length - 1) {
                        printStream.println("Invalid gloss index " + n);
                        nArray[nArray.length - 1] = -1;
                    } else {
                        int n2 = n;
                        nArray[n2] = nArray[n2] + 1;
                    }
                    return -2;
                }
            });
        }
        catch (DLTException dLTException) {
            bl = false;
            dLTException.printStackTrace(printStream);
        }
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (this.glosses.getRefCount(i) == nArray[i]) continue;
            printStream.println("Gloss refcount mismatch, gloss " + i + ", " + this.glosses.getRefCount(i) + " vs " + nArray[i] + " actual references.");
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean verifyConsistency() {
        boolean bl = this.net.verifyConsistency();
        if (bl && !this.char_map.attachedToMultipleNets() && !(bl = this.checkGlossReferences(System.err))) {
            this.dumpNet(System.err);
        }
        return bl;
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.net.dumpNet(printStream, n);
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        this.net.printStatistics(printStream);
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
        this.net.setTransitionToStringMapper(statistics);
    }

    @Override
    public void setOwnerDictionary(Dictionary dictionary) {
        this.glosses.setOwnerDictionary(dictionary);
    }

    public final void ensureInitialized() throws DLTException {
        if (this.net.getSize() == 0) {
            this.startModify();
        }
    }

    @Override
    public GlossCollection get(CharacterIterator characterIterator, int n, int n2, int n3) {
        return this.get(characterIterator, n);
    }

    @Override
    public boolean traverseLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.traverseLongest(characterIterator, matchBuffer);
    }

    @Override
    public int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.traverse(characterIterator, matchBuffer);
    }

    @Override
    public MultiNet getMultiNet() {
        return this;
    }

    static class NetStagedNode
    extends NetGenericNode {
        int[] transitions = null;

        NetStagedNode(DictionaryAccess dictionaryAccess, int n) {
            super(dictionaryAccess, n);
        }

        @Override
        public int num_trans() {
            if (this.transitions == null) {
                this.transitions = this.dic.net.gatherNodeLinks(this.node);
            }
            return this.transitions.length;
        }

        @Override
        public Node get_trans(int n) {
            return new NetStagedNode(this.dic, this.dic.net.transitionValue(this.node, this.transitions[n]));
        }

        @Override
        public char get_char(int n) {
            assert (n >= 0 && n < this.num_trans());
            return this.dic.characters.invert(this.transitions[n]);
        }

        @Override
        public String get_chars(int n) {
            assert (n >= 0 && n < this.num_trans());
            char[] cArray = new char[]{this.dic.characters.invert(this.transitions[n])};
            return new String(cArray);
        }

        @Override
        public Node next(char c) {
            char c2 = this.dic.characters.translate(c);
            if (this.dic.net.transitionPresent(this.node, c2)) {
                return new NetStagedNode(this.dic, this.dic.net.transitionValue(this.node, c2));
            }
            return null;
        }

        @Override
        public Node next(CharacterIterator characterIterator) {
            char c = this.dic.characters.translate(characterIterator.current());
            if (this.dic.net.transitionPresent(this.node, c)) {
                characterIterator.next();
                return new NetStagedNode(this.dic, this.dic.net.transitionValue(this.node, c));
            }
            return null;
        }

        @Override
        public Node previous(CharacterIterator characterIterator) {
            char c = this.dic.characters.translate(characterIterator.previous());
            if (this.dic.net.transitionPresent(this.node, c)) {
                return new NetStagedNode(this.dic, this.dic.net.transitionValue(this.node, c));
            }
            characterIterator.next();
            return null;
        }
    }

    static class NetGenericNode
    implements Node {
        final int node;
        final DictionaryAccess dic;

        NetGenericNode(DictionaryAccess dictionaryAccess, int n) {
            this.node = n;
            this.dic = dictionaryAccess;
        }

        public boolean transitionPossible(char c) {
            char c2 = this.dic.characters.translate(c);
            return this.dic.net.transitionPresent(this.node, c2);
        }

        @Override
        public Node next(char c) {
            char c2 = this.dic.characters.translate(c);
            if (this.dic.net.transitionPresent(this.node, c2)) {
                return new NetGenericNode(this.dic, this.dic.net.transitionValue(this.node, c2));
            }
            return null;
        }

        @Override
        public Node next(CharacterIterator characterIterator) {
            char c = this.dic.characters.translate(characterIterator.current());
            if (this.dic.net.transitionPresent(this.node, c)) {
                characterIterator.next();
                return new NetGenericNode(this.dic, this.dic.net.transitionValue(this.node, c));
            }
            return null;
        }

        @Override
        public Node previous(CharacterIterator characterIterator) {
            char c = this.dic.characters.translate(characterIterator.previous());
            if (this.dic.net.transitionPresent(this.node, c)) {
                return new NetGenericNode(this.dic, this.dic.net.transitionValue(this.node, c));
            }
            characterIterator.next();
            return null;
        }

        @Override
        public int num_trans() {
            return this.dic.characters.getUsedCount();
        }

        @Override
        public int num_chars() {
            return 1;
        }

        @Override
        public Node get_trans(int n) {
            if (this.dic.net.transitionPresent(this.node, n += 4)) {
                return new NetGenericNode(this.dic, this.dic.net.transitionValue(this.node, n));
            }
            return null;
        }

        @Override
        public char get_char(int n) {
            assert (n >= 0 && n < this.num_trans());
            return this.dic.characters.getUsedChar(n);
        }

        @Override
        public String get_chars(int n) {
            assert (n >= 0 && n < this.num_trans());
            char[] cArray = new char[]{this.dic.characters.getUsedChar(n)};
            return new String(cArray);
        }

        @Override
        public boolean isFinal() {
            return this.dic.net.transitionPresent(this.node, 3) || this.dic.net.transitionPresent(this.node, 2);
        }

        @Override
        public GlossCollection getGloss() {
            GlossCollection glossCollection = null;
            if (this.dic.net.transitionPresent(this.node, 3)) {
                glossCollection = this.dic.glosses.getGlossByIdx(this.dic.net.transitionValue(this.node, 3));
            }
            if (this.dic.net.transitionPresent(this.node, 2)) {
                GlossCollection glossCollection2 = this.dic.glosses.getGlossByIdx(this.dic.net.transitionValue(this.node, 2));
                if (glossCollection == null) {
                    glossCollection = glossCollection2;
                } else {
                    glossCollection = new GlossCollection(glossCollection);
                    glossCollection.addAll(glossCollection2);
                }
            }
            return glossCollection;
        }

        @Override
        public Node nextRestricted(CharacterIterator characterIterator, int n) {
            if (n > 0) {
                return this.next(characterIterator);
            }
            return this;
        }

        @Override
        public void dispose() {
        }

        public int hashCode() {
            return this.node;
        }

        public boolean equals(Object object) {
            assert (((NetGenericNode)object).dic == this.dic);
            return ((NetGenericNode)object).node == this.node;
        }
    }

    static class DictionaryAccess {
        final NetGenericReadOnly net;
        final CharacterMap characters;
        final GlossCollectionHandler glosses;

        DictionaryAccess(NetGenericDictionary netGenericDictionary) {
            this.net = netGenericDictionary.net.getReader();
            this.characters = netGenericDictionary.char_map;
            this.glosses = netGenericDictionary.glosses;
        }
    }

    static class LWareMergerNode
    implements Merger.MergerNode {
        private final Node node;
        private Node tnode;
        Object gloss;
        Object gen_gloss;
        final CharacterMap char_map;
        GlossProcessor processor;

        LWareMergerNode(Node node, CharacterMap characterMap, GlossProcessor glossProcessor) {
            this.node = node;
            this.char_map = characterMap;
            this.processor = glossProcessor;
            this.gloss = null;
            this.gen_gloss = null;
        }

        @Override
        public boolean startCopy() throws DLTException {
            Node node = this.node;
            GlossCollection glossCollection = null;
            GlossCollection glossCollection2 = null;
            do {
                if (node.isFinal()) {
                    GlossCollection glossCollection3 = node.getGloss();
                    if (glossCollection == null) {
                        glossCollection = new GlossCollection();
                    }
                    if (glossCollection2 == null) {
                        glossCollection2 = new GlossCollection();
                    }
                    for (Gloss gloss : glossCollection3) {
                        if (gloss instanceof MidGloss && ((MidGloss)gloss).getGloss(MorphRuleGloss.class) != null) {
                            glossCollection2.add(gloss);
                            continue;
                        }
                        glossCollection.add(gloss);
                    }
                }
                if (node.num_chars() == 0) {
                    if (node.num_trans() > 1) {
                        throw new DLTException(Messages.getString("node.format"));
                    }
                } else {
                    if (node.num_chars() <= 1) break;
                    throw new DLTException(Messages.getString("node.format"));
                }
                node = node.get_trans(0);
            } while (node != null);
            if (glossCollection != null && !glossCollection.isEmpty()) {
                this.gloss = this.processor.process(glossCollection);
            }
            if (glossCollection2 != null && !glossCollection2.isEmpty()) {
                this.gen_gloss = this.processor.process(glossCollection2);
            }
            this.tnode = node;
            if (node != null) {
                for (int i = 0; i < this.tnode.num_trans(); ++i) {
                    if (this.tnode.get_trans(i) == null) continue;
                    this.char_map.translateAdding(this.tnode.get_char(i));
                }
            }
            return true;
        }

        @Override
        public int[] gatherLinks() {
            if (this.tnode == null) {
                return new int[0];
            }
            int[] nArray = new int[this.tnode.num_trans()];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.char_map.translate(this.tnode.get_char(i));
                if (this.tnode.get_trans(i) != null) continue;
                nArray[i] = Integer.MAX_VALUE;
                ++n;
            }
            Arrays.sort(nArray);
            if (n > 0) {
                int[] nArray2 = new int[nArray.length - n];
                System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
                return nArray2;
            }
            return nArray;
        }

        @Override
        public boolean transitionPresent(int n) {
            if (n >= 4) {
                if (this.tnode == null) {
                    return false;
                }
                Node node = this.tnode.next(this.char_map.invert(n));
                return node != null;
            }
            return this.transitionValue(n) != null;
        }

        @Override
        public Object transitionValue(int n) {
            switch (n) {
                case 3: {
                    return this.gloss;
                }
                case 2: {
                    return this.gen_gloss;
                }
            }
            return null;
        }

        @Override
        public Merger.MergerNode getTransition(int n) {
            if (this.tnode == null) {
                return null;
            }
            Node node = this.tnode.next(this.char_map.invert(n));
            if (node == null) {
                return null;
            }
            return new LWareMergerNode(node, this.char_map, this.processor);
        }

        @Override
        public void finalizeCopy() {
        }

        @Override
        public int hashCode() {
            return this.node.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.node.equals(((LWareMergerNode)object).node);
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

