/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.WritableNode;
import java.text.CharacterIterator;

class NodeChain
implements WritableNode {
    char[] inChar;
    Node outNode;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    NodeChain() {
        this.inChar = null;
    }

    NodeChain(int n) {
        this.inChar = new char[n];
    }

    @Override
    public final Node next(CharacterIterator characterIterator) {
        int n = characterIterator.getIndex();
        for (int i = 0; i < this.inChar.length; ++i) {
            if (characterIterator.current() != this.inChar[i]) {
                characterIterator.setIndex(n);
                return null;
            }
            characterIterator.next();
        }
        return this.outNode;
    }

    @Override
    public final Node previous(CharacterIterator characterIterator) {
        int n = characterIterator.getIndex() - 1;
        for (int i = 0; i < this.inChar.length; ++i) {
            if (characterIterator.previous() == this.inChar[i]) continue;
            characterIterator.setIndex(n);
            return null;
        }
        return this.outNode;
    }

    @Override
    public final Node nextRestricted(CharacterIterator characterIterator, int n) {
        int n2;
        if (n == 0) {
            return null;
        }
        int n3 = characterIterator.getIndex();
        for (n2 = 0; n2 < this.inChar.length && n != 0; ++n2, --n) {
            if (characterIterator.current() != this.inChar[n2]) {
                characterIterator.setIndex(n3);
                return null;
            }
            characterIterator.next();
        }
        return n2 < this.inChar.length ? null : this.outNode;
    }

    final int match(CharacterIterator characterIterator) {
        int n;
        int n2 = characterIterator.getIndex();
        for (n = 0; n < this.inChar.length && this.inChar[n] == characterIterator.current(); ++n) {
            characterIterator.next();
        }
        characterIterator.setIndex(n2);
        return n;
    }

    @Override
    public final Node next(char c) {
        return null;
    }

    @Override
    public final int num_trans() {
        return 1;
    }

    @Override
    public final Node get_trans(int n) {
        if (n == 0) {
            return this.outNode;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public char get_char(int n) {
        return this.inChar[n];
    }

    @Override
    public String get_chars(int n) {
        return new String(this.inChar);
    }

    @Override
    public final void set_trans(int n, Node node) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.outNode = node;
    }

    @Override
    public final void process_glosses(GlossProcessor glossProcessor) throws DLTException {
    }

    @Override
    public int addChar(char c, int n, Node node) throws DLTException {
        if (n == 0x40000000) {
            this.outNode = node;
        }
        throw new DLTException(Messages.getString("notimplement"));
    }

    @Override
    public int removeChar(char c, int n) throws DLTException {
        throw new DLTException(Messages.getString("cannot.removechar"));
    }

    @Override
    public Node dupRemoveChar(char c) throws DLTException {
        throw new DLTException(Messages.getString("cannot.dupremove"));
    }

    @Override
    public int num_chars() {
        return this.inChar.length;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public void copy(Node node) {
        if (node instanceof NodeChain) {
            NodeChain nodeChain = (NodeChain)node;
            this.outNode = nodeChain.outNode;
            this.inChar = new char[nodeChain.inChar.length];
            System.arraycopy(nodeChain.inChar, 0, this.inChar, 0, nodeChain.inChar.length);
            return;
        }
        throw new IllegalArgumentException(Messages.getString("cannot.copy"));
    }

    @Override
    public int add(CharacterIterator characterIterator, int n, int n2, Node node) throws DLTException {
        switch (n2) {
            case 0x40000000: {
                for (int i = 0; i < this.inChar.length; ++i) {
                    char c = characterIterator.current();
                    if (c != this.inChar[i]) {
                        throw new DLTException(Messages.getString("cannot.replacestring"));
                    }
                    characterIterator.next();
                }
                this.outNode = node;
                return 0;
            }
            case -2147483648: 
            case 0: {
                char c;
                int n3;
                if (this.inChar == null || n != this.inChar.length) {
                    this.inChar = new char[n];
                }
                for (n3 = 0; n3 < n && (c = characterIterator.current()) != '\uffff'; ++n3) {
                    this.inChar[n3] = c;
                    characterIterator.next();
                }
                this.outNode = node;
                return n -= n3;
            }
        }
        throw new DLTException(Messages.getString("error.hintvalue"));
    }

    @Override
    public GlossCollection getGloss() {
        return null;
    }

    @Override
    public void setGloss(Object object) {
        throw new IllegalArgumentException(Messages.getString("cannot.setgloss"));
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void deallocate() {
    }

    @Override
    public void dispose() {
    }
}

