/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.PolymorphicNode;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NodeHashIndex {
    private final Map<Object, Integer> _glossCollections = new HashMap<Object, Integer>();
    private final Collection<GlossCollection> _glossCollectionsList = new ArrayList<GlossCollection>();
    private final Map<Node, Integer> _nodes = new HashMap<Node, Integer>();
    private final Collection<Node> _nodesList = new ArrayList<Node>();
    private final Node _first;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public NodeHashIndex(Node node) {
        this._first = node;
        this.processNode(node);
    }

    public int getNodeCount() {
        return this._nodes.size();
    }

    public int getGlossCollectionCount() {
        return this._glossCollections.size();
    }

    private void processNode(Node node) {
        Object object;
        if (node == null) {
            return;
        }
        if (this._nodes.containsKey(node)) {
            return;
        }
        this._nodes.put(node, this._nodes.size());
        this._nodesList.add(node);
        if (node.isFinal() && !this._glossCollections.containsKey(object = this.getNodeGlossCollectionKey(node))) {
            this._glossCollections.put(object, this._glossCollections.size());
            this._glossCollectionsList.add(node.getGloss());
        }
        for (int i = 0; i < node.num_trans(); ++i) {
            this.processNode(node.get_trans(i));
        }
    }

    private Object getNodeGlossCollectionKey(Node node) {
        return node.getGloss();
    }

    public void write_nodes(DataOutput dataOutput, int n) throws Exception {
        this.writeNodeDetails(dataOutput, this._first, n);
        for (Node node : this._nodesList) {
            if (node == this._first) continue;
            this.writeNodeDetails(dataOutput, node, n);
        }
    }

    public int write_gloss_header(DataOutput dataOutput, GlossMapper glossMapper) throws Exception {
        int n = 0;
        int n2 = this.getGlossCollectionsSize();
        dataOutput.writeInt(n2);
        n += 4;
        for (GlossCollection glossCollection : this._glossCollectionsList) {
            n += (glossCollection.writeGlossCollectionDetails(dataOutput, glossMapper) + 1) * 4;
        }
        dataOutput.writeInt(-84230466);
        return n += 4;
    }

    private int getGlossCollectionsSize() {
        int n = 0;
        for (GlossCollection glossCollection : this._glossCollectionsList) {
            n += glossCollection.size();
        }
        return n;
    }

    public static int newHash(int n) {
        if (n == 0) {
            return n;
        }
        int n2 = --n / 3;
        return 4 * n2 + 1 + n % 3;
    }

    private int getNodeGlossCollectionHash(Node node) {
        Object object = this.getNodeGlossCollectionKey(node);
        int n = this._glossCollections.get(object);
        return NodeHashIndex.newHash(n);
    }

    private void writeNodeDetails(DataOutput dataOutput, Node node, int n) throws Exception {
        int n2 = 9;
        if (node instanceof PolymorphicNode) {
            n2 = ((PolymorphicNode)node).getType();
        }
        boolean bl = node.isFinal();
        dataOutput.writeByte(2);
        dataOutput.writeByte((byte)n2);
        dataOutput.writeByte((byte)(bl ? 1 : 0));
        dataOutput.writeByte(0);
        int n3 = n2 == 4 ? node.num_chars() : node.num_trans();
        dataOutput.writeShort((short)n3);
        switch (n2) {
            case 1: 
            case 2: {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    dataOutput.writeShort(node.get_char(n4));
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    Node node2 = node.get_trans(n4);
                    Integer n5 = this._nodes.get(node2);
                    int n6 = n5 != null ? n5 : 0;
                    dataOutput.writeInt(n + n6);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 65536; ++i) {
                    Node node3 = node.get_trans(i);
                    int n7 = -1;
                    if (node3 != null) {
                        Integer n8 = this._nodes.get(node3);
                        n7 = n8;
                    }
                    dataOutput.writeInt(n + n7);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n3; ++i) {
                    dataOutput.writeShort(node.get_char(i));
                }
                Node node4 = node.get_trans(0);
                Integer n9 = this._nodes.get(node4);
                int n10 = n9;
                dataOutput.writeInt(n + n10);
                break;
            }
            case 5: {
                int n11 = this.getNodeGlossCollectionHash(node);
                dataOutput.writeInt(n11);
                break;
            }
            case 6: {
                Node node5 = node.get_trans(0);
                Integer n12 = this._nodes.get(node5);
                int n13 = n12;
                dataOutput.writeInt(n + n13);
                int n14 = this.getNodeGlossCollectionHash(node);
                dataOutput.writeInt(n14);
                break;
            }
            case 8: {
                for (int i = 0; i < n3; ++i) {
                    Node node6 = node.get_trans(i);
                    Integer n15 = this._nodes.get(node6);
                    int n16 = n15 != null ? n15 : 0;
                    dataOutput.writeInt(n + n16);
                }
                break;
            }
            default: {
                throw new DLTException(Messages.format("node.type", n2));
            }
        }
    }
}

