/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.WritableNode;
import java.text.CharacterIterator;

public class NodeTable
implements WritableNode {
    public Node[] outNode;
    int size;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public NodeTable() {
        this.outNode = new Node[65536];
        this.size = 0;
    }

    NodeTable(int n) {
        this.outNode = new Node[n];
        this.size = 0;
    }

    @Override
    public final Node next(CharacterIterator characterIterator) {
        Node node;
        char c = characterIterator.current();
        Node node2 = node = c < this.outNode.length ? this.outNode[c] : null;
        if (node != null) {
            characterIterator.next();
        }
        return node;
    }

    @Override
    public final Node previous(CharacterIterator characterIterator) {
        Node node;
        char c = characterIterator.previous();
        Node node2 = node = c < this.outNode.length ? this.outNode[c] : null;
        if (node == null) {
            characterIterator.next();
        }
        return node;
    }

    @Override
    public final Node next(char c) {
        Node node = this.outNode[c];
        return node;
    }

    @Override
    public final void process_glosses(GlossProcessor glossProcessor) {
    }

    @Override
    public final int num_trans() {
        return 65536;
    }

    @Override
    public int num_chars() {
        return 1;
    }

    @Override
    public char get_char(int n) {
        return (char)n;
    }

    @Override
    public String get_chars(int n) {
        return "" + (char)n;
    }

    @Override
    public final Node get_trans(int n) {
        return this.outNode[n];
    }

    @Override
    public final void set_trans(int n, Node node) {
        this.outNode[n] = node;
    }

    @Override
    public int addChar(char c, int n, Node node) throws DLTException {
        if (this.outNode[c] == null) {
            if (n == 0x40000000) {
                throw new IllegalArgumentException(Messages.getString("cannot.replaceentry"));
            }
            ++this.size;
        }
        this.outNode[c] = node;
        return 0;
    }

    @Override
    public int removeChar(char c, int n) throws DLTException {
        if (this.outNode[c] != null) {
            this.outNode[c] = null;
            --this.size;
        }
        return c;
    }

    @Override
    public Node dupRemoveChar(char c) throws DLTException {
        throw new DLTException(Messages.getString("cannot.dupremove"));
    }

    @Override
    public final boolean isFinal() {
        return false;
    }

    @Override
    public void copy(Node node) {
    }

    @Override
    public int add(CharacterIterator characterIterator, int n, int n2, Node node) throws DLTException {
        return 0;
    }

    @Override
    public GlossCollection getGloss() {
        return null;
    }

    @Override
    public void setGloss(Object object) {
        throw new IllegalArgumentException(Messages.getString("cannot.setgloss"));
    }

    @Override
    public Node nextRestricted(CharacterIterator characterIterator, int n) {
        return n > 0 ? this.next(characterIterator) : null;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void deallocate() {
    }

    @Override
    public void dispose() {
    }
}

