/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.Merger;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.NonDeterministicBuildNode;
import com.ibm.dltj.netgeneric.NonDeterministicNodeAdapter;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.netgeneric.RegExBuilder;
import com.ibm.dltj.netgeneric.Statistics;
import com.ibm.dltj.util.SetIndexManipulable;
import com.ibm.dltj.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ParserFilter
implements Initializer,
Statistics {
    public static final int INDEX_UNMAPPED = 1;
    static final int INDEX_RESERVED = 2;
    static final int INDEX_SETID = 3;
    static final int INDEX_FIRST_LINK = 4;
    static final int INTSET_RULE_LIMIT = 31;
    final NetGeneric net;
    SetIndexManipulable sets;
    final Map<String, Integer> types_map;
    int free_index;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public ParserFilter() throws DLTException {
        this.sets = null;
        this.net = NetGenericFactory.create(448061489, 4, this);
        this.net.setPayloadManipulator(3, new IntSetManipulator());
        this.types_map = new HashMap<String, Integer>();
        this.free_index = 4;
        this.net.setTransitionToStringMapper(this);
    }

    public RegExBuilder getRegExBuilder() {
        return this.net.getRegExBuilder();
    }

    public void processRule(int n, RegExBuilder.RegExElement regExElement, RegExBuilder regExBuilder) throws DLTException {
        if (this.sets == null && n >= 31) {
            this.switchToBitSets();
        }
        BitSet bitSet = new BitSet();
        bitSet.set(n);
        regExBuilder.addRegEx(regExElement, NetGeneric.IndexIterator.Root, 3, bitSet);
    }

    private void switchToBitSets() throws DLTException {
        this.sets = new SetIndexManipulable();
        this.net.forAllInstances(3, new NetGeneric.ChangeEncapsulator(){

            @Override
            public int Apply(int n) throws DLTException {
                int n2 = ParserFilter.this.sets.fromIntMask(n + 1);
                ParserFilter.this.sets.reference(n2);
                return n2;
            }
        });
        this.net.setPayloadManipulator(3, this.sets);
    }

    private void switchToIntSets() throws DLTException {
        this.net.forAllInstances(3, new NetGeneric.ChangeEncapsulator(){

            @Override
            public int Apply(int n) throws DLTException {
                BitSet bitSet = ParserFilter.this.sets.getSet(n);
                assert (bitSet.length() < 31);
                int n2 = Utils.intMaskFromBitSet(bitSet);
                return n2 - 1;
            }
        });
        this.net.setPayloadManipulator(3, new IntSetManipulator());
        this.sets = null;
    }

    public void pushFinalsDownstream() throws DLTException {
        class PushFinalsMergerNode
        implements Merger.MergerNode {
            final int node;
            final BitSet gatheredGlosses;
            final BitSet newGlosses;

            public PushFinalsMergerNode(int n, BitSet bitSet) throws DLTException {
                this.node = n;
                if (ParserFilter.this.net.transitionPresent(n, 3)) {
                    BitSet bitSet2 = (BitSet)ParserFilter.this.net.getPayload(n, 3, null);
                    if (bitSet == null) {
                        this.gatheredGlosses = bitSet2;
                        this.newGlosses = bitSet2;
                    } else {
                        this.gatheredGlosses = (BitSet)bitSet.clone();
                        this.gatheredGlosses.or(bitSet2);
                        if (this.gatheredGlosses.equals(bitSet)) {
                            this.newGlosses = null;
                        } else {
                            this.newGlosses = (BitSet)bitSet2.clone();
                            this.newGlosses.andNot(bitSet);
                        }
                    }
                } else {
                    this.gatheredGlosses = bitSet;
                    this.newGlosses = null;
                }
            }

            @Override
            public boolean startCopy() throws DLTException {
                return true;
            }

            @Override
            public int[] gatherLinks() {
                return ParserFilter.this.net.gatherNodeLinks(this.node);
            }

            @Override
            public boolean transitionPresent(int n) {
                return ParserFilter.this.net.transitionPresent(this.node, n);
            }

            @Override
            public Merger.MergerNode getTransition(int n) throws DLTException {
                return new PushFinalsMergerNode(ParserFilter.this.net.transitionValue(this.node, n), this.gatheredGlosses);
            }

            @Override
            public Object transitionValue(int n) throws DLTException {
                assert (n == 3);
                return this.newGlosses;
            }

            @Override
            public void finalizeCopy() {
            }

            @Override
            public int hashCode() {
                int n = 1;
                n = 31 * n + (this.gatheredGlosses == null ? 0 : this.gatheredGlosses.hashCode());
                n = 31 * n + this.node;
                n = 31 * n + (this.newGlosses == null ? 0 : this.newGlosses.hashCode());
                return n;
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                PushFinalsMergerNode pushFinalsMergerNode = (PushFinalsMergerNode)object;
                if (this.gatheredGlosses == null ? pushFinalsMergerNode.gatheredGlosses != null : !this.gatheredGlosses.equals(pushFinalsMergerNode.gatheredGlosses)) {
                    return false;
                }
                if (this.node != pushFinalsMergerNode.node) {
                    return false;
                }
                return !(this.newGlosses == null ? pushFinalsMergerNode.newGlosses != null : !this.newGlosses.equals(pushFinalsMergerNode.newGlosses));
            }
        }
        this.net.transformBranch(NetGeneric.IndexIterator.Root, new PushFinalsMergerNode(this.net.first_base(), null));
    }

    public void duplicateTransitions(int n, BitSet bitSet) throws DLTException {
        class DuplicateTransitionsNode
        implements NonDeterministicBuildNode {
            int node;
            int index;
            DuplicateTransitionsNode duplicated;
            final /* synthetic */ int val$oldCode;
            final /* synthetic */ BitSet val$newCodes;

            public DuplicateTransitionsNode(int n) {
                this.val$oldCode = n2;
                this.val$newCodes = bitSet;
                this.node = n;
            }

            @Override
            public void updateMaxIndex() throws DLTException {
            }

            @Override
            public void startEnumeration() throws DLTException {
                if (ParserFilter.this.net.transitionPresent(this.node, this.val$oldCode)) {
                    this.duplicated = new DuplicateTransitionsNode(ParserFilter.this.net.transitionValue(this.node, this.val$oldCode));
                }
                this.index = 0;
            }

            @Override
            public void endEnumeration() {
            }

            @Override
            public Object getChild() throws DLTException {
                if (this.duplicated != null) {
                    return this.duplicated;
                }
                if (this.index < ParserFilter.this.net.getFirstLinkIndex()) {
                    return ParserFilter.this.net.transitionValue(this.node, this.index);
                }
                return new DuplicateTransitionsNode(ParserFilter.this.net.transitionValue(this.node, this.index));
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public boolean nextTransition() {
                if (this.duplicated != null) {
                    this.index = this.val$newCodes.nextSetBit(this.index + 1);
                    if (this.index >= 0) {
                        return true;
                    }
                    this.duplicated = null;
                    this.index = 0;
                }
                do {
                    ++this.index;
                    if (this.index != ParserFilter.this.net.getMaxIndex()) continue;
                    return false;
                } while (!ParserFilter.this.net.transitionPresent(this.node, this.index));
                return true;
            }

            @Override
            public boolean startEpsilonEnumeration() throws DLTException {
                return false;
            }

            @Override
            public NonDeterministicBuildNode nextEpsilonTransition() {
                return null;
            }

            public int hashCode() {
                return this.node;
            }

            public boolean equals(Object object) {
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                DuplicateTransitionsNode duplicateTransitionsNode = (DuplicateTransitionsNode)object;
                return this.node == duplicateTransitionsNode.node;
            }
        }
        this.net.transformBranch(NetGeneric.IndexIterator.Root, NonDeterministicNodeAdapter.createAdapter(new DuplicateTransitionsNode(this.net.first_base()), this.net));
    }

    public MatchSession createMatchSession() {
        return this.sets == null ? new MatchSessionInts() : new MatchSessionBitSets();
    }

    public void save(DataOutput dataOutput) throws IOException, DLTException {
        dataOutput.writeInt(this.free_index);
        for (int i = 4; i < this.free_index; ++i) {
            dataOutput.writeUTF(this.invertType(i));
        }
        if (this.sets != null) {
            this.sets.save(dataOutput);
        } else {
            dataOutput.writeInt(-1);
        }
        NetGenericFactory.save(dataOutput, this.net);
    }

    public ParserFilter(DataInput dataInput) throws IOException, DLTException {
        Object object;
        int n;
        this.types_map = new HashMap<String, Integer>();
        this.free_index = dataInput.readInt();
        for (n = 4; n < this.free_index; ++n) {
            object = dataInput.readUTF();
            this.types_map.put((String)object, n);
        }
        n = dataInput.readInt();
        if (n >= 0) {
            this.sets = new SetIndexManipulable();
            object = this.sets;
            this.sets.load(dataInput, n);
        } else {
            this.sets = null;
            object = new IntSetManipulator();
        }
        this.net = NetGenericFactory.load(dataInput, 4, this.free_index, this);
        this.net.setPayloadManipulator(3, (PayloadManipulator)object);
        if (this.sets != null && this.sets.getHighestRule() < 31) {
            this.switchToIntSets();
        }
        this.net.setTransitionToStringMapper(this);
    }

    @Override
    public void endModify() {
        this.net.endModify();
        if (this.sets != null) {
            this.sets.endModify();
        }
    }

    @Override
    public void reset() {
        this.net.reset();
        if (this.sets != null) {
            this.sets.reset();
        }
        this.types_map.clear();
        this.free_index = 4;
    }

    @Override
    public void startModify() throws DLTException {
        this.net.startModify();
        if (this.sets != null) {
            this.sets.startModify();
        }
    }

    private int addType(String string) throws DLTException {
        this.types_map.put(string, this.free_index++);
        this.net.setMaxIndex(this.free_index);
        return this.free_index - 1;
    }

    public int translateType(String string) {
        Integer n = this.types_map.get(string);
        if (n != null) {
            return n;
        }
        return 1;
    }

    public int translateTypeAdding(String string) throws DLTException {
        Integer n = this.types_map.get(string);
        if (n != null) {
            return n;
        }
        return this.addType(string);
    }

    String invertType(int n) {
        for (Map.Entry<String, Integer> entry : this.types_map.entrySet()) {
            if (entry.getValue() != n) continue;
            return entry.getKey();
        }
        return null;
    }

    String invertTypes(BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 91;
        for (Map.Entry<String, Integer> entry : this.types_map.entrySet()) {
            if (!bitSet.get(entry.getValue())) continue;
            stringBuilder.append((char)n);
            stringBuilder.append(entry.getKey());
            n = 44;
        }
        if (n == 91) {
            stringBuilder.append((char)n);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Set<Map.Entry<String, Integer>> getTypesSet() {
        return this.types_map.entrySet();
    }

    @Override
    public void dumpNet(PrintStream printStream, int n) {
        this.net.dumpNet(printStream, n);
    }

    @Override
    public boolean dumpNet(PrintStream printStream) {
        return this.net.dumpNet(printStream);
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        this.net.printStatistics(printStream);
    }

    @Override
    public void setTransitionToStringMapper(Statistics statistics) {
    }

    @Override
    public String transitionToString(int n, int n2) {
        if (n >= 4) {
            return this.invertType(n) + "->" + n2;
        }
        return this.net.transitionToString(n, n2);
    }

    @Override
    public boolean verifyConsistency() {
        return this.net.verifyConsistency();
    }

    class IntSetManipulator
    implements PayloadManipulator {
        IntSetManipulator() {
        }

        @Override
        public void dereference(int n) {
        }

        @Override
        public Object getObject(int n) throws DLTException {
            return Utils.bitSetFromIntMask(n + 1);
        }

        @Override
        public int merge(int n, Object object) throws DLTException {
            if (object == null) {
                return n;
            }
            assert (((BitSet)object).length() <= 32);
            return (n + 1 | Utils.intMaskFromBitSet((BitSet)object)) - 1;
        }

        @Override
        public int mergeInternal(int n, int n2) throws DLTException {
            return (n + 1 | n2 + 1) - 1;
        }

        @Override
        public int intersect(int n, Object object) throws DLTException {
            if (object == null) {
                return -1;
            }
            assert (((BitSet)object).length() <= 32);
            return (n + 1 & Utils.intMaskFromBitSet((BitSet)object)) - 1;
        }

        @Override
        public int intersectInternal(int n, int n2) throws DLTException {
            return (n + 1 & n2 + 1) - 1;
        }

        @Override
        public int subtract(int n, Object object) throws DLTException {
            if (object == null) {
                return n;
            }
            assert (((BitSet)object).length() <= 32);
            return (n + 1 & ~Utils.intMaskFromBitSet((BitSet)object)) - 1;
        }

        @Override
        public int subtractInternal(int n, int n2) throws DLTException {
            return (n + 1 & ~(n2 + 1)) - 1;
        }

        @Override
        public int reference(int n) {
            return n;
        }
    }

    final class MatchSessionBitSets
    extends MatchSession {
        BitSet[] states_final;

        MatchSessionBitSets() {
            this.states_final = new BitSet[this.states.length];
            for (int i = 0; i < this.states_final.length; ++i) {
                this.states_final[i] = (BitSet)ParserFilter.this.sets.getSet(-1).clone();
            }
        }

        @Override
        void initializeAsSource(Object object) {
            this.makeSpace(this.active_states);
            this.state_data[this.active_states] = object;
            this.states_end[this.active_states] = this.active_states + 1;
            this.states_final[this.active_states].clear();
            this.states[this.active_states] = ParserFilter.this.net.first_base();
            ++this.active_states;
            this.state_idx = -1;
            this.state_end = 0;
        }

        @Override
        void processTransitions(MatchSession matchSession, ParsingRunner parsingRunner, int[] nArray, int n) throws Exception {
            int n2;
            MatchSessionBitSets matchSessionBitSets = (MatchSessionBitSets)matchSession;
            int n3 = this.state_idx;
            this.makeSpace(this.state_idx);
            BitSet bitSet = this.states_final[n3];
            BitSet bitSet2 = matchSessionBitSets.states_final[matchSessionBitSets.state_idx];
            bitSet.or(bitSet2);
            bitSet.and(bitSet2);
            int n4 = -1;
            for (int i = matchSessionBitSets.state_idx; i < matchSessionBitSets.state_end; ++i) {
                for (n2 = 0; n2 < n; ++n2) {
                    int n5 = ParserFilter.this.net.takeTransition(matchSessionBitSets.states[i], nArray[n2], n4);
                    if (n4 == n5) continue;
                    if (ParserFilter.this.net.transitionPresent(n5, 3)) {
                        bitSet.or(ParserFilter.this.sets.getSet(ParserFilter.this.net.transitionValue(n5, 3)));
                    }
                    this.makeSpace(this.state_idx);
                    this.states[this.state_idx] = n5;
                    ++this.state_idx;
                    n4 = n5;
                }
            }
            this.state_data[n3] = matchSessionBitSets.state_data[matchSessionBitSets.state_idx];
            if (n4 == -1 && !bitSet.isEmpty()) {
                if (this.state_idx == 0) {
                    Object object = this.state_data[0];
                    if (parsingRunner.prepareRun(object)) {
                        n2 = bitSet.nextSetBit(0);
                        while (n2 != -1) {
                            parsingRunner.performRun(n2);
                            n2 = bitSet.nextSetBit(n2 + 1);
                        }
                        parsingRunner.finalizeRun(object);
                    }
                } else {
                    this.states[this.state_idx] = n4;
                }
            }
            this.states_end[n3] = ++this.state_idx;
        }

        private void makeSpace(int n) {
            if (n >= this.states.length) {
                int[] nArray = new int[n + 16];
                System.arraycopy(this.states, 0, nArray, 0, this.states.length);
                this.states = nArray;
                int[] nArray2 = new int[n + 16];
                System.arraycopy(this.states_end, 0, nArray2, 0, this.states_end.length);
                this.states_end = nArray2;
                BitSet[] bitSetArray = new BitSet[n + 16];
                System.arraycopy(this.states_final, 0, bitSetArray, 0, this.states_final.length);
                for (int i = this.states_final.length; i < bitSetArray.length; ++i) {
                    bitSetArray[i] = (BitSet)ParserFilter.this.sets.getSet(-1).clone();
                }
                this.states_final = bitSetArray;
                Object[] objectArray = new Object[n + 16];
                System.arraycopy(this.state_data, 0, objectArray, 0, this.state_data.length);
                this.state_data = objectArray;
            }
        }
    }

    final class MatchSessionInts
    extends MatchSession {
        int[] states_final;

        MatchSessionInts() {
            this.states_final = new int[this.states.length];
        }

        @Override
        void initializeAsSource(Object object) {
            this.makeSpace(this.active_states);
            this.state_data[this.active_states] = object;
            this.states_end[this.active_states] = this.active_states + 1;
            this.states_final[this.active_states] = 0;
            this.states[this.active_states] = ParserFilter.this.net.first_base();
            ++this.active_states;
            this.state_idx = -1;
            this.state_end = 0;
        }

        @Override
        void processTransitions(MatchSession matchSession, ParsingRunner parsingRunner, int[] nArray, int n) throws Exception {
            int n2;
            int n3;
            MatchSessionInts matchSessionInts = (MatchSessionInts)matchSession;
            int n4 = this.state_idx;
            this.makeSpace(this.state_idx);
            int n5 = matchSessionInts.states_final[matchSessionInts.state_idx];
            int n6 = -1;
            for (int i = matchSessionInts.state_idx; i < matchSessionInts.state_end; ++i) {
                for (n3 = 0; n3 < n; ++n3) {
                    n2 = ParserFilter.this.net.takeTransition(matchSessionInts.states[i], nArray[n3], n6);
                    if (n6 == n2) continue;
                    n5 |= ParserFilter.this.net.takeTransition(n2, 3, -1) + 1;
                    this.makeSpace(this.state_idx);
                    this.states[this.state_idx] = n2;
                    ++this.state_idx;
                    n6 = n2;
                }
            }
            this.state_data[n4] = matchSessionInts.state_data[matchSessionInts.state_idx];
            this.states_final[n4] = n5;
            if (n6 == -1 && n5 != 0) {
                if (this.state_idx == 0) {
                    Object object = this.state_data[0];
                    if (parsingRunner.prepareRun(object)) {
                        n3 = Utils.trailingZeroCnt(n5);
                        n2 = 0;
                        while (n3 != -1) {
                            parsingRunner.performRun(n2 += n3);
                            n3 = Utils.trailingZeroCnt(n5 >>> ++n2);
                        }
                        parsingRunner.finalizeRun(object);
                    }
                } else {
                    this.states[this.state_idx] = n6;
                }
            }
            this.states_end[n4] = ++this.state_idx;
        }

        private void makeSpace(int n) {
            if (n >= this.states.length) {
                int[] nArray = new int[n + 16];
                System.arraycopy(this.states, 0, nArray, 0, this.states.length);
                this.states = nArray;
                int[] nArray2 = new int[n + 16];
                System.arraycopy(this.states_end, 0, nArray2, 0, this.states_end.length);
                this.states_end = nArray2;
                int[] nArray3 = new int[n + 16];
                System.arraycopy(this.states_final, 0, nArray3, 0, this.states_final.length);
                this.states_final = nArray3;
                Object[] objectArray = new Object[n + 16];
                System.arraycopy(this.state_data, 0, objectArray, 0, this.state_data.length);
                this.state_data = objectArray;
            }
        }
    }

    public abstract class MatchSession {
        protected int[] states = new int[32];
        protected int[] states_end = new int[32];
        protected Object[] state_data = new Object[32];
        protected int active_states = 0;
        protected int state_idx;
        protected int state_end;

        MatchSession() {
        }

        public void reset() {
            this.active_states = 0;
        }

        abstract void initializeAsSource(Object var1);

        final boolean advanceSource() {
            if (this.state_end >= this.active_states) {
                return false;
            }
            this.state_idx = this.state_end;
            this.state_end = this.states_end[this.state_idx];
            return true;
        }

        public void processTransitions(int[] nArray, int n, Object object, MatchSession matchSession, ParsingRunner parsingRunner) throws Exception {
            matchSession.initializeAsSource(object);
            this.state_idx = 0;
            while (matchSession.advanceSource()) {
                this.processTransitions(matchSession, parsingRunner, nArray, n);
            }
            this.active_states = this.state_idx;
        }

        abstract void processTransitions(MatchSession var1, ParsingRunner var2, int[] var3, int var4) throws Exception;
    }

    public static interface ParsingRunner {
        public boolean prepareRun(Object var1);

        public void performRun(int var1) throws Exception;

        public void finalizeRun(Object var1) throws Exception;
    }
}

