/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.NodeTable;
import com.ibm.dltj.fst.WritableNode;
import java.text.CharacterIterator;

abstract class TransitionList
implements WritableNode {
    public char[] inChar;
    public Node[] outNode;
    transient int size = 0;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    TransitionList(int n) {
        this.inChar = new char[n];
        this.outNode = new Node[n];
    }

    @Override
    public final int num_trans() {
        return this.size;
    }

    @Override
    public final Node get_trans(int n) {
        return n >= 0 && n < this.size ? this.outNode[n] : null;
    }

    @Override
    public final char get_char(int n) {
        return n >= 0 && n < this.size ? this.inChar[n] : (char)'\u0000';
    }

    @Override
    public final String get_chars(int n) {
        return "" + this.get_char(n);
    }

    @Override
    public final void set_trans(int n, Node node) {
        if (n >= 0 && n < this.size) {
            this.outNode[n] = node;
        }
    }

    @Override
    public final int add(CharacterIterator characterIterator, int n, int n2, Node node) throws DLTException {
        if (n <= 0) {
            throw new IllegalArgumentException(Messages.getString("length.nonpositive"));
        }
        this.addChar(characterIterator.current(), n2, node);
        characterIterator.next();
        if (n2 != 0x40000000) {
            --n;
        }
        return n;
    }

    private int ceil_x_size(int n) {
        return n + 1 & 0xFFFFFFFE;
    }

    public final void addOne(int n) {
        if (this.outNode.length == this.size) {
            int n2 = this.ceil_x_size(this.size + 1);
            char[] cArray = this.inChar;
            this.inChar = new char[n2];
            System.arraycopy(cArray, 0, this.inChar, 0, n);
            System.arraycopy(cArray, n, this.inChar, n + 1, this.size - n);
            Node[] nodeArray = this.outNode;
            this.outNode = new Node[n2];
            System.arraycopy(nodeArray, 0, this.outNode, 0, n);
            System.arraycopy(nodeArray, n, this.outNode, n + 1, this.size - n);
        } else {
            System.arraycopy(this.inChar, n, this.inChar, n + 1, this.size - n);
            System.arraycopy(this.outNode, n, this.outNode, n + 1, this.size - n);
        }
        ++this.size;
    }

    public final void removeOne(int n) {
        int n2 = this.ceil_x_size(this.size - 1);
        if (this.outNode.length != n2) {
            char[] cArray = this.inChar;
            this.inChar = new char[n2];
            System.arraycopy(cArray, 0, this.inChar, 0, n);
            System.arraycopy(cArray, n + 1, this.inChar, n, this.size - n - 1);
            Node[] nodeArray = this.outNode;
            this.outNode = new Node[n2];
            System.arraycopy(nodeArray, 0, this.outNode, 0, n);
            System.arraycopy(nodeArray, n + 1, this.outNode, n, this.size - n - 1);
        } else {
            System.arraycopy(this.inChar, n + 1, this.inChar, n, this.size - n - 1);
            System.arraycopy(this.outNode, n + 1, this.outNode, n, this.size - n - 1);
        }
        --this.size;
    }

    @Override
    public final int num_chars() {
        return 1;
    }

    @Override
    public void copy(Node node) throws DLTException {
        this.size = 0;
        if (node instanceof TransitionList) {
            int n = node.num_trans();
            for (int i = 0; i < n; ++i) {
                this.addChar(node.get_char(i), 0x40000000, node.get_trans(i));
            }
            return;
        }
        if (node instanceof NodeTable) {
            this.size = node.num_trans();
            this.inChar = new char[this.size];
            this.outNode = new Node[this.size];
            int n = 0;
            for (int i = 0; i < 65536; ++i) {
                Node node2 = node.get_trans(i);
                if (node2 == null) continue;
                this.inChar[n] = node.get_char(i);
                this.outNode[n++] = node2;
            }
            return;
        }
        throw new IllegalArgumentException(Messages.getString("cannot.copy"));
    }

    @Override
    public Node nextRestricted(CharacterIterator characterIterator, int n) {
        return n > 0 ? this.next(characterIterator) : null;
    }

    @Override
    public Node dupRemoveChar(char c) throws DLTException {
        throw new DLTException(Messages.getString("cannot.dupremove"));
    }

    @Override
    public void deallocate() {
    }

    @Override
    public void dispose() {
    }
}

