/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.Net;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.WritableNode;
import com.ibm.dltj.fst._NetIntegerImplBase;
import com.ibm.dltj.gloss.IntegerGloss;
import java.io.DataInput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.util.Iterator;
import java.util.Map;

public class _NetIntegerImpl
extends _NetIntegerImplBase
implements MultiNet {
    private static final int MAX_TEMP_NODES = 100;
    private NodeImpl _free = null;
    private int _freeSize = 0;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    WritableNode allocNode(int n) {
        if (n == -1) {
            return null;
        }
        if (this._free != null) {
            NodeImpl nodeImpl = this._free;
            this._free = nodeImpl.nodeAllocated(n, this);
            --this._freeSize;
            return nodeImpl;
        }
        return new NodeImpl(n, this);
    }

    void freeNode(NodeImpl nodeImpl) {
        if (this._freeSize < 100) {
            nodeImpl.nodeFree(this._free);
            this._free = nodeImpl;
            ++this._freeSize;
        }
    }

    @Override
    public Node first() {
        return this.allocNode(this.first_ptr());
    }

    @Override
    public long readContents(DataInput dataInput, int n) throws DLTException, IOException {
        if (dataInput.readInt() != -1161904401) {
            throw new DLTException(Messages.getString("error.dict.signature"));
        }
        int n2 = dataInput.readInt();
        dataInput.readInt();
        this.readFSAContents(dataInput, n2 / 4, (n & 4) != 0);
        int n3 = this.readGlosses(dataInput);
        int n4 = dataInput.readInt();
        while (n4 == -1) {
            n4 = dataInput.readInt();
        }
        if (n4 != -84230466) {
            throw new DLTException(Messages.getString("error.marker"));
        }
        return n3;
    }

    protected int readGlosses(DataInput dataInput) throws IOException, DLTException {
        int n;
        GlossCollection glossCollection;
        for (int i = n = dataInput.readInt(); i > 0; i -= glossCollection.readGlossCollectionDetails(dataInput, this.ownerDictionary)) {
            glossCollection = new GlossCollection();
            this.addGloss(glossCollection);
        }
        return n;
    }

    void setGloss(int n, Object object) throws DLTException {
        this.setGlossIdx(n, this.addGloss(object));
    }

    @Override
    public void setChainPolicy(boolean bl) {
        this.enchain = bl;
    }

    @Override
    public boolean getChainPolicy() {
        return this.enchain;
    }

    @Override
    public boolean isContracted() {
        return this.contracted;
    }

    @Override
    public boolean isModifiable() {
        return !this.isContracted();
    }

    @Override
    public int getFileFSTFormat() {
        return this.fileFstFormat;
    }

    @Override
    public void processGlosses(GlossProcessor glossProcessor) throws DLTException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void endReading() {
    }

    @Override
    public void startBuild(boolean bl) {
    }

    @Override
    public int endBuild() {
        return 0;
    }

    @Override
    public int remove(CharacterIterator characterIterator, int n) throws DLTException {
        int n2;
        int n3;
        int n4;
        int n5 = characterIterator.getIndex();
        int n6 = n5 + n;
        if (characterIterator.current() == '\uffff') {
            return 0;
        }
        int n7 = this.first_ptr();
        int n8 = this.first_ptr();
        int n9 = -1;
        int n10 = -1;
        int n11 = this.getType(n7);
        int n12 = -1;
        int n13 = characterIterator.getIndex();
        int n14 = n5;
        while (characterIterator.getIndex() < n6) {
            n4 = characterIterator.getIndex();
            n3 = this.next_restricted(n7, characterIterator, n6);
            if (n3 == -1) {
                return 0;
            }
            n2 = this.getType(n3);
            if (this.num_trans(n7) > 1 || n2 == 6) {
                n8 = n7;
                n13 = n4;
                n9 = n10;
                n14 = n12;
            }
            n12 = n4;
            n10 = n7;
            n7 = n3;
            n11 = n2;
        }
        if (characterIterator.getIndex() != n6 && characterIterator.current() != '\uffff') {
            return 0;
        }
        if (n11 != 6 && n11 != 5) {
            return 0;
        }
        n4 = this.getGlossIdx(n7);
        this.removeGloss(n4);
        if (n11 == 6) {
            n3 = this.get_trans(n7, 0);
            this.deallocate(n7);
            characterIterator.previous();
            this.replace(n8, characterIterator, n6, n3);
            return 1;
        }
        characterIterator.setIndex(n13);
        n3 = this.next_restricted(n8, characterIterator, n6);
        if (this.getType(n3) == 6) {
            n2 = this.getGlossIdx(n3);
            int n15 = this.new_node(5, 0);
            this.setGlossIdx(n15, n2);
            characterIterator.setIndex(n13);
            this.replace(n8, characterIterator, n6, n15);
        } else {
            characterIterator.setIndex(n13);
            n2 = this.dupRemoveChar(n8, characterIterator.current());
            if (n8 == this.first_ptr()) {
                this.first_node = n2;
            } else {
                characterIterator.setIndex(n14);
                this.replace(n9, characterIterator, n6, n2);
            }
            this.deallocate(n8);
        }
        while (n3 != -1) {
            if (this.num_trans(n3) > 1) {
                throw new DLTException(Messages.getString("error.network"));
            }
            n2 = this.get_trans(n3, 0);
            this.deallocate(n3);
            n3 = n2;
        }
        return 1;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Net.WordIterator(this.first());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iteratorAC(String string) {
        return new Net.WordIterator(this.first(), string, true);
    }

    @Override
    public void removeGloss(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        if (gloss == null) {
            this.remove(characterIterator, n);
            return;
        }
        if (this.contracted) {
            throw new IllegalStateException(Messages.getString("wrong.call"));
        }
        int n2 = characterIterator.getIndex();
        int n3 = this.getFinalNode(characterIterator, n);
        if (n3 == -1 || !this.isFinal(n3)) {
            return;
        }
        if (this.processRemove(n3, gloss)) {
            characterIterator.setIndex(n2);
            this.remove(characterIterator, n);
        }
    }

    @Override
    GlossCollection getGlossByIdx(int n) {
        return new GlossCollection(new IntegerGloss(n));
    }

    @Override
    GlossCollection getGlossForNode(int n) {
        return this.getGlossByIdx(this.getGlossIdx(n));
    }

    int addGloss(Object object) throws DLTException {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return n;
        }
        throw new DLTException(Messages.getString("wrong.call"));
    }

    void removeGloss(int n) {
        throw new IllegalStateException(Messages.getString("wrong.call"));
    }

    @Override
    void processExisting(int n, Object object) throws DLTException {
        if (!(object instanceof Integer)) {
            throw new DLTException(Messages.getString("wrong.call"));
        }
        int n2 = (Integer)object;
        this.setGlossIdx(n, n2);
    }

    @Override
    void processNew(int n, Object object) throws DLTException {
        if (!(object instanceof Integer)) {
            throw new DLTException(Messages.getString("wrong.call"));
        }
        int n2 = (Integer)object;
        this.setGlossIdx(n, n2);
    }

    boolean processRemove(int n, Object object) throws DLTException {
        if (object instanceof Integer) {
            return true;
        }
        throw new DLTException(Messages.getString("wrong.call"));
    }

    @Override
    public WritableNode newNode(int n, int n2) {
        return this.allocNode(this.new_node(n, n2));
    }

    @Override
    public void setFirstNode(Node node) throws DLTException {
        if (!(node instanceof NodeImpl)) {
            throw new DLTException(Messages.getString("wrong.call"));
        }
        this.first_node = ((NodeImpl)node).getPNode();
    }

    @Override
    boolean glossesEqual(int n, int n2) {
        return n == n2;
    }

    @Override
    int glossHash(int n) {
        return n + 17;
    }

    @Override
    public MultiNet getMultiNet() {
        return this;
    }

    private static class NodeImpl
    implements WritableNode {
        private int pnode;
        private _NetIntegerImpl _net;
        private NodeImpl _nextFree;

        NodeImpl(int n, _NetIntegerImpl _NetIntegerImpl2) {
            this.pnode = n;
            this._net = _NetIntegerImpl2;
        }

        int getPNode() {
            return this.pnode;
        }

        void nodeFree(NodeImpl nodeImpl) {
            this._nextFree = nodeImpl;
            this._net = null;
        }

        NodeImpl nodeAllocated(int n, _NetIntegerImpl _NetIntegerImpl2) {
            this.pnode = n;
            this._net = _NetIntegerImpl2;
            NodeImpl nodeImpl = this._nextFree;
            this._nextFree = null;
            return nodeImpl;
        }

        @Override
        public Node next(char c) {
            return this._net.allocNode(this._net.next(this.pnode, c));
        }

        @Override
        public Node next(CharacterIterator characterIterator) {
            return this._net.allocNode(this._net.next(this.pnode, characterIterator));
        }

        @Override
        public Node previous(CharacterIterator characterIterator) {
            return this._net.allocNode(this._net.previous(this.pnode, characterIterator));
        }

        @Override
        public int num_trans() {
            return this._net.num_trans(this.pnode);
        }

        @Override
        public int num_chars() {
            return this._net.num_chars(this.pnode);
        }

        @Override
        public Node get_trans(int n) {
            return this._net.allocNode(this._net.get_trans(this.pnode, n));
        }

        @Override
        public char get_char(int n) {
            return this._net.get_char(this.pnode, n);
        }

        @Override
        public String get_chars(int n) {
            return this._net.get_chars(this.pnode, n);
        }

        @Override
        public void set_trans(int n, Node node) throws DLTException {
            if (!(node instanceof NodeImpl)) {
                throw new IllegalStateException(Messages.getString("cannot.usefunction"));
            }
            this._net.set_trans(this.pnode, n, ((NodeImpl)node).pnode);
        }

        @Override
        public void process_glosses(GlossProcessor glossProcessor) throws DLTException {
            Object object = glossProcessor.process(this._net.getGlossForNode(this.pnode));
            this._net.setGloss(this.pnode, object);
        }

        @Override
        public int addChar(char c, int n, Node node) throws DLTException {
            if (node instanceof NodeImpl) {
                return this._net.addChar(this.pnode, c, n, ((NodeImpl)node).pnode);
            }
            throw new IllegalStateException(Messages.getString("cannot.usefunction"));
        }

        @Override
        public int add(CharacterIterator characterIterator, int n, int n2, Node node) throws DLTException {
            if (node instanceof NodeImpl) {
                return this._net.add(this.pnode, characterIterator, ((NodeImpl)node).pnode);
            }
            throw new IllegalStateException(Messages.getString("cannot.usefunction"));
        }

        @Override
        public int removeChar(char c, int n) throws DLTException {
            return this._net.removeChar(this.pnode, c, n);
        }

        @Override
        public Node dupRemoveChar(char c) throws DLTException {
            return this._net.allocNode(this._net.dupRemoveChar(this.pnode, c));
        }

        @Override
        public void deallocate() {
            this.removeExistingGloss();
            this._net.deallocate(this.pnode);
            this.pnode = -1;
        }

        private void removeExistingGloss() {
            int n;
            if (this.isFinal() && (n = this._net.getGlossIdx(this.pnode)) >= 0) {
                this._net.removeGloss(n);
            }
        }

        @Override
        public boolean isFinal() {
            int n = this._net.getType(this.pnode);
            return n == 5 || n == 6;
        }

        @Override
        public void copy(Node node) throws DLTException {
            if (node instanceof NodeImpl) {
                throw new DLTException(Messages.getString("notimplement"));
            }
            throw new DLTException(Messages.getString("notimplement"));
        }

        @Override
        public GlossCollection getGloss() {
            if (this.isFinal()) {
                return this._net.getGlossForNode(this.pnode);
            }
            return null;
        }

        @Override
        public void setGloss(Object object) throws DLTException {
            this.removeExistingGloss();
            this._net.setGloss(this.pnode, object);
        }

        @Override
        public Node nextRestricted(CharacterIterator characterIterator, int n) {
            return this._net.allocNode(this._net.next_restricted(this.pnode, characterIterator, characterIterator.getIndex() + n));
        }

        @Override
        public int getType() {
            return this._net.getType(this.pnode);
        }

        public int hashCode() {
            return this.pnode;
        }

        public boolean equals(Object object) {
            return ((NodeImpl)object).pnode == this.pnode;
        }

        @Override
        public void dispose() {
            this.pnode = -1;
            this._net.freeNode(this);
        }
    }
}

