/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractByteVectorGloss
extends Gloss {
    public byte[] value;
    public int rtData;
    private static final byte[] EMPTY = new byte[0];

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public AbstractByteVectorGloss() {
        this.value = EMPTY;
    }

    public AbstractByteVectorGloss(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.value = byArray;
    }

    public void read_(DataInputStream dataInputStream, int n) throws IOException {
        this.rtData = dataInputStream.readInt();
        this.value = new byte[n];
        dataInputStream.readFully(this.value);
    }

    public void write_(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.value.length);
        dataOutputStream.writeInt(this.rtData);
        dataOutputStream.write(this.value);
    }

    public final int hashCode_() {
        return this.value.hashCode();
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }

    public int getRtData() {
        return this.rtData;
    }

    public int setRtData(int n) {
        this.rtData = n;
        return this.rtData;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AbstractByteVectorGloss && Arrays.equals(((AbstractByteVectorGloss)object).value, this.value);
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.value.length; ++i) {
            n = 31 * n + this.value[i];
        }
        return n;
    }
}

