/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public abstract class AbstractGlossVectorGloss
extends Gloss {
    public Gloss[] element = EMPTY;
    public int rtData = 0;
    private static final Gloss[] EMPTY = new Gloss[0];

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public AbstractGlossVectorGloss() {
    }

    public AbstractGlossVectorGloss(Gloss[] glossArray) throws DLTException {
        if (glossArray == null) {
            return;
        }
        for (int i = 0; i < glossArray.length; ++i) {
            Gloss gloss = glossArray[i];
            if (gloss != null) continue;
            throw new DLTException(Messages.getString("error.gloss.null"));
        }
        this.element = new Gloss[glossArray.length];
        System.arraycopy(glossArray, 0, this.element, 0, glossArray.length);
    }

    @Override
    public int numChildren() {
        return this.element.length;
    }

    @Override
    public Gloss getChild(int n) {
        return this.element[n];
    }

    @Override
    public void setChild(int n, Gloss gloss) {
        if (n > -1 && n < this.element.length) {
            this.element[n] = gloss;
            return;
        }
        throw new IllegalArgumentException();
    }

    public void read_(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        if (n < 0) {
            throw new DLTException(Messages.getString("error.streamformat"));
        }
        this.element = new Gloss[n];
        this.rtData = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.element[i] = new MapperGloss(dataInputStream.readInt());
        }
    }

    public void write_(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.element.length);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.element.length; ++i) {
            int n2 = glossMapper.getGlossIndex(this.element[i]);
            dataOutputStream.writeInt(n2);
        }
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        if (this.element != null && this.element.length > 0 && this.element[0] instanceof MapperGloss) {
            for (int i = 0; i < this.element.length; ++i) {
                this.element[i] = glossArray[((MapperGloss)this.element[i]).map];
            }
        }
    }

    public int hashCode_() {
        int n = 17;
        for (int i = 0; i < this.element.length; ++i) {
            Gloss gloss = this.element[i];
            if (gloss == null) continue;
            n += gloss.hashCode();
        }
        return n;
    }

    @Override
    public int hashCode() {
        return this.hashCode_();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractGlossVectorGloss)) {
            return false;
        }
        AbstractGlossVectorGloss abstractGlossVectorGloss = (AbstractGlossVectorGloss)object;
        if (this.element.length != abstractGlossVectorGloss.element.length) {
            return false;
        }
        boolean[] blArray = new boolean[this.element.length];
        for (int i = 0; i < this.element.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.element.length; ++j) {
                Gloss gloss = this.element[i];
                if (blArray[j] || !gloss.equals(abstractGlossVectorGloss.element[j])) continue;
                blArray[j] = true;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSimilar(Object object) {
        if (!(object instanceof AbstractGlossVectorGloss)) {
            return false;
        }
        AbstractGlossVectorGloss abstractGlossVectorGloss = (AbstractGlossVectorGloss)object;
        if (this.element.length != abstractGlossVectorGloss.element.length) {
            return false;
        }
        boolean[] blArray = new boolean[this.element.length];
        for (int i = 0; i < this.element.length; ++i) {
            boolean bl = false;
            Gloss gloss = this.element[i];
            for (int j = 0; j < this.element.length; ++j) {
                if (blArray[j] || !gloss.isSimilar(abstractGlossVectorGloss.element[j])) continue;
                blArray[j] = true;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public Gloss mergeGloss(Object object) {
        Object object2;
        if (object.getClass() != this.getClass()) {
            return this;
        }
        ArrayList<Gloss> arrayList = new ArrayList<Gloss>();
        AbstractGlossVectorGloss abstractGlossVectorGloss = (AbstractGlossVectorGloss)object;
        if (this.element.length != abstractGlossVectorGloss.element.length) {
            return this;
        }
        boolean[] blArray = new boolean[this.element.length];
        for (int i = 0; i < this.element.length; ++i) {
            boolean bl = false;
            object2 = this.element[i];
            for (int j = 0; j < this.element.length; ++j) {
                if (blArray[j] || !((Gloss)object2).isSimilar(abstractGlossVectorGloss.element[j])) continue;
                blArray[j] = true;
                bl = true;
                arrayList.add(((Gloss)object2).mergeGloss(abstractGlossVectorGloss.element[j]));
                break;
            }
            if (bl) continue;
            arrayList.add((Gloss)object2);
        }
        Gloss[] glossArray = new Gloss[arrayList.size()];
        arrayList.toArray(glossArray);
        Class<?> clazz = this.getClass();
        try {
            object2 = clazz.getConstructor(Gloss[].class);
            return (Gloss)((Constructor)object2).newInstance(new Object[]{glossArray});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return this;
    }

    protected Gloss[] applyProcessorToElements(GlossProcessor glossProcessor) throws DLTException {
        boolean bl = false;
        int n = 0;
        Gloss[] glossArray = new Gloss[this.element.length];
        for (int i = 0; i < this.element.length; ++i) {
            glossArray[i] = this.element[i].applyGlossProcessor(glossProcessor);
            bl = bl || glossArray[i] != this.element[i];
            n += glossArray[i] == null ? 1 : 0;
        }
        if (n > 0) {
            Gloss[] glossArray2 = new Gloss[this.element.length - n];
            int n2 = 0;
            for (int i = 0; i < glossArray.length; ++i) {
                if (glossArray[i] == null) continue;
                glossArray2[n2++] = glossArray[i];
            }
            return glossArray2;
        }
        return bl ? glossArray : this.element;
    }

    @Deprecated
    public int getRtData() {
        return this.rtData;
    }

    @Deprecated
    public void setRtData(int n) {
        this.rtData = n;
    }

    public final Gloss getGloss(Class<? extends Gloss> clazz) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i].getClass() != clazz) continue;
            return this.element[i];
        }
        return null;
    }

    public Gloss getGloss(int n) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i].getType() != n) continue;
            return this.element[i];
        }
        return null;
    }
}

