/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.AbstractCharVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.util.CharacterMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public abstract class BasicCutPasteGloss
extends AbstractCharVectorGloss
implements LemmaGenerator {
    private byte conv;
    private byte options;
    private short cut;
    private Converter converter = null;
    public static final byte DLT_CASE_CONV_NOCONV = 0;
    public static final byte DLT_CASE_CONV_TOLOWER = 1;
    public static final byte DLT_CASE_CONV_TOUPPER = 2;
    public static final byte DLT_CASE_CONV_CAPITALIZE = 3;
    public static final byte DLT_FUZZY_CASE_SS_IS_ONE_CHAR = 1;
    public static final byte DLT_FUZZY_CASE_FIRST_CHAR_ONLY = 2;
    public static final byte DLT_FUZZY_CASE_TURKISH = 64;
    private static final Converter[] CONV_METHODS = new Converter[]{new ToLowerConverter(), new CapitalizeConverter(), new ToUpperConverter(), new ToLowerConverterOpt(1), new CapitalizeConverterOpt(1), new ToUpperConverterOpt(1), new ToLowerConverterOpt(64), new CapitalizeConverterOpt(64), new ToUpperConverterOpt(64), new NoConvConverter()};

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    BasicCutPasteGloss() {
        this.cut = 0;
        this.conv = 0;
        this.options = 0;
        this.converter = CONV_METHODS[CONV_METHODS.length - 1];
    }

    BasicCutPasteGloss(String string, String string2) {
        this.calcBestMethod(string, string2);
    }

    private void calcBestMethod(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        Converter converter = CONV_METHODS[0];
        int n2 = -1;
        int n3 = -1;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < CONV_METHODS.length; ++i) {
            Converter converter2;
            block4: {
                converter2 = CONV_METHODS[i];
                stringCharacterIterator.setIndex(0);
                stringBuilder.setLength(0);
                try {
                    converter2.process(stringCharacterIterator, stringCharacterIterator.getEndIndex(), 0, stringBuilder);
                }
                catch (DLTException dLTException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            int n4 = BasicCutPasteGloss.findDifferentPosition(string2, stringBuilder);
            if (n3 < n4) {
                converter = converter2;
                n2 = stringBuilder.length();
                n3 = n4;
            }
            if (n4 == n) break;
        }
        this.conv = converter.getConv();
        this.options = converter.getFlags();
        this.value = string2.substring(n3).intern();
        this.converter = converter;
        this.cut = (short)(n2 - n3);
    }

    BasicCutPasteGloss(String string, int n, byte by, byte by2) {
        this.value = string.intern();
        this.cut = (short)n;
        this.conv = by;
        this.options = by2;
        this.setConverter();
    }

    void setConverter() {
        for (int i = 0; i < CONV_METHODS.length; ++i) {
            if (CONV_METHODS[i].getConv() != this.conv || CONV_METHODS[i].getFlags() != this.options) continue;
            this.converter = CONV_METHODS[i];
            return;
        }
        switch (this.conv) {
            case 3: {
                this.converter = new CapitalizeConverterOpt(this.options);
                break;
            }
            case 0: {
                this.converter = new NoConvConverter();
                break;
            }
            case 2: {
                this.converter = new ToUpperConverterOpt(this.options);
                break;
            }
            case 1: {
                this.converter = new ToLowerConverterOpt(this.options);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static int findDifferentPosition(CharSequence charSequence, CharSequence charSequence2) {
        int n = Math.min(charSequence.length(), charSequence2.length());
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        this.rtData = dataInputStream.readInt();
        short s = dataInputStream.readShort();
        this.conv = (byte)((s & 0xFFFF) >>> 14);
        this.options = (byte)(s & 0xFF);
        this.cut = dataInputStream.readShort();
        StringBuffer stringBuffer = new StringBuffer(n -= 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)dataInputStream.readShort());
        }
        this.value = stringBuffer.toString().intern();
        this.setConverter();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.value.length() + 2);
        dataOutputStream.writeInt(this.rtData);
        int n2 = 0;
        n2 = (this.conv & 0xFFFF) << 14;
        n2 = this.options | n2;
        dataOutputStream.writeShort((short)n2);
        dataOutputStream.writeShort(this.cut);
        for (int i = 0; i < this.value.length(); ++i) {
            dataOutputStream.writeShort(this.value.charAt(i));
        }
    }

    static void memcpy(StringBuilder stringBuilder, CharacterIterator characterIterator, int n) {
        char c = characterIterator.current();
        while (n > 0) {
            stringBuilder.append(c);
            c = characterIterator.next();
            --n;
        }
    }

    private void apply(CharacterIterator characterIterator, int n, StringBuilder stringBuilder) throws DLTException {
        if (n < 0 || characterIterator.getEndIndex() < characterIterator.getIndex() + n) {
            throw new DLTException(Messages.getString("error.wordboundary"));
        }
        this.setConverter();
        this.converter.process(characterIterator, n, this.cut, stringBuilder);
        stringBuilder.append(this.value);
    }

    static void applyToUpper(CharacterIterator characterIterator, int n, StringBuilder stringBuilder, byte by) {
        if (n-- <= 0) {
            return;
        }
        int n2 = characterIterator.current();
        do {
            switch (n2) {
                case 105: {
                    if ((by & 0x40) != 0) {
                        n2 = 304;
                        break;
                    }
                }
                case 305: {
                    if ((by & 0x40) != 0) {
                        n2 = 73;
                        break;
                    }
                }
                case 223: {
                    if ((by & 1) == 0) break;
                    stringBuilder.append('S');
                    n2 = 83;
                    break;
                }
                default: {
                    n2 = Character.toUpperCase((char)n2);
                }
            }
            stringBuilder.append((char)n2);
            n2 = characterIterator.next();
        } while ((by & 2) == 0 && n-- > 0);
        if (n > 0) {
            BasicCutPasteGloss.memcpy(stringBuilder, characterIterator, n);
        }
    }

    static void applyToLower(CharacterIterator characterIterator, int n, StringBuilder stringBuilder, byte by) {
        if (n-- <= 0) {
            return;
        }
        int n2 = characterIterator.current();
        do {
            switch (n2) {
                case 304: {
                    if ((by & 0x40) != 0) {
                        n2 = 105;
                        break;
                    }
                }
                case 73: {
                    if ((by & 0x40) != 0) {
                        n2 = 305;
                        break;
                    }
                }
                case 83: {
                    if ((by & 1) != 0 && n > 0) {
                        --n;
                        char c = characterIterator.next();
                        n2 = c;
                        if (c == 'S') {
                            n2 = 223;
                            break;
                        }
                        stringBuilder.append('s');
                        break;
                    }
                }
                default: {
                    n2 = CharacterMapper.toLowerCase((char)n2);
                }
            }
            stringBuilder.append((char)n2);
            n2 = characterIterator.next();
        } while ((by & 2) == 0 && n-- > 0);
        if (n > 0) {
            BasicCutPasteGloss.memcpy(stringBuilder, characterIterator, n);
        }
    }

    private static void applyLowerFirstOnly(CharacterIterator characterIterator, int n, StringBuilder stringBuilder) {
        if (n < 1) {
            return;
        }
        char c = characterIterator.current();
        stringBuilder.append(CharacterMapper.toLowerCase(c));
        --n;
        while (n > 0) {
            c = characterIterator.next();
            stringBuilder.append(c);
            --n;
        }
    }

    static void applyUpperOnly(CharacterIterator characterIterator, int n, StringBuilder stringBuilder) {
        char c = characterIterator.current();
        while (n > 0) {
            stringBuilder.append(Character.toUpperCase(c));
            c = characterIterator.next();
            --n;
        }
    }

    private static void applyUpperFirstOnly(CharacterIterator characterIterator, int n, StringBuilder stringBuilder) {
        if (n < 1) {
            return;
        }
        char c = characterIterator.current();
        stringBuilder.append(Character.toUpperCase(c));
        --n;
        while (n > 0) {
            c = characterIterator.next();
            stringBuilder.append(c);
            --n;
        }
    }

    static void applyCapitalize(CharacterIterator characterIterator, int n, StringBuilder stringBuilder, byte by) {
        if (n-- <= 0) {
            return;
        }
        int n2 = characterIterator.current();
        switch (n2) {
            case 105: {
                if ((by & 0x40) != 0) {
                    n2 = 304;
                    break;
                }
            }
            case 305: {
                if ((by & 0x40) != 0) {
                    n2 = 73;
                    break;
                }
            }
            case 83: {
                if ((by & 1) == 0 || n <= 0) break;
                --n;
                char c = characterIterator.next();
                n2 = c;
                if (c == 'S') break;
                stringBuilder.append('S');
                break;
            }
            case 223: {
                if ((by & 1) == 0) break;
                stringBuilder.append('S');
                n2 = 83;
                break;
            }
            default: {
                n2 = Character.toUpperCase((char)n2);
            }
        }
        stringBuilder.append((char)n2);
        characterIterator.next();
        if ((by & 2) != 0) {
            BasicCutPasteGloss.memcpy(stringBuilder, characterIterator, n);
        } else {
            BasicCutPasteGloss.applyToLower(characterIterator, n, stringBuilder, by);
        }
    }

    static void applyCapitalizeOnly(CharacterIterator characterIterator, int n, StringBuilder stringBuilder) {
        if (n-- <= 0) {
            return;
        }
        char c = characterIterator.current();
        c = Character.toUpperCase(c);
        stringBuilder.append(c);
        characterIterator.next();
        CharacterMapper.toLowerCaseStr(stringBuilder, characterIterator, n);
    }

    @Override
    public void appendLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
        int n3 = characterIterator.getIndex();
        characterIterator.setIndex(n);
        this.apply(characterIterator, n2 - n, stringBuilder);
        characterIterator.setIndex(n3);
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
        stringBuilder.setLength(0);
        this.appendLemma(characterIterator, n, n2, stringBuilder);
    }

    @Override
    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuffer stringBuffer) throws DLTException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLemma(characterIterator, n, n2, stringBuilder);
        stringBuffer.append((CharSequence)stringBuilder);
    }

    @Override
    public String getLemma(CharacterIterator characterIterator, int n, int n2) throws DLTException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLemma(characterIterator, n, n2, stringBuilder);
        return stringBuilder.toString();
    }

    @Deprecated
    public String getLemma(String string) throws DLTException {
        return this.getLemma(new StringCharacterIterator(string), 0, string.length());
    }

    public String toString(String string) throws DLTException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        int n = string.length();
        return this.getLemma(stringCharacterIterator, 0, n);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof BasicCutPasteGloss)) {
            return false;
        }
        BasicCutPasteGloss basicCutPasteGloss = (BasicCutPasteGloss)object;
        return basicCutPasteGloss.value.equals(this.value) && basicCutPasteGloss.cut == this.cut && basicCutPasteGloss.conv == this.conv && basicCutPasteGloss.options == this.options;
    }

    @Override
    public int compareTo(Gloss gloss) {
        int n = super.compareTo(gloss);
        if (n != 0) {
            return n;
        }
        if (gloss instanceof BasicCutPasteGloss) {
            BasicCutPasteGloss basicCutPasteGloss = (BasicCutPasteGloss)gloss;
            n = this.cut - basicCutPasteGloss.cut;
            if (n != 0) {
                return n;
            }
            n = this.conv - basicCutPasteGloss.conv;
            if (n != 0) {
                return n;
            }
            n = this.options - basicCutPasteGloss.options;
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return this.cut + (this.conv << 3) + (this.options << 5) ^ this.value.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(9 + this.value.length() + 1);
        stringBuilder.append('@').append(this.cut);
        stringBuilder.append(' ').append(this.conv);
        stringBuilder.append(' ').append(this.options);
        stringBuilder.append(" +\"").append(this.value).append('\"');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    @Override
    public int getMinSourceLength() {
        return this.cut;
    }

    public byte getConv() {
        return this.conv;
    }

    public short getCut() {
        return this.cut;
    }

    public byte getOptions() {
        return this.options;
    }

    private static class NoConvConverter
    implements Converter {
        @Override
        public byte getConv() {
            return 0;
        }

        @Override
        public byte getFlags() {
            return 0;
        }

        @Override
        public void process(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
            int n3 = n - n2;
            if (n3 < 0) {
                throw new DLTException(Messages.getString("error.code"));
            }
            BasicCutPasteGloss.memcpy(stringBuilder, characterIterator, n3);
        }
    }

    private static class CapitalizeConverterOpt
    implements Converter {
        final byte flags;

        CapitalizeConverterOpt(byte by) {
            this.flags = by;
        }

        @Override
        public byte getConv() {
            return 3;
        }

        @Override
        public byte getFlags() {
            return this.flags;
        }

        @Override
        public void process(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
            int n3 = stringBuilder.length();
            BasicCutPasteGloss.applyCapitalize(characterIterator, n, stringBuilder, this.flags);
            n3 = stringBuilder.length() - n3 - n2;
            if (n3 < 0) {
                throw new DLTException(Messages.getString("error.code"));
            }
            stringBuilder.setLength(n3);
        }
    }

    private static class CapitalizeConverter
    implements Converter {
        @Override
        public byte getConv() {
            return 3;
        }

        @Override
        public byte getFlags() {
            return 0;
        }

        @Override
        public void process(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
            int n3 = n - n2;
            if (n3 < 0) {
                throw new DLTException(Messages.getString("error.code"));
            }
            BasicCutPasteGloss.applyCapitalizeOnly(characterIterator, n3, stringBuilder);
        }
    }

    private static class ToUpperConverterOpt
    implements Converter {
        final byte flags;

        ToUpperConverterOpt(byte by) {
            this.flags = by;
        }

        @Override
        public byte getConv() {
            return 2;
        }

        @Override
        public byte getFlags() {
            return this.flags;
        }

        @Override
        public void process(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
            int n3 = stringBuilder.length();
            BasicCutPasteGloss.applyToUpper(characterIterator, n, stringBuilder, this.flags);
            n3 = stringBuilder.length() - n3 - n2;
            if (n3 < 0) {
                throw new DLTException(Messages.getString("error.code"));
            }
            stringBuilder.setLength(n3);
        }
    }

    private static class ToUpperConverter
    implements Converter {
        @Override
        public byte getConv() {
            return 2;
        }

        @Override
        public byte getFlags() {
            return 0;
        }

        @Override
        public void process(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
            int n3 = n - n2;
            if (n3 < 0) {
                throw new DLTException(Messages.getString("error.code"));
            }
            BasicCutPasteGloss.applyUpperOnly(characterIterator, n3, stringBuilder);
        }
    }

    private static final class ToLowerConverterOpt
    implements Converter {
        final byte flags;

        ToLowerConverterOpt(byte by) {
            this.flags = by;
        }

        @Override
        public byte getConv() {
            return 1;
        }

        @Override
        public byte getFlags() {
            return this.flags;
        }

        @Override
        public void process(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
            int n3 = stringBuilder.length();
            BasicCutPasteGloss.applyToLower(characterIterator, n, stringBuilder, this.flags);
            n3 = stringBuilder.length() - n3 - n2;
            if (n3 < 0) {
                throw new DLTException(Messages.getString("error.code"));
            }
            stringBuilder.setLength(n3);
        }
    }

    private static class ToLowerConverter
    implements Converter {
        @Override
        public byte getConv() {
            return 1;
        }

        @Override
        public byte getFlags() {
            return 0;
        }

        @Override
        public void process(CharacterIterator characterIterator, int n, int n2, StringBuilder stringBuilder) throws DLTException {
            int n3 = n - n2;
            if (n3 < 0) {
                throw new DLTException(Messages.getString("error.code"));
            }
            CharacterMapper.toLowerCaseStr(stringBuilder, characterIterator, n3);
        }
    }

    private static interface Converter {
        public byte getConv();

        public byte getFlags();

        public void process(CharacterIterator var1, int var2, int var3, StringBuilder var4) throws DLTException;
    }
}

