/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CRFLabelSetGloss
extends Gloss
implements CRFLabelSet {
    private final ArrayList<String> _list = new ArrayList();
    private final Map<String, Integer> _map = new HashMap<String, Integer>();
    private boolean _editable = false;
    private int _rt = 0;
    private static final int RESERVED_ID_NUM = 2;
    private int _nilId;
    private int _startId;
    private int _finalId;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CRFLabelSetGloss() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRFLabelSetGloss(Collection<String> collection) {
        boolean bl = this._editable;
        try {
            this._editable = true;
            this._nilId = this.addLabel("__nil__");
            this._startId = this.addLabel("__state__");
            this._finalId = this.addLabel("__state__");
            assert (this._list.size() == 2);
            if (collection != null) {
                this._list.ensureCapacity(collection.size());
                for (String string : collection) {
                    this.addLabel(string);
                }
            }
            this._list.trimToSize();
        }
        finally {
            this._editable = bl;
        }
    }

    @Override
    public int getType() {
        return 50;
    }

    @Override
    public int size() {
        assert (this._list.size() == this._map.size());
        return this._list.size();
    }

    @Override
    public List<String> getUserLabels() {
        ArrayList<String> arrayList = new ArrayList<String>(this._list);
        arrayList.remove("__nil__");
        arrayList.remove("__state__");
        arrayList.remove("__state__");
        return arrayList;
    }

    @Override
    public int addLabel(String string) {
        Integer n = this._map.get(string);
        if (n == null) {
            if (this._editable) {
                n = this._list.size();
                this._map.put(string, n);
                this._list.add(string);
            } else {
                n = this.getId("__nil__");
            }
        }
        assert (this._list.size() == this._map.size());
        return n;
    }

    @Override
    public String getLabel(int n) {
        if (n < 0 || n >= this._list.size()) {
            return "__nil__";
        }
        return this._list.get(n);
    }

    @Override
    public String getUserLabel(int n) {
        if (n < 2 || n >= this._list.size()) {
            return "__nil__";
        }
        return this._list.get(n);
    }

    @Override
    public boolean hasId(String string) {
        return this._map.containsKey(string);
    }

    @Override
    public int getId(String string) {
        Integer n = this._map.get(string);
        if (n == null) {
            n = this.addLabel(string);
        }
        return n;
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    @Override
    public int getStartId() {
        return this._startId;
    }

    @Override
    public int getFinalId() {
        return this._finalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        boolean bl = this._editable;
        try {
            this._editable = true;
            this._list.ensureCapacity(n);
            this._rt = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string = dataInputStream.readUTF();
                if ("__nil__".equals(string)) {
                    this._nilId = this.addLabel(string);
                    continue;
                }
                if ("__state__".equals(string)) {
                    this._startId = this.addLabel(string);
                    continue;
                }
                if ("__state__".equals(string)) {
                    this._finalId = this.addLabel(string);
                    continue;
                }
                this.addLabel(string);
            }
        }
        finally {
            this._editable = bl;
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        assert (this._list.size() == this._map.size());
        dataOutputStream.writeInt(this._list.size());
        dataOutputStream.writeInt(this._rt);
        for (String string : this._list) {
            dataOutputStream.writeUTF(string);
        }
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CRFLabelSet");
        stringBuilder.append(this._list.toString());
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

