/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.CRFLearningRate;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CRFLearningRateGloss
extends Gloss
implements CRFLearningRate {
    private double _C;
    private double _eta;
    private double _eta0;
    private double _alpha;
    private int _k = -1;
    private double _u;
    private double _N = 1.0;
    private double _threshold;
    private int _rt = 0;
    private static final double DEFAULT_C = 0.3;
    private static final double DEFAULT_ETA0 = 1.0;
    private static final double DEFAULT_ALPHA = 0.95;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Override
    public int getType() {
        return 53;
    }

    public CRFLearningRateGloss() {
        this(0.3, 1.0, 0.95, 1.0E-5);
    }

    public CRFLearningRateGloss(double d, double d2, double d3, double d4) {
        this._C = d;
        this._alpha = d3;
        this._eta0 = d2;
        this._eta = d2;
        this._u = 0.0;
        this._threshold = d4;
    }

    @Override
    public void reset() {
        this._k = 0;
        this._eta = this._eta0;
        this._u = 0.0;
    }

    @Override
    public void next() {
        this.next(this._C);
    }

    @Override
    public void next(double d) {
        ++this._k;
        double d2 = this._alpha < 1.0 ? (double)this._k / this._N : (double)(-this._k) / this._N;
        this._eta = this._eta0 * Math.pow(this._alpha, d2);
        this._u += this._eta * d / this._N;
    }

    @Override
    public void C(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException();
        }
        this._C = d;
    }

    @Override
    public void alpha(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException();
        }
        this._alpha = d;
    }

    @Override
    public double C() {
        return this._C;
    }

    @Override
    public void eta0(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException();
        }
        this._eta0 = d;
    }

    @Override
    public double u() {
        return this._u;
    }

    @Override
    public double eta() {
        return this._eta;
    }

    @Override
    public double threshold() {
        return this._threshold;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this._rt = dataInputStream.readInt();
        this._C = dataInputStream.readDouble();
        this._eta = dataInputStream.readDouble();
        this._eta0 = dataInputStream.readDouble();
        this._alpha = dataInputStream.readDouble();
        this._k = dataInputStream.readInt();
        this._u = dataInputStream.readDouble();
        this._N = dataInputStream.readDouble();
        dataInputStream.readInt();
        this._threshold = dataInputStream.readDouble();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this._rt);
        dataOutputStream.writeDouble(this._C);
        dataOutputStream.writeDouble(this._eta);
        dataOutputStream.writeDouble(this._eta0);
        dataOutputStream.writeDouble(this._alpha);
        dataOutputStream.writeInt(this._k);
        dataOutputStream.writeDouble(this._u);
        dataOutputStream.writeDouble(this._N);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeDouble(this._threshold);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LearningRate(");
        stringBuilder.append("C=").append(this._C).append(", ");
        stringBuilder.append("eta0=").append(this._eta0).append(", ");
        stringBuilder.append("eta=").append(this._eta).append(", ");
        stringBuilder.append("u=").append(this._u).append(", ");
        stringBuilder.append("alpha=").append(this._alpha).append(", ");
        stringBuilder.append("N=").append(this._N).append(", ");
        stringBuilder.append("Threshold=").append(this._threshold);
        stringBuilder.append(")");
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

