/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.util.ArrayUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class CRFStateFeatureGloss
extends Gloss {
    private long _bits = 0L;
    private double[] _w = ArrayUtils.EMPTY_DOUBLE_ARRAY;
    private double[] _q = ArrayUtils.EMPTY_DOUBLE_ARRAY;
    private double[] _g = ArrayUtils.EMPTY_DOUBLE_ARRAY;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CRFStateFeatureGloss() {
        this(0);
    }

    public CRFStateFeatureGloss(int n) {
        if (n > 0) {
            this._w = new double[n];
        }
    }

    public CRFStateFeatureGloss(float[] fArray) {
        this(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            if ((double)fArray[i] == 0.0) continue;
            this.w(i, fArray[i], 0.0);
        }
    }

    @Override
    public int getType() {
        return 51;
    }

    private final int internalIndex(int n) {
        long l = 1L << n;
        if ((this._bits & l) == 0L) {
            return -1;
        }
        return Long.bitCount(this._bits & l - 1L);
    }

    public long bits() {
        return this._bits;
    }

    public int first() {
        return Long.numberOfTrailingZeros(this._bits);
    }

    public int last() {
        return 64 - Long.numberOfLeadingZeros(this._bits);
    }

    private int size() {
        return Long.bitCount(this._bits);
    }

    private double get(double[] dArray, int n) {
        int n2 = this.internalIndex(n);
        if (n2 < 0 || n2 >= dArray.length) {
            return 0.0;
        }
        return dArray[n2];
    }

    private void set(double[] dArray, int n, double d, double d2) {
        int n2 = this.internalIndex(n);
        if (n2 < 0) {
            n2 = this.insertAt(n);
        }
        dArray[n2] = d == 0.0 || Math.abs(d) < d2 ? 0.0 : d;
    }

    public double w(int n) {
        return this.get(this._w, n);
    }

    public void w(int n, double d, double d2) {
        int n2 = this.internalIndex(n);
        if (n2 < 0) {
            n2 = this.insertAt(n);
        }
        this._w[n2] = d == 0.0 || Math.abs(d) < d2 ? 0.0 : d;
    }

    public double q(int n) {
        return this.get(this._q, n);
    }

    public void q(int n, double d, double d2) {
        int n2 = this.internalIndex(n);
        if (n2 < 0) {
            n2 = this.insertAt(n);
        }
        this._q[n2] = d == 0.0 || Math.abs(d) < d2 ? 0.0 : d;
    }

    public double g(int n) {
        return this.get(this._g, n);
    }

    public void g(int n, double d, double d2) {
        int n2 = this.internalIndex(n);
        if (n2 < 0) {
            n2 = this.insertAt(n);
        }
        this._g[n2] = d == 0.0 || Math.abs(d) < d2 ? 0.0 : d;
    }

    public void clear() {
        Arrays.fill(this._g, 0.0);
    }

    public boolean isEmpty(double d) {
        for (double d2 : this._w) {
            if (!(Math.abs(d2) > d)) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int n) {
        this._w = ArrayUtils.resize(this._w, n);
        this._q = ArrayUtils.resize(this._q, n);
        this._g = ArrayUtils.resize(this._g, n);
    }

    private int insertAt(int n) {
        this._bits |= 1L << n;
        int n2 = this.internalIndex(n);
        int n3 = this.size();
        if (n3 > this._w.length) {
            this._w = ArrayUtils.insertAt(this._w, n2, 0.0);
        } else {
            ArrayUtils.rotateRight(this._w, n2, this._w.length);
            this._w[n2] = 0.0;
        }
        if (n3 > this._q.length) {
            this._q = ArrayUtils.insertAt(this._q, n2, 0.0);
        } else {
            ArrayUtils.rotateRight(this._q, n2, this._q.length);
            this._q[n2] = 0.0;
        }
        if (n3 > this._g.length) {
            this._g = ArrayUtils.insertAt(this._g, n2, 0.0);
        } else {
            ArrayUtils.rotateRight(this._g, n2, this._g.length);
            this._g[n2] = 0.0;
        }
        return n2;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        dataInputStream.readInt();
        this._bits = dataInputStream.readLong();
        int n2 = dataInputStream.readInt();
        if (n2 == 0) {
            this._w = ArrayUtils.EMPTY_DOUBLE_ARRAY;
        } else {
            this._w = new double[n2];
            for (int i = 0; i < this._w.length; ++i) {
                this._w[i] = dataInputStream.readFloat();
            }
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(64);
        dataOutputStream.writeLong(this._bits);
        dataOutputStream.writeInt(this._w.length);
        for (double d : this._w) {
            dataOutputStream.writeFloat((float)d);
        }
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CRFStateFeaturegloss(");
        stringBuilder.append(Arrays.toString(this._w));
        stringBuilder.append(")");
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

