/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.util.ArrayUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class CRFTransitionFeatureGloss
extends Gloss {
    private float[][] _w;
    private float[][] _q = ArrayUtils.EMPTY_FLOAT_DARRAY;
    private float[][] _g = ArrayUtils.EMPTY_FLOAT_DARRAY;
    private boolean _wMaxCalculated = false;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CRFTransitionFeatureGloss() {
        this(0);
    }

    public CRFTransitionFeatureGloss(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._w = n == 0 ? ArrayUtils.EMPTY_FLOAT_DARRAY : new float[n][n + 2];
    }

    @Override
    public int getType() {
        return 52;
    }

    public float[][] w() {
        this.calcMaxes(this._w);
        return this._w;
    }

    private static double get(float[][] fArray, int n, int n2) {
        if (n < 0 || n >= fArray.length) {
            return 0.0;
        }
        if (n2 < 0 || n2 + 2 >= fArray[n].length) {
            return 0.0;
        }
        return fArray[n][n2 + 2];
    }

    private static void set(float[][] fArray, int n, int n2, double d, double d2) {
        fArray[n][n2 + 2] = d == 0.0 || Math.abs(d) < d2 ? 0.0f : (float)d;
    }

    public double w(int n, int n2) {
        return CRFTransitionFeatureGloss.get(this._w, n, n2);
    }

    public void w(int n, int n2, double d, double d2) {
        CRFTransitionFeatureGloss.set(this._w, n, n2, d, d2);
        this._wMaxCalculated = false;
    }

    public double q(int n, int n2) {
        return CRFTransitionFeatureGloss.get(this._q, n, n2);
    }

    public void q(int n, int n2, double d, double d2) {
        if (this._q == ArrayUtils.EMPTY_FLOAT_DARRAY) {
            this._q = new float[this._w.length][this._w.length + 2];
        }
        CRFTransitionFeatureGloss.set(this._q, n, n2, d, d2);
    }

    public double g(int n, int n2) {
        return CRFTransitionFeatureGloss.get(this._g, n, n2);
    }

    public void g(int n, int n2, double d, double d2) {
        if (this._g == ArrayUtils.EMPTY_FLOAT_DARRAY) {
            this._g = new float[this._w.length][this._w.length + 2];
        }
        CRFTransitionFeatureGloss.set(this._g, n, n2, d, d2);
    }

    public void clear() {
        for (float[] fArray : this._g) {
            Arrays.fill(fArray, 0.0f);
        }
    }

    public void ensureCapacity(int n) {
        assert (n >= 0);
        this._w = CRFTransitionFeatureGloss.ensureCapacity(this._w, n);
        this._q = CRFTransitionFeatureGloss.ensureCapacity(this._q, n);
        this._g = CRFTransitionFeatureGloss.ensureCapacity(this._g, n);
    }

    private static float[][] ensureCapacity(float[][] fArray, int n) {
        if (fArray.length < n) {
            fArray = (float[][])ArrayUtils.resize(fArray, n);
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == null) {
                    fArray[i] = new float[n + 2];
                    continue;
                }
                if (fArray[i].length >= n + 2) continue;
                fArray[i] = ArrayUtils.resize(fArray[i], n + 2);
            }
        }
        return fArray;
    }

    public void trimToSize(double d) {
        for (int i = 0; i < this._w.length; ++i) {
            for (int j = 0; j < this._w[i].length; ++j) {
                if (!((double)Math.abs(this._w[i][j]) < d)) continue;
                this._w[i][j] = 0.0f;
            }
        }
        this._q = ArrayUtils.EMPTY_FLOAT_DARRAY;
        this._g = ArrayUtils.EMPTY_FLOAT_DARRAY;
    }

    public boolean isEmpty(double d) {
        float[][] fArray = this._w;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray2;
            for (float f : fArray2 = fArray[i]) {
                if (!((double)Math.abs(f) > d)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this._w = new float[n][n + 2];
        for (int i = 0; i < this._w.length; ++i) {
            for (int j = 2; j < this._w[i].length; ++j) {
                this._w[i][j] = dataInputStream.readFloat();
            }
        }
        this.calcMaxes(this._w);
    }

    private void calcMaxes(float[][] fArray) {
        if (!this._wMaxCalculated) {
            for (int i = 0; i < fArray.length; ++i) {
                float[] fArray2 = fArray[i];
                int n = 2;
                int n2 = 2;
                for (int j = 3; j < fArray2.length; ++j) {
                    if (fArray2[n2] < fArray2[j]) {
                        n2 = j;
                    }
                    if (!(fArray2[n] > fArray2[j])) continue;
                    n = j;
                }
                fArray2[0] = fArray2[n];
                fArray2[1] = fArray2[n2];
            }
            this._wMaxCalculated = true;
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this._w.length);
        for (float[] fArray : this._w) {
            for (int i = 2; i < fArray.length; ++i) {
                dataOutputStream.writeFloat(fArray[i]);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CRF(");
        for (float[] fArray : this._w) {
            stringBuilder.append(Arrays.toString(fArray));
        }
        stringBuilder.append(")");
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

