/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.util.CharacterMapper;
import com.ibm.dltj.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.StringTokenizer;

public final class CaseGloss
extends Gloss {
    private int _case;
    private BitSet _crazyCase;
    private static final int OLD_CASE_LOWER = 1;
    private static final int OLD_CASE_UPPER = 2;
    private static final int OLD_CASE_FIRST_TITLE = 4;
    private static final int OLD_CASE_ALL_TITLE = 8;
    private static final int OLD_CASE_CRAZY = 16;
    private static final int FLAG_NEW_CASES = 256;
    public static final int PROPER_CASE_LOWER = 24;
    public static final int PROPER_CASE_TITLE = 16;
    public static final int PROPER_CASE_UPPER = 8;
    public static final int PROPER_CASE_CRAZY = 0;
    private static final int FLAG_MASK_SPECIFIED = 32;
    public static final int PROPER_CASE_MASK = 24;
    private static final int SHIFT_MASK = 56;
    private static final int FLAG_ALL_WORDS_TITLE = 512;
    public static final int PERMITS_CASE_LOWER = 0x1000000;
    public static final int PERMITS_CASE_TITLE = 0x2000000;
    public static final int PERMITS_CASE_UPPER = 0x4000000;
    public static final int PERMITS_CASE_TITLE_FIRST = 0x8000000;
    public static final int PERMITS_CASE_CRAZY = 0x10000000;
    private static final int PERMITTED_CASE_MASK = 0x1F000000;
    private static final int PERMITTED_CASE_FILTER_SHIFT = 24;
    public static final int FILTERED_INDEX_MAX = 32;
    public static final int MASK_METHOD_PROMOTE = 67372551;
    public static final int MASK_METHOD_PROMOTE_TITLE_FIRST_ONLY = 67372557;
    public static final int MASK_METHOD_PROPER = 262657;
    public static final int MASK_METHOD_PROPER_TITLE_FIRST = 262665;
    public static final int MASK_METHOD_DEMOTE = 17236737;
    public static final int MASK_METHOD_ALLCASE = 0x7070707;
    public static final int MASK_METHOD_ALLCASE_CRAZY = 0x17171717;
    public static final int MASK_METHOD_ADD_CRAZY = 0x10000000;
    public static final int MASK_EXPAND_PROPER = 268698113;
    public static final int MASK_EXPAND_TITLE = 268700161;
    public static final int MASK_EXPAND_FIRSTWORD_SPELL = 268700160;
    public static final int MASK_EXPAND_COMPOUND = 386138881;
    private static final String WORD_DELIM = " -\u2007\u3000\u2010";
    private static short[] OLD_CASE_MAPPING = new short[]{1, 280, 2, 264, 4, 272, 8, 768, 16, 256};

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CaseGloss() {
    }

    public CaseGloss(String string) {
        this._case = CaseExtractor.getSubStringCase(string);
        this._crazyCase = this.isCrazyCase() && !this.isAllTitleCase() ? CaseGloss.computeCrazyCase(string) : null;
    }

    public CaseGloss(CharacterIterator characterIterator, int n, int n2) {
        this._case = CaseExtractor.getSubStringCase(characterIterator, n, n2);
        this._crazyCase = this.isCrazyCase() && !this.isAllTitleCase() ? CaseGloss.computeCrazyCase(characterIterator, n, n2) : null;
    }

    private CaseGloss(int n, BitSet bitSet) {
        this._case = n;
        this._crazyCase = bitSet;
    }

    public String getCase(String string) {
        if (string == null) {
            return null;
        }
        switch (this._case & 0x18) {
            case 24: {
                return string.toLowerCase();
            }
            case 8: {
                return string.toUpperCase();
            }
            case 16: {
                return CaseGloss.firstTitleCase(string);
            }
            case 0: {
                if ((this._case & 0x200) != 0) {
                    return CaseGloss.allTitleCase(string);
                }
                return this.crazyCase(string);
            }
        }
        return string;
    }

    public static int createMaskMethod(int n, int n2, int n3, int n4) {
        n = (n & 0x1F000000) >> 24;
        n2 = (n2 & 0x1F000000) >> 16;
        n3 = (n3 & 0x1F000000) >> 8;
        n4 = (n4 & 0x1F000000) >> 0;
        return n | n2 | n3 | n4;
    }

    public final int applyMethod(int n) {
        return this._case | (int)((long)n << (this._case & 0x38)) & 0x1F000000;
    }

    public final int getMask(int n) {
        return (this._case | (int)((long)n << (this._case & 0x38))) & 0x1F000000;
    }

    public static final int getMask(int n, int n2) {
        return (n | (int)((long)n2 << (n & 0x38))) & 0x1F000000;
    }

    public static final int applyMethod(int n, int n2) {
        return n | (int)((long)n2 << (n & 0x38)) & 0x1F000000;
    }

    public boolean permitsCase(int n, int n2) {
        return (this.getMask(n2) & n) != 0;
    }

    public static boolean permitsCase(int n, int n2, int n3, int n4) {
        return (CaseGloss.getMask(n, n2) & CaseGloss.applyMethod(n3, n4)) != 0;
    }

    public boolean permitsCase(int n, int n2, CharacterIterator characterIterator, int n3, int n4) {
        int n5 = this.getMask(n2);
        if ((n5 & n) != 0) {
            return true;
        }
        if (this.isCase(0) && (n & 0x10000000) != 0 && characterIterator != null) {
            String string = Utils.makeString(characterIterator, n3, n4);
            return string.equals(this.getCase(string));
        }
        return false;
    }

    public boolean isCase(int n) {
        return (this._case & 0x18) == n;
    }

    public static boolean isCase(int n, int n2) {
        return (n & 0x18) == n2;
    }

    public boolean isAllTitleCase() {
        return (this._case & 0x200) != 0;
    }

    public boolean isLowerCase() {
        return this.isCase(24);
    }

    public boolean isUpperCase() {
        return this.isCase(8);
    }

    public boolean isTitleCase() {
        return this.isCase(16);
    }

    public boolean isFirstTitleCase() {
        return this.isCase(16);
    }

    public boolean isCrazyCase() {
        return this.isCase(0);
    }

    public CaseGloss chooseCompatibleCase(int n, CaseGloss caseGloss, int n2) {
        int n3;
        int n4 = this.getMask(n);
        if ((n4 & (n3 = caseGloss.getMask(n2))) != 0) {
            return caseGloss;
        }
        return this;
    }

    public CaseGloss copyAssignMask(int n) {
        return new CaseGloss(this.applyMethod(n) | 0x20, this._crazyCase);
    }

    public boolean hasPermanentMask() {
        return (this._case & 0x20) != 0;
    }

    BitSet getCrazyBitSet() {
        return this._crazyCase;
    }

    private static void titleCase(String string, StringBuffer stringBuffer) {
        int n = string.length();
        if (n == 0) {
            return;
        }
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        if (n > 1) {
            stringBuffer.append(string.substring(1).toLowerCase());
        }
    }

    private static String firstTitleCase(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        CaseGloss.titleCase(string, stringBuffer);
        return stringBuffer.toString();
    }

    private static String allTitleCase(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, WORD_DELIM, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            CaseGloss.titleCase(string2, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String crazyCase(String string) {
        if (this._crazyCase == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (this._crazyCase.get(i)) {
                stringBuffer.append(Character.toUpperCase(c));
                continue;
            }
            stringBuffer.append(CharacterMapper.toLowerCase(c));
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CaseGloss)) {
            return false;
        }
        CaseGloss caseGloss = (CaseGloss)object;
        if (this._case != caseGloss._case) {
            return false;
        }
        if (this._crazyCase == null) {
            return caseGloss._crazyCase == null;
        }
        return this._crazyCase.equals(caseGloss._crazyCase);
    }

    @Override
    public int getType() {
        return 28;
    }

    @Override
    public int hashCode() {
        int n = this._case;
        if (this._crazyCase != null) {
            n = n * 13 + this._crazyCase.hashCode();
        }
        return n;
    }

    public static boolean isStringAllTitle(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.getIndex();
        char c = characterIterator.setIndex(n);
        boolean bl = true;
        while (characterIterator.getIndex() < n2) {
            if (bl != Character.isUpperCase(c)) {
                characterIterator.setIndex(n3);
                return false;
            }
            bl = WORD_DELIM.indexOf(c) >= 0;
            c = characterIterator.next();
        }
        characterIterator.setIndex(n3);
        return true;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        this._case = dataInputStream.readInt();
        if ((this._case & 0x100) == 0) {
            for (n2 = OLD_CASE_MAPPING.length - 2; n2 > 0 && OLD_CASE_MAPPING[n2] != this._case; n2 -= 2) {
            }
            this._case = OLD_CASE_MAPPING[n2 + 1];
        }
        if ((this._case & 0x200) != 0) {
            this._case = this._case & 0xFFFFFFE7 | 0;
        }
        if ((n2 = dataInputStream.readInt()) < 0) {
            this._crazyCase = null;
        } else {
            this._crazyCase = new BitSet(n2);
            for (int i = 0; i < n2; ++i) {
                this._crazyCase.set(i, dataInputStream.readBoolean());
            }
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        assert ((this._case & 0x100) != 0);
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this._case);
        if (this._crazyCase == null) {
            dataOutputStream.writeInt(-1);
        } else {
            int n2 = this._crazyCase.length();
            dataOutputStream.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                dataOutputStream.writeBoolean(this._crazyCase.get(i));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Case(");
        switch (this._case & 0x18) {
            case 24: {
                stringBuilder.append('L');
                break;
            }
            case 16: {
                stringBuilder.append('T');
                break;
            }
            case 8: {
                stringBuilder.append('U');
                break;
            }
            case 0: {
                if ((this._case & 0x200) != 0) {
                    stringBuilder.append("AT");
                    break;
                }
                stringBuilder.append('C');
            }
        }
        if ((this._case & 0x20) != 0) {
            stringBuilder.append(':');
            if ((this._case & 0x1000000) != 0) {
                stringBuilder.append('l');
            }
            if ((this._case & 0x2000000) != 0) {
                stringBuilder.append('t');
            } else if ((this._case & 0x8000000) != 0) {
                stringBuilder.append('f');
            }
            if ((this._case & 0x4000000) != 0) {
                stringBuilder.append('u');
            }
            if ((this._case & 0x10000000) != 0) {
                stringBuilder.append('c');
            }
        }
        if (this._crazyCase != null) {
            stringBuilder.append(';');
            stringBuilder.append(this._crazyCase.toString());
        }
        stringBuilder.append(')');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }

    static BitSet computeCrazyCase(String string) {
        int n = string.length();
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            bitSet.set(i, Character.isUpperCase(string.charAt(i)));
        }
        return bitSet;
    }

    static BitSet computeCrazyCase(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.getIndex();
        int n4 = n2 - n;
        BitSet bitSet = new BitSet(n4);
        for (int i = 0; i < n4; ++i) {
            bitSet.set(i, Character.isUpperCase(characterIterator.setIndex(i + n)));
        }
        characterIterator.setIndex(n3);
        return bitSet;
    }

    public static GlossCollection filterByCase(GlossCollection glossCollection, int n, int n2, CharacterIterator characterIterator, int n3, int n4) {
        ArrayList<Gloss> arrayList = null;
        for (int i = 0; i < glossCollection.size(); ++i) {
            Gloss gloss = (Gloss)glossCollection.get(i);
            CaseGloss caseGloss = gloss instanceof MidGloss ? (CaseGloss)((MidGloss)gloss).getGloss(CaseGloss.class) : (gloss.getType() == 28 ? (CaseGloss)gloss : null);
            if (caseGloss == null || caseGloss.permitsCase(n, n2, characterIterator, n3, n4)) {
                if (arrayList == null) continue;
                arrayList.add(gloss);
                continue;
            }
            if (arrayList != null) continue;
            arrayList = new ArrayList<Gloss>(glossCollection.size());
            arrayList.addAll(glossCollection.subList(0, i));
        }
        if (arrayList == null) {
            return glossCollection;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new GlossCollection((Collection<Gloss>)arrayList, glossCollection.getOwnerDictionary());
    }

    public static GlossCollection filterByCase(GlossCollection glossCollection, int n, CharacterIterator characterIterator, int n2, int n3, boolean bl) {
        return CaseGloss.filterByCase(glossCollection, CaseGloss.applyMethod(CaseExtractor.getSubStringCase(characterIterator, n2, n3), bl ? 268700161 : 268698113), n, characterIterator, n2, n3);
    }

    public boolean preferableTo(CaseGloss caseGloss) {
        if (caseGloss == null) {
            return true;
        }
        int n = (this._case & 0x18) - (caseGloss._case & 0x18);
        if (n != 0) {
            return n > 0;
        }
        return this.isAllTitleCase() && !caseGloss.isAllTitleCase();
    }

    public static int getFilterIndex(int n) {
        return (n & 0x1F000000) >> 24;
    }

    public static GlossCollection prefilterByCase(GlossCollection glossCollection, int n, int n2) {
        return CaseGloss.filterByCase(glossCollection, n, n2 |= 0x10000000, null, 0, 0);
    }

    public static GlossCollection refilterByCase(GlossCollection glossCollection, int n, int n2, CharacterIterator characterIterator, int n3, int n4) {
        if ((n & 0x10000000) != 0 && (n2 & 0x10000000) == 0 && glossCollection != null) {
            return CaseGloss.filterByCase(glossCollection, n, n2, characterIterator, n3, n4);
        }
        return glossCollection;
    }

    public int getCaseValue() {
        return this._case;
    }

    public static class CaseExtractor {
        public static final byte[] FSA;
        public static final int[] char_map;
        public static final int FIRST_NODE = 1;
        static final int CHAR_SIZE = 65536;
        static final int POINT_SHIFT = 2;
        static final int POINT_MASK = 3;
        static final int POINTS_PER_INT_SHIFT = 4;
        static final int POINTS_PER_INT_MASK = 15;

        public static int getOffset(char c) {
            return char_map[c >> 4] >> 2 * (c & 0xF) & 3;
        }

        public static int takeStep(int n, char c) {
            return FSA[n + (char_map[c >> 4] >> 2 * (c & 0xF) & 3)];
        }

        public static int takeStepWithOffset(int n, int n2) {
            return FSA[n + n2];
        }

        public static int getCaseMask(int n) {
            return FSA[n - 1] << 3;
        }

        public static int getSubStringCase(CharacterIterator characterIterator, int n, int n2) {
            int n3 = 1;
            for (int i = n; i < n2; ++i) {
                n3 = CaseExtractor.takeStep(n3, characterIterator.setIndex(i));
            }
            return CaseExtractor.getCaseMask(n3);
        }

        public static int getSubStringCaseMask(CharacterIterator characterIterator, int n, int n2, boolean bl) {
            return CaseGloss.applyMethod(CaseExtractor.getSubStringCase(characterIterator, n, n2), bl ? 268700161 : 268698113);
        }

        public static int getSubStringCase(String string) {
            int n = string.length();
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                n2 = CaseExtractor.takeStep(n2, string.charAt(i));
            }
            return CaseExtractor.getCaseMask(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            try {
                DataInputStream dataInputStream = null;
                try {
                    dataInputStream = new DataInputStream(CaseExtractor.class.getResourceAsStream("case.rule.dat"));
                    int n = dataInputStream.readInt();
                    assert (n == 2);
                    char_map = new int[4096];
                    for (int i = 0; i < char_map.length; ++i) {
                        CaseExtractor.char_map[i] = dataInputStream.readInt();
                    }
                    n = dataInputStream.readInt();
                    assert (n == 8);
                    n = dataInputStream.readInt();
                    FSA = new byte[n];
                    dataInputStream.readFully(FSA);
                }
                finally {
                    if (null != dataInputStream) {
                        dataInputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                throw new Error("CaseGloss static initialization", iOException);
            }
        }
    }
}

